/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.noise.hammersley;

import kotlin.Metadata;
import kotlin.UInt;
import kotlin.UnsignedKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\r\u001a\u0016\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0010"}, d2={"hammersley2D", "Lorg/openrndr/math/Vector2;", "i", "", "n", "hammersley3D", "Lorg/openrndr/math/Vector3;", "hammersley4D", "Lorg/openrndr/math/Vector4;", "radicalInverseBase2", "", "Lkotlin/UInt;", "radicalInverseBase2-WZ4Q5Ns", "(I)D", "radicalInverse", "base", "orx-noise"})
public final class HammersleyKt {
    @NotNull
    public static final Vector2 hammersley2D(int i, int n) {
        return new Vector2((double)i / (double)n, HammersleyKt.radicalInverseBase2-WZ4Q5Ns(UInt.constructor-impl(i)));
    }

    @NotNull
    public static final Vector3 hammersley3D(int i, int n) {
        return new Vector3((double)i / (double)n, HammersleyKt.radicalInverseBase2-WZ4Q5Ns(UInt.constructor-impl(i)), HammersleyKt.radicalInverse(3, i));
    }

    @NotNull
    public static final Vector4 hammersley4D(int i, int n) {
        return new Vector4((double)i / (double)n, HammersleyKt.radicalInverseBase2-WZ4Q5Ns(UInt.constructor-impl(i)), HammersleyKt.radicalInverse(3, i), HammersleyKt.radicalInverse(5, i));
    }

    public static final double radicalInverseBase2-WZ4Q5Ns(int i) {
        int bits = i;
        bits = UInt.constructor-impl(UInt.constructor-impl(bits << 16) | UInt.constructor-impl(bits >>> 16));
        bits = UInt.constructor-impl(UInt.constructor-impl(UInt.constructor-impl(bits & 0x55555555) << 1) | UInt.constructor-impl(UInt.constructor-impl(bits & 0xAAAAAAAA) >>> 1));
        bits = UInt.constructor-impl(UInt.constructor-impl(UInt.constructor-impl(bits & 0x33333333) << 2) | UInt.constructor-impl(UInt.constructor-impl(bits & 0xCCCCCCCC) >>> 2));
        bits = UInt.constructor-impl(UInt.constructor-impl(UInt.constructor-impl(bits & 0xF0F0F0F) << 4) | UInt.constructor-impl(UInt.constructor-impl(bits & 0xF0F0F0F0) >>> 4));
        bits = UInt.constructor-impl(UInt.constructor-impl(UInt.constructor-impl(bits & 0xFF00FF) << 8) | UInt.constructor-impl(UInt.constructor-impl(bits & 0xFF00FF00) >>> 8));
        return UnsignedKt.uintToDouble(bits) * 2.3283064365386963E-10;
    }

    public static final double radicalInverse(int base, int i) {
        double v = 0.0;
        double denom = 1.0;
        int n = i;
        while (n > 0) {
            int n2 = n % base;
            int remainder = n2 + (base & ((n2 ^ base) & (n2 | -n2)) >> 31);
            n /= base;
            v += (double)remainder / (denom *= (double)base);
        }
        return v;
    }
}

