/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.mesh.noise;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.noise.UHashKt;
import org.openrndr.math.Vector3;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u001a\u0010\u0002\u001a\u00060\u0001j\u0002`\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u001a.\u0010\u0007\u001a\u00060\u0001j\u0002`\u00032\n\u0010\b\u001a\u00060\u0001j\u0002`\u00032\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005\u001a\u001a\u0010\f\u001a\u00060\u0001j\u0002`\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e*\n\u0010\u0000\"\u00020\u00012\u00020\u0001\u00a8\u0006\u0010"}, d2={"Barycentric", "Lorg/openrndr/math/Vector3;", "uniformBarycentric", "Lorg/openrndr/extra/mesh/noise/Barycentric;", "u", "", "v", "weightBarycentric", "barycentric", "weight0", "weight1", "weight2", "hashBarycentric", "seed", "", "x", "orx-mesh-noise"})
public final class BarycentricKt {
    @NotNull
    public static final Vector3 uniformBarycentric(double u, double v) {
        double su0 = Math.sqrt(u);
        double b0 = 1.0 - su0;
        double b1 = v * su0;
        return new Vector3(b0, b1, 1.0 - b0 - b1);
    }

    @NotNull
    public static final Vector3 weightBarycentric(@NotNull Vector3 barycentric, double weight0, double weight1, double weight2) {
        Intrinsics.checkNotNullParameter(barycentric, "barycentric");
        double b0 = barycentric.x() * weight0;
        double b1 = barycentric.y() * weight1;
        double b2 = barycentric.z() * weight2;
        double totalWeight = b0 + b1 + b2;
        return new Vector3(b0 / totalWeight, b1 / totalWeight, b2 / totalWeight);
    }

    @NotNull
    public static final Vector3 hashBarycentric(int seed, int x) {
        double u = UHashKt.fhash1D(seed, x);
        double v = UHashKt.fhash1D(seed, (int)Double.doubleToRawLongBits(u) - x);
        double su0 = Math.sqrt(u);
        double b0 = 1.0 - su0;
        double b1 = v * su0;
        return new Vector3(b0, b1, 1.0 - b0 - b1);
    }
}

