/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.mesh;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.extra.mesh.IIndexedPolygon;
import org.openrndr.extra.mesh.IMeshData;
import org.openrndr.extra.mesh.IndexedPolygon;
import org.openrndr.extra.mesh.MeshDataExtensionsKt;
import org.openrndr.extra.mesh.MutableMeshData;
import org.openrndr.extra.mesh.Polygon;
import org.openrndr.extra.mesh.VertexData;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\u0000H\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006H\u0016J\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0001H\u0016J\b\u0010\u0011\u001a\u00020\u0000H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J#\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0010\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\nR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lorg/openrndr/extra/mesh/MeshData;", "Lorg/openrndr/extra/mesh/IMeshData;", "Ljava/lang/Record;", "vertexData", "Lorg/openrndr/extra/mesh/VertexData;", "polygons", "", "Lorg/openrndr/extra/mesh/IndexedPolygon;", "<init>", "(Lorg/openrndr/extra/mesh/VertexData;Ljava/util/List;)V", "()Lorg/openrndr/extra/mesh/VertexData;", "()Ljava/util/List;", "triangulate", "toPolygons", "Lorg/openrndr/extra/mesh/Polygon;", "join", "other", "toMeshData", "toMutableMeshData", "Lorg/openrndr/extra/mesh/MutableMeshData;", "component1", "component2", "copy", "equals", "", "", "hashCode", "", "toString", "", "orx-mesh"})
@SourceDebugExtension(value={"SMAP\nMeshData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MeshData.kt\norg/openrndr/extra/mesh/MeshData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,244:1\n1368#2:245\n1454#2,5:246\n1557#2:251\n1628#2,3:252\n1557#2:255\n1628#2,3:256\n*S KotlinDebug\n*F\n+ 1 MeshData.kt\norg/openrndr/extra/mesh/MeshData\n*L\n111#1:245\n111#1:246,5\n115#1:251\n115#1:252,3\n188#1:255\n188#1:256,3\n*E\n"})
public record MeshData(@NotNull VertexData vertexData, @NotNull List<IndexedPolygon> polygons) implements IMeshData
{
    public MeshData {
        Intrinsics.checkNotNullParameter(vertexData, "vertexData");
        Intrinsics.checkNotNullParameter(polygons, "polygons");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MeshData triangulate() {
        MeshData meshData;
        if (MeshDataExtensionsKt.isTriangular(this)) {
            meshData = this;
        } else {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Iterable iterable = this.polygons();
            VertexData vertexData = null;
            MeshData meshData2 = this;
            boolean $i$f$flatMap = false;
            void var3_5 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                IndexedPolygon polygon = (IndexedPolygon)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = polygon.triangulate(this.vertexData());
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            List list = (List)destination$iv$iv;
            meshData = MeshData.copy$default(meshData2, vertexData, list, 1, null);
        }
        return meshData;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Polygon> toPolygons() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.polygons();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void ip;
            IndexedPolygon indexedPolygon = (IndexedPolygon)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ip.toPolygon(this.vertexData()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IMeshData join(@NotNull IMeshData other) {
        Collection<IndexedPolygon> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List<Vector3> list;
        List<Vector3> list2;
        List<Vector3> list3;
        List<ColorRGBa> list4;
        List<Vector2> list5;
        List<Vector3> list6;
        Intrinsics.checkNotNullParameter(other, "other");
        if (this.vertexData() == other.getVertexData()) {
            VertexData vertexData = this.vertexData();
            Collection collection2 = this.polygons();
            List<IIndexedPolygon> list7 = other.getPolygons();
            Intrinsics.checkNotNull(list7, "null cannot be cast to non-null type kotlin.collections.List<org.openrndr.extra.mesh.IndexedPolygon>");
            return new MeshData(vertexData, CollectionsKt.plus(collection2, (Iterable)list7));
        }
        int positionsShift = 0;
        if (this.vertexData().getPositions() == other.getVertexData().getPositions()) {
            positionsShift = 0;
            list6 = this.vertexData().getPositions();
        } else {
            positionsShift = this.vertexData().getPositions().size();
            list6 = CollectionsKt.plus((Collection)this.vertexData().getPositions(), (Iterable)other.getVertexData().getPositions());
        }
        List<Vector3> positions = list6;
        int textureCoordsShift = 0;
        if (this.vertexData().getTextureCoords() == other.getVertexData().getTextureCoords()) {
            textureCoordsShift = 0;
            list5 = this.vertexData().getTextureCoords();
        } else {
            textureCoordsShift = this.vertexData().getTextureCoords().size();
            list5 = CollectionsKt.plus((Collection)this.vertexData().getTextureCoords(), (Iterable)other.getVertexData().getTextureCoords());
        }
        List<Vector2> textureCoords = list5;
        int colorsShift = 0;
        if (this.vertexData().getColors() == other.getVertexData().getColors()) {
            colorsShift = 0;
            list4 = this.vertexData().getColors();
        } else {
            colorsShift = this.vertexData().getColors().size();
            list4 = CollectionsKt.plus((Collection)this.vertexData().getColors(), (Iterable)other.getVertexData().getColors());
        }
        List<ColorRGBa> colors = list4;
        int normalsShift = 0;
        if (this.vertexData().getNormals() == other.getVertexData().getNormals()) {
            normalsShift = 0;
            list3 = this.vertexData().getNormals();
        } else {
            normalsShift = this.vertexData().getNormals().size();
            list3 = CollectionsKt.plus((Collection)this.vertexData().getNormals(), (Iterable)other.getVertexData().getNormals());
        }
        List<Vector3> normals = list3;
        int tangentsShift = 0;
        if (this.vertexData().getTangents() == other.getVertexData().getTangents()) {
            tangentsShift = 0;
            list2 = this.vertexData().getTangents();
        } else {
            tangentsShift = this.vertexData().getTangents().size();
            list2 = CollectionsKt.plus((Collection)this.vertexData().getTangents(), (Iterable)other.getVertexData().getTangents());
        }
        List<Vector3> tangents = list2;
        int bitangentsShift = 0;
        if (this.vertexData().getBitangents() == other.getVertexData().getBitangents()) {
            bitangentsShift = 0;
            list = this.vertexData().getBitangents();
        } else {
            bitangentsShift = this.vertexData().getBitangents().size();
            list = CollectionsKt.plus((Collection)this.vertexData().getBitangents(), (Iterable)other.getVertexData().getBitangents());
        }
        List<Vector3> bitangents = list;
        Iterable iterable = other.getPolygons();
        Collection collection3 = this.polygons();
        VertexData vertexData = new VertexData(positions, textureCoords, colors, normals, tangents, bitangents);
        boolean $i$f$map = false;
        void var16_18 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IIndexedPolygon iIndexedPolygon = (IIndexedPolygon)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it, "null cannot be cast to non-null type org.openrndr.extra.mesh.IndexedPolygon");
            collection.add(((IndexedPolygon)it).shiftIndices(positionsShift, textureCoordsShift, colorsShift, normalsShift, tangentsShift, bitangentsShift));
        }
        collection = (List)destination$iv$iv;
        List<IndexedPolygon> list8 = CollectionsKt.plus(collection3, (Iterable)collection);
        VertexData vertexData2 = vertexData;
        return new MeshData(vertexData2, list8);
    }

    @Override
    @NotNull
    public MeshData toMeshData() {
        return this;
    }

    @Override
    @NotNull
    public MutableMeshData toMutableMeshData() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    public final VertexData component1() {
        return this.vertexData;
    }

    @NotNull
    public final List<IndexedPolygon> component2() {
        return this.polygons;
    }

    @NotNull
    public final MeshData copy(@NotNull VertexData vertexData, @NotNull List<IndexedPolygon> polygons) {
        Intrinsics.checkNotNullParameter(vertexData, "vertexData");
        Intrinsics.checkNotNullParameter(polygons, "polygons");
        return new MeshData(vertexData, polygons);
    }

    public static /* synthetic */ MeshData copy$default(MeshData meshData, VertexData vertexData, List list, int n, Object object) {
        if ((n & 1) != 0) {
            vertexData = meshData.vertexData;
        }
        if ((n & 2) != 0) {
            list = meshData.polygons;
        }
        return meshData.copy(vertexData, list);
    }

    @Override
    @NotNull
    public String toString() {
        return "MeshData(vertexData=" + this.vertexData + ", polygons=" + this.polygons + ")";
    }

    @Override
    public int hashCode() {
        int result = this.vertexData.hashCode();
        result = result * 31 + ((Object)this.polygons).hashCode();
        return result;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MeshData)) {
            return false;
        }
        MeshData meshData = (MeshData)other;
        if (!Intrinsics.areEqual(this.vertexData, meshData.vertexData)) {
            return false;
        }
        return Intrinsics.areEqual(this.polygons, meshData.polygons);
    }
}

