/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.mesh;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.mesh.IPolygon;
import org.openrndr.extra.mesh.IVertexData;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0014H&R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u001e"}, d2={"Lorg/openrndr/extra/mesh/IIndexedPolygon;", "", "positions", "", "", "getPositions", "()Ljava/util/List;", "textureCoords", "getTextureCoords", "normals", "getNormals", "colors", "getColors", "tangents", "getTangents", "bitangents", "getBitangents", "base", "Lorg/openrndr/math/Matrix44;", "vertexData", "Lorg/openrndr/extra/mesh/IVertexData;", "isPlanar", "", "eps", "", "isConvex", "normal", "Lorg/openrndr/math/Vector3;", "toPolygon", "Lorg/openrndr/extra/mesh/IPolygon;", "orx-mesh"})
public interface IIndexedPolygon {
    @NotNull
    public List<Integer> getPositions();

    @NotNull
    public List<Integer> getTextureCoords();

    @NotNull
    public List<Integer> getNormals();

    @NotNull
    public List<Integer> getColors();

    @NotNull
    public List<Integer> getTangents();

    @NotNull
    public List<Integer> getBitangents();

    @NotNull
    public Matrix44 base(@NotNull IVertexData var1);

    public boolean isPlanar(@NotNull IVertexData var1, double var2);

    public boolean isConvex(@NotNull IVertexData var1);

    @NotNull
    public Vector3 normal(@NotNull IVertexData var1);

    @NotNull
    public IPolygon toPolygon(@NotNull IVertexData var1);

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nIndexedPolygon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexedPolygon.kt\norg/openrndr/extra/mesh/IIndexedPolygon$DefaultImpls\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,333:1\n1734#2,3:334\n*S KotlinDebug\n*F\n+ 1 IndexedPolygon.kt\norg/openrndr/extra/mesh/IIndexedPolygon$DefaultImpls\n*L\n80#1:334,3\n*E\n"})
    public static final class DefaultImpls {
        @NotNull
        public static Matrix44 base(@NotNull IIndexedPolygon $this, @NotNull IVertexData vertexData) {
            Intrinsics.checkNotNullParameter(vertexData, "vertexData");
            Vector3 u = vertexData.getPositions().get(((Number)$this.getPositions().get(1)).intValue()).minus(vertexData.getPositions().get(((Number)$this.getPositions().get(0)).intValue()));
            Vector3 v = vertexData.getPositions().get(((Number)$this.getPositions().get($this.getPositions().size() - 1)).intValue()).minus(vertexData.getPositions().get(((Number)$this.getPositions().get(0)).intValue()));
            Vector3 normal = u.cross(v);
            Vector3 bitangent = normal.cross(u);
            return Matrix44.Companion.fromColumnVectors((Vector4)u.xyz0().getNormalized(), (Vector4)bitangent.xyz0().getNormalized(), (Vector4)normal.xyz0().getNormalized(), Vector4.Companion.getUNIT_W());
        }

        public static boolean isPlanar(@NotNull IIndexedPolygon $this, @NotNull IVertexData vertexData, double eps) {
            boolean bl;
            block5: {
                Intrinsics.checkNotNullParameter(vertexData, "vertexData");
                if ($this.getPositions().size() <= 3) {
                    bl = true;
                } else {
                    Vector3 n0 = DefaultImpls.isPlanar$normal(vertexData, $this, 0);
                    Iterable $this$all$iv = RangesKt.until(1, $this.getPositions().size() - 2);
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        Iterator iterator2 = $this$all$iv.iterator();
                        while (iterator2.hasNext()) {
                            int element$iv;
                            int it = element$iv = ((IntIterator)iterator2).nextInt();
                            boolean bl2 = false;
                            if (n0.dot(DefaultImpls.isPlanar$normal(vertexData, $this, it)) >= 1.0 - eps) continue;
                            bl = false;
                            break block5;
                        }
                        bl = true;
                    }
                }
            }
            return bl;
        }

        public static /* synthetic */ boolean isPlanar$default(IIndexedPolygon iIndexedPolygon, IVertexData iVertexData, double d, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isPlanar");
            }
            if ((n & 2) != 0) {
                d = 0.01;
            }
            return iIndexedPolygon.isPlanar(iVertexData, d);
        }

        public static boolean isConvex(@NotNull IIndexedPolygon $this, @NotNull IVertexData vertexData) {
            Intrinsics.checkNotNullParameter(vertexData, "vertexData");
            Matrix44 planar = $this.base(vertexData).inversed();
            if ($this.getPositions().size() < 3) {
                return false;
            }
            Vector2 old = DefaultImpls.isConvex$p(planar, vertexData.getPositions().get(((Number)$this.getPositions().get($this.getPositions().size() - 2)).intValue()));
            Vector2 vector2 = DefaultImpls.isConvex$p(planar, vertexData.getPositions().get(((Number)$this.getPositions().get($this.getPositions().size() - 1)).intValue()));
            double newDirection = Math.atan2(vector2.y() - old.y(), vector2.x() - old.x());
            double angleSum = 0.0;
            double oldDirection = 0.0;
            double orientation = Double.POSITIVE_INFINITY;
            Iterator iterator2 = ((Iterable)$this.getPositions()).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                Vector2 newPoint;
                int ndx = n++;
                int newPointIndex = ((Number)iterator2.next()).intValue();
                old = vector2;
                oldDirection = newDirection;
                vector2 = newPoint = DefaultImpls.isConvex$p(planar, vertexData.getPositions().get(newPointIndex));
                newDirection = Math.atan2(vector2.y() - old.y(), vector2.x() - old.x());
                if (Intrinsics.areEqual(old, vector2)) {
                    return false;
                }
                double angle = newDirection - oldDirection;
                if (angle <= -Math.PI) {
                    angle += Math.PI * 2;
                }
                if (angle > Math.PI) {
                    angle -= Math.PI * 2;
                }
                if (ndx == 0) {
                    if (angle == 0.0) {
                        return false;
                    }
                    orientation = angle > 0.0 ? 1.0 : -1.0;
                } else if (orientation * angle <= 0.0) {
                    return false;
                }
                angleSum += angle;
            }
            return Math.abs(Math.rint(angleSum / (Math.PI * 2))) == 1.0;
        }

        @NotNull
        public static Vector3 normal(@NotNull IIndexedPolygon $this, @NotNull IVertexData vertexData) {
            Intrinsics.checkNotNullParameter(vertexData, "vertexData");
            Vector3 u = vertexData.getPositions().get(((Number)$this.getPositions().get(1)).intValue()).minus(vertexData.getPositions().get(((Number)$this.getPositions().get(0)).intValue()));
            Vector3 v = vertexData.getPositions().get(((Number)$this.getPositions().get(2)).intValue()).minus(vertexData.getPositions().get(((Number)$this.getPositions().get(0)).intValue()));
            return (Vector3)u.cross(v).getNormalized();
        }

        private static Vector3 isPlanar$normal(IVertexData $vertexData, IIndexedPolygon this$0, int i) {
            int n = i - 1;
            int n2 = this$0.getPositions().size();
            int n3 = n % n2;
            Vector3 p0 = $vertexData.getPositions().get(((Number)this$0.getPositions().get(n3 + (n2 & ((n3 ^ n2) & (n3 | -n3)) >> 31))).intValue());
            n2 = i;
            n3 = this$0.getPositions().size();
            int n4 = n2 % n3;
            Vector3 p1 = $vertexData.getPositions().get(((Number)this$0.getPositions().get(n4 + (n3 & ((n4 ^ n3) & (n4 | -n4)) >> 31))).intValue());
            n3 = i + 1;
            n4 = this$0.getPositions().size();
            int n5 = n3 % n4;
            Vector3 p2 = $vertexData.getPositions().get(((Number)this$0.getPositions().get(n5 + (n4 & ((n5 ^ n4) & (n5 | -n5)) >> 31))).intValue());
            Vector3 u = (Vector3)p0.minus(p1).getNormalized();
            Vector3 v = (Vector3)p2.minus(p1).getNormalized();
            return (Vector3)u.cross(v).getNormalized();
        }

        private static Vector2 isConvex$p(Matrix44 planar, Vector3 v) {
            return planar.times(v.xyz1()).xy();
        }
    }
}

