/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.fx.distort;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.Filter1to1;
import org.openrndr.extra.fx.FilterToolsKt;
import org.openrndr.extra.parameters.BooleanParameter;
import org.openrndr.extra.parameters.ColorParameter;
import org.openrndr.extra.parameters.Description;
import org.openrndr.extra.parameters.DoubleParameter;

@Description(title="Tape noise")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b/\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R+\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR1\u0010\r\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u0011\u0010\f\u0012\u0004\b\u000e\u0010\u0003\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\nR1\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u0016\u0010\f\u0012\u0004\b\u0013\u0010\u0003\u001a\u0004\b\u0014\u0010\b\"\u0004\b\u0015\u0010\nR1\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u001b\u0010\f\u0012\u0004\b\u0018\u0010\u0003\u001a\u0004\b\u0019\u0010\b\"\u0004\b\u001a\u0010\nR1\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b \u0010\f\u0012\u0004\b\u001d\u0010\u0003\u001a\u0004\b\u001e\u0010\b\"\u0004\b\u001f\u0010\nR1\u0010!\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b%\u0010\f\u0012\u0004\b\"\u0010\u0003\u001a\u0004\b#\u0010\b\"\u0004\b$\u0010\nR1\u0010&\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b*\u0010\f\u0012\u0004\b'\u0010\u0003\u001a\u0004\b(\u0010\b\"\u0004\b)\u0010\nR1\u0010+\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b/\u0010\f\u0012\u0004\b,\u0010\u0003\u001a\u0004\b-\u0010\b\"\u0004\b.\u0010\nR1\u00100\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b4\u0010\f\u0012\u0004\b1\u0010\u0003\u001a\u0004\b2\u0010\b\"\u0004\b3\u0010\nR1\u00106\u001a\u0002052\u0006\u0010\u0004\u001a\u0002058F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b<\u0010\f\u0012\u0004\b7\u0010\u0003\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R1\u0010>\u001a\u00020=2\u0006\u0010\u0004\u001a\u00020=8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\bD\u0010\f\u0012\u0004\b?\u0010\u0003\u001a\u0004\b@\u0010A\"\u0004\bB\u0010C\u00a8\u0006E"}, d2={"Lorg/openrndr/extra/fx/distort/TapeNoise;", "Lorg/openrndr/draw/Filter1to1;", "<init>", "()V", "<set-?>", "", "time", "getTime", "()D", "setTime", "(D)V", "time$delegate", "Ljava/util/Map;", "gain", "getGain$annotations", "getGain", "setGain", "gain$delegate", "noiseLow", "getNoiseLow$annotations", "getNoiseLow", "setNoiseLow", "noiseLow$delegate", "noiseHigh", "getNoiseHigh$annotations", "getNoiseHigh", "setNoiseHigh", "noiseHigh$delegate", "gapFrequency", "getGapFrequency$annotations", "getGapFrequency", "setGapFrequency", "gapFrequency$delegate", "gapLow", "getGapLow$annotations", "getGapLow", "setGapLow", "gapLow$delegate", "gapHigh", "getGapHigh$annotations", "getGapHigh", "setGapHigh", "gapHigh$delegate", "deformAmplitude", "getDeformAmplitude$annotations", "getDeformAmplitude", "setDeformAmplitude", "deformAmplitude$delegate", "deformFrequency", "getDeformFrequency$annotations", "getDeformFrequency", "setDeformFrequency", "deformFrequency$delegate", "Lorg/openrndr/color/ColorRGBa;", "tint", "getTint$annotations", "getTint", "()Lorg/openrndr/color/ColorRGBa;", "setTint", "(Lorg/openrndr/color/ColorRGBa;)V", "tint$delegate", "", "monochrome", "getMonochrome$annotations", "getMonochrome", "()Z", "setMonochrome", "(Z)V", "monochrome$delegate", "orx-fx"})
public final class TapeNoise
extends Filter1to1 {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Map time$delegate = this.getParameters();
    @NotNull
    private final Map gain$delegate = this.getParameters();
    @NotNull
    private final Map noiseLow$delegate = this.getParameters();
    @NotNull
    private final Map noiseHigh$delegate = this.getParameters();
    @NotNull
    private final Map gapFrequency$delegate = this.getParameters();
    @NotNull
    private final Map gapLow$delegate = this.getParameters();
    @NotNull
    private final Map gapHigh$delegate = this.getParameters();
    @NotNull
    private final Map deformAmplitude$delegate = this.getParameters();
    @NotNull
    private final Map deformFrequency$delegate = this.getParameters();
    @NotNull
    private final Map tint$delegate = this.getParameters();
    @NotNull
    private final Map monochrome$delegate = this.getParameters();

    public TapeNoise() {
        super(FilterToolsKt.mppFilterShader("out vec4 o_output;\nuniform sampler2D tex0;\nin vec2 v_texCoord0;\nuniform float time;\n\nuniform float gain;\nuniform float noiseLow;\nuniform float noiseHigh;\nuniform vec4 tint;\nuniform bool monochrome;\nuniform float deformAmplitude;\nuniform float deformFrequency;\nuniform float gapFrequency;\nuniform float gapLow;\nuniform float gapHigh;\n\n#define HASHSCALE 443.8975\nvec2 hash22(vec2 p) {\n    vec3 p3 = fract(vec3(p.xyx) * HASHSCALE);\n    p3 += dot(p3, p3.yzx+19.19);\n    return fract(vec2((p3.x + p3.y)*p3.z, (p3.x+p3.z)*p3.y));\n}\n\nvec3 saturate(vec3 x) {\n    return clamp(x, vec3(0.0), vec3(1.0));\n}\n\nvec3 aberrationColor(float f) {\n    f = f * 3.0 - 1.5;\n    return saturate(vec3(-f, 1.0 - abs(f), f));\n}\n\nvoid main() {\n    float dk = 1.0/600.0;\n    o_output = vec4(0.0);\n    for (int k = 0; k < 10; ++k ) {\n        vec2 duv = v_texCoord0;\n        duv.y += smoothstep(pow(cos(time+float(k)*dk+v_texCoord0.y*1.0),10.0)*0.1+0.1, 0.0, v_texCoord0.x)*deformAmplitude * cos((time+float(k)*dk)*deformFrequency);\n        duv.y += smoothstep(pow(1.0-cos(time+float(k)*dk+v_texCoord0.y*1.0),10.0)*0.1+0.1, 0.9, v_texCoord0.x)*deformAmplitude * cos((time+float(k)*dk)*deformFrequency);\n        duv.y += sin(v_texCoord0.x*3.1415926535)*0.0;\n        float bc = floor(hash22(vec2(time+float(k)*dk, (time+float(k)*dk)*0.1)).x*20.0);\n\n        float gb3 = floor(duv.y*bc)/bc;\n\n        vec2 v = hash22(duv.xy*0.003+time+float(k)*dk);\n        vec2 v2 = hash22(duv.xy*0.03+time+float(k)*dk);\n        vec2 v2b = hash22(duv.yx*0.03+time+float(k)*dk);\n        float stretch = (cos(time+float(k)*dk)*0.001+0.002)*0.3+0.001;\n        vec2 h = hash22(duv.yy*stretch+time+float(k)*dk);\n        float gap = smoothstep(gapLow, gapHigh, cos(gb3*(gapFrequency+duv.y*gapFrequency + (time+float(k)*dk)*gapFrequency) +duv.x*gapFrequency)) * (cos(gb3)*0.5+0.5);\n\n        float r = smoothstep(noiseLow, noiseHigh, h.x*gap*v2.x)*1.0;\n        float g = smoothstep(noiseLow, noiseHigh, h.x*gap*v2.y)*1.0;\n        float b = smoothstep(noiseLow, noiseHigh, h.x*gap*v2b.x)*1.0;\n        float a = smoothstep(noiseLow, noiseHigh, h.x*gap*v2b.y)*1.0;\n        if (!monochrome) {\n            o_output += vec4(r, g, b, a)*gain * tint;\n        } else {\n            o_output += vec4(r, r, r, a)*gain * tint;\n        }\n    }\n    o_output *= o_output.a;\n    o_output += texture(tex0, v_texCoord0);\n}", "tape-noise"), null, 2, null);
        this.setGain(0.5);
        this.setNoiseLow(0.5);
        this.setNoiseHigh(0.8);
        this.setTint(ColorRGBa.Companion.getWHITE());
        this.setMonochrome(false);
        this.setGapFrequency(10.0);
        this.setGapLow(-1.0);
        this.setGapHigh(-0.99);
    }

    public final double getTime() {
        Map map2 = this.time$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[0].getName())).doubleValue();
    }

    public final void setTime(double d) {
        Map map2 = this.time$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[0];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    public final double getGain() {
        Map map2 = this.gain$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[1].getName())).doubleValue();
    }

    public final void setGain(double d) {
        Map map2 = this.gain$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[1];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="gain", low=0.0, high=1.0)
    public static /* synthetic */ void getGain$annotations() {
    }

    public final double getNoiseLow() {
        Map map2 = this.noiseLow$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[2].getName())).doubleValue();
    }

    public final void setNoiseLow(double d) {
        Map map2 = this.noiseLow$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[2];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="noise low", low=0.0, high=1.0)
    public static /* synthetic */ void getNoiseLow$annotations() {
    }

    public final double getNoiseHigh() {
        Map map2 = this.noiseHigh$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[3].getName())).doubleValue();
    }

    public final void setNoiseHigh(double d) {
        Map map2 = this.noiseHigh$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[3];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="noise high", low=0.0, high=1.0)
    public static /* synthetic */ void getNoiseHigh$annotations() {
    }

    public final double getGapFrequency() {
        Map map2 = this.gapFrequency$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[4].getName())).doubleValue();
    }

    public final void setGapFrequency(double d) {
        Map map2 = this.gapFrequency$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[4];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="gap frequency", low=0.0, high=2.0)
    public static /* synthetic */ void getGapFrequency$annotations() {
    }

    public final double getGapLow() {
        Map map2 = this.gapLow$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[5].getName())).doubleValue();
    }

    public final void setGapLow(double d) {
        Map map2 = this.gapLow$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[5];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="gap low", low=-1.0, high=1.0)
    public static /* synthetic */ void getGapLow$annotations() {
    }

    public final double getGapHigh() {
        Map map2 = this.gapHigh$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[6].getName())).doubleValue();
    }

    public final void setGapHigh(double d) {
        Map map2 = this.gapHigh$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[6];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="gap high", low=-1.0, high=1.0)
    public static /* synthetic */ void getGapHigh$annotations() {
    }

    public final double getDeformAmplitude() {
        Map map2 = this.deformAmplitude$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[7].getName())).doubleValue();
    }

    public final void setDeformAmplitude(double d) {
        Map map2 = this.deformAmplitude$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[7];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="deform amplitude", low=0.0, high=1.0)
    public static /* synthetic */ void getDeformAmplitude$annotations() {
    }

    public final double getDeformFrequency() {
        Map map2 = this.deformFrequency$delegate;
        return ((Number)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[8].getName())).doubleValue();
    }

    public final void setDeformFrequency(double d) {
        Map map2 = this.deformFrequency$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[8];
        Double d2 = d;
        map2.put(kProperty.getName(), d2);
    }

    @DoubleParameter(label="deform frequency", low=0.0, high=1.0)
    public static /* synthetic */ void getDeformFrequency$annotations() {
    }

    @NotNull
    public final ColorRGBa getTint() {
        Map map2 = this.tint$delegate;
        return (ColorRGBa)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[9].getName());
    }

    public final void setTint(@NotNull ColorRGBa colorRGBa) {
        Intrinsics.checkNotNullParameter(colorRGBa, "<set-?>");
        Map map2 = this.tint$delegate;
        map2.put($$delegatedProperties[9].getName(), colorRGBa);
    }

    @ColorParameter(label="tint")
    public static /* synthetic */ void getTint$annotations() {
    }

    public final boolean getMonochrome() {
        Map map2 = this.monochrome$delegate;
        return (Boolean)MapsKt.getOrImplicitDefaultNullable(map2, $$delegatedProperties[10].getName());
    }

    public final void setMonochrome(boolean bl) {
        Map map2 = this.monochrome$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[10];
        Boolean bl2 = bl;
        map2.put(kProperty.getName(), bl2);
    }

    @BooleanParameter(label="monochrome")
    public static /* synthetic */ void getMonochrome$annotations() {
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(TapeNoise.class, "time", "getTime()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(TapeNoise.class, "gain", "getGain()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(TapeNoise.class, "noiseLow", "getNoiseLow()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(TapeNoise.class, "noiseHigh", "getNoiseHigh()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(TapeNoise.class, "gapFrequency", "getGapFrequency()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(TapeNoise.class, "gapLow", "getGapLow()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(TapeNoise.class, "gapHigh", "getGapHigh()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(TapeNoise.class, "deformAmplitude", "getDeformAmplitude()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(TapeNoise.class, "deformFrequency", "getDeformFrequency()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(TapeNoise.class, "tint", "getTint()Lorg/openrndr/color/ColorRGBa;", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(TapeNoise.class, "monochrome", "getMonochrome()Z", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

