/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.fx.blur;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferKt;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.Filter;
import org.openrndr.draw.Filter1to1;
import org.openrndr.extra.fx.FilterToolsKt;
import org.openrndr.extra.fx.blur.BloomCombine;
import org.openrndr.extra.fx.blur.BloomDownscale;
import org.openrndr.extra.fx.blur.BloomUpscale;
import org.openrndr.extra.parameters.Description;
import org.openrndr.extra.parameters.DoubleParameter;
import org.openrndr.shape.Rectangle;

@Description(title="MipBloom")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0017\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J3\u0010>\u001a\u00020?2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020*0A2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020*0A2\b\u0010C\u001a\u0004\u0018\u00010DH\u0016\u00a2\u0006\u0002\u0010ER\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0019\u0010\u0013\u001a\u0004\b\u001a\u0010\u0015\"\u0004\b\u001b\u0010\u0017R$\u0010\u001c\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001d\u0010\u0013\u001a\u0004\b\u001e\u0010\u0015\"\u0004\b\u001f\u0010\u0017R$\u0010 \u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b!\u0010\u0013\u001a\u0004\b\"\u0010\u0015\"\u0004\b#\u0010\u0017R$\u0010$\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b%\u0010\u0013\u001a\u0004\b&\u0010\u0015\"\u0004\b'\u0010\u0017R \u0010(\u001a\b\u0012\u0004\u0012\u00020*0)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R \u0010/\u001a\b\u0012\u0004\u0012\u00020*0)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010,\"\u0004\b1\u0010.R\u0011\u00102\u001a\u000203\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0011\u00106\u001a\u000207\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0011\u0010:\u001a\u00020;\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=\u00a8\u0006F"}, d2={"Lorg/openrndr/extra/fx/blur/MipBloom;", "T", "Lorg/openrndr/draw/Filter;", "Lorg/openrndr/draw/Filter1to1;", "blur", "<init>", "(Lorg/openrndr/draw/Filter;)V", "getBlur", "()Lorg/openrndr/draw/Filter;", "Lorg/openrndr/draw/Filter;", "passes", "", "getPasses", "()I", "setPasses", "(I)V", "shape", "", "getShape$annotations", "()V", "getShape", "()D", "setShape", "(D)V", "gain", "getGain$annotations", "getGain", "setGain", "pregain", "getPregain$annotations", "getPregain", "setPregain", "noiseGain", "getNoiseGain$annotations", "getNoiseGain", "setNoiseGain", "noiseSeed", "getNoiseSeed$annotations", "getNoiseSeed", "setNoiseSeed", "intermediates", "", "Lorg/openrndr/draw/ColorBuffer;", "getIntermediates", "()Ljava/util/List;", "setIntermediates", "(Ljava/util/List;)V", "blurred", "getBlurred", "setBlurred", "upscale", "Lorg/openrndr/extra/fx/blur/BloomUpscale;", "getUpscale", "()Lorg/openrndr/extra/fx/blur/BloomUpscale;", "downScale", "Lorg/openrndr/extra/fx/blur/BloomDownscale;", "getDownScale", "()Lorg/openrndr/extra/fx/blur/BloomDownscale;", "combine", "Lorg/openrndr/extra/fx/blur/BloomCombine;", "getCombine", "()Lorg/openrndr/extra/fx/blur/BloomCombine;", "apply", "", "source", "", "target", "clip", "Lorg/openrndr/shape/Rectangle;", "([Lorg/openrndr/draw/ColorBuffer;[Lorg/openrndr/draw/ColorBuffer;Lorg/openrndr/shape/Rectangle;)V", "orx-fx"})
@SourceDebugExtension(value={"SMAP\nMipBloom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MipBloom.kt\norg/openrndr/extra/fx/blur/MipBloom\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,158:1\n1863#2,2:159\n1863#2,2:161\n37#3:163\n36#3,3:164\n*S KotlinDebug\n*F\n+ 1 MipBloom.kt\norg/openrndr/extra/fx/blur/MipBloom\n*L\n82#1:159,2\n85#1:161,2\n110#1:163\n110#1:164,3\n*E\n"})
public class MipBloom<T extends Filter>
extends Filter1to1 {
    @NotNull
    private final T blur;
    private int passes;
    private double shape;
    private double gain;
    private double pregain;
    private double noiseGain;
    private double noiseSeed;
    @NotNull
    private List<ColorBuffer> intermediates;
    @NotNull
    private List<ColorBuffer> blurred;
    @NotNull
    private final BloomUpscale upscale;
    @NotNull
    private final BloomDownscale downScale;
    @NotNull
    private final BloomCombine combine;

    public MipBloom(@NotNull T blur) {
        Intrinsics.checkNotNullParameter(blur, "blur");
        super(FilterToolsKt.mppFilterShader("out vec4 o_output;\nin vec2 v_texCoord0;\n\nuniform sampler2D tex0;\nuniform sampler2D tex1;\n\nuniform float gain;\nuniform float pregain;\nuniform vec4 bias;\n\nvoid main() {\n\to_output = texture(tex0, v_texCoord0) * pregain +  texture(tex1, v_texCoord0)*gain;\n\to_output.a = clamp(o_output.a, 0.0, 1.0);\n}", "bloom-combine"), null, 2, null);
        this.blur = blur;
        this.passes = 6;
        this.shape = 1.0;
        this.gain = 1.0;
        this.pregain = 1.0;
        this.noiseGain = 0.25;
        this.intermediates = new ArrayList();
        this.blurred = new ArrayList();
        this.upscale = new BloomUpscale();
        this.downScale = new BloomDownscale();
        this.combine = new BloomCombine();
    }

    @NotNull
    public final T getBlur() {
        return this.blur;
    }

    public final int getPasses() {
        return this.passes;
    }

    public final void setPasses(int n) {
        this.passes = n;
    }

    public final double getShape() {
        return this.shape;
    }

    public final void setShape(double d) {
        this.shape = d;
    }

    @DoubleParameter(label="shape", low=0.0, high=4.0)
    public static /* synthetic */ void getShape$annotations() {
    }

    public final double getGain() {
        return this.gain;
    }

    public final void setGain(double d) {
        this.gain = d;
    }

    @DoubleParameter(label="gain", low=0.0, high=4.0)
    public static /* synthetic */ void getGain$annotations() {
    }

    public final double getPregain() {
        return this.pregain;
    }

    public final void setPregain(double d) {
        this.pregain = d;
    }

    @DoubleParameter(label="pregain", low=0.0, high=4.0)
    public static /* synthetic */ void getPregain$annotations() {
    }

    public final double getNoiseGain() {
        return this.noiseGain;
    }

    public final void setNoiseGain(double d) {
        this.noiseGain = d;
    }

    @DoubleParameter(label="noise gain", low=0.0, high=1.0)
    public static /* synthetic */ void getNoiseGain$annotations() {
    }

    public final double getNoiseSeed() {
        return this.noiseSeed;
    }

    public final void setNoiseSeed(double d) {
        this.noiseSeed = d;
    }

    @DoubleParameter(label="noise seed", low=0.0, high=1000.0)
    public static /* synthetic */ void getNoiseSeed$annotations() {
    }

    @NotNull
    public final List<ColorBuffer> getIntermediates() {
        return this.intermediates;
    }

    public final void setIntermediates(@NotNull List<ColorBuffer> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.intermediates = list;
    }

    @NotNull
    public final List<ColorBuffer> getBlurred() {
        return this.blurred;
    }

    public final void setBlurred(@NotNull List<ColorBuffer> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.blurred = list;
    }

    @NotNull
    public final BloomUpscale getUpscale() {
        return this.upscale;
    }

    @NotNull
    public final BloomDownscale getDownScale() {
        return this.downScale;
    }

    @NotNull
    public final BloomCombine getCombine() {
        return this.combine;
    }

    @Override
    public void apply(@NotNull ColorBuffer[] source, @NotNull ColorBuffer[] target2, @Nullable Rectangle clip) {
        int $i$f$forEach;
        ColorBuffer colorBuffer;
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(target2, "target");
        if (!(clip == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.upscale.setShape(this.shape);
        if (this.intermediates.size() != this.passes || !((Collection)this.intermediates).isEmpty() && !ColorBufferKt.isEquivalentTo$default(colorBuffer = this.intermediates.get(0), target2[0], false, false, false, true, true, false, false, 206, null)) {
            ColorBuffer it;
            Iterable $this$forEach$iv = this.intermediates;
            $i$f$forEach = 0;
            for (Object element$iv : $this$forEach$iv) {
                it = (ColorBuffer)element$iv;
                boolean bl = false;
                it.destroy();
            }
            $this$forEach$iv = this.blurred;
            $i$f$forEach = 0;
            for (Object element$iv : $this$forEach$iv) {
                it = (ColorBuffer)element$iv;
                boolean bl = false;
                it.destroy();
            }
            this.intermediates.clear();
            this.blurred.clear();
            $i$f$forEach = this.passes;
            for (int pass = 0; pass < $i$f$forEach; ++pass) {
                int tdiv = 1 << pass + 1;
                ColorBuffer cb = ColorBufferKt.colorBuffer$default(target2[0].getWidth() / tdiv, target2[0].getHeight() / tdiv, 0.0, null, ColorType.FLOAT32, null, 0, null, 236, null);
                this.intermediates.add(cb);
                ColorBuffer cbb = ColorBufferKt.colorBuffer$default(target2[0].getWidth() / tdiv, target2[0].getHeight() / tdiv, 0.0, null, ColorType.FLOAT32, null, 0, null, 236, null);
                this.blurred.add(cbb);
            }
        }
        this.upscale.setNoiseGain(this.noiseGain);
        this.upscale.setNoiseSeed(this.noiseSeed);
        this.downScale.apply(source[0], this.intermediates.get(0), clip);
        ((Filter)this.blur).apply(this.intermediates.get(0), this.blurred.get(0), clip);
        $i$f$forEach = this.passes;
        for (int pass = 1; pass < $i$f$forEach; ++pass) {
            this.downScale.apply(this.blurred.get(pass - 1), this.intermediates.get(pass), clip);
            ((Filter)this.blur).apply(this.intermediates.get(pass), this.blurred.get(pass), clip);
        }
        Collection $this$toTypedArray$iv = this.blurred;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ColorBuffer[] colorBufferArray = new ColorBuffer[]{target2[0]};
        this.upscale.apply(thisCollection$iv.toArray(new ColorBuffer[0]), colorBufferArray, clip);
        this.combine.setGain(this.gain);
        this.combine.setPregain(this.pregain);
        colorBufferArray = new ColorBuffer[]{source[0], target2[0]};
        this.combine.apply(colorBufferArray, target2, clip);
    }
}

