/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.fx.blur;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferKt;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.Filter1to1;
import org.openrndr.extra.fx.blur.LaserBlurKt;
import org.openrndr.extra.fx.blur.LaserBlurPass;
import org.openrndr.extra.parameters.Description;
import org.openrndr.extra.parameters.DoubleParameter;
import org.openrndr.extra.parameters.IntParameter;
import org.openrndr.extra.parameters.Vector2Parameter;
import org.openrndr.math.Vector2;
import org.openrndr.shape.Rectangle;

@Description(title="Laser blur")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010<\u001a\u00020=2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002090?2\f\u0010@\u001a\b\u0012\u0004\u0012\u0002090?2\b\u0010A\u001a\u0004\u0018\u00010BH\u0016\u00a2\u0006\u0002\u0010CR$\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR$\u0010\u000b\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\r\u0010\u0003\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0013\u0010\u0003\u001a\u0004\b\u0014\u0010\u000f\"\u0004\b\u0015\u0010\u0011R$\u0010\u0016\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0017\u0010\u0003\u001a\u0004\b\u0018\u0010\u000f\"\u0004\b\u0019\u0010\u0011R$\u0010\u001a\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001b\u0010\u0003\u001a\u0004\b\u001c\u0010\u000f\"\u0004\b\u001d\u0010\u0011R$\u0010\u001e\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001f\u0010\u0003\u001a\u0004\b \u0010\u000f\"\u0004\b!\u0010\u0011R$\u0010\"\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b#\u0010\u0003\u001a\u0004\b$\u0010\u000f\"\u0004\b%\u0010\u0011R$\u0010&\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b'\u0010\u0003\u001a\u0004\b(\u0010\u000f\"\u0004\b)\u0010\u0011R$\u0010*\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b+\u0010\u0003\u001a\u0004\b,\u0010\u000f\"\u0004\b-\u0010\u0011R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u00100\u001a\u0002018\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b2\u0010\u0003\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u0017\u00107\u001a\b\u0012\u0004\u0012\u00020908\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;\u00a8\u0006D"}, d2={"Lorg/openrndr/extra/fx/blur/LaserBlur;", "Lorg/openrndr/draw/Filter1to1;", "<init>", "()V", "center", "Lorg/openrndr/math/Vector2;", "getCenter$annotations", "getCenter", "()Lorg/openrndr/math/Vector2;", "setCenter", "(Lorg/openrndr/math/Vector2;)V", "radius", "", "getRadius$annotations", "getRadius", "()D", "setRadius", "(D)V", "amp0", "getAmp0$annotations", "getAmp0", "setAmp0", "amp1", "getAmp1$annotations", "getAmp1", "setAmp1", "vignette", "getVignette$annotations", "getVignette", "setVignette", "vignetteSize", "getVignetteSize$annotations", "getVignetteSize", "setVignetteSize", "aberration", "getAberration$annotations", "getAberration", "setAberration", "exp", "getExp$annotations", "getExp", "setExp", "phase", "getPhase$annotations", "getPhase", "setPhase", "pass", "Lorg/openrndr/extra/fx/blur/LaserBlurPass;", "passes", "", "getPasses$annotations", "getPasses", "()I", "setPasses", "(I)V", "intermediates", "", "Lorg/openrndr/draw/ColorBuffer;", "getIntermediates", "()Ljava/util/List;", "apply", "", "source", "", "target", "clip", "Lorg/openrndr/shape/Rectangle;", "([Lorg/openrndr/draw/ColorBuffer;[Lorg/openrndr/draw/ColorBuffer;Lorg/openrndr/shape/Rectangle;)V", "orx-fx"})
@SourceDebugExtension(value={"SMAP\nLaserBlur.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LaserBlur.kt\norg/openrndr/extra/fx/blur/LaserBlur\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1734#2,3:106\n1863#2,2:109\n*S KotlinDebug\n*F\n+ 1 LaserBlur.kt\norg/openrndr/extra/fx/blur/LaserBlur\n*L\n79#1:106,3\n80#1:109,2\n*E\n"})
public final class LaserBlur
extends Filter1to1 {
    @NotNull
    private Vector2 center = Vector2.Companion.getZERO();
    private double radius = -0.18;
    private double amp0 = 0.5;
    private double amp1 = 0.5;
    private double vignette;
    private double vignetteSize;
    private double aberration = 0.006;
    private double exp = 0.739;
    private double phase;
    @NotNull
    private final LaserBlurPass pass = new LaserBlurPass();
    private int passes = 15;
    @NotNull
    private final List<ColorBuffer> intermediates = new ArrayList();

    public LaserBlur() {
        super(null, null, 3, null);
    }

    @NotNull
    public final Vector2 getCenter() {
        return this.center;
    }

    public final void setCenter(@NotNull Vector2 vector2) {
        Intrinsics.checkNotNullParameter(vector2, "<set-?>");
        this.center = vector2;
    }

    @Vector2Parameter(label="center", order=0)
    public static /* synthetic */ void getCenter$annotations() {
    }

    public final double getRadius() {
        return this.radius;
    }

    public final void setRadius(double d) {
        this.radius = d;
    }

    @DoubleParameter(label="radius", low=-2.0, high=2.0, order=1)
    public static /* synthetic */ void getRadius$annotations() {
    }

    public final double getAmp0() {
        return this.amp0;
    }

    public final void setAmp0(double d) {
        this.amp0 = d;
    }

    @DoubleParameter(label="amp0", low=0.0, high=1.0, order=2)
    public static /* synthetic */ void getAmp0$annotations() {
    }

    public final double getAmp1() {
        return this.amp1;
    }

    public final void setAmp1(double d) {
        this.amp1 = d;
    }

    @DoubleParameter(label="amp1", low=0.0, high=1.0, order=3)
    public static /* synthetic */ void getAmp1$annotations() {
    }

    public final double getVignette() {
        return this.vignette;
    }

    public final void setVignette(double d) {
        this.vignette = d;
    }

    @DoubleParameter(label="vignette", low=0.0, high=1.0, order=4)
    public static /* synthetic */ void getVignette$annotations() {
    }

    public final double getVignetteSize() {
        return this.vignetteSize;
    }

    public final void setVignetteSize(double d) {
        this.vignetteSize = d;
    }

    @DoubleParameter(label="vignette size", low=0.0, high=1.0, order=5)
    public static /* synthetic */ void getVignetteSize$annotations() {
    }

    public final double getAberration() {
        return this.aberration;
    }

    public final void setAberration(double d) {
        this.aberration = d;
    }

    @DoubleParameter(label="aberration", low=-1.0, high=1.0, order=6)
    public static /* synthetic */ void getAberration$annotations() {
    }

    public final double getExp() {
        return this.exp;
    }

    public final void setExp(double d) {
        this.exp = d;
    }

    @DoubleParameter(label="exp", low=-1.0, high=1.0, order=7)
    public static /* synthetic */ void getExp$annotations() {
    }

    public final double getPhase() {
        return this.phase;
    }

    public final void setPhase(double d) {
        this.phase = d;
    }

    @DoubleParameter(label="phase", low=-1.0, high=1.0, order=7)
    public static /* synthetic */ void getPhase$annotations() {
    }

    public final int getPasses() {
        return this.passes;
    }

    public final void setPasses(int n) {
        this.passes = n;
    }

    @IntParameter(label="passes", low=2, high=32, order=4)
    public static /* synthetic */ void getPasses$annotations() {
    }

    @NotNull
    public final List<ColorBuffer> getIntermediates() {
        return this.intermediates;
    }

    @Override
    public void apply(@NotNull ColorBuffer[] source, @NotNull ColorBuffer[] target2, @Nullable Rectangle clip) {
        ColorBuffer it;
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter(source, "source");
            Intrinsics.checkNotNullParameter(target2, "target");
            this.pass.setCenter(this.center);
            this.pass.setRadius(this.radius);
            this.pass.setAmp0(this.amp0);
            this.pass.setAmp1(this.amp1);
            this.pass.setVignette(this.vignette);
            this.pass.setVignetteSize(this.vignetteSize);
            this.pass.setAberration(this.aberration);
            Iterable $this$all$iv = this.intermediates;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (ColorBuffer)element$iv;
                    boolean bl2 = false;
                    if (ColorBufferKt.isEquivalentTo$default(it, source[0], false, false, false, true, true, false, false, 206, null)) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        if (!bl) {
            Iterable $this$forEach$iv = this.intermediates;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ColorBuffer)element$iv;
                boolean bl3 = false;
                it.destroy();
            }
            this.intermediates.clear();
        }
        if (this.intermediates.size() == 0) {
            this.intermediates.add(ColorBufferKt.createEquivalent$default(source[0], 0, 0, 0.0, null, ColorType.FLOAT16, null, 0, 111, null));
            this.intermediates.add(ColorBufferKt.createEquivalent$default(source[0], 0, 0, 0.0, null, ColorType.FLOAT16, null, 0, 111, null));
        }
        this.pass.setRadius(1.0 + LaserBlurKt.access$pow(this.exp, 0.0) * this.radius);
        this.pass.apply(source[0], this.intermediates.get(0), clip);
        int n = this.passes - 1;
        for (int i = 0; i < n; ++i) {
            this.pass.setRadius(1.0 + LaserBlurKt.access$pow(this.exp, (double)i + 1.0) * this.radius);
            this.pass.apply(this.intermediates.get(i % 2), this.intermediates.get((i + 1) % 2), clip);
        }
        this.pass.setRadius(1.0 + LaserBlurKt.access$pow(this.exp, (double)this.passes * 1.0) * this.radius);
        this.pass.apply(this.intermediates.get((this.passes + 1) % 2), target2[0], clip);
    }
}

