/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.dnk3;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u0011\u0010\b\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0003\"\u0011\u0010\n\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0003\"\u0011\u0010\f\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0003\"\u0011\u0010\u000e\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0003\u00a8\u0006\u0010"}, d2={"shaderNoRepetition", "", "getShaderNoRepetition", "()Ljava/lang/String;", "shaderNoRepetitionVert", "getShaderNoRepetitionVert", "shaderProjectOnPlane", "getShaderProjectOnPlane", "shaderSideOfPlane", "getShaderSideOfPlane", "shaderLinePlaneIntersect", "getShaderLinePlaneIntersect", "shaderVSM", "getShaderVSM", "shaderGGX", "getShaderGGX", "deminityy"})
public final class ShaderUtilitiesKt {
    @NotNull
    private static final String shaderNoRepetition = "\n// -- shaderNoRepetition    \nfloat sum( vec3 v ) { return v.x+v.y+v.z; }\n    \n// based on https://www.shadertoy.com/view/Xtl3zf \nvec4 textureNoTile(in sampler2D noiseTex, in sampler2D tex, in vec2 noiseOffset,  in vec2 x)\n{\n    float v = 1.0;\n    float k = texture(noiseTex, noiseOffset + x*0.01 ).x; // cheap (cache friendly) lookup\n    \n    vec2 duvdx = dFdx( x );\n    vec2 duvdy = dFdx( x );\n    \n    float l = k*8.0;\n    float f = fract(l);\n    \n#if 0\n    float ia = floor(l); // my method\n    float ib = ia + 1.0;\n#else\n    float ia = floor(l+0.5); // suslik's method (see comments)\n    float ib = floor(l);\n    f = min(f, 1.0-f)*2.0;\n#endif    \n    \n    vec2 offa = sin(vec2(3.0,7.0)*ia); // can replace with any other hash\n    vec2 offb = sin(vec2(3.0,7.0)*ib); // can replace with any other hash\n\n    vec3 cola = textureGrad( tex, x + v*offa, duvdx, duvdy ).xyz;\n    vec3 colb = textureGrad( tex, x + v*offb, duvdx, duvdy ).xyz;\n    \n    return vec4(mix( cola, colb, smoothstep(0.2,0.8,f-0.1*sum(cola-colb)) ), 1.0);\n}\n";
    @NotNull
    private static final String shaderNoRepetitionVert = "\n// -- shaderNoRepetitionVert\nfloat sum( vec3 v ) { return v.x+v.y+v.z; }\n    \n// based on https://www.shadertoy.com/view/Xtl3zf \nvec4 textureNoTile(in sampler2D tex, in vec2 noiseOffset, in vec2 x)\n{\n    float v = 1.0;\n    float k = texture(tex, noiseOffset + 0.005*x ).x; // cheap (cache friendly) lookup\n    \n    float l = k*8.0;\n    float f = fract(l);\n    \n#if 0\n    float ia = floor(l); // my method\n    float ib = ia + 1.0;\n#else\n    float ia = floor(l+0.5); // suslik's method (see comments)\n    float ib = floor(l);\n    f = min(f, 1.0-f)*2.0;\n#endif    \n    \n    vec2 offa = sin(vec2(3.0,7.0)*ia); // can replace with any other hash\n    vec2 offb = sin(vec2(3.0,7.0)*ib); // can replace with any other hash\n\n    vec3 cola = texture( tex, x + v*offa).xyz;\n    vec3 colb = texture( tex, x + v*offb).xyz;\n    \n    return vec4(mix( cola, colb, smoothstep(0.2,0.8,f-0.1*sum(cola-colb)) ), 1.0);\n}\n";
    @NotNull
    private static final String shaderProjectOnPlane = "// -- shaderProjectOnPlane\nvec3 projectOnPlane(vec3 p, vec3 pc, vec3 pn) {\n    float distance = dot(pn, p-pc);\n    return p - distance * pn;\n}";
    @NotNull
    private static final String shaderSideOfPlane = "// -- shaderSideOfPlane     \nint sideOfPlane(in vec3 p, in vec3 pc, in vec3 pn){\n   if (dot(p-pc,pn) >= 0.0) return 1; else return 0;\n}";
    @NotNull
    private static final String shaderLinePlaneIntersect = "// -- shaderLinePlaneIntersect    \nvec3 linePlaneIntersect(in vec3 lp, in vec3 lv, in vec3 pc, in vec3 pn){\n   return lp+lv*(dot(pn,pc-lp)/dot(pn,lv));\n}";
    @NotNull
    private static final String shaderVSM = "|// -- shaderVSM    \n|float linstep(float min, float max, float v)\n|{\n|  return clamp((v - min) / (max - min), 0.0, 1.0);\n|}\n|// https://developer.nvidia.com/gpugems/GPUGems3/gpugems3_ch08.html\n|float chebyshevUpperBound(vec2 moments, float t, float minVariance) {\n|   // One-tailed inequality valid if t > Moments.x\n|   float p = (t <= moments.x) ? 1.0 : 0.0;\n|   // Compute variance.\n|   float variance = moments.y - (moments.x * moments.x);\n|   variance = max(variance, minVariance);\n|   // Compute probabilistic upper bound.\n|   float d = t - moments.x;\n|   float p_max = variance / (variance + d*d);\n|   p_max = smoothstep(0.6, 1.0, p_max);\n|   return max(p, p_max);\n}";
    @NotNull
    private static final String shaderGGX = "// -- shaderGGX\n#define bias 0.125\n#define HASHSCALE 443.8975\nvec2 hash22(vec2 p) {\n\tvec3 p3 = fract(vec3(p.xyx) * HASHSCALE);\n    p3 += dot(p3, p3.yzx+19.19);\n    return fract(vec2((p3.x + p3.y)*p3.z, (p3.x+p3.z)*p3.y));\n}\n\n#define PI 3.1415926535\n\nfloat pow5(float x) {\n    float x2 = x * x;\n    return x2 * x2 * x;\n}\n\nfloat D_GGX(float linearRoughness, float NoH, const vec3 h) {\n    // Walter et al. 2007, \"Microfacet Models for Refraction through Rough Surfaces\"\n    float oneMinusNoHSquared = 1.0 - NoH * NoH;\n    float a = NoH * linearRoughness;\n    float k = linearRoughness / (oneMinusNoHSquared + a * a);\n    float d = k * k * (1.0 / PI);\n    return d;\n}\n\nfloat D_GGXm(float linearRoughness, float NoH, const vec3 h, const vec3 n) {\n    vec3 NxH = cross(n, h);\n        float oneMinusNoHSquared = dot(NxH, NxH);\n\n\n    // Walter et al. 2007, \"Microfacet Models for Refraction through Rough Surfaces\"\n    //float oneMinusNoHSquared = 1.0 - NoH * NoH;\n    float a = NoH * linearRoughness;\n    float k = linearRoughness / (oneMinusNoHSquared + a * a);\n    float d = k * k * (1.0 / PI);\n    return d;\n}\n\n\nfloat V_SmithGGXCorrelated(float linearRoughness, float NoV, float NoL) {\n    // Heitz 2014, \"Understanding the Masking-Shadowing Function in Microfacet-Based BRDFs\"\n    float a2 = linearRoughness * linearRoughness;\n    float GGXV = NoL * sqrt((NoV - a2 * NoV) * NoV + a2);\n    float GGXL = NoV * sqrt((NoL - a2 * NoL) * NoL + a2);\n    return 0.5 / (GGXV + GGXL);\n}\n\nvec3 F_Schlick(const vec3 f0, float VoH) {\n    // Schlick 1994, \"An Inexpensive BRDF Model for Physically-Based Rendering\"\n    return f0 + (vec3(1.0) - f0) * pow5(1.0 - VoH);\n}\nvec3 F_SchlickRoughness(vec3 F0, float roughness, float VoH)\n{\n    return F0 + (max(vec3(1.0 - roughness), F0) - F0) * pow(1.0 - VoH, 5.0);\n} \n\nfloat F_Schlick(float f0, float f90, float VoH) {\n    return f0 + (f90 - f0) * pow5(1.0 - VoH);\n}\n\nfloat Fd_Burley(float linearRoughness, float NoV, float NoL, float LoH) {\n    // Burley 2012, \"Physically-Based Shading at Disney\"\n    float f90 = 0.5 + 2.0 * linearRoughness * LoH * LoH;\n    float lightScatter = F_Schlick(1.0, f90, NoL);\n    float viewScatter  = F_Schlick(1.0, f90, NoV);\n    return lightScatter * viewScatter * (1.0 / PI);\n}\n\nvec2 PrefilteredDFG_Karis(float roughness, float NoV) {\n    //https://www.shadertoy.com/view/XlKSDR\n    // Karis 2014, \"Physically Based Material on Mobile\"\n    const vec4 c0 = vec4(-1.0, -0.0275, -0.572,  0.022);\n    const vec4 c1 = vec4( 1.0,  0.0425,  1.040, -0.040);\n\n    vec4 r = roughness * c0 + c1;\n    float a004 = min(r.x * r.x, exp2(-9.28 * NoV)) * r.x + r.y;\n    return vec2(-1.04, 1.04) * a004 + r.zw;\n}\n\nfloat saturate(float x) {\n    return clamp(x, 0.0, 1.0);\n}\n\nfloat G1V(float dotNV, float k)\n{\n\treturn 1.0f/(dotNV*(1.0f-k)+k);\n}\n\nfloat ggx(vec3 N, vec3 V, vec3 L, float roughness, float F0)\n{\n\tfloat alpha = roughness*roughness;\n\n\tvec3 H = normalize(V+L);\n\n\tfloat dotNL = saturate(dot(N,L));\n\tfloat dotNV = saturate(dot(N,V));\n\tfloat dotNH = saturate(dot(N,H));\n\tfloat dotLH = saturate(dot(L,H));\n\n\tfloat F, D, vis;\n\n\t// D\n\tfloat alphaSqr = alpha*alpha;\n\tfloat pi = 3.14159f;\n\tfloat denom = dotNH * dotNH *(alphaSqr-1.0) + 1.0f;\n\tD = alphaSqr/(pi * denom * denom);\n\n\t// F\n\tfloat dotLH5 = pow(1.0f-dotLH,5.0);\n\tF = F0 + (1.0-F0)*(dotLH5);\n\n\t// V\n\tfloat k = alpha/2.0f;\n\tvis = G1V(dotNL,k)*G1V(dotNV,k);\n\n\tfloat specular = dotNL * D * F * vis;\n\treturn specular;\n}";

    @NotNull
    public static final String getShaderNoRepetition() {
        return shaderNoRepetition;
    }

    @NotNull
    public static final String getShaderNoRepetitionVert() {
        return shaderNoRepetitionVert;
    }

    @NotNull
    public static final String getShaderProjectOnPlane() {
        return shaderProjectOnPlane;
    }

    @NotNull
    public static final String getShaderSideOfPlane() {
        return shaderSideOfPlane;
    }

    @NotNull
    public static final String getShaderLinePlaneIntersect() {
        return shaderLinePlaneIntersect;
    }

    @NotNull
    public static final String getShaderVSM() {
        return shaderVSM;
    }

    @NotNull
    public static final String getShaderGGX() {
        return shaderGGX;
    }
}

