/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.dnk3;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.extra.dnk3.Camera;
import org.openrndr.extra.dnk3.SceneNode;
import org.openrndr.math.Matrix44;
import org.openrndr.math.transforms.TransformsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0096\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001a\u0010\u0018\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\u001a\u0010\u001b\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0012\"\u0004\b\u001d\u0010\u0014\u00a8\u0006$"}, d2={"Lorg/openrndr/extra/dnk3/PerspectiveCamera;", "Lorg/openrndr/extra/dnk3/Camera;", "node", "Lorg/openrndr/extra/dnk3/SceneNode;", "<init>", "(Lorg/openrndr/extra/dnk3/SceneNode;)V", "getNode", "()Lorg/openrndr/extra/dnk3/SceneNode;", "setNode", "projectionMatrix", "Lorg/openrndr/math/Matrix44;", "getProjectionMatrix", "()Lorg/openrndr/math/Matrix44;", "viewMatrix", "getViewMatrix", "aspectRatio", "", "getAspectRatio", "()D", "setAspectRatio", "(D)V", "fov", "getFov", "setFov", "far", "getFar", "setFar", "near", "getNear", "setNear", "hashCode", "", "equals", "", "other", "", "deminityy"})
public final class PerspectiveCamera
extends Camera {
    @NotNull
    private SceneNode node;
    private double aspectRatio;
    private double fov;
    private double far;
    private double near;

    public PerspectiveCamera(@NotNull SceneNode node) {
        Intrinsics.checkNotNullParameter(node, "node");
        this.node = node;
        this.aspectRatio = 1.7777777777777777;
        this.fov = 45.0;
        this.far = 100.0;
        this.near = 0.1;
    }

    @NotNull
    public final SceneNode getNode() {
        return this.node;
    }

    public final void setNode(@NotNull SceneNode sceneNode) {
        Intrinsics.checkNotNullParameter(sceneNode, "<set-?>");
        this.node = sceneNode;
    }

    @Override
    @NotNull
    public Matrix44 getProjectionMatrix() {
        return TransformsKt.perspective(this.fov, this.aspectRatio, this.near, this.far);
    }

    @Override
    @NotNull
    public Matrix44 getViewMatrix() {
        return this.node.getWorldTransform().inversed();
    }

    public final double getAspectRatio() {
        return this.aspectRatio;
    }

    public final void setAspectRatio(double d) {
        this.aspectRatio = d;
    }

    public final double getFov() {
        return this.fov;
    }

    public final void setFov(double d) {
        this.fov = d;
    }

    public final double getFar() {
        return this.far;
    }

    public final void setFar(double d) {
        this.far = d;
    }

    public final double getNear() {
        return this.near;
    }

    public final void setNear(double d) {
        this.near = d;
    }

    public int hashCode() {
        int result = Double.hashCode(this.aspectRatio);
        result = 31 * result + Double.hashCode(this.fov);
        result = 31 * result + Double.hashCode(this.far);
        result = 31 * result + Double.hashCode(this.near);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull(other, "null cannot be cast to non-null type org.openrndr.extra.dnk3.PerspectiveCamera");
        PerspectiveCamera cfr_ignored_0 = (PerspectiveCamera)other;
        if (!(this.aspectRatio == ((PerspectiveCamera)other).aspectRatio)) {
            return false;
        }
        if (!(this.fov == ((PerspectiveCamera)other).fov)) {
            return false;
        }
        if (!(this.far == ((PerspectiveCamera)other).far)) {
            return false;
        }
        return this.near == ((PerspectiveCamera)other).near;
    }
}

