/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.dnk3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferTexture;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.Cubemap;
import org.openrndr.draw.DepthBuffer;
import org.openrndr.draw.ProgramRenderTarget;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.ShadeStyle;
import org.openrndr.draw.ShadeStyleKt;
import org.openrndr.draw.ShadeStyleOutput;
import org.openrndr.extra.dnk3.AmbientLight;
import org.openrndr.extra.dnk3.ContextKey;
import org.openrndr.extra.dnk3.CubemapReflection;
import org.openrndr.extra.dnk3.DirectionalLight;
import org.openrndr.extra.dnk3.DummySource;
import org.openrndr.extra.dnk3.FacetCombiner;
import org.openrndr.extra.dnk3.FacetType;
import org.openrndr.extra.dnk3.Fog;
import org.openrndr.extra.dnk3.HemisphereLight;
import org.openrndr.extra.dnk3.Light;
import org.openrndr.extra.dnk3.Material;
import org.openrndr.extra.dnk3.MaterialContext;
import org.openrndr.extra.dnk3.ModelCoordinates;
import org.openrndr.extra.dnk3.NodeContent;
import org.openrndr.extra.dnk3.PBRMaterialKt;
import org.openrndr.extra.dnk3.PointLight;
import org.openrndr.extra.dnk3.PrimitiveContext;
import org.openrndr.extra.dnk3.RenderPassKt;
import org.openrndr.extra.dnk3.SceneNode;
import org.openrndr.extra.dnk3.ShaderUtilitiesKt;
import org.openrndr.extra.dnk3.Shadows;
import org.openrndr.extra.dnk3.SpotLight;
import org.openrndr.extra.dnk3.Texture;
import org.openrndr.extra.dnk3.TextureFromCode;
import org.openrndr.extra.dnk3.TextureFromColorBuffer;
import org.openrndr.extra.dnk3.TextureFunction;
import org.openrndr.extra.dnk3.TextureSource;
import org.openrndr.extra.dnk3.TextureTarget;
import org.openrndr.extra.dnk3.Triplanar;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;
import org.openrndr.math.transforms.TransformsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u0005H\u0016J\u0018\u0010P\u001a\u00020N2\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020TH\u0016J\u0010\u0010U\u001a\u00020\u00122\u0006\u0010V\u001a\u00020RH\u0002J\u0018\u0010W\u001a\u00020X2\u0006\u0010V\u001a\u00020R2\u0006\u0010Y\u001a\u00020NH\u0016J\b\u0010Z\u001a\u00020\fH\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u000b\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u001a\u0010\u001a\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016R\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010&\"\u0004\b+\u0010(R\u001a\u0010,\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010 \"\u0004\b.\u0010\"R\u001a\u0010/\u001a\u000200X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001c\u00105\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0007\"\u0004\b7\u0010\tR\u001c\u00108\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u0007\"\u0004\b:\u0010\tR\u001c\u0010;\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u0007\"\u0004\b=\u0010\tR&\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020@0?X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR \u0010E\u001a\b\u0012\u0004\u0012\u00020G0FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR\u001d\u0010L\u001a\u000e\u0012\u0004\u0012\u00020M\u0012\u0004\u0012\u00020N0?\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010B\u00a8\u0006["}, d2={"Lorg/openrndr/extra/dnk3/PBRMaterial;", "Lorg/openrndr/extra/dnk3/Material;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "toString", "fragmentID", "", "getFragmentID", "()I", "setFragmentID", "(I)V", "doubleSided", "", "getDoubleSided", "()Z", "setDoubleSided", "(Z)V", "transparent", "getTransparent", "setTransparent", "environmentMap", "getEnvironmentMap", "setEnvironmentMap", "color", "Lorg/openrndr/color/ColorRGBa;", "getColor", "()Lorg/openrndr/color/ColorRGBa;", "setColor", "(Lorg/openrndr/color/ColorRGBa;)V", "metalness", "", "getMetalness", "()D", "setMetalness", "(D)V", "roughness", "getRoughness", "setRoughness", "emission", "getEmission", "setEmission", "cubemapReflection", "Lorg/openrndr/extra/dnk3/CubemapReflection;", "getCubemapReflection", "()Lorg/openrndr/extra/dnk3/CubemapReflection;", "setCubemapReflection", "(Lorg/openrndr/extra/dnk3/CubemapReflection;)V", "fragmentPreamble", "getFragmentPreamble", "setFragmentPreamble", "vertexPreamble", "getVertexPreamble", "setVertexPreamble", "vertexTransform", "getVertexTransform", "setVertexTransform", "parameters", "", "", "getParameters", "()Ljava/util/Map;", "setParameters", "(Ljava/util/Map;)V", "textures", "", "Lorg/openrndr/extra/dnk3/Texture;", "getTextures", "()Ljava/util/List;", "setTextures", "(Ljava/util/List;)V", "shadeStyles", "Lorg/openrndr/extra/dnk3/ContextKey;", "Lorg/openrndr/draw/ShadeStyle;", "getShadeStyles", "generateShadeStyle", "materialContext", "Lorg/openrndr/extra/dnk3/MaterialContext;", "primitiveContext", "Lorg/openrndr/extra/dnk3/PrimitiveContext;", "needLight", "context", "applyToShadeStyle", "", "shadeStyle", "hashCode", "deminityy"})
@SourceDebugExtension(value={"SMAP\nPBRMaterial.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PBRMaterial.kt\norg/openrndr/extra/dnk3/PBRMaterial\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,686:1\n381#2,3:687\n384#2,4:722\n1567#3:690\n1598#3,4:691\n1567#3:695\n1598#3,4:696\n774#3:700\n865#3,2:701\n1567#3:703\n1598#3,4:704\n1567#3:708\n1598#3,4:709\n1567#3:713\n1598#3,4:714\n1557#3:718\n1628#3,3:719\n1755#3,3:726\n1755#3,3:729\n1872#3,3:734\n1872#3,3:737\n1872#3,3:740\n1872#3,3:743\n1557#3:746\n1628#3,3:747\n216#4,2:732\n*S KotlinDebug\n*F\n+ 1 PBRMaterial.kt\norg/openrndr/extra/dnk3/PBRMaterial\n*L\n354#1:687,3\n354#1:722,4\n371#1:690\n371#1:691,4\n379#1:695\n379#1:696,4\n393#1:700\n393#1:701,2\n408#1:703\n408#1:704,4\n453#1:708\n453#1:709,4\n466#1:713\n466#1:714,4\n474#1:718\n474#1:719,3\n517#1:726,3\n518#1:729,3\n547#1:734,3\n573#1:737,3\n641#1:740,3\n646#1:743,3\n501#1:746\n501#1:747,3\n532#1:732,2\n*E\n"})
public final class PBRMaterial
implements Material {
    @Nullable
    private String name;
    private int fragmentID;
    private boolean doubleSided;
    private boolean transparent;
    private boolean environmentMap;
    @NotNull
    private ColorRGBa color;
    private double metalness;
    private double roughness;
    @NotNull
    private ColorRGBa emission;
    @NotNull
    private CubemapReflection cubemapReflection;
    @Nullable
    private String fragmentPreamble;
    @Nullable
    private String vertexPreamble;
    @Nullable
    private String vertexTransform;
    @NotNull
    private Map<String, Object> parameters;
    @NotNull
    private List<Texture> textures;
    @NotNull
    private final Map<ContextKey, ShadeStyle> shadeStyles;

    public PBRMaterial() {
        int n;
        int n2 = n = PBRMaterialKt.access$getFragmentIDCounter$p();
        PBRMaterial pBRMaterial = this;
        boolean bl = false;
        PBRMaterialKt.access$setFragmentIDCounter$p(PBRMaterialKt.access$getFragmentIDCounter$p() + 1);
        pBRMaterial.fragmentID = n;
        this.color = ColorRGBa.Companion.getWHITE();
        this.metalness = 0.5;
        this.roughness = 1.0;
        this.emission = ColorRGBa.Companion.getBLACK();
        this.cubemapReflection = new CubemapReflection(null);
        this.parameters = new LinkedHashMap();
        this.textures = new ArrayList();
        this.shadeStyles = new LinkedHashMap();
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String string) {
        this.name = string;
    }

    @NotNull
    public String toString() {
        return "PBRMaterial(name: " + this.getName() + ", fragmentID: " + this.getFragmentID() + ", doubleSided: " + this.getDoubleSided() + ", textures: " + this.textures + ", color: " + this.color + ", metalness: " + this.metalness + ", roughness: " + this.roughness + ", emissive: " + this.emission + "))";
    }

    @Override
    public int getFragmentID() {
        return this.fragmentID;
    }

    public void setFragmentID(int n) {
        this.fragmentID = n;
    }

    @Override
    public boolean getDoubleSided() {
        return this.doubleSided;
    }

    @Override
    public void setDoubleSided(boolean bl) {
        this.doubleSided = bl;
    }

    @Override
    public boolean getTransparent() {
        return this.transparent;
    }

    @Override
    public void setTransparent(boolean bl) {
        this.transparent = bl;
    }

    public final boolean getEnvironmentMap() {
        return this.environmentMap;
    }

    public final void setEnvironmentMap(boolean bl) {
        this.environmentMap = bl;
    }

    @NotNull
    public final ColorRGBa getColor() {
        return this.color;
    }

    public final void setColor(@NotNull ColorRGBa colorRGBa) {
        Intrinsics.checkNotNullParameter(colorRGBa, "<set-?>");
        this.color = colorRGBa;
    }

    public final double getMetalness() {
        return this.metalness;
    }

    public final void setMetalness(double d) {
        this.metalness = d;
    }

    public final double getRoughness() {
        return this.roughness;
    }

    public final void setRoughness(double d) {
        this.roughness = d;
    }

    @NotNull
    public final ColorRGBa getEmission() {
        return this.emission;
    }

    public final void setEmission(@NotNull ColorRGBa colorRGBa) {
        Intrinsics.checkNotNullParameter(colorRGBa, "<set-?>");
        this.emission = colorRGBa;
    }

    @NotNull
    public final CubemapReflection getCubemapReflection() {
        return this.cubemapReflection;
    }

    public final void setCubemapReflection(@NotNull CubemapReflection cubemapReflection) {
        Intrinsics.checkNotNullParameter(cubemapReflection, "<set-?>");
        this.cubemapReflection = cubemapReflection;
    }

    @Nullable
    public final String getFragmentPreamble() {
        return this.fragmentPreamble;
    }

    public final void setFragmentPreamble(@Nullable String string) {
        this.fragmentPreamble = string;
    }

    @Nullable
    public final String getVertexPreamble() {
        return this.vertexPreamble;
    }

    public final void setVertexPreamble(@Nullable String string) {
        this.vertexPreamble = string;
    }

    @Nullable
    public final String getVertexTransform() {
        return this.vertexTransform;
    }

    public final void setVertexTransform(@Nullable String string) {
        this.vertexTransform = string;
    }

    @NotNull
    public final Map<String, Object> getParameters() {
        return this.parameters;
    }

    public final void setParameters(@NotNull Map<String, Object> map2) {
        Intrinsics.checkNotNullParameter(map2, "<set-?>");
        this.parameters = map2;
    }

    @NotNull
    public final List<Texture> getTextures() {
        return this.textures;
    }

    public final void setTextures(@NotNull List<Texture> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.textures = list;
    }

    @NotNull
    public final Map<ContextKey, ShadeStyle> getShadeStyles() {
        return this.shadeStyles;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ShadeStyle generateShadeStyle(@NotNull MaterialContext materialContext, @NotNull PrimitiveContext primitiveContext) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(materialContext, "materialContext");
        Intrinsics.checkNotNullParameter(primitiveContext, "primitiveContext");
        Map<ContextKey, ShadeStyle> map2 = this.shadeStyles;
        ContextKey key$iv = new ContextKey(materialContext, primitiveContext);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            void $this$mapTo$iv$iv;
            String string;
            String doubleSidedFS;
            String string2;
            Object source;
            int n;
            Iterable destination$iv$iv;
            String skinVS;
            void $this$filterTo$iv$iv;
            String string3;
            int n2;
            Object object2;
            Object source2;
            Object object3;
            Iterable destination$iv$iv2;
            boolean bl = false;
            boolean needLight = this.needLight(materialContext);
            String preambleFS = "vec4 m_color = p_color;\nuint f_fragmentID = uint(p_fragmentID);\nfloat m_f0 = 0.5;\nfloat m_roughness = p_roughness;\nfloat m_metalness = p_metalness;\nfloat m_ambientOcclusion = 1.0;\nvec3 m_emission = p_emission.rgb;\nvec3 m_normal = vec3(0.0, 0.0, 1.0);\nvec4 f_fog = vec4(0.0, 0.0, 0.0, 0.0);\nvec3 f_worldNormal = v_worldNormal;\nvec3 f_emission = m_emission;";
            if (needLight) {
                int index;
                Texture it;
                int n3;
                Iterable $this$mapIndexedTo$iv$iv;
                Iterable $this$mapIndexed$iv = this.textures;
                boolean $i$f$mapIndexed = false;
                Iterable iterable = $this$mapIndexed$iv;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    Object object4;
                    if ((n3 = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Texture texture = (Texture)item$iv$iv;
                    int n4 = n3;
                    object3 = destination$iv$iv2;
                    boolean bl2 = false;
                    source2 = it.getSource();
                    if (Intrinsics.areEqual(source2, DummySource.INSTANCE)) {
                        object4 = "vec4 tex" + index + " = vec4(1.0);";
                    } else if (source2 instanceof ModelCoordinates) {
                        object4 = PBRMaterialKt.access$fs((ModelCoordinates)source2, index);
                    } else if (source2 instanceof Triplanar) {
                        object4 = PBRMaterialKt.access$fs((Triplanar)source2, index, it.getTarget());
                    } else if (source2 instanceof TextureFromCode) {
                        object4 = PBRMaterialKt.access$fs((TextureFromCode)source2, index, it.getTarget());
                    } else {
                        throw new NotImplementedError(null, 1, null);
                    }
                    object3.add(object4);
                }
                $this$mapIndexed$iv = this.textures;
                object3 = (List)destination$iv$iv2;
                $i$f$mapIndexed = false;
                $this$mapIndexedTo$iv$iv = $this$mapIndexed$iv;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
                $i$f$mapIndexedTo = false;
                index$iv$iv = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    Object object5;
                    void texture;
                    if ((n3 = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    it = (Texture)item$iv$iv;
                    index = n3;
                    object2 = destination$iv$iv2;
                    n2 = 0;
                    source2 = texture.getTarget();
                    if (Intrinsics.areEqual(source2, TextureTarget.NONE.INSTANCE)) {
                        object5 = "";
                    } else if (Intrinsics.areEqual(source2, TextureTarget.COLOR.INSTANCE)) {
                        object5 = "m_color.rgb *= pow(tex" + index + ".rgb, vec3(2.2)); m_color.a *= tex" + index + ".a;";
                    } else if (Intrinsics.areEqual(source2, TextureTarget.METALNESS.INSTANCE)) {
                        object5 = "m_metalness = tex" + index + ".r;";
                    } else if (Intrinsics.areEqual(source2, TextureTarget.ROUGHNESS.INSTANCE)) {
                        object5 = "m_roughness = tex" + index + ".r;";
                    } else if (Intrinsics.areEqual(source2, TextureTarget.METALNESS_ROUGHNESS.INSTANCE)) {
                        object5 = "m_metalness = tex" + index + ".r; m_roughness = tex" + index + ".g;";
                    } else if (Intrinsics.areEqual(source2, TextureTarget.EMISSION.INSTANCE)) {
                        object5 = "m_emission *= tex" + index + ".rgb;";
                    } else if (Intrinsics.areEqual(source2, TextureTarget.NORMAL.INSTANCE)) {
                        object5 = "f_worldNormal = normalize((v_modelNormalMatrix * vec4(tex" + index + ".xyz,0.0)).xyz);";
                    } else if (Intrinsics.areEqual(source2, TextureTarget.AMBIENT_OCCLUSION.INSTANCE)) {
                        object5 = "m_ambientOcclusion *= tex" + index + ".r;";
                    } else if (source2 instanceof TextureTarget.Height) {
                        object5 = "";
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    object2.add(object5);
                }
                string3 = CollectionsKt.joinToString$default(CollectionsKt.plus(object3, (Iterable)((List)destination$iv$iv2)), "\n", null, null, 0, null, null, 62, null);
            } else {
                string3 = "";
            }
            String textureFs = string3;
            Iterable $this$filter$iv = this.textures;
            boolean $i$f$filter = false;
            destination$iv$iv2 = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Texture it = (Texture)element$iv$iv;
                boolean bl3 = false;
                if (!(it.getTarget() instanceof TextureTarget.Height)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List displacers = (List)destination$iv$iv3;
            String string4 = skinVS = primitiveContext.hasSkinning() ? StringsKt.trimIndent("\n                    uvec4 j = a_joints;\n                    mat4 skinTransform = p_jointTransforms[j.x] * a_weights.x \n                    + p_jointTransforms[j.y] * a_weights.y \n                    + p_jointTransforms[j.z] * a_weights.z \n                    + p_jointTransforms[j.w] * a_weights.w;                    \n                    " + (primitiveContext.hasNormalAttribute() ? "x_normal = normalize(mat3(skinTransform) * x_normal);                        " : "") + "\n                    \n                    x_position = (skinTransform * vec4(x_position,1)).xyz;\n            ") : "";
            if (!((Collection)displacers).isEmpty()) {
                void $this$mapIndexedTo$iv$iv;
                Iterable $this$mapIndexed$iv = this.textures;
                boolean $i$f$mapIndexed = false;
                Iterable $i$f$filterTo2 = $this$mapIndexed$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    Object object6;
                    Iterator it;
                    if ((n2 = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    source2 = (Texture)item$iv$iv;
                    int n5 = n2;
                    object3 = destination$iv$iv;
                    n = 0;
                    if (((Texture)((Object)it)).getTarget() instanceof TextureTarget.Height) {
                        Object object7;
                        void index;
                        source = ((Texture)((Object)it)).getSource();
                        if (Intrinsics.areEqual(source, DummySource.INSTANCE)) {
                            object7 = "vec4 tex" + (int)index + " = vec4(1.0);";
                        } else if (source instanceof ModelCoordinates) {
                            object7 = PBRMaterialKt.access$fs((ModelCoordinates)source, (int)index);
                        } else if (source instanceof Triplanar) {
                            object7 = PBRMaterialKt.access$fs((Triplanar)source, (int)index, ((Texture)((Object)it)).getTarget());
                        } else if (source instanceof TextureFromCode) {
                            object7 = PBRMaterialKt.access$fs((TextureFromCode)source, (int)index, ((Texture)((Object)it)).getTarget());
                        } else {
                            throw new NotImplementedError(null, 1, null);
                        }
                        object6 = (String)object7 + StringsKt.trimIndent("\n                x_position += x_normal * tex" + (int)index + ".r * p_textureHeightScale" + (int)index + ";\n            ");
                    } else {
                        object6 = "";
                    }
                    object3.add(object6);
                }
                string2 = CollectionsKt.joinToString$default((List)destination$iv$iv, "\n", null, null, 0, null, null, 62, null);
            } else {
                string2 = "";
            }
            String textureVS = string2;
            List<NodeContent<Light>> lights = materialContext.getLights();
            String string5 = doubleSidedFS = this.getDoubleSided() ? "if (dot(V, N) <0) {\n    N *= -1.0;\n}" : "";
            if (needLight) {
                Collection<String> collection;
                int index;
                SceneNode node;
                Object object8;
                Iterable $this$mapIndexedTo$iv$iv;
                Iterable $this$mapIndexed$iv;
                destination$iv$iv = lights;
                object2 = this.environmentMap && !materialContext.getMeshCubemaps().isEmpty() && primitiveContext.hasNormalAttribute() ? "{\n     vec2 dfg = PrefilteredDFG_Karis(m_roughness, NoV);\n     vec3 sc = m_metalness * m_color.rgb + (1.0-m_metalness) * vec3(0.04);\n     \n     f_specular.rgb += sc * (texture(p_environmentMap, reflect(-V, normalize(f_worldNormal))).rgb * dfg.x + dfg.y) * m_ambientOcclusion;\n }" : "";
                object3 = primitiveContext.hasNormalAttribute() ? "abs(dot(N, V)) + 1e-5" : "1.0";
                boolean $i$f$mapIndexed = false;
                void index$iv$iv = $this$mapIndexed$iv;
                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv2 = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    String string6;
                    if ((n = index$iv$iv2++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    source = (NodeContent)item$iv$iv;
                    int n6 = n;
                    object8 = destination$iv$iv4;
                    boolean bl4 = false;
                    node = ((NodeContent)source).component1();
                    Light light = (Light)((NodeContent)source).component2();
                    Light light2 = light;
                    if (light2 instanceof AmbientLight) {
                        string6 = PBRMaterialKt.access$fs((AmbientLight)light, index);
                    } else if (light2 instanceof PointLight) {
                        string6 = PBRMaterialKt.access$fs((PointLight)light, index, primitiveContext.hasNormalAttribute());
                    } else if (light2 instanceof SpotLight) {
                        string6 = PBRMaterialKt.access$fs((SpotLight)light, index, primitiveContext.hasNormalAttribute());
                    } else if (light2 instanceof DirectionalLight) {
                        string6 = PBRMaterialKt.access$fs((DirectionalLight)light, index, primitiveContext.hasNormalAttribute());
                    } else if (light2 instanceof HemisphereLight) {
                        string6 = PBRMaterialKt.access$fs((HemisphereLight)light, index, primitiveContext.hasNormalAttribute());
                    } else {
                        throw new NotImplementedError(null, 1, null);
                    }
                    object8.add(string6);
                }
                object8 = (List)destination$iv$iv4;
                $this$mapIndexed$iv = materialContext.getFogs();
                object8 = CollectionsKt.joinToString$default((Iterable)object8, "\n", null, null, 0, null, null, 62, null);
                $i$f$mapIndexed = false;
                $this$mapIndexedTo$iv$iv = $this$mapIndexed$iv;
                destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
                $i$f$mapIndexedTo = false;
                index$iv$iv2 = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    if ((n = index$iv$iv2++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    source = (NodeContent)item$iv$iv;
                    index = n;
                    collection = destination$iv$iv4;
                    boolean bl5 = false;
                    node = ((NodeContent)source).component1();
                    Fog fog = (Fog)((NodeContent)source).component2();
                    collection.add(PBRMaterialKt.access$fs(fog, index));
                }
                collection = (List)destination$iv$iv4;
                string = StringsKt.trimIndent("\n        vec3 f_diffuse = vec3(0.0);\n        vec3 f_specular = vec3(0.0);\n        vec3 f_ambient = vec3(0.0);\n        float f_occlusion = 1.0;\n        vec3 N = normalize(f_worldNormal);\n        \n        vec3 ep = (p_viewMatrixInverse * vec4(0.0, 0.0, 0.0, 1.0)).xyz;\n        vec3 Vr = ep - v_worldPosition;\n        vec3 V = normalize(Vr);\n\n        float NoV = " + (String)object3 + ";\n\n        " + (String)object2 + "\n\n        " + (String)object8 + "\n\n\n  \n        " + CollectionsKt.joinToString$default(collection, "\n", null, null, 0, null, null, 62, null) + "\n\n    ");
            } else {
                string = "";
            }
            String lightFS = string;
            RenderTarget rt = RenderTarget.Companion.getActive();
            Iterable $this$map$iv = materialContext.getPass().combiners();
            boolean $i$f$map = false;
            Iterable $i$f$mapIndexedTo = $this$map$iv;
            Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                source = (FacetCombiner)item$iv$iv;
                object3 = destination$iv$iv5;
                boolean bl6 = false;
                object3.add(it.generateShader());
            }
            String combinerFS = CollectionsKt.joinToString$default((List)destination$iv$iv5, "\n", null, null, 0, null, null, 62, null);
            String fs = preambleFS + textureFs + lightFS + combinerFS;
            String string7 = this.vertexTransform;
            if (string7 == null) {
                string7 = "";
            }
            String vs = string7 + textureVS + skinVS;
            ShadeStyle answer$iv = ShadeStyleKt.shadeStyle(arg_0 -> PBRMaterial.generateShadeStyle$lambda$10$lambda$9(this, vs, fs, materialContext, rt, arg_0));
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ShadeStyle cached = (ShadeStyle)object;
        return cached;
    }

    private final boolean needLight(MaterialContext context) {
        boolean bl;
        boolean needSpecular;
        block7: {
            boolean bl2;
            block6: {
                Iterable $this$any$iv = context.getPass().combiners();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FacetCombiner it = (FacetCombiner)element$iv;
                        boolean bl3 = false;
                        if (!it.getFacets().contains((Object)FacetType.SPECULAR)) continue;
                        bl2 = true;
                        break block6;
                    }
                    bl2 = false;
                }
            }
            needSpecular = bl2;
            Iterable $this$any$iv = context.getPass().combiners();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FacetCombiner it = (FacetCombiner)element$iv;
                    boolean bl4 = false;
                    if (!it.getFacets().contains((Object)FacetType.DIFFUSE)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        boolean needDiffuse = bl;
        boolean needLight = needSpecular || needDiffuse;
        return needLight;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyToShadeStyle(@NotNull MaterialContext context, @NotNull ShadeStyle shadeStyle) {
        Object k;
        int n;
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(shadeStyle, "shadeStyle");
        shadeStyle.parameter("emission", this.emission);
        shadeStyle.parameter("color", this.color);
        shadeStyle.parameter("metalness", this.metalness);
        shadeStyle.parameter("roughness", this.roughness);
        shadeStyle.parameter("fragmentID", this.getFragmentID());
        Map<String, Object> $this$forEach$iv = this.parameters;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, Object> entry;
            Map.Entry<String, Object> entry2 = entry = iterator2.next();
            n = 0;
            k = entry2.getKey();
            Object v = entry2.getValue();
            Object object = v;
            if (object instanceof Double) {
                shadeStyle.parameter((String)k, ((Number)v).doubleValue());
                continue;
            }
            if (object instanceof Integer) {
                shadeStyle.parameter((String)k, ((Number)v).intValue());
                continue;
            }
            if (object instanceof Vector2) {
                shadeStyle.parameter((String)k, (Vector2)v);
                continue;
            }
            if (object instanceof Vector3) {
                shadeStyle.parameter((String)k, (Vector3)v);
                continue;
            }
            if (object instanceof Vector4) {
                shadeStyle.parameter((String)k, (Vector4)v);
                continue;
            }
            if (object instanceof BufferTexture) {
                shadeStyle.parameter((String)k, (BufferTexture)v);
                continue;
            }
            if (object instanceof ColorBuffer) {
                shadeStyle.parameter((String)k, (ColorBuffer)v);
                continue;
            }
            String string = "support " + v.getClass();
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        if (this.needLight(context)) {
            SceneNode node;
            this.cubemapReflection.applyToShadeStyle(shadeStyle);
            $this$forEachIndexed$iv = this.textures;
            $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                k = (Texture)item$iv;
                int index = n;
                boolean bl = false;
                TextureSource source = texture.getSource();
                if (source instanceof TextureFromColorBuffer) {
                    shadeStyle.parameter("texture" + index, ((TextureFromColorBuffer)source).getTexture());
                    if (((TextureFromColorBuffer)source).getTextureFunction() == TextureFunction.NOT_TILING) {
                        shadeStyle.parameter("textureNoise", PBRMaterialKt.access$getNoise128());
                    }
                }
                if ((source = texture.getSource()) instanceof Triplanar) {
                    shadeStyle.parameter("textureTriplanarSharpness" + index, ((Triplanar)source).getSharpness());
                    shadeStyle.parameter("textureTriplanarScale" + index, ((Triplanar)source).getScale());
                    shadeStyle.parameter("textureTriplanarOffset" + index, ((Triplanar)source).getOffset());
                }
                if (!(texture.getTarget() instanceof TextureTarget.Height)) continue;
                TextureTarget textureTarget = texture.getTarget();
                Intrinsics.checkNotNull(textureTarget, "null cannot be cast to non-null type org.openrndr.extra.dnk3.TextureTarget.Height");
                TextureTarget.Height target2 = (TextureTarget.Height)textureTarget;
                shadeStyle.parameter("textureHeightScale" + index, target2.getScale());
            }
            List<NodeContent<Light>> lights = context.getLights();
            Iterable $this$forEachIndexed$iv = lights;
            boolean $i$f$forEachIndexed = false;
            boolean bl = false;
            for (Object item$iv : $this$forEachIndexed$iv) {
                AutoCloseable it;
                Matrix44 look;
                void var6_12;
                void texture;
                if ((texture = ++var6_12) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                NodeContent index = (NodeContent)item$iv;
                void index2 = texture;
                boolean bl2 = false;
                node = index.component1();
                Light light = (Light)index.component2();
                shadeStyle.parameter("lightColor" + (int)index2, light.getColor());
                Light light2 = light;
                if (light2 instanceof AmbientLight) continue;
                if (light2 instanceof PointLight) {
                    shadeStyle.parameter("lightPosition" + (int)index2, node.getWorldTransform().times(Vector4.Companion.getUNIT_W()).xyz());
                    shadeStyle.parameter("lightConstantAttenuation" + (int)index2, ((PointLight)light).getConstantAttenuation());
                    shadeStyle.parameter("lightLinearAttenuation" + (int)index2, ((PointLight)light).getLinearAttenuation());
                    shadeStyle.parameter("lightQuadraticAttenuation" + (int)index2, ((PointLight)light).getQuadraticAttenuation());
                    continue;
                }
                if (light2 instanceof SpotLight) {
                    shadeStyle.parameter("lightPosition" + (int)index2, node.getWorldTransform().times(Vector4.Companion.getUNIT_W()).xyz());
                    shadeStyle.parameter("lightDirection" + (int)index2, ((Vector4)TransformsKt.normalMatrix(node.getWorldTransform()).times(((SpotLight)light).getDirection().xyz0()).getNormalized()).xyz());
                    shadeStyle.parameter("lightConstantAttenuation" + (int)index2, ((SpotLight)light).getConstantAttenuation());
                    shadeStyle.parameter("lightLinearAttenuation" + (int)index2, ((SpotLight)light).getLinearAttenuation());
                    shadeStyle.parameter("lightQuadraticAttenuation" + (int)index2, ((SpotLight)light).getQuadraticAttenuation());
                    shadeStyle.parameter("lightInnerCos" + (int)index2, Math.cos(Math.toRadians(((SpotLight)light).getInnerAngle())));
                    shadeStyle.parameter("lightOuterCos" + (int)index2, Math.cos(Math.toRadians(((SpotLight)light).getOuterAngle())));
                    if (!(((SpotLight)light).getShadows() instanceof Shadows.MappedShadows)) continue;
                    if (context.getShadowMaps().get(light) != null) {
                        boolean bl22 = false;
                        look = ((SpotLight)light).view(node);
                        shadeStyle.parameter("lightTransform" + (int)index2, ((SpotLight)light).projection((RenderTarget)it).times(look));
                        if (((SpotLight)light).getShadows() instanceof Shadows.DepthMappedShadows) {
                            DepthBuffer depthBuffer = it.getDepthBuffer();
                            if (depthBuffer == null) {
                                throw new NotImplementedError(null, 1, null);
                            }
                            shadeStyle.parameter("lightShadowMap" + (int)index2, depthBuffer);
                        }
                        if (!(((SpotLight)light).getShadows() instanceof Shadows.ColorMappedShadows)) continue;
                        shadeStyle.parameter("lightShadowMap" + (int)index2, it.colorBuffer(0));
                    }
                    continue;
                }
                if (light2 instanceof DirectionalLight) {
                    shadeStyle.parameter("lightPosition" + (int)index2, node.getWorldTransform().times(Vector4.Companion.getUNIT_W()).xyz());
                    shadeStyle.parameter("lightDirection" + (int)index2, ((Vector4)TransformsKt.normalMatrix(node.getWorldTransform()).times(((DirectionalLight)light).getDirection().xyz0()).getNormalized()).xyz());
                    if (!(((DirectionalLight)light).getShadows() instanceof Shadows.MappedShadows)) continue;
                    if (context.getShadowMaps().get(light) != null) {
                        boolean bl3 = false;
                        look = ((DirectionalLight)light).view(node);
                        shadeStyle.parameter("lightTransform" + (int)index2, ((DirectionalLight)light).projection((RenderTarget)it).times(look));
                        if (((DirectionalLight)light).getShadows() instanceof Shadows.DepthMappedShadows) {
                            DepthBuffer depthBuffer = it.getDepthBuffer();
                            if (depthBuffer == null) {
                                throw new NotImplementedError(null, 1, null);
                            }
                            shadeStyle.parameter("lightShadowMap" + (int)index2, depthBuffer);
                        }
                        if (!(((DirectionalLight)light).getShadows() instanceof Shadows.ColorMappedShadows)) continue;
                        shadeStyle.parameter("lightShadowMap" + (int)index2, it.colorBuffer(0));
                    }
                    continue;
                }
                if (!(light2 instanceof HemisphereLight)) continue;
                shadeStyle.parameter("lightDirection" + (int)index2, ((Vector4)TransformsKt.normalMatrix(node.getWorldTransform()).times(((HemisphereLight)light).getDirection().xyz0()).getNormalized()).xyz());
                shadeStyle.parameter("lightUpColor" + (int)index2, ((HemisphereLight)light).getUpColor());
                shadeStyle.parameter("lightDownColor" + (int)index2, ((HemisphereLight)light).getDownColor());
                if (((HemisphereLight)light).getIrradianceMap() == null) continue;
                boolean bl4 = false;
                shadeStyle.parameter("lightIrradianceMap" + (int)index2, (Cubemap)it);
            }
            $this$forEachIndexed$iv = context.getFogs();
            $i$f$forEachIndexed = false;
            boolean bl3 = false;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void var6_14;
                void texture;
                if ((texture = ++var6_14) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                NodeContent index = (NodeContent)item$iv;
                void index3 = texture;
                boolean bl4 = false;
                node = index.component1();
                Fog fog = (Fog)index.component2();
                shadeStyle.parameter("fogColor" + (int)index3, fog.getColor());
                shadeStyle.parameter("fogEnd" + (int)index3, fog.getEnd());
            }
        } else {
            $this$forEachIndexed$iv = this.textures;
            $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n2;
                if ((n2 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                texture = (Texture)item$iv;
                int index = n2;
                boolean bl = false;
                if (!(texture.getTarget() instanceof TextureTarget.Height)) continue;
                TextureSource source = texture.getSource();
                if (source instanceof TextureFromColorBuffer) {
                    shadeStyle.parameter("texture" + index, ((TextureFromColorBuffer)source).getTexture());
                }
                if ((source = texture.getSource()) instanceof Triplanar) {
                    shadeStyle.parameter("textureTriplanarSharpness" + index, ((Triplanar)source).getSharpness());
                    shadeStyle.parameter("textureTriplanarScale" + index, ((Triplanar)source).getScale());
                    shadeStyle.parameter("textureTriplanarOffset" + index, ((Triplanar)source).getOffset());
                }
                TextureTarget textureTarget = texture.getTarget();
                Intrinsics.checkNotNull(textureTarget, "null cannot be cast to non-null type org.openrndr.extra.dnk3.TextureTarget.Height");
                TextureTarget.Height target3 = (TextureTarget.Height)textureTarget;
                shadeStyle.parameter("textureHeightScale" + index, target3.getScale());
            }
        }
    }

    public int hashCode() {
        int result = Integer.hashCode(this.getFragmentID());
        result = 31 * Boolean.hashCode(this.getDoubleSided());
        result = 31 * result + Boolean.hashCode(this.getTransparent());
        result = 31 * result + this.color.hashCode();
        result = 31 * result + Double.hashCode(this.metalness);
        result = 31 * result + Double.hashCode(this.roughness);
        result = 31 * result + this.emission.hashCode();
        String string = this.fragmentPreamble;
        result = 31 * result + (string != null ? string.hashCode() : 0);
        String string2 = this.vertexPreamble;
        result = 31 * result + (string2 != null ? string2.hashCode() : 0);
        String string3 = this.vertexTransform;
        result = 31 * result + (string3 != null ? string3.hashCode() : 0);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit generateShadeStyle$lambda$10$lambda$9(PBRMaterial this$0, String $vs, String $fs, MaterialContext $materialContext, RenderTarget $rt, ShadeStyle $this$shadeStyle) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$shadeStyle, "$this$shadeStyle");
        String string = this$0.fragmentPreamble;
        if (string == null) {
            string = "";
        }
        $this$shadeStyle.setFragmentPreamble(string);
        String string2 = ShaderUtilitiesKt.getShaderNoRepetitionVert();
        String string3 = this$0.vertexPreamble;
        if (string3 == null) {
            string3 = "";
        }
        $this$shadeStyle.setVertexPreamble(StringsKt.trimIndent("\n                    " + string2 + "\n                     " + string3 + "\n                "));
        $this$shadeStyle.setFragmentPreamble($this$shadeStyle.getFragmentPreamble() + StringsKt.trimMargin$default("\n                    \n            |" + ShaderUtilitiesKt.getShaderLinePlaneIntersect() + "\n            |" + ShaderUtilitiesKt.getShaderProjectOnPlane() + "\n            |" + ShaderUtilitiesKt.getShaderSideOfPlane() + "\n            |" + ShaderUtilitiesKt.getShaderGGX() + "\n            |" + ShaderUtilitiesKt.getShaderVSM() + "\n            |" + ShaderUtilitiesKt.getShaderNoRepetition() + "\n            |\n#ifndef PHRASE_TBN_MATRIX\n#define PHRASE_TBN_MATRIX    \nmat3 tbnMatrix(vec4 tangent, vec3 normal) {\n    vec3 bitangent = cross(normal, tangent.xyz) * tangent.w;\n    return mat3(tangent.xyz, bitangent, normal);\n}\n#endif\n\n            ", null, 1, null));
        $this$shadeStyle.setSuppressDefaultOutput(true);
        $this$shadeStyle.setVertexTransform($vs);
        $this$shadeStyle.setFragmentTransform($fs);
        Iterable $this$map$iv = $materialContext.getPass().combiners();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FacetCombiner facetCombiner = (FacetCombiner)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if ($rt instanceof ProgramRenderTarget || $materialContext.getPass() == RenderPassKt.getDefaultPass() || $materialContext.getPass() == RenderPassKt.getDefaultOpaquePass() || Intrinsics.areEqual($materialContext.getPass(), RenderPassKt.getDefaultTransparentPass()) || $materialContext.getPass().skipTarget()) {
                $this$shadeStyle.output(it.getTargetOutput(), new ShadeStyleOutput(0, null, null, 6, null));
            } else {
                Integer n = $rt.colorAttachmentIndexByName(it.getTargetOutput());
                if (n == null) {
                    throw new IllegalStateException(("attachment " + it.getTargetOutput() + " not found").toString());
                }
                int index = n;
                ColorType type = $rt.colorBuffer(index).getType();
                ColorFormat format = $rt.colorBuffer(index).getFormat();
                $this$shadeStyle.output(it.getTargetOutput(), new ShadeStyleOutput(index, format, type));
            }
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return Unit.INSTANCE;
    }
}

