/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.color.spaces;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.AlgebraicColor;
import org.openrndr.color.ChromaColor;
import org.openrndr.color.ColorModel;
import org.openrndr.color.ColorRGBa;
import org.openrndr.color.HueShiftableColor;
import org.openrndr.color.LuminosityColor;
import org.openrndr.color.ShadableColor;
import org.openrndr.extra.color.spaces.ColorOKLABa;
import org.openrndr.extra.color.spaces.ColorOKLCHa$;
import org.openrndr.extra.color.spaces.ColorOKLCHaKt;
import org.openrndr.math.Vector4;

@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 >2\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\b\u0012\u0004\u0012\u00020\u00000\u00032\b\u0012\u0004\u0012\u00020\u00000\u00042\b\u0012\u0004\u0012\u00020\u00000\u00052\b\u0012\u0004\u0012\u00020\u00000\u00062\u00020\u0007:\u0002>?B)\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\b\b\u0002\u0010\f\u001a\u00020\t\u00a2\u0006\u0004\b\r\u0010\u000eB;\b\u0010\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\t\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\b\r\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\tH\u0016J\u0010\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\tH\u0016J\u0011\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\tH\u0096\u0002J\u0018\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\tH\u0016J\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\u0010\u0010&\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\tH\u0016J\u0010\u0010(\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\tH\u0016J\u0010\u0010*\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\tH\u0016J\t\u0010+\u001a\u00020\tH\u00c6\u0003J\t\u0010,\u001a\u00020\tH\u00c6\u0003J\t\u0010-\u001a\u00020\tH\u00c6\u0003J\t\u0010.\u001a\u00020\tH\u00c6\u0003J1\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\tH\u00c6\u0001J\u0013\u00100\u001a\u0002012\b\u0010\u001e\u001a\u0004\u0018\u000102H\u00d6\u0003J\t\u00103\u001a\u00020\u0010H\u00d6\u0001J\t\u00104\u001a\u000205H\u00d6\u0001J%\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0001\u00a2\u0006\u0002\b=R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0014R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0014R\u0014\u0010\f\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0014R\u0014\u0010%\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0014R\u0014\u0010'\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0014R\u0014\u0010)\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0014\u00a8\u0006@"}, d2={"Lorg/openrndr/extra/color/spaces/ColorOKLCHa;", "Lorg/openrndr/color/ColorModel;", "Lorg/openrndr/color/ShadableColor;", "Lorg/openrndr/color/ChromaColor;", "Lorg/openrndr/color/HueShiftableColor;", "Lorg/openrndr/color/LuminosityColor;", "Lorg/openrndr/color/AlgebraicColor;", "Ljava/lang/Record;", "l", "", "c", "h", "alpha", "<init>", "(DDDD)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IDDDDLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "()D", "opacify", "factor", "shade", "plus", "right", "minus", "times", "scale", "mix", "other", "toOKLABa", "Lorg/openrndr/extra/color/spaces/ColorOKLABa;", "toRGBa", "Lorg/openrndr/color/ColorRGBa;", "toVector4", "Lorg/openrndr/math/Vector4;", "chroma", "withChroma", "hue", "withHue", "luminosity", "withLuminosity", "component1", "component2", "component3", "component4", "copy", "equals", "", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$orx_color", "Companion", "$serializer", "orx-color"})
@SourceDebugExtension(value={"SMAP\nColorOKLCHa.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorOKLCHa.kt\norg/openrndr/extra/color/spaces/ColorOKLCHa\n+ 2 Functions.kt\norg/openrndr/math/FunctionsKt\n*L\n1#1,82:1\n86#2:83\n86#2:84\n*S KotlinDebug\n*F\n+ 1 ColorOKLCHa.kt\norg/openrndr/extra/color/spaces/ColorOKLCHa\n*L\n51#1:83\n52#1:84\n*E\n"})
public final class ColorOKLCHa
extends Record
implements ColorModel<ColorOKLCHa>,
ShadableColor<ColorOKLCHa>,
ChromaColor<ColorOKLCHa>,
HueShiftableColor<ColorOKLCHa>,
LuminosityColor<ColorOKLCHa>,
AlgebraicColor<ColorOKLCHa> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double l;
    private final double c;
    private final double h;
    private final double alpha;

    public ColorOKLCHa(double l, double c2, double h, double alpha) {
        this.l = l;
        this.c = c2;
        this.h = h;
        this.alpha = alpha;
    }

    public /* synthetic */ ColorOKLCHa(double d, double d2, double d3, double d4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        this(d, d2, d3, d4);
    }

    public final double l() {
        return this.l;
    }

    public final double c() {
        return this.c;
    }

    public final double h() {
        return this.h;
    }

    public double alpha() {
        return this.alpha;
    }

    @Override
    @NotNull
    public ColorOKLCHa opacify(double factor) {
        return ColorOKLCHa.copy$default(this, 0.0, 0.0, 0.0, this.alpha() * factor, 7, null);
    }

    @Override
    @NotNull
    public ColorOKLCHa shade(double factor) {
        return ColorOKLCHa.copy$default(this, this.l * factor, 0.0, 0.0, 0.0, 14, null);
    }

    @Override
    @NotNull
    public ColorOKLCHa plus(@NotNull ColorOKLCHa right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return this.copy(this.l + right.l, this.c + right.c, this.h + right.h, this.alpha() + right.alpha());
    }

    @Override
    @NotNull
    public ColorOKLCHa minus(@NotNull ColorOKLCHa right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return this.copy(this.l - right.l, this.c - right.c, this.h - right.h, this.alpha() - right.alpha());
    }

    @Override
    @NotNull
    public ColorOKLCHa times(double scale) {
        return this.copy(this.l * scale, this.c * scale, this.h * scale, this.alpha() * scale);
    }

    @Override
    @NotNull
    public ColorOKLCHa mix(@NotNull ColorOKLCHa other, double factor) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ColorOKLCHaKt.mix(this, other, factor);
    }

    @NotNull
    public final ColorOKLABa toOKLABa() {
        double $this$asRadians$iv = this.h;
        boolean $i$f$getAsRadians = false;
        double a = this.c * Math.cos($this$asRadians$iv * (Math.PI / 180));
        double $this$asRadians$iv2 = this.h;
        boolean $i$f$getAsRadians2 = false;
        double b = this.c * Math.sin($this$asRadians$iv2 * (Math.PI / 180));
        return new ColorOKLABa(this.l, a, b, this.alpha());
    }

    @Override
    @NotNull
    public ColorRGBa toRGBa() {
        return this.toOKLABa().toRGBa();
    }

    @Override
    @NotNull
    public Vector4 toVector4() {
        return new Vector4(this.l, this.c, this.h, this.alpha());
    }

    public double chroma() {
        return this.c * 100.0;
    }

    @Override
    @NotNull
    public ColorOKLCHa withChroma(double chroma) {
        return ColorOKLCHa.copy$default(this, 0.0, chroma / 100.0, 0.0, 0.0, 13, null);
    }

    public double hue() {
        return this.h;
    }

    @Override
    @NotNull
    public ColorOKLCHa withHue(double hue) {
        return ColorOKLCHa.copy$default(this, 0.0, 0.0, hue, 0.0, 11, null);
    }

    public double luminosity() {
        return this.l * 100.0;
    }

    @Override
    @NotNull
    public ColorOKLCHa withLuminosity(double luminosity) {
        return ColorOKLCHa.copy$default(this, luminosity / 100.0, 0.0, 0.0, 0.0, 14, null);
    }

    public final double component1() {
        return this.l;
    }

    public final double component2() {
        return this.c;
    }

    public final double component3() {
        return this.h;
    }

    public final double component4() {
        return this.alpha;
    }

    @NotNull
    public final ColorOKLCHa copy(double l, double c2, double h, double alpha) {
        return new ColorOKLCHa(l, c2, h, alpha);
    }

    public static /* synthetic */ ColorOKLCHa copy$default(ColorOKLCHa colorOKLCHa, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            d = colorOKLCHa.l;
        }
        if ((n & 2) != 0) {
            d2 = colorOKLCHa.c;
        }
        if ((n & 4) != 0) {
            d3 = colorOKLCHa.h;
        }
        if ((n & 8) != 0) {
            d4 = colorOKLCHa.alpha;
        }
        return colorOKLCHa.copy(d, d2, d3, d4);
    }

    @Override
    @NotNull
    public String toString() {
        return "ColorOKLCHa(l=" + this.l + ", c=" + this.c + ", h=" + this.h + ", alpha=" + this.alpha + ")";
    }

    @Override
    public int hashCode() {
        int result = Double.hashCode(this.l);
        result = result * 31 + Double.hashCode(this.c);
        result = result * 31 + Double.hashCode(this.h);
        result = result * 31 + Double.hashCode(this.alpha);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ColorOKLCHa)) {
            return false;
        }
        ColorOKLCHa colorOKLCHa = (ColorOKLCHa)other;
        if (Double.compare(this.l, colorOKLCHa.l) != 0) {
            return false;
        }
        if (Double.compare(this.c, colorOKLCHa.c) != 0) {
            return false;
        }
        if (Double.compare(this.h, colorOKLCHa.h) != 0) {
            return false;
        }
        return Double.compare(this.alpha, colorOKLCHa.alpha) == 0;
    }

    @Override
    @NotNull
    public ColorOKLCHa shiftChroma(double shift) {
        return ChromaColor.DefaultImpls.shiftChroma(this, shift);
    }

    @Override
    @NotNull
    public ColorOKLCHa modulateChroma(double factor) {
        return ChromaColor.DefaultImpls.modulateChroma(this, factor);
    }

    @Override
    @NotNull
    public ColorOKLCHa mixChroma(double target2, double factor) {
        return ChromaColor.DefaultImpls.mixChroma(this, target2, factor);
    }

    @Override
    @NotNull
    public ColorOKLCHa shiftHue(double shiftInDegrees) {
        return HueShiftableColor.DefaultImpls.shiftHue(this, shiftInDegrees);
    }

    @Override
    @NotNull
    public ColorOKLCHa mixHue(double hue, double factor) {
        return HueShiftableColor.DefaultImpls.mixHue(this, hue, factor);
    }

    @Override
    @NotNull
    public ColorOKLCHa shadeLuminosity(double factor) {
        return LuminosityColor.DefaultImpls.shadeLuminosity(this, factor);
    }

    @Override
    @NotNull
    public ColorOKLCHa mixLuminosity(double luminosity, double factor) {
        return LuminosityColor.DefaultImpls.mixLuminosity(this, luminosity, factor);
    }

    @Override
    @NotNull
    public ColorOKLCHa div(double scale) {
        return AlgebraicColor.DefaultImpls.div(this, scale);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$orx_color(ColorOKLCHa self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeDoubleElement(serialDesc, 0, self.l);
        output.encodeDoubleElement(serialDesc, 1, self.c);
        output.encodeDoubleElement(serialDesc, 2, self.h);
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : Double.compare(self.alpha(), 1.0) != 0) {
            output.encodeDoubleElement(serialDesc, 3, self.alpha());
        }
    }

    public /* synthetic */ ColorOKLCHa(int seen0, double l, double c2, double h, double alpha, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 7, $serializer.INSTANCE.getDescriptor());
        }
        this.l = l;
        this.c = c2;
        this.h = h;
        this.alpha = (seen0 & 8) == 0 ? 1.0 : alpha;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a8\u0006\n"}, d2={"Lorg/openrndr/extra/color/spaces/ColorOKLCHa$Companion;", "", "<init>", "()V", "fromColorOKLABa", "Lorg/openrndr/extra/color/spaces/ColorOKLCHa;", "oklaba", "Lorg/openrndr/extra/color/spaces/ColorOKLABa;", "serializer", "Lkotlinx/serialization/KSerializer;", "orx-color"})
    @SourceDebugExtension(value={"SMAP\nColorOKLCHa.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorOKLCHa.kt\norg/openrndr/extra/color/spaces/ColorOKLCHa$Companion\n+ 2 Functions.kt\norg/openrndr/math/FunctionsKt\n*L\n1#1,82:1\n87#2:83\n*S KotlinDebug\n*F\n+ 1 ColorOKLCHa.kt\norg/openrndr/extra/color/spaces/ColorOKLCHa$Companion\n*L\n37#1:83\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ColorOKLCHa fromColorOKLABa(@NotNull ColorOKLABa oklaba) {
            Intrinsics.checkNotNullParameter(oklaba, "oklaba");
            double l = oklaba.l();
            double c2 = Math.sqrt(oklaba.a() * oklaba.a() + oklaba.b() * oklaba.b());
            double h = Math.atan2(oklaba.b(), oklaba.a());
            if (h < 0.0) {
                h += Math.PI * 2;
            }
            double $this$asDegrees$iv = h;
            boolean $i$f$getAsDegrees = false;
            h = $this$asDegrees$iv * 57.29577951308232;
            return new ColorOKLCHa(l, c2, h, oklaba.alpha());
        }

        @NotNull
        public final KSerializer<ColorOKLCHa> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

