/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.color.spaces;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.AlgebraicColor;
import org.openrndr.color.ColorModel;
import org.openrndr.color.ColorRGBa;
import org.openrndr.color.HueShiftableColor;
import org.openrndr.color.Linearity;
import org.openrndr.color.SaturatableColor;
import org.openrndr.color.ShadableColor;
import org.openrndr.extra.color.spaces.ColorOKHSLa$;
import org.openrndr.extra.color.spaces.ColorOKLABa;
import org.openrndr.extra.color.spaces.ColorOKLABaKt;
import org.openrndr.extra.color.spaces.OKHelpersKt;
import org.openrndr.math.MappingKt;
import org.openrndr.math.Vector4;

@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 92\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\b\u0012\u0004\u0012\u00020\u00000\u00032\b\u0012\u0004\u0012\u00020\u00000\u00042\b\u0012\u0004\u0012\u00020\u00000\u00052\u00020\u0006:\u00029:B)\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\rB;\b\u0010\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b\f\u0010\u0012J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\bH\u0016J\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\bH\u0016J\u0010\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\bH\u0016J\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\bH\u0096\u0002J\u0018\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\bH\u0016J\b\u0010$\u001a\u00020%H\u0016J\t\u0010&\u001a\u00020\bH\u00c6\u0003J\t\u0010'\u001a\u00020\bH\u00c6\u0003J\t\u0010(\u001a\u00020\bH\u00c6\u0003J\t\u0010)\u001a\u00020\bH\u00c6\u0003J1\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\bH\u00c6\u0001J\u0013\u0010+\u001a\u00020,2\b\u0010#\u001a\u0004\u0018\u00010-H\u00d6\u0003J\t\u0010.\u001a\u00020\u000fH\u00d6\u0001J\t\u0010/\u001a\u000200H\u00d6\u0001J%\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00002\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0001\u00a2\u0006\u0002\b8R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0013R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0013R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0013R\u0014\u0010\u000b\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0013R\u0014\u0010\u001a\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0013\u00a8\u0006;"}, d2={"Lorg/openrndr/extra/color/spaces/ColorOKHSLa;", "Lorg/openrndr/color/ColorModel;", "Lorg/openrndr/color/HueShiftableColor;", "Lorg/openrndr/color/SaturatableColor;", "Lorg/openrndr/color/ShadableColor;", "Lorg/openrndr/color/AlgebraicColor;", "Ljava/lang/Record;", "h", "", "s", "l", "alpha", "<init>", "(DDDD)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IDDDDLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "()D", "toRGBa", "Lorg/openrndr/color/ColorRGBa;", "hue", "withHue", "opacify", "factor", "saturation", "withSaturation", "shade", "minus", "right", "plus", "times", "scale", "mix", "other", "toVector4", "Lorg/openrndr/math/Vector4;", "component1", "component2", "component3", "component4", "copy", "equals", "", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$orx_color", "Companion", "$serializer", "orx-color"})
public final class ColorOKHSLa
extends Record
implements ColorModel<ColorOKHSLa>,
HueShiftableColor<ColorOKHSLa>,
SaturatableColor<ColorOKHSLa>,
ShadableColor<ColorOKHSLa>,
AlgebraicColor<ColorOKHSLa> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double h;
    private final double s;
    private final double l;
    private final double alpha;

    public ColorOKHSLa(double h, double s, double l, double alpha) {
        this.h = h;
        this.s = s;
        this.l = l;
        this.alpha = alpha;
    }

    public /* synthetic */ ColorOKHSLa(double d, double d2, double d3, double d4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        this(d, d2, d3, d4);
    }

    public final double h() {
        return this.h;
    }

    public final double s() {
        return this.s;
    }

    public final double l() {
        return this.l;
    }

    public double alpha() {
        return this.alpha;
    }

    @Override
    @NotNull
    public ColorRGBa toRGBa() {
        double d;
        if (this.l == 0.0 || this.l == 1.0) {
            return new ColorRGBa(this.l, this.l, this.l, this.alpha(), Linearity.SRGB);
        }
        double a_ = Math.cos(Math.PI * 2 * this.h / 360.0);
        double b_ = Math.sin(Math.PI * 2 * this.h / 360.0);
        double L = OKHelpersKt.toeInv(this.l);
        double[] Cs = OKHelpersKt.get_Cs(L, a_, b_);
        double C_0 = Cs[0];
        double C_mid = Cs[1];
        double C_max = Cs[2];
        if (this.s < 0.8) {
            t = 1.25 * this.s;
            k_0 = 0.0;
            k_1 = 0.8 * C_0;
            k_2 = 1.0 - k_1 / C_mid;
            d = k_0 + t * k_1 / (1.0 - k_2 * t);
        } else {
            t = (double)5 * (this.s - 0.8);
            k_0 = C_mid;
            k_1 = 0.2 * C_mid * C_mid * 1.25 * 1.25 / C_0;
            k_2 = 1.0 - k_1 / (C_max - C_mid);
            d = k_0 + t * k_1 / (1.0 - k_2 * t);
        }
        double C = d;
        return new ColorOKLABa(L == L ? L : 0.0, C == C ? C * a_ : 0.0, C == C ? C * b_ : 0.0, this.alpha()).toRGBa().toSRGB();
    }

    public double hue() {
        return this.h;
    }

    @Override
    @NotNull
    public ColorOKHSLa withHue(double hue) {
        return ColorOKHSLa.copy$default(this, hue, 0.0, 0.0, 0.0, 14, null);
    }

    @Override
    @NotNull
    public ColorOKHSLa opacify(double factor) {
        return ColorOKHSLa.copy$default(this, 0.0, 0.0, 0.0, this.alpha() * factor, 7, null);
    }

    public double saturation() {
        return this.s;
    }

    @Override
    @NotNull
    public ColorOKHSLa withSaturation(double saturation) {
        return ColorOKHSLa.copy$default(this, 0.0, saturation, 0.0, 0.0, 13, null);
    }

    @Override
    @NotNull
    public ColorOKHSLa shade(double factor) {
        return ColorOKHSLa.copy$default(this, 0.0, 0.0, this.l * factor, 0.0, 11, null);
    }

    @Override
    @NotNull
    public ColorOKHSLa minus(@NotNull ColorOKHSLa right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return this.copy(this.h - right.h, this.s - right.s, this.l - right.l, this.alpha() - right.alpha());
    }

    @Override
    @NotNull
    public ColorOKHSLa plus(@NotNull ColorOKHSLa right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return this.copy(this.h + right.h, this.s + right.s, this.l + right.l, this.alpha() + right.alpha());
    }

    @Override
    @NotNull
    public ColorOKHSLa times(double scale) {
        return this.copy(this.h * scale, this.s * scale, this.l * scale, this.alpha() * scale);
    }

    @Override
    @NotNull
    public ColorOKHSLa mix(@NotNull ColorOKHSLa other, double factor) {
        Intrinsics.checkNotNullParameter(other, "other");
        double sx = RangesKt.coerceIn(factor, 0.0, 1.0);
        return new ColorOKHSLa(MappingKt.mixAngle(this.h, other.h, sx), (1.0 - sx) * this.s + sx * other.s, (1.0 - sx) * this.l + sx * other.l, (1.0 - sx) * this.alpha() + sx * other.alpha());
    }

    @Override
    @NotNull
    public Vector4 toVector4() {
        return new Vector4(this.h, this.s, this.l, this.alpha());
    }

    public final double component1() {
        return this.h;
    }

    public final double component2() {
        return this.s;
    }

    public final double component3() {
        return this.l;
    }

    public final double component4() {
        return this.alpha;
    }

    @NotNull
    public final ColorOKHSLa copy(double h, double s, double l, double alpha) {
        return new ColorOKHSLa(h, s, l, alpha);
    }

    public static /* synthetic */ ColorOKHSLa copy$default(ColorOKHSLa colorOKHSLa, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            d = colorOKHSLa.h;
        }
        if ((n & 2) != 0) {
            d2 = colorOKHSLa.s;
        }
        if ((n & 4) != 0) {
            d3 = colorOKHSLa.l;
        }
        if ((n & 8) != 0) {
            d4 = colorOKHSLa.alpha;
        }
        return colorOKHSLa.copy(d, d2, d3, d4);
    }

    @Override
    @NotNull
    public String toString() {
        return "ColorOKHSLa(h=" + this.h + ", s=" + this.s + ", l=" + this.l + ", alpha=" + this.alpha + ")";
    }

    @Override
    public int hashCode() {
        int result = Double.hashCode(this.h);
        result = result * 31 + Double.hashCode(this.s);
        result = result * 31 + Double.hashCode(this.l);
        result = result * 31 + Double.hashCode(this.alpha);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ColorOKHSLa)) {
            return false;
        }
        ColorOKHSLa colorOKHSLa = (ColorOKHSLa)other;
        if (Double.compare(this.h, colorOKHSLa.h) != 0) {
            return false;
        }
        if (Double.compare(this.s, colorOKHSLa.s) != 0) {
            return false;
        }
        if (Double.compare(this.l, colorOKHSLa.l) != 0) {
            return false;
        }
        return Double.compare(this.alpha, colorOKHSLa.alpha) == 0;
    }

    @Override
    @NotNull
    public ColorOKHSLa shiftHue(double shiftInDegrees) {
        return HueShiftableColor.DefaultImpls.shiftHue(this, shiftInDegrees);
    }

    @Override
    @NotNull
    public ColorOKHSLa mixHue(double hue, double factor) {
        return HueShiftableColor.DefaultImpls.mixHue(this, hue, factor);
    }

    @Override
    @NotNull
    public ColorOKHSLa saturate(double factor) {
        return SaturatableColor.DefaultImpls.saturate(this, factor);
    }

    @Override
    @NotNull
    public ColorOKHSLa mixSaturation(double saturation, double factor) {
        return SaturatableColor.DefaultImpls.mixSaturation(this, saturation, factor);
    }

    @Override
    @NotNull
    public ColorOKHSLa div(double scale) {
        return AlgebraicColor.DefaultImpls.div(this, scale);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$orx_color(ColorOKHSLa self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeDoubleElement(serialDesc, 0, self.h);
        output.encodeDoubleElement(serialDesc, 1, self.s);
        output.encodeDoubleElement(serialDesc, 2, self.l);
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : Double.compare(self.alpha(), 1.0) != 0) {
            output.encodeDoubleElement(serialDesc, 3, self.alpha());
        }
    }

    public /* synthetic */ ColorOKHSLa(int seen0, double h, double s, double l, double alpha, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 7, $serializer.INSTANCE.getDescriptor());
        }
        this.h = h;
        this.s = s;
        this.l = l;
        this.alpha = (seen0 & 8) == 0 ? 1.0 : alpha;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a8\u0006\n"}, d2={"Lorg/openrndr/extra/color/spaces/ColorOKHSLa$Companion;", "", "<init>", "()V", "fromColorRGBa", "Lorg/openrndr/extra/color/spaces/ColorOKHSLa;", "c", "Lorg/openrndr/color/ColorRGBa;", "serializer", "Lkotlinx/serialization/KSerializer;", "orx-color"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ColorOKHSLa fromColorRGBa(@NotNull ColorRGBa c2) {
            double d;
            Intrinsics.checkNotNullParameter(c2, "c");
            ColorOKLABa lab = ColorOKLABaKt.toOKLABa(c2);
            double C = Math.sqrt(lab.a() * lab.a() + lab.b() * lab.b());
            double a_ = lab.a() / C;
            double b_ = lab.b() / C;
            double L = lab.l();
            double h = 0.5 + 0.5 * Math.atan2(-lab.b(), -lab.a()) / Math.PI;
            double[] dArray = OKHelpersKt.get_Cs(L, a_, b_);
            double c0 = dArray[0];
            double cMid = dArray[1];
            double cMax = dArray[2];
            if (C < cMid) {
                boolean k0 = false;
                double k1 = 0.8 * c0;
                double k2 = 1.0 - k1 / cMid;
                double t = (C - (double)k0) / (k1 + k2 * (C - (double)k0));
                d = t * 0.8;
            } else {
                double k0 = cMid;
                double k1 = 0.2 * cMid * cMid * 1.25 * 1.25 / c0;
                double k2 = 1.0 - k1 / (cMax - cMid);
                double t = (C - k0) / (k1 + k2 * (C - k0));
                d = 0.8 + 0.2 * t;
            }
            double s = d;
            double l = OKHelpersKt.toe(L);
            return new ColorOKHSLa(h * 360.0, s == s ? s : 0.0, l == l ? l : 0.0, c2.getAlpha());
        }

        @NotNull
        public final KSerializer<ColorOKHSLa> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

