/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.camera;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.openrndr.Extension;
import org.openrndr.KeyEvent;
import org.openrndr.MouseButton;
import org.openrndr.MouseEvent;
import org.openrndr.Program;
import org.openrndr.draw.Drawer;
import org.openrndr.extra.camera.OrbitalCamera;
import org.openrndr.extra.camera.ProjectionType;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001)B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\r\"\u0004\b'\u0010\u000f\u00a8\u0006*"}, d2={"Lorg/openrndr/extra/camera/OrbitalControls;", "Lorg/openrndr/Extension;", "orbitalCamera", "Lorg/openrndr/extra/camera/OrbitalCamera;", "userInteraction", "", "keySpeed", "", "<init>", "(Lorg/openrndr/extra/camera/OrbitalCamera;ZD)V", "getOrbitalCamera", "()Lorg/openrndr/extra/camera/OrbitalCamera;", "getUserInteraction", "()Z", "setUserInteraction", "(Z)V", "getKeySpeed", "()D", "state", "Lorg/openrndr/extra/camera/OrbitalControls$STATE;", "fov", "getFov", "setFov", "(D)V", "program", "Lorg/openrndr/Program;", "lastMousePosition", "Lorg/openrndr/math/Vector2;", "mouseScrolled", "", "event", "Lorg/openrndr/MouseEvent;", "mouseMoved", "mouseButtonDown", "keyPressed", "keyEvent", "Lorg/openrndr/KeyEvent;", "enabled", "getEnabled", "setEnabled", "setup", "STATE", "orx-camera"})
@SourceDebugExtension(value={"SMAP\nOrbitalControls.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrbitalControls.kt\norg/openrndr/extra/camera/OrbitalControls\n+ 2 Functions.kt\norg/openrndr/math/FunctionsKt\n*L\n1#1,152:1\n86#2:153\n*S KotlinDebug\n*F\n+ 1 OrbitalControls.kt\norg/openrndr/extra/camera/OrbitalControls\n*L\n58#1:153\n*E\n"})
public final class OrbitalControls
implements Extension {
    @NotNull
    private final OrbitalCamera orbitalCamera;
    private boolean userInteraction;
    private final double keySpeed;
    @NotNull
    private STATE state;
    private double fov;
    private Program program;
    private Vector2 lastMousePosition;
    private boolean enabled;

    public OrbitalControls(@NotNull OrbitalCamera orbitalCamera, boolean userInteraction, double keySpeed) {
        Intrinsics.checkNotNullParameter(orbitalCamera, "orbitalCamera");
        this.orbitalCamera = orbitalCamera;
        this.userInteraction = userInteraction;
        this.keySpeed = keySpeed;
        this.state = STATE.NONE;
        this.fov = this.orbitalCamera.getFov();
        this.enabled = true;
    }

    public /* synthetic */ OrbitalControls(OrbitalCamera orbitalCamera, boolean bl, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            d = 1.0;
        }
        this(orbitalCamera, bl, d);
    }

    @NotNull
    public final OrbitalCamera getOrbitalCamera() {
        return this.orbitalCamera;
    }

    public final boolean getUserInteraction() {
        return this.userInteraction;
    }

    public final void setUserInteraction(boolean bl) {
        this.userInteraction = bl;
    }

    public final double getKeySpeed() {
        return this.keySpeed;
    }

    public final double getFov() {
        return this.fov;
    }

    public final void setFov(double d) {
        this.fov = d;
    }

    private final void mouseScrolled(MouseEvent event) {
        if (this.userInteraction && !event.getPropagationCancelled()) {
            if (this.orbitalCamera.getProjectionType() == ProjectionType.PERSPECTIVE) {
                if (Math.abs(event.getRotation().x()) > 0.1) {
                    return;
                }
                if (event.getRotation().y() > 0.0) {
                    this.orbitalCamera.dollyIn();
                } else if (event.getRotation().y() < 0.0) {
                    this.orbitalCamera.dollyOut();
                }
            } else {
                if (Math.abs(event.getRotation().x()) > 0.1) {
                    return;
                }
                if (event.getRotation().y() > 0.0) {
                    this.orbitalCamera.scale(1.0);
                } else if (event.getRotation().y() < 0.0) {
                    this.orbitalCamera.scale(-1.0);
                }
            }
        }
    }

    private final void mouseMoved(MouseEvent event) {
        if (this.userInteraction && !event.getPropagationCancelled()) {
            if (this.state == STATE.NONE) {
                return;
            }
            Vector2 vector2 = this.lastMousePosition;
            if (vector2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("lastMousePosition");
                vector2 = null;
            }
            Vector2 delta = vector2.minus(event.getPosition());
            this.lastMousePosition = event.getPosition();
            if (this.state == STATE.PAN) {
                Vector3 offset = Vector3.Companion.fromSpherical(this.orbitalCamera.getSpherical()).minus(this.orbitalCamera.getLookAt());
                double $this$asRadians$iv = this.fov;
                boolean $i$f$getAsRadians = false;
                double targetDistance = offset.length() * Math.tan($this$asRadians$iv * (Math.PI / 180) / (double)2);
                double d = (double)2 * delta.x() * targetDistance;
                Program program2 = this.program;
                if (program2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("program");
                    program2 = null;
                }
                double panX = d / (double)program2.getWidth();
                double d2 = (double)2 * delta.y() * targetDistance;
                Program program3 = this.program;
                if (program3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("program");
                    program3 = null;
                }
                double panY = d2 / (double)program3.getHeight();
                this.orbitalCamera.pan(panX, -panY, 0.0);
            } else {
                double d = 360.0 * delta.x();
                Program program4 = this.program;
                if (program4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("program");
                    program4 = null;
                }
                double rotX = d / (double)program4.getWidth();
                double d3 = 360.0 * delta.y();
                Program program5 = this.program;
                if (program5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("program");
                    program5 = null;
                }
                double rotY = d3 / (double)program5.getHeight();
                this.orbitalCamera.rotate(rotX, rotY);
            }
        }
    }

    private final void mouseButtonDown(MouseEvent event) {
        if (this.userInteraction && !event.getPropagationCancelled()) {
            STATE previousState = this.state;
            switch (WhenMappings.$EnumSwitchMapping$0[event.getButton().ordinal()]) {
                case 1: {
                    this.state = STATE.ROTATE;
                    break;
                }
                case 2: {
                    this.state = STATE.PAN;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if (previousState == STATE.NONE) {
                this.lastMousePosition = event.getPosition();
            }
        }
    }

    public final void keyPressed(@NotNull KeyEvent keyEvent) {
        Intrinsics.checkNotNullParameter(keyEvent, "keyEvent");
        if (this.userInteraction && !keyEvent.getPropagationCancelled()) {
            if (keyEvent.getKey() == 262) {
                this.orbitalCamera.pan(this.keySpeed, 0.0, 0.0);
            }
            if (keyEvent.getKey() == 263) {
                this.orbitalCamera.pan(-this.keySpeed, 0.0, 0.0);
            }
            if (keyEvent.getKey() == 265) {
                this.orbitalCamera.pan(0.0, this.keySpeed, 0.0);
            }
            if (keyEvent.getKey() == 264) {
                this.orbitalCamera.pan(0.0, -this.keySpeed, 0.0);
            }
            if (Intrinsics.areEqual(keyEvent.getName(), "q")) {
                this.orbitalCamera.pan(0.0, -this.keySpeed, 0.0);
            }
            if (Intrinsics.areEqual(keyEvent.getName(), "e")) {
                this.orbitalCamera.pan(0.0, this.keySpeed, 0.0);
            }
            if (Intrinsics.areEqual(keyEvent.getName(), "w")) {
                this.orbitalCamera.pan(0.0, 0.0, -this.keySpeed);
            }
            if (Intrinsics.areEqual(keyEvent.getName(), "s")) {
                this.orbitalCamera.pan(0.0, 0.0, this.keySpeed);
            }
            if (Intrinsics.areEqual(keyEvent.getName(), "a")) {
                this.orbitalCamera.pan(-this.keySpeed, 0.0, 0.0);
            }
            if (Intrinsics.areEqual(keyEvent.getName(), "d")) {
                this.orbitalCamera.pan(this.keySpeed, 0.0, 0.0);
            }
            if (keyEvent.getKey() == 266) {
                this.orbitalCamera.zoom(this.keySpeed);
            }
            if (keyEvent.getKey() == 267) {
                this.orbitalCamera.zoom(-this.keySpeed);
            }
        }
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public void setup(@NotNull Program program2) {
        Intrinsics.checkNotNullParameter(program2, "program");
        this.program = program2;
        program2.getMouse().getMoved().listen(arg_0 -> OrbitalControls.setup$lambda$0(this, arg_0));
        program2.getMouse().getButtonDown().listen(arg_0 -> OrbitalControls.setup$lambda$1(this, arg_0));
        program2.getMouse().getButtonUp().listen(arg_0 -> OrbitalControls.setup$lambda$2(this, arg_0));
        program2.getMouse().getScrolled().listen(arg_0 -> OrbitalControls.setup$lambda$3(this, arg_0));
        program2.getKeyboard().getKeyDown().listen(arg_0 -> OrbitalControls.setup$lambda$4(this, arg_0));
        program2.getKeyboard().getKeyRepeat().listen(arg_0 -> OrbitalControls.setup$lambda$5(this, arg_0));
    }

    @Override
    public void beforeDraw(@NotNull Drawer drawer, @NotNull Program program2) {
        Extension.DefaultImpls.beforeDraw(this, drawer, program2);
    }

    @Override
    public void afterDraw(@NotNull Drawer drawer, @NotNull Program program2) {
        Extension.DefaultImpls.afterDraw(this, drawer, program2);
    }

    @Override
    public void shutdown(@NotNull Program program2) {
        Extension.DefaultImpls.shutdown(this, program2);
    }

    private static final Unit setup$lambda$0(OrbitalControls this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.mouseMoved(it);
        return Unit.INSTANCE;
    }

    private static final Unit setup$lambda$1(OrbitalControls this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.mouseButtonDown(it);
        return Unit.INSTANCE;
    }

    private static final Unit setup$lambda$2(OrbitalControls this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.state = STATE.NONE;
        return Unit.INSTANCE;
    }

    private static final Unit setup$lambda$3(OrbitalControls this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.mouseScrolled(it);
        return Unit.INSTANCE;
    }

    private static final Unit setup$lambda$4(OrbitalControls this$0, KeyEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.keyPressed(it);
        return Unit.INSTANCE;
    }

    private static final Unit setup$lambda$5(OrbitalControls this$0, KeyEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.keyPressed(it);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/extra/camera/OrbitalControls$STATE;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "ROTATE", "PAN", "orx-camera"})
    public static final class STATE
    extends Enum<STATE> {
        public static final /* enum */ STATE NONE = new STATE();
        public static final /* enum */ STATE ROTATE = new STATE();
        public static final /* enum */ STATE PAN = new STATE();
        private static final /* synthetic */ STATE[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static STATE[] values() {
            return (STATE[])$VALUES.clone();
        }

        public static STATE valueOf(String value) {
            return Enum.valueOf(STATE.class, value);
        }

        @NotNull
        public static EnumEntries<STATE> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sTATEArray = new STATE[]{STATE.NONE, STATE.ROTATE, STATE.PAN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MouseButton.values().length];
            try {
                nArray[MouseButton.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MouseButton.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MouseButton.CENTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MouseButton.NONE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

