/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.camera;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.DepthTestPass;
import org.openrndr.draw.Drawer;
import org.openrndr.extra.camera.OrbitalCamera;
import org.openrndr.extra.camera.ProjectionType;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\u001a+\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\u0002\b\u0007\u001a\u0012\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002\u00a8\u0006\r"}, d2={"isolated", "", "Lorg/openrndr/extra/camera/OrbitalCamera;", "drawer", "Lorg/openrndr/draw/Drawer;", "function", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "applyTo", "pow", "", "a", "x", "orx-camera"})
public final class OrbitalCameraKt {
    public static final void isolated(@NotNull OrbitalCamera $this$isolated, @NotNull Drawer drawer, @NotNull Function1<? super Drawer, Unit> function2) {
        Intrinsics.checkNotNullParameter($this$isolated, "<this>");
        Intrinsics.checkNotNullParameter(drawer, "drawer");
        Intrinsics.checkNotNullParameter(function2, "function");
        drawer.pushTransforms();
        drawer.pushStyle();
        OrbitalCameraKt.applyTo($this$isolated, drawer);
        function2.invoke(drawer);
        drawer.popStyle();
        drawer.popTransforms();
    }

    public static final void applyTo(@NotNull OrbitalCamera $this$applyTo, @NotNull Drawer drawer) {
        Intrinsics.checkNotNullParameter($this$applyTo, "<this>");
        Intrinsics.checkNotNullParameter(drawer, "drawer");
        if ($this$applyTo.getProjectionType() == ProjectionType.PERSPECTIVE) {
            drawer.perspective($this$applyTo.getFov(), (double)drawer.getWidth() / (double)drawer.getHeight(), $this$applyTo.getNear(), $this$applyTo.getFar());
        } else {
            double ar = (double)drawer.getWidth() * 1.0 / (double)drawer.getHeight();
            drawer.ortho(-ar * $this$applyTo.getMagnitude(), ar * $this$applyTo.getMagnitude(), -1.0 * $this$applyTo.getMagnitude(), 1.0 * $this$applyTo.getMagnitude(), $this$applyTo.getOrthoNear(), $this$applyTo.getOrthoFar());
        }
        drawer.setView($this$applyTo.viewMatrix());
        if ($this$applyTo.getDepthTest()) {
            drawer.getDrawStyle().setDepthWrite(true);
            drawer.getDrawStyle().setDepthTestPass(DepthTestPass.LESS_OR_EQUAL);
        }
    }

    private static final double pow(double a, double x) {
        return Math.pow(a, x);
    }

    public static final /* synthetic */ double access$pow(double a, double x) {
        return OrbitalCameraKt.pow(a, x);
    }
}

