/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw.font;

import java.io.File;
import java.net.URL;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.stb.STBTTFontinfo;
import org.lwjgl.stb.STBTruetype;
import org.lwjgl.system.MemoryUtil;
import org.openrndr.draw.font.Face;
import org.openrndr.draw.font.FaceStbTt;
import org.openrndr.draw.font.internal.FontDriver;
import org.openrndr.utils.url.TextFromURLKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/openrndr/draw/font/FontDriverStbTt;", "Lorg/openrndr/draw/font/internal/FontDriver;", "<init>", "()V", "loadFace", "Lorg/openrndr/draw/font/Face;", "fileOrUrl", "", "openrndr-gl3"})
@SourceDebugExtension(value={"SMAP\nFontDriverStbTt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FontDriverStbTt.kt\norg/openrndr/draw/font/FontDriverStbTt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,250:1\n1#2:251\n*E\n"})
public final class FontDriverStbTt
implements FontDriver {
    @Override
    @NotNull
    public Face loadFace(@NotNull String fileOrUrl) {
        Object object;
        block7: {
            URL url;
            block6: {
                Intrinsics.checkNotNullParameter(fileOrUrl, "fileOrUrl");
                Pair<File, URL> pair = TextFromURLKt.resolveFileOrUrl(fileOrUrl);
                File file = pair.component1();
                url = pair.component2();
                object = file;
                if (object == null) break block6;
                byte[] byArray = FilesKt.readBytes((File)object);
                object = byArray;
                if (byArray != null) break block7;
            }
            URL uRL = url;
            if (uRL != null) {
                object = TextStreamsKt.readBytes(uRL);
            } else {
                throw new IllegalStateException(("no content for file or url: '" + fileOrUrl + "'").toString());
            }
        }
        Object byteArray = object;
        int fileSize = ((Object)byteArray).length;
        ByteBuffer byteBuffer = MemoryUtil.memAlloc(fileSize);
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "memAlloc(...)");
        ByteBuffer bb = byteBuffer;
        bb.put((byte[])byteArray, 0, fileSize);
        bb.rewind();
        STBTTFontinfo sTBTTFontinfo = STBTTFontinfo.create();
        Intrinsics.checkNotNullExpressionValue(sTBTTFontinfo, "create(...)");
        STBTTFontinfo fontInfo = sTBTTFontinfo;
        boolean status = STBTruetype.stbtt_InitFont(fontInfo, bb);
        if (!status) {
            boolean bl = false;
            String string = "failed to load font " + fileOrUrl;
            throw new IllegalStateException(string.toString());
        }
        return new FaceStbTt(bb, fontInfo);
    }
}

