/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.BufferAlignment;
import org.openrndr.draw.VertexElement;
import org.openrndr.draw.VertexElementType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0010J\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0010J\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0010J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\u000e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0010J\u000e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0010J\u001a\u0010\u001f\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00102\b\b\u0002\u0010 \u001a\u00020\u0010J \u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001c2\b\b\u0002\u0010%\u001a\u00020\u0010J\b\u0010&\u001a\u00020#H\u0016J\u000e\u0010'\u001a\u00020(2\u0006\u0010\"\u001a\u00020#J\u0013\u0010)\u001a\u00020(2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010+\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010,\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006."}, d2={"Lorg/openrndr/draw/VertexFormat;", "", "alignment", "Lorg/openrndr/draw/BufferAlignment;", "<init>", "(Lorg/openrndr/draw/BufferAlignment;)V", "getAlignment", "()Lorg/openrndr/draw/BufferAlignment;", "items", "", "Lorg/openrndr/draw/VertexElement;", "getItems", "()Ljava/util/List;", "setItems", "(Ljava/util/List;)V", "vertexSizeInBytes", "", "size", "getSize", "()I", "position", "", "dimensions", "padding", "paddingInBytes", "paddingFloat", "sizeInFloats", "floatTypeFromDimensions", "Lorg/openrndr/draw/VertexElementType;", "normal", "color", "textureCoordinate", "index", "attribute", "name", "", "type", "arraySize", "toString", "hasAttribute", "", "equals", "other", "hashCode", "isInStd430Layout", "()Z", "openrndr-draw"})
@SourceDebugExtension(value={"SMAP\nVertexFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VertexFormat.kt\norg/openrndr/draw/VertexFormat\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n1#2:201\n1755#3,3:202\n*S KotlinDebug\n*F\n+ 1 VertexFormat.kt\norg/openrndr/draw/VertexFormat\n*L\n122#1:202,3\n*E\n"})
public final class VertexFormat {
    @NotNull
    private final BufferAlignment alignment;
    @NotNull
    private List<VertexElement> items;
    private int vertexSizeInBytes;

    public VertexFormat(@NotNull BufferAlignment alignment) {
        Intrinsics.checkNotNullParameter((Object)alignment, "alignment");
        this.alignment = alignment;
        this.items = new ArrayList();
    }

    public /* synthetic */ VertexFormat(BufferAlignment bufferAlignment, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bufferAlignment = BufferAlignment.NONE;
        }
        this(bufferAlignment);
    }

    @NotNull
    public final BufferAlignment getAlignment() {
        return this.alignment;
    }

    @NotNull
    public final List<VertexElement> getItems() {
        return this.items;
    }

    public final void setItems(@NotNull List<VertexElement> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.items = list;
    }

    public final int getSize() {
        int n;
        if (this.alignment == BufferAlignment.STD430) {
            Comparable comparable;
            Iterator iterator2 = ((Iterable)this.items).iterator();
            if (!iterator2.hasNext()) {
                comparable = null;
            } else {
                VertexElement it = (VertexElement)iterator2.next();
                boolean bl = false;
                Comparable comparable2 = Integer.valueOf(it.getType().getStd430AlignmentInBytes());
                while (iterator2.hasNext()) {
                    VertexElement it2 = (VertexElement)iterator2.next();
                    $i$a$-maxOfOrNull-VertexFormat$size$maxAlign$1 = false;
                    Comparable comparable3 = Integer.valueOf(it2.getType().getStd430AlignmentInBytes());
                    if (comparable2.compareTo(comparable3) >= 0) continue;
                    comparable2 = comparable3;
                }
                comparable = comparable2;
            }
            Integer n2 = (Integer)comparable;
            int maxAlign = n2 != null ? n2 : 0;
            int n3 = this.vertexSizeInBytes % maxAlign;
            if (n3 + (maxAlign & ((n3 ^ maxAlign) & (n3 | -n3)) >> 31) != 0) {
                n3 = this.vertexSizeInBytes % maxAlign;
                n = this.vertexSizeInBytes + (maxAlign - (n3 + (maxAlign & ((n3 ^ maxAlign) & (n3 | -n3)) >> 31)));
            } else {
                n = this.vertexSizeInBytes;
            }
        } else {
            n = this.vertexSizeInBytes;
        }
        return n;
    }

    public final void position(int dimensions) {
        VertexFormat.attribute$default(this, "position", this.floatTypeFromDimensions(dimensions), 0, 4, null);
    }

    public final void padding(int paddingInBytes) {
        this.attribute("_", VertexElementType.UINT8, paddingInBytes);
    }

    public final void paddingFloat(int sizeInFloats) {
        this.attribute("_", VertexElementType.FLOAT32, sizeInFloats);
    }

    private final VertexElementType floatTypeFromDimensions(int dimensions) {
        return switch (dimensions) {
            case 1 -> VertexElementType.FLOAT32;
            case 2 -> VertexElementType.VECTOR2_FLOAT32;
            case 3 -> VertexElementType.VECTOR3_FLOAT32;
            case 4 -> VertexElementType.VECTOR4_FLOAT32;
            default -> throw new IllegalArgumentException("dimensions can only be 1, 2, 3 or 4 (got " + dimensions + ")");
        };
    }

    public final void normal(int dimensions) {
        VertexFormat.attribute$default(this, "normal", this.floatTypeFromDimensions(dimensions), 0, 4, null);
    }

    public final void color(int dimensions) {
        VertexFormat.attribute$default(this, "color", this.floatTypeFromDimensions(dimensions), 0, 4, null);
    }

    public final void textureCoordinate(int dimensions, int index) {
        VertexFormat.attribute$default(this, "texCoord" + index, this.floatTypeFromDimensions(dimensions), 0, 4, null);
    }

    public static /* synthetic */ void textureCoordinate$default(VertexFormat vertexFormat, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 2;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        vertexFormat.textureCoordinate(n, n2);
    }

    public final void attribute(@NotNull String name, @NotNull VertexElementType type, int arraySize) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        int offset = this.vertexSizeInBytes;
        if (this.alignment == BufferAlignment.STD430) {
            int alignmentInBytes = switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1, 2, 3 -> 16;
                case 4 -> 16;
                default -> type.getSizeInBytes();
            };
            int n = offset % alignmentInBytes;
            if (n + (alignmentInBytes & ((n ^ alignmentInBytes) & (n | -n)) >> 31) != 0) {
                n = offset % alignmentInBytes;
                offset += alignmentInBytes - (n + (alignmentInBytes & ((n ^ alignmentInBytes) & (n | -n)) >> 31));
            }
        }
        VertexElement item = new VertexElement(name, offset, type, arraySize);
        this.items.add(item);
        this.vertexSizeInBytes = offset + type.getSizeInBytes() * arraySize;
    }

    public static /* synthetic */ void attribute$default(VertexFormat vertexFormat, String string, VertexElementType vertexElementType, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        vertexFormat.attribute(string, vertexElementType, n);
    }

    @NotNull
    public String toString() {
        return "VertexFormat{items=" + this.items + ", vertexSize=" + this.vertexSizeInBytes + "}";
    }

    public final boolean hasAttribute(@NotNull String name) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(name, "name");
            Iterable $this$any$iv = this.items;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VertexElement it = (VertexElement)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getAttribute(), name)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VertexFormat)) {
            return false;
        }
        return Intrinsics.areEqual(this.items, ((VertexFormat)other).items);
    }

    public int hashCode() {
        return ((Object)this.items).hashCode();
    }

    public final boolean isInStd430Layout() {
        int maxAlign = 4;
        for (VertexElement item : this.items) {
            int alignSize;
            maxAlign = alignSize = (switch (WhenMappings.$EnumSwitchMapping$0[item.getType().ordinal()]) {
                case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> 16;
                case 10, 11, 12 -> 8;
                case 13, 14, 15 -> 4;
                default -> throw new IllegalStateException(("unsupported item type " + item.getType()).toString());
            });
            int n = item.getOffset() % alignSize;
            boolean aligned = n + (alignSize & ((n ^ alignSize) & (n | -n)) >> 31) == 0;
            if (aligned) continue;
            return false;
        }
        int n = this.getSize() % maxAlign;
        return n + (maxAlign & ((n ^ maxAlign) & (n | -n)) >> 31) == 0;
    }

    public VertexFormat() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VertexElementType.values().length];
            try {
                nArray[VertexElementType.VECTOR3_FLOAT32.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR3_UINT32.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR3_INT32.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.MATRIX33_FLOAT32.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.MATRIX44_FLOAT32.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.MATRIX22_FLOAT32.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR4_UINT32.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR4_FLOAT32.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR4_INT32.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR2_UINT32.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR2_FLOAT32.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR2_INT32.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.FLOAT32.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.UINT32.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.INT32.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

