/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.BufferMultisample;
import org.openrndr.draw.ColorAttachment;
import org.openrndr.draw.ColorBufferAttachment;
import org.openrndr.draw.DepthBuffer;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.RenderTargetBuilder;
import org.openrndr.draw.RenderTargetKt;
import org.openrndr.draw.Session;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00060\u0001j\u0002`\u0002BN\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000e\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016J$\u0010\u001b\u001a\u00020\u000f2\b\b\u0002\u0010\u001c\u001a\u00020\u00042\b\b\u0002\u0010\u001d\u001a\u00020\u00042\b\b\u0002\u0010\u001e\u001a\u00020\u0007J\b\u0010\u001f\u001a\u00020\u000fH\u0016R\"\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\b\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006 "}, d2={"Lorg/openrndr/draw/ResizableRenderTarget;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "width", "", "height", "contentScale", "", "multisample", "Lorg/openrndr/draw/BufferMultisample;", "session", "Lorg/openrndr/draw/Session;", "builder", "Lkotlin/Function1;", "Lorg/openrndr/draw/RenderTargetBuilder;", "", "Lkotlin/ExtensionFunctionType;", "<init>", "(IIDLorg/openrndr/draw/BufferMultisample;Lorg/openrndr/draw/Session;Lkotlin/jvm/functions/Function1;)V", "getBuilder", "()Lkotlin/jvm/functions/Function1;", "renderTarget", "Lorg/openrndr/draw/RenderTarget;", "getRenderTarget", "()Lorg/openrndr/draw/RenderTarget;", "setRenderTarget", "(Lorg/openrndr/draw/RenderTarget;)V", "resize", "newWidth", "newHeight", "newContentScale", "close", "openrndr-draw"})
public final class ResizableRenderTarget
implements AutoCloseable {
    @NotNull
    private final Function1<RenderTargetBuilder, Unit> builder;
    @NotNull
    private RenderTarget renderTarget;

    public ResizableRenderTarget(int width, int height, double contentScale, @NotNull BufferMultisample multisample, @Nullable Session session, @NotNull Function1<? super RenderTargetBuilder, Unit> builder) {
        Intrinsics.checkNotNullParameter(multisample, "multisample");
        Intrinsics.checkNotNullParameter(builder, "builder");
        this.builder = builder;
        this.renderTarget = RenderTargetKt.renderTarget(width, height, contentScale, multisample, session, this.builder);
    }

    public /* synthetic */ ResizableRenderTarget(int n, int n2, double d, BufferMultisample bufferMultisample, Session session, Function1 function1, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            d = 1.0;
        }
        if ((n3 & 8) != 0) {
            bufferMultisample = BufferMultisample.Disabled.INSTANCE;
        }
        this(n, n2, d, bufferMultisample, session, function1);
    }

    @NotNull
    public final Function1<RenderTargetBuilder, Unit> getBuilder() {
        return this.builder;
    }

    @NotNull
    public final RenderTarget getRenderTarget() {
        return this.renderTarget;
    }

    public final void setRenderTarget(@NotNull RenderTarget renderTarget) {
        Intrinsics.checkNotNullParameter(renderTarget, "<set-?>");
        this.renderTarget = renderTarget;
    }

    public final void resize(@NotNull RenderTarget renderTarget) {
        Intrinsics.checkNotNullParameter(renderTarget, "renderTarget");
        this.resize(renderTarget.getWidth(), renderTarget.getHeight(), renderTarget.getContentScale());
    }

    public final void resize(int newWidth, int newHeight, double newContentScale) {
        if (this.renderTarget.getWidth() != newWidth || this.renderTarget.getHeight() != newHeight || !(this.renderTarget.getContentScale() == newContentScale)) {
            for (ColorAttachment attachment : this.renderTarget.getColorAttachments()) {
                if (attachment instanceof ColorBufferAttachment) {
                    ((ColorBufferAttachment)attachment).getColorBuffer().destroy();
                    continue;
                }
                throw new IllegalStateException(("unsupported attachment `" + attachment + "` in ResizableRenderTarget").toString());
            }
            DepthBuffer depthBuffer = this.renderTarget.getDepthBuffer();
            if (depthBuffer != null) {
                depthBuffer.destroy();
            }
            this.renderTarget.detachColorAttachments();
            this.renderTarget.detachDepthBuffer();
            this.renderTarget.destroy();
            this.renderTarget = RenderTargetKt.renderTarget(newWidth, newHeight, newContentScale, this.renderTarget.getMultisample(), this.renderTarget.getSession(), this.builder);
        }
    }

    public static /* synthetic */ void resize$default(ResizableRenderTarget resizableRenderTarget, int n, int n2, double d, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = resizableRenderTarget.renderTarget.getWidth();
        }
        if ((n3 & 2) != 0) {
            n2 = resizableRenderTarget.renderTarget.getHeight();
        }
        if ((n3 & 4) != 0) {
            d = resizableRenderTarget.renderTarget.getContentScale();
        }
        resizableRenderTarget.resize(n, n2, d);
    }

    @Override
    public void close() {
        this.renderTarget.close();
    }
}

