/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.BufferMultisample;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferKt;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.Session;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002BU\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J$\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u00042\b\b\u0002\u0010\u001c\u001a\u00020\u00042\b\b\u0002\u0010\u001d\u001a\u00020\u0007J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u001aH\u0016R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006!"}, d2={"Lorg/openrndr/draw/ResizableColorBuffer;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "width", "", "height", "contentScale", "", "format", "Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "multisample", "Lorg/openrndr/draw/BufferMultisample;", "levels", "session", "Lorg/openrndr/draw/Session;", "<init>", "(IIDLorg/openrndr/draw/ColorFormat;Lorg/openrndr/draw/ColorType;Lorg/openrndr/draw/BufferMultisample;ILorg/openrndr/draw/Session;)V", "colorBuffer", "Lorg/openrndr/draw/ColorBuffer;", "getColorBuffer", "()Lorg/openrndr/draw/ColorBuffer;", "setColorBuffer", "(Lorg/openrndr/draw/ColorBuffer;)V", "resize", "", "newWidth", "newHeight", "newContentScale", "renderTarget", "Lorg/openrndr/draw/RenderTarget;", "close", "openrndr-draw"})
public final class ResizableColorBuffer
implements AutoCloseable {
    @NotNull
    private ColorBuffer colorBuffer;

    public ResizableColorBuffer(int width, int height, double contentScale, @NotNull ColorFormat format, @NotNull ColorType type, @NotNull BufferMultisample multisample, int levels, @Nullable Session session) {
        Intrinsics.checkNotNullParameter((Object)format, "format");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Intrinsics.checkNotNullParameter(multisample, "multisample");
        this.colorBuffer = ColorBufferKt.colorBuffer(width, height, contentScale, format, type, multisample, levels, session);
    }

    public /* synthetic */ ResizableColorBuffer(int n, int n2, double d, ColorFormat colorFormat, ColorType colorType, BufferMultisample bufferMultisample, int n3, Session session, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            d = 1.0;
        }
        if ((n4 & 8) != 0) {
            colorFormat = ColorFormat.RGBa;
        }
        if ((n4 & 0x10) != 0) {
            colorType = ColorBufferKt.defaultColorType(colorFormat);
        }
        if ((n4 & 0x20) != 0) {
            bufferMultisample = BufferMultisample.Disabled.INSTANCE;
        }
        if ((n4 & 0x40) != 0) {
            n3 = 1;
        }
        if ((n4 & 0x80) != 0) {
            session = Session.Companion.getActive();
        }
        this(n, n2, d, colorFormat, colorType, bufferMultisample, n3, session);
    }

    @NotNull
    public final ColorBuffer getColorBuffer() {
        return this.colorBuffer;
    }

    public final void setColorBuffer(@NotNull ColorBuffer colorBuffer) {
        Intrinsics.checkNotNullParameter(colorBuffer, "<set-?>");
        this.colorBuffer = colorBuffer;
    }

    public final void resize(int newWidth, int newHeight, double newContentScale) {
        if (newWidth != this.colorBuffer.getWidth() || newHeight != this.colorBuffer.getHeight() || !(newContentScale == this.colorBuffer.getContentScale())) {
            this.colorBuffer.destroy();
            this.colorBuffer = ColorBufferKt.colorBuffer(newWidth, newHeight, newContentScale, this.colorBuffer.getFormat(), this.colorBuffer.getType(), this.colorBuffer.getMultisample(), this.colorBuffer.getLevels(), this.colorBuffer.getSession());
        }
    }

    public static /* synthetic */ void resize$default(ResizableColorBuffer resizableColorBuffer, int n, int n2, double d, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = resizableColorBuffer.colorBuffer.getWidth();
        }
        if ((n3 & 2) != 0) {
            n2 = resizableColorBuffer.colorBuffer.getHeight();
        }
        if ((n3 & 4) != 0) {
            d = resizableColorBuffer.colorBuffer.getContentScale();
        }
        resizableColorBuffer.resize(n, n2, d);
    }

    public final void resize(@NotNull RenderTarget renderTarget) {
        Intrinsics.checkNotNullParameter(renderTarget, "renderTarget");
        this.resize(renderTarget.getWidth(), renderTarget.getHeight(), renderTarget.getContentScale());
    }

    @Override
    public void close() {
        this.colorBuffer.close();
    }
}

