/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.DrawContextJVM;
import org.openrndr.draw.DrawContextKt;
import org.openrndr.draw.Shader;
import org.openrndr.draw.UniformBlock;
import org.openrndr.internal.Driver;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.transforms.TransformsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00c6\u0003JO\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u000fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0010R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0010\u00a8\u0006$"}, d2={"Lorg/openrndr/draw/DrawContext;", "Ljava/lang/Record;", "model", "Lorg/openrndr/math/Matrix44;", "view", "projection", "width", "", "height", "contentScale", "", "modelViewScalingFactor", "<init>", "(Lorg/openrndr/math/Matrix44;Lorg/openrndr/math/Matrix44;Lorg/openrndr/math/Matrix44;IIDD)V", "()Lorg/openrndr/math/Matrix44;", "()I", "()D", "applyToShader", "", "shader", "Lorg/openrndr/draw/Shader;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "", "hashCode", "toString", "", "openrndr-draw"})
@SourceDebugExtension(value={"SMAP\nDrawContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DrawContext.kt\norg/openrndr/draw/DrawContext\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,117:1\n381#2,7:118\n*S KotlinDebug\n*F\n+ 1 DrawContext.kt\norg/openrndr/draw/DrawContext\n*L\n82#1:118,7\n*E\n"})
public final class DrawContext
extends Record {
    @NotNull
    private final Matrix44 model;
    @NotNull
    private final Matrix44 view;
    @NotNull
    private final Matrix44 projection;
    private final int width;
    private final int height;
    private final double contentScale;
    private final double modelViewScalingFactor;

    public DrawContext(@NotNull Matrix44 model, @NotNull Matrix44 view, @NotNull Matrix44 projection, int width, int height, double contentScale, double modelViewScalingFactor) {
        Intrinsics.checkNotNullParameter(model, "model");
        Intrinsics.checkNotNullParameter(view, "view");
        Intrinsics.checkNotNullParameter(projection, "projection");
        this.model = model;
        this.view = view;
        this.projection = projection;
        this.width = width;
        this.height = height;
        this.contentScale = contentScale;
        this.modelViewScalingFactor = modelViewScalingFactor;
    }

    @NotNull
    public final Matrix44 model() {
        return this.model;
    }

    @NotNull
    public final Matrix44 view() {
        return this.view;
    }

    @NotNull
    public final Matrix44 projection() {
        return this.projection;
    }

    public final int width() {
        return this.width;
    }

    public final int height() {
        return this.height;
    }

    public final double contentScale() {
        return this.contentScale;
    }

    public final double modelViewScalingFactor() {
        return this.modelViewScalingFactor;
    }

    /*
     * WARNING - void declaration
     */
    public final void applyToShader(@NotNull Shader shader) {
        block19: {
            Matrix44 matrix44;
            Matrix44 matrix442;
            UniformBlock contextBlock;
            Object object;
            void $this$getOrPut$iv;
            block18: {
                Matrix44 normalMatrix;
                Intrinsics.checkNotNullParameter(shader, "shader");
                if (DrawContextJVM.getUseContextBlock()) break block18;
                if (shader.hasUniform("u_viewMatrix")) {
                    shader.uniform("u_viewMatrix", this.view);
                }
                if (shader.hasUniform("u_modelMatrix")) {
                    shader.uniform("u_modelMatrix", this.model);
                }
                if (shader.hasUniform("u_projectionMatrix")) {
                    shader.uniform("u_projectionMatrix", this.projection);
                }
                if (shader.hasUniform("u_viewDimensions")) {
                    shader.uniform("u_viewDimensions", new Vector2(this.width, this.height));
                }
                if (shader.hasUniform("u_modelNormalMatrix")) {
                    Matrix44 matrix443;
                    if (this.model == DrawContextKt.access$getLastModel$p()) {
                        matrix443 = DrawContextKt.access$getLastModelNormal$p();
                    } else {
                        DrawContextKt.access$setLastModelNormal$p(this.model != Matrix44.Companion.getIDENTITY() ? TransformsKt.normalMatrix(this.model) : Matrix44.Companion.getIDENTITY());
                        DrawContextKt.access$setLastModel$p(this.model);
                        matrix443 = DrawContextKt.access$getLastModelNormal$p();
                    }
                    normalMatrix = matrix443;
                    shader.uniform("u_modelNormalMatrix", normalMatrix);
                }
                if (shader.hasUniform("u_viewNormalMatrix")) {
                    Matrix44 matrix444;
                    if (this.view == DrawContextKt.access$getLastView$p()) {
                        matrix444 = DrawContextKt.access$getLastViewNormal$p();
                    } else {
                        DrawContextKt.access$setLastViewNormal$p(this.view != Matrix44.Companion.getIDENTITY() ? TransformsKt.normalMatrix(this.view) : Matrix44.Companion.getIDENTITY());
                        DrawContextKt.access$setLastView$p(this.view);
                        matrix444 = DrawContextKt.access$getLastViewNormal$p();
                    }
                    normalMatrix = matrix444;
                    shader.uniform("u_viewNormalMatrix", normalMatrix);
                }
                if (shader.hasUniform("u_contentScale")) {
                    shader.uniform("u_contentScale", this.contentScale);
                }
                if (!shader.hasUniform("u_modelViewScalingFactor")) break block19;
                shader.uniform("u_modelViewScalingFactor", this.modelViewScalingFactor);
                break block19;
            }
            Object object2 = DrawContextKt.getContextBlocks();
            Long key$iv = Driver.Companion.getInstance().getContextID();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                UniformBlock answer$iv = shader.createBlock("ContextBlock");
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            UniformBlock uniformBlock = contextBlock = (UniformBlock)object;
            if (uniformBlock == null) break block19;
            Object $this$applyToShader_u24lambda_u243 = object2 = uniformBlock;
            boolean bl = false;
            $this$applyToShader_u24lambda_u243.uniform("u_viewMatrix", this.view);
            $this$applyToShader_u24lambda_u243.uniform("u_modelMatrix", this.model);
            $this$applyToShader_u24lambda_u243.uniform("u_projectionMatrix", this.projection);
            $this$applyToShader_u24lambda_u243.uniform("u_viewDimensions", new Vector2(this.width, this.height));
            Object $this$applyToShader_u24lambda_u243_u24lambda_u241 = $this$applyToShader_u24lambda_u243;
            boolean bl2 = false;
            if (this.model == DrawContextKt.access$getLastModel$p()) {
                matrix442 = DrawContextKt.access$getLastModelNormal$p();
            } else {
                DrawContextKt.access$setLastModelNormal$p(this.model != Matrix44.Companion.getIDENTITY() ? TransformsKt.normalMatrix(this.model) : Matrix44.Companion.getIDENTITY());
                DrawContextKt.access$setLastModel$p(this.model);
                matrix442 = DrawContextKt.access$getLastModelNormal$p();
            }
            Matrix44 normalMatrix = matrix442;
            $this$applyToShader_u24lambda_u243_u24lambda_u241.uniform("u_modelNormalMatrix", normalMatrix);
            Object $this$applyToShader_u24lambda_u243_u24lambda_u242 = $this$applyToShader_u24lambda_u243;
            boolean bl3 = false;
            if (this.view == DrawContextKt.access$getLastView$p()) {
                matrix44 = DrawContextKt.access$getLastViewNormal$p();
            } else {
                DrawContextKt.access$setLastViewNormal$p(this.view != Matrix44.Companion.getIDENTITY() ? TransformsKt.normalMatrix(this.view) : Matrix44.Companion.getIDENTITY());
                DrawContextKt.access$setLastView$p(this.view);
                matrix44 = DrawContextKt.access$getLastViewNormal$p();
            }
            normalMatrix = matrix44;
            $this$applyToShader_u24lambda_u243_u24lambda_u242.uniform("u_viewNormalMatrix", normalMatrix);
            $this$applyToShader_u24lambda_u243.uniform("u_contentScale", (float)this.contentScale);
            $this$applyToShader_u24lambda_u243.uniform("u_modelViewScalingFactor", (float)this.modelViewScalingFactor);
            if ($this$applyToShader_u24lambda_u243.getDirty()) {
                $this$applyToShader_u24lambda_u243.upload();
            }
            shader.block("ContextBlock", (UniformBlock)$this$applyToShader_u24lambda_u243);
        }
    }

    @NotNull
    public final Matrix44 component1() {
        return this.model;
    }

    @NotNull
    public final Matrix44 component2() {
        return this.view;
    }

    @NotNull
    public final Matrix44 component3() {
        return this.projection;
    }

    public final int component4() {
        return this.width;
    }

    public final int component5() {
        return this.height;
    }

    public final double component6() {
        return this.contentScale;
    }

    public final double component7() {
        return this.modelViewScalingFactor;
    }

    @NotNull
    public final DrawContext copy(@NotNull Matrix44 model, @NotNull Matrix44 view, @NotNull Matrix44 projection, int width, int height, double contentScale, double modelViewScalingFactor) {
        Intrinsics.checkNotNullParameter(model, "model");
        Intrinsics.checkNotNullParameter(view, "view");
        Intrinsics.checkNotNullParameter(projection, "projection");
        return new DrawContext(model, view, projection, width, height, contentScale, modelViewScalingFactor);
    }

    public static /* synthetic */ DrawContext copy$default(DrawContext drawContext, Matrix44 matrix44, Matrix44 matrix442, Matrix44 matrix443, int n, int n2, double d, double d2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            matrix44 = drawContext.model;
        }
        if ((n3 & 2) != 0) {
            matrix442 = drawContext.view;
        }
        if ((n3 & 4) != 0) {
            matrix443 = drawContext.projection;
        }
        if ((n3 & 8) != 0) {
            n = drawContext.width;
        }
        if ((n3 & 0x10) != 0) {
            n2 = drawContext.height;
        }
        if ((n3 & 0x20) != 0) {
            d = drawContext.contentScale;
        }
        if ((n3 & 0x40) != 0) {
            d2 = drawContext.modelViewScalingFactor;
        }
        return drawContext.copy(matrix44, matrix442, matrix443, n, n2, d, d2);
    }

    @Override
    @NotNull
    public String toString() {
        return "DrawContext(model=" + this.model + ", view=" + this.view + ", projection=" + this.projection + ", width=" + this.width + ", height=" + this.height + ", contentScale=" + this.contentScale + ", modelViewScalingFactor=" + this.modelViewScalingFactor + ")";
    }

    @Override
    public int hashCode() {
        int result = this.model.hashCode();
        result = result * 31 + this.view.hashCode();
        result = result * 31 + this.projection.hashCode();
        result = result * 31 + Integer.hashCode(this.width);
        result = result * 31 + Integer.hashCode(this.height);
        result = result * 31 + Double.hashCode(this.contentScale);
        result = result * 31 + Double.hashCode(this.modelViewScalingFactor);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DrawContext)) {
            return false;
        }
        DrawContext drawContext = (DrawContext)other;
        if (!Intrinsics.areEqual(this.model, drawContext.model)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.view, drawContext.view)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.projection, drawContext.projection)) {
            return false;
        }
        if (this.width != drawContext.width) {
            return false;
        }
        if (this.height != drawContext.height) {
            return false;
        }
        if (Double.compare(this.contentScale, drawContext.contentScale) != 0) {
            return false;
        }
        return Double.compare(this.modelViewScalingFactor, drawContext.modelViewScalingFactor) == 0;
    }
}

