/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.IntVector2;
import org.openrndr.math.IntVector3;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0006\u001a\u0016\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002\u00a8\u0006\u000b"}, d2={"computeShader1DExecuteSize", "Lorg/openrndr/math/IntVector3;", "workGroupSize", "dataSize", "", "computeShader2DExecuteSize", "Lorg/openrndr/math/IntVector2;", "computeShaderExecuteSize", "workGroupDimensionSize", "layout", "size", "openrndr-draw"})
@SourceDebugExtension(value={"SMAP\nComputeShader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComputeShader.kt\norg/openrndr/draw/ComputeShaderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n1#2:155\n*E\n"})
public final class ComputeShaderKt {
    @NotNull
    public static final IntVector3 computeShader1DExecuteSize(@NotNull IntVector3 workGroupSize, int dataSize) {
        Intrinsics.checkNotNullParameter(workGroupSize, "workGroupSize");
        if (!(workGroupSize.y() == 1)) {
            boolean $i$a$-require-ComputeShaderKt$computeShader1DExecuteSize$32 = false;
            String $i$a$-require-ComputeShaderKt$computeShader1DExecuteSize$32 = "workGroupSize.y must be 1";
            throw new IllegalArgumentException($i$a$-require-ComputeShaderKt$computeShader1DExecuteSize$32.toString());
        }
        if (!(workGroupSize.z() == 1)) {
            boolean bl = false;
            String string = "workGroupSize.z must be 1";
            throw new IllegalArgumentException(string.toString());
        }
        return ComputeShaderKt.computeShaderExecuteSize(workGroupSize, new IntVector3(dataSize, 1, 1));
    }

    @NotNull
    public static final IntVector3 computeShader2DExecuteSize(@NotNull IntVector3 workGroupSize, @NotNull IntVector2 dataSize) {
        Intrinsics.checkNotNullParameter(workGroupSize, "workGroupSize");
        Intrinsics.checkNotNullParameter(dataSize, "dataSize");
        if (!(workGroupSize.z() == 1)) {
            boolean bl = false;
            String string = "workGroupSize.z must be 1";
            throw new IllegalArgumentException(string.toString());
        }
        return ComputeShaderKt.computeShaderExecuteSize(workGroupSize, new IntVector3(dataSize.x(), dataSize.y(), 1));
    }

    @NotNull
    public static final IntVector3 computeShaderExecuteSize(@NotNull IntVector3 workGroupSize, @NotNull IntVector3 dataSize) {
        Intrinsics.checkNotNullParameter(workGroupSize, "workGroupSize");
        Intrinsics.checkNotNullParameter(dataSize, "dataSize");
        return new IntVector3(ComputeShaderKt.workGroupDimensionSize(workGroupSize.x(), dataSize.x()), ComputeShaderKt.workGroupDimensionSize(workGroupSize.y(), dataSize.y()), ComputeShaderKt.workGroupDimensionSize(workGroupSize.z(), dataSize.z()));
    }

    private static final int workGroupDimensionSize(int layout, int size) {
        return (int)Math.ceil((double)size / (double)layout);
    }
}

