/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.io.File;
import java.net.URL;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferKt;
import org.openrndr.draw.ImageFileFormat;
import org.openrndr.draw.Session;
import org.openrndr.internal.ImageData;
import org.openrndr.internal.ImageDriver;
import org.openrndr.utils.buffer.MPPBuffer;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a:\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u001a:\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u001a:\u0010\u0000\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u001a8\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0086@\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"loadImage", "Lorg/openrndr/draw/ColorBuffer;", "fileOrUrl", "", "formatHint", "Lorg/openrndr/draw/ImageFileFormat;", "allowSRGB", "", "loadMipmaps", "session", "Lorg/openrndr/draw/Session;", "file", "Ljava/io/File;", "url", "Ljava/net/URL;", "loadImageSuspend", "(Ljava/lang/String;Lorg/openrndr/draw/ImageFileFormat;ZLorg/openrndr/draw/Session;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "openrndr-draw"})
@JvmName(name="ColorBufferJVM")
public final class ColorBufferJVM {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final ColorBuffer loadImage(@NotNull String fileOrUrl, @Nullable ImageFileFormat formatHint, boolean allowSRGB, boolean loadMipmaps, @Nullable Session session) {
        ColorBuffer colorBuffer;
        Intrinsics.checkNotNullParameter(fileOrUrl, "fileOrUrl");
        try (ImageData data = ImageDriver.Companion.getInstance().loadImage(fileOrUrl, formatHint, allowSRGB);){
            int size = Math.min(data.getWidth(), data.getHeight());
            int levels = loadMipmaps ? (int)Math.floor(MathKt.log2((double)size)) + 1 : 1;
            ColorBuffer cb = ColorBufferKt.colorBuffer$default(data.getWidth(), data.getHeight(), 1.0, data.getFormat(), data.getType(), null, levels, session, 32, null);
            Object object = data.getData();
            if (object == null || (object = ((MPPBuffer)object).getByteBuffer()) == null) {
                throw new IllegalStateException("no data".toString());
            }
            ColorBuffer.write$default(cb, (ByteBuffer)object, null, null, 0, 14, null);
            if (loadMipmaps) {
                cb.generateMipmaps();
            }
            colorBuffer = cb;
        }
        return colorBuffer;
    }

    public static /* synthetic */ ColorBuffer loadImage$default(String string, ImageFileFormat imageFileFormat, boolean bl, boolean bl2, Session session, int n, Object object) {
        if ((n & 2) != 0) {
            String[] stringArray = new String[]{"."};
            imageFileFormat = ImageFileFormat.Companion.guessFromExtension((String)CollectionsKt.last(StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null)));
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x10) != 0) {
            session = Session.Companion.getActive();
        }
        return ColorBufferJVM.loadImage(string, imageFileFormat, bl, bl2, session);
    }

    @NotNull
    public static final ColorBuffer loadImage(@NotNull File file, @Nullable ImageFileFormat formatHint, boolean allowSRGB, boolean loadMipmaps, @Nullable Session session) {
        Intrinsics.checkNotNullParameter(file, "file");
        String string = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue(string, "getAbsolutePath(...)");
        return ColorBufferJVM.loadImage(string, formatHint, allowSRGB, loadMipmaps, session);
    }

    public static /* synthetic */ ColorBuffer loadImage$default(File file, ImageFileFormat imageFileFormat, boolean bl, boolean bl2, Session session, int n, Object object) {
        if ((n & 2) != 0) {
            imageFileFormat = ImageFileFormat.Companion.guessFromExtension(FilesKt.getExtension(file));
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x10) != 0) {
            session = Session.Companion.getActive();
        }
        return ColorBufferJVM.loadImage(file, imageFileFormat, bl, bl2, session);
    }

    @NotNull
    public static final ColorBuffer loadImage(@NotNull URL url, @Nullable ImageFileFormat formatHint, boolean allowSRGB, boolean loadMipmaps, @Nullable Session session) {
        Intrinsics.checkNotNullParameter(url, "url");
        String string = url.toExternalForm();
        Intrinsics.checkNotNullExpressionValue(string, "toExternalForm(...)");
        return ColorBufferJVM.loadImage(string, formatHint, allowSRGB, loadMipmaps, session);
    }

    public static /* synthetic */ ColorBuffer loadImage$default(URL uRL, ImageFileFormat imageFileFormat, boolean bl, boolean bl2, Session session, int n, Object object) {
        if ((n & 2) != 0) {
            String string = uRL.toExternalForm();
            Intrinsics.checkNotNullExpressionValue(string, "toExternalForm(...)");
            String[] stringArray = new String[]{"."};
            imageFileFormat = ImageFileFormat.Companion.guessFromExtension((String)CollectionsKt.lastOrNull(StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null)));
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x10) != 0) {
            session = Session.Companion.getActive();
        }
        return ColorBufferJVM.loadImage(uRL, imageFileFormat, bl, bl2, session);
    }

    @Nullable
    public static final Object loadImageSuspend(@NotNull String fileOrUrl, @Nullable ImageFileFormat formatHint, boolean allowSRGB, @Nullable Session session, @NotNull Continuation<? super ColorBuffer> $completion) {
        return BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super ColorBuffer>, Object>(fileOrUrl, formatHint, allowSRGB, session, null){
            int label;
            final /* synthetic */ String $fileOrUrl;
            final /* synthetic */ ImageFileFormat $formatHint;
            final /* synthetic */ boolean $allowSRGB;
            final /* synthetic */ Session $session;
            {
                this.$fileOrUrl = $fileOrUrl;
                this.$formatHint = $formatHint;
                this.$allowSRGB = $allowSRGB;
                this.$session = $session;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        return ColorBufferJVM.loadImage(this.$fileOrUrl, this.$formatHint, this.$allowSRGB, true, this.$session);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super ColorBuffer> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    public static /* synthetic */ Object loadImageSuspend$default(String string, ImageFileFormat imageFileFormat, boolean bl, Session session, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            imageFileFormat = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            session = Session.Companion.getActive();
        }
        return ColorBufferJVM.loadImageSuspend(string, imageFileFormat, bl, session, continuation);
    }
}

