/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.io.File;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.ArrayTexture;
import org.openrndr.draw.BufferMultisample;
import org.openrndr.draw.ColorBufferKt;
import org.openrndr.draw.ColorBufferShadow;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.ImageFileFormat;
import org.openrndr.draw.MagnifyingFilter;
import org.openrndr.draw.MinifyingFilter;
import org.openrndr.draw.Session;
import org.openrndr.draw.WrapMode;
import org.openrndr.internal.ImageSaveConfiguration;
import org.openrndr.internal.ImageSaveContext;
import org.openrndr.math.Vector2;
import org.openrndr.shape.IntRectangle;
import org.openrndr.shape.IntRectangleKt;
import org.openrndr.shape.Rectangle;
import org.openrndr.utils.buffer.MPPBuffer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 |2\u00060\u0001j\u0002`\u0002:\u0001|B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010)\u001a\u00020*2\b\b\u0002\u0010+\u001a\u00020\nJ$\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u0002012\b\b\u0002\u00102\u001a\u000203H&J\"\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\b\b\u0002\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H&J1\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\b\b\u0002\u00102\u001a\u0002032\u0017\u00106\u001a\u0013\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020507\u00a2\u0006\u0002\b9J\u0012\u0010:\u001a\u00020;2\b\b\u0002\u00100\u001a\u000201H&J.\u0010<\u001a\u00020-2\u0006\u0010=\u001a\u00020>2\b\b\u0002\u0010?\u001a\u00020\u00142\b\b\u0002\u0010@\u001a\u00020\u00182\b\b\u0002\u0010+\u001a\u00020\nH&J.\u0010A\u001a\u00020-2\u0006\u0010B\u001a\u00020>2\b\b\u0002\u0010C\u001a\u00020\u00142\b\b\u0002\u0010D\u001a\u00020\u00182\b\b\u0002\u0010+\u001a\u00020\nH&J\u000e\u0010E\u001a\u00020\u00002\u0006\u0010F\u001a\u00020GJ>\u0010H\u001a\u00020-2\u0006\u0010I\u001a\u00020\u00002\b\b\u0002\u0010J\u001a\u00020\n2\b\b\u0002\u0010K\u001a\u00020\n2\u0006\u0010F\u001a\u00020G2\u0006\u0010L\u001a\u00020G2\b\b\u0002\u0010M\u001a\u00020NH&J.\u0010H\u001a\u00020-2\u0006\u0010I\u001a\u00020\u00002\b\b\u0002\u0010J\u001a\u00020\n2\b\b\u0002\u0010K\u001a\u00020\n2\b\b\u0002\u0010M\u001a\u00020NH&J,\u0010H\u001a\u00020-2\u0006\u0010I\u001a\u00020O2\u0006\u0010P\u001a\u00020\n2\b\b\u0002\u0010J\u001a\u00020\n2\b\b\u0002\u0010K\u001a\u00020\nH&J\u001a\u0010Q\u001a\u00020-2\u0006\u0010R\u001a\u00020S2\b\b\u0002\u0010+\u001a\u00020\nH&J\u0018\u0010M\u001a\u00020-2\u0006\u0010]\u001a\u00020^2\u0006\u0010c\u001a\u00020NH&J\b\u0010l\u001a\u00020-H&J\u0010\u0010m\u001a\u00020-2\u0006\u0010n\u001a\u00020\nH&J\b\u0010o\u001a\u00020-H&JV\u0010<\u001a\u00020-2\u0006\u0010=\u001a\u00020y2\b\b\u0002\u0010?\u001a\u00020\u00142\b\b\u0002\u0010@\u001a\u00020\u00182\b\b\u0002\u0010z\u001a\u00020\n2\b\b\u0002\u0010{\u001a\u00020\n2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\n2\b\b\u0002\u0010+\u001a\u00020\nH&R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u00020\u0018X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0012\u0010\u001b\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\fR\u0012\u0010\u001d\u001a\u00020\u001eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\fR\u0011\u0010'\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\fR\u0018\u0010T\u001a\u00020UX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\bV\u0010W\"\u0004\bX\u0010YR\u0018\u0010Z\u001a\u00020UX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b[\u0010W\"\u0004\b\\\u0010YR\u0018\u0010]\u001a\u00020^X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b_\u0010`\"\u0004\ba\u0010bR\u0018\u0010c\u001a\u00020NX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\bd\u0010e\"\u0004\bf\u0010gR\u0012\u0010h\u001a\u00020iX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bj\u0010kR\u0018\u0010p\u001a\u00020\u0010X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\bq\u0010\u0012\"\u0004\br\u0010sR\u0018\u0010t\u001a\u000203X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\bu\u0010v\"\u0004\bw\u0010x\u00a8\u0006}"}, d2={"Lorg/openrndr/draw/ColorBuffer;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "<init>", "()V", "session", "Lorg/openrndr/draw/Session;", "getSession", "()Lorg/openrndr/draw/Session;", "width", "", "getWidth", "()I", "height", "getHeight", "contentScale", "", "getContentScale", "()D", "format", "Lorg/openrndr/draw/ColorFormat;", "getFormat", "()Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "getType", "()Lorg/openrndr/draw/ColorType;", "levels", "getLevels", "multisample", "Lorg/openrndr/draw/BufferMultisample;", "getMultisample", "()Lorg/openrndr/draw/BufferMultisample;", "bounds", "Lorg/openrndr/shape/Rectangle;", "getBounds", "()Lorg/openrndr/shape/Rectangle;", "effectiveWidth", "getEffectiveWidth", "effectiveHeight", "getEffectiveHeight", "bufferSize", "", "level", "saveToFile", "", "file", "Ljava/io/File;", "imageFileFormat", "Lorg/openrndr/draw/ImageFileFormat;", "async", "", "configuration", "Lorg/openrndr/internal/ImageSaveConfiguration;", "configurator", "Lkotlin/Function1;", "Lorg/openrndr/internal/ImageSaveContext;", "Lkotlin/ExtensionFunctionType;", "toDataUrl", "", "write", "sourceBuffer", "Ljava/nio/ByteBuffer;", "sourceFormat", "sourceType", "read", "targetBuffer", "targetFormat", "targetType", "crop", "sourceRectangle", "Lorg/openrndr/shape/IntRectangle;", "copyTo", "target", "fromLevel", "toLevel", "targetRectangle", "filter", "Lorg/openrndr/draw/MagnifyingFilter;", "Lorg/openrndr/draw/ArrayTexture;", "layer", "fill", "color", "Lorg/openrndr/color/ColorRGBa;", "wrapU", "Lorg/openrndr/draw/WrapMode;", "getWrapU", "()Lorg/openrndr/draw/WrapMode;", "setWrapU", "(Lorg/openrndr/draw/WrapMode;)V", "wrapV", "getWrapV", "setWrapV", "filterMin", "Lorg/openrndr/draw/MinifyingFilter;", "getFilterMin", "()Lorg/openrndr/draw/MinifyingFilter;", "setFilterMin", "(Lorg/openrndr/draw/MinifyingFilter;)V", "filterMag", "getFilterMag", "()Lorg/openrndr/draw/MagnifyingFilter;", "setFilterMag", "(Lorg/openrndr/draw/MagnifyingFilter;)V", "shadow", "Lorg/openrndr/draw/ColorBufferShadow;", "getShadow", "()Lorg/openrndr/draw/ColorBufferShadow;", "destroy", "bind", "unit", "generateMipmaps", "anisotropy", "getAnisotropy", "setAnisotropy", "(D)V", "flipV", "getFlipV", "()Z", "setFlipV", "(Z)V", "Lorg/openrndr/utils/buffer/MPPBuffer;", "x", "y", "Companion", "openrndr-draw"})
public abstract class ColorBuffer
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public abstract Session getSession();

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract double getContentScale();

    @NotNull
    public abstract ColorFormat getFormat();

    @NotNull
    public abstract ColorType getType();

    public abstract int getLevels();

    @NotNull
    public abstract BufferMultisample getMultisample();

    @NotNull
    public final Rectangle getBounds() {
        return new Rectangle(Vector2.Companion.getZERO(), (double)this.getWidth() * 1.0, (double)this.getHeight() * 1.0);
    }

    public final int getEffectiveWidth() {
        return (int)((double)this.getWidth() * this.getContentScale());
    }

    public final int getEffectiveHeight() {
        return (int)((double)this.getHeight() * this.getContentScale());
    }

    public final long bufferSize(int level) {
        long baseSize = this.getEffectiveWidth() * this.getEffectiveHeight() >> level;
        return switch (WhenMappings.$EnumSwitchMapping$0[this.getType().ordinal()]) {
            case 1 -> baseSize / (long)2;
            case 2, 3 -> baseSize;
            case 4 -> throw new NotImplementedError(null, 1, null);
            case 5 -> throw new NotImplementedError(null, 1, null);
            case 6 -> throw new NotImplementedError(null, 1, null);
            default -> baseSize * (long)this.getFormat().getComponentCount() * (long)this.getType().getComponentSize();
        };
    }

    public static /* synthetic */ long bufferSize$default(ColorBuffer colorBuffer, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: bufferSize");
        }
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return colorBuffer.bufferSize(n);
    }

    public abstract void saveToFile(@NotNull File var1, @NotNull ImageFileFormat var2, boolean var3);

    public static /* synthetic */ void saveToFile$default(ColorBuffer colorBuffer, File file, ImageFileFormat imageFileFormat, boolean bl, int n, Object object) {
        ImageFileFormat imageFileFormat2;
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: saveToFile");
        }
        if ((n & 2) != 0 && (imageFileFormat2 = ImageFileFormat.Companion.guessFromExtension(FilesKt.getExtension(file))) == null) {
            imageFileFormat2 = imageFileFormat = ImageFileFormat.PNG;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        colorBuffer.saveToFile(file, imageFileFormat, bl);
    }

    public abstract void saveToFile(@NotNull File var1, boolean var2, @NotNull ImageSaveConfiguration var3);

    public static /* synthetic */ void saveToFile$default(ColorBuffer colorBuffer, File file, boolean bl, ImageSaveConfiguration imageSaveConfiguration, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: saveToFile");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        colorBuffer.saveToFile(file, bl, imageSaveConfiguration);
    }

    public final void saveToFile(@NotNull File file, boolean async, @NotNull Function1<? super ImageSaveContext, ? extends ImageSaveConfiguration> configurator) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(configurator, "configurator");
        this.saveToFile(file, async, configurator.invoke(new ImageSaveContext()));
    }

    public static /* synthetic */ void saveToFile$default(ColorBuffer colorBuffer, File file, boolean bl, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: saveToFile");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        colorBuffer.saveToFile(file, bl, function1);
    }

    @NotNull
    public abstract String toDataUrl(@NotNull ImageFileFormat var1);

    public static /* synthetic */ String toDataUrl$default(ColorBuffer colorBuffer, ImageFileFormat imageFileFormat, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toDataUrl");
        }
        if ((n & 1) != 0) {
            imageFileFormat = ImageFileFormat.JPG;
        }
        return colorBuffer.toDataUrl(imageFileFormat);
    }

    public abstract void write(@NotNull ByteBuffer var1, @NotNull ColorFormat var2, @NotNull ColorType var3, int var4);

    public static /* synthetic */ void write$default(ColorBuffer colorBuffer, ByteBuffer byteBuffer, ColorFormat colorFormat, ColorType colorType, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: write");
        }
        if ((n2 & 2) != 0) {
            colorFormat = colorBuffer.getFormat();
        }
        if ((n2 & 4) != 0) {
            colorType = colorBuffer.getType();
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        colorBuffer.write(byteBuffer, colorFormat, colorType, n);
    }

    public abstract void read(@NotNull ByteBuffer var1, @NotNull ColorFormat var2, @NotNull ColorType var3, int var4);

    public static /* synthetic */ void read$default(ColorBuffer colorBuffer, ByteBuffer byteBuffer, ColorFormat colorFormat, ColorType colorType, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: read");
        }
        if ((n2 & 2) != 0) {
            colorFormat = colorBuffer.getFormat();
        }
        if ((n2 & 4) != 0) {
            colorType = colorBuffer.getType();
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        colorBuffer.read(byteBuffer, colorFormat, colorType, n);
    }

    @NotNull
    public final ColorBuffer crop(@NotNull IntRectangle sourceRectangle) {
        Intrinsics.checkNotNullParameter(sourceRectangle, "sourceRectangle");
        ColorBuffer cropped = ColorBufferKt.createEquivalent$default(this, sourceRectangle.width(), sourceRectangle.height(), 0.0, null, null, null, 0, 124, null);
        this.copyTo(cropped, 0, 0, sourceRectangle, IntRectangleKt.IntRectangle(0, 0, sourceRectangle.width(), sourceRectangle.height()), MagnifyingFilter.NEAREST);
        return cropped;
    }

    public abstract void copyTo(@NotNull ColorBuffer var1, int var2, int var3, @NotNull IntRectangle var4, @NotNull IntRectangle var5, @NotNull MagnifyingFilter var6);

    public static /* synthetic */ void copyTo$default(ColorBuffer colorBuffer, ColorBuffer colorBuffer2, int n, int n2, IntRectangle intRectangle, IntRectangle intRectangle2, MagnifyingFilter magnifyingFilter, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copyTo");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x20) != 0) {
            magnifyingFilter = MagnifyingFilter.NEAREST;
        }
        colorBuffer.copyTo(colorBuffer2, n, n2, intRectangle, intRectangle2, magnifyingFilter);
    }

    public abstract void copyTo(@NotNull ColorBuffer var1, int var2, int var3, @NotNull MagnifyingFilter var4);

    public static /* synthetic */ void copyTo$default(ColorBuffer colorBuffer, ColorBuffer colorBuffer2, int n, int n2, MagnifyingFilter magnifyingFilter, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copyTo");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        if ((n3 & 8) != 0) {
            magnifyingFilter = MagnifyingFilter.NEAREST;
        }
        colorBuffer.copyTo(colorBuffer2, n, n2, magnifyingFilter);
    }

    public abstract void copyTo(@NotNull ArrayTexture var1, int var2, int var3, int var4);

    public static /* synthetic */ void copyTo$default(ColorBuffer colorBuffer, ArrayTexture arrayTexture, int n, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copyTo");
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = 0;
        }
        colorBuffer.copyTo(arrayTexture, n, n2, n3);
    }

    public abstract void fill(@NotNull ColorRGBa var1, int var2);

    public static /* synthetic */ void fill$default(ColorBuffer colorBuffer, ColorRGBa colorRGBa, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fill");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        colorBuffer.fill(colorRGBa, n);
    }

    @NotNull
    public abstract WrapMode getWrapU();

    public abstract void setWrapU(@NotNull WrapMode var1);

    @NotNull
    public abstract WrapMode getWrapV();

    public abstract void setWrapV(@NotNull WrapMode var1);

    @NotNull
    public abstract MinifyingFilter getFilterMin();

    public abstract void setFilterMin(@NotNull MinifyingFilter var1);

    @NotNull
    public abstract MagnifyingFilter getFilterMag();

    public abstract void setFilterMag(@NotNull MagnifyingFilter var1);

    @NotNull
    public abstract ColorBufferShadow getShadow();

    public abstract void filter(@NotNull MinifyingFilter var1, @NotNull MagnifyingFilter var2);

    public abstract void destroy();

    public abstract void bind(int var1);

    public abstract void generateMipmaps();

    public abstract double getAnisotropy();

    public abstract void setAnisotropy(double var1);

    public abstract boolean getFlipV();

    public abstract void setFlipV(boolean var1);

    public abstract void write(@NotNull MPPBuffer var1, @NotNull ColorFormat var2, @NotNull ColorType var3, int var4, int var5, int var6, int var7, int var8);

    public static /* synthetic */ void write$default(ColorBuffer colorBuffer, MPPBuffer mPPBuffer, ColorFormat colorFormat, ColorType colorType, int n, int n2, int n3, int n4, int n5, int n6, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: write");
        }
        if ((n6 & 2) != 0) {
            colorFormat = colorBuffer.getFormat();
        }
        if ((n6 & 4) != 0) {
            colorType = colorBuffer.getType();
        }
        if ((n6 & 8) != 0) {
            n = 0;
        }
        if ((n6 & 0x10) != 0) {
            n2 = 0;
        }
        if ((n6 & 0x20) != 0) {
            n3 = colorBuffer.getEffectiveWidth();
        }
        if ((n6 & 0x40) != 0) {
            n4 = colorBuffer.getEffectiveHeight();
        }
        if ((n6 & 0x80) != 0) {
            n5 = 0;
        }
        colorBuffer.write(mPPBuffer, colorFormat, colorType, n, n2, n3, n4, n5);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/openrndr/draw/ColorBuffer$Companion;", "", "<init>", "()V", "openrndr-draw"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ColorType.values().length];
            try {
                nArray[ColorType.DXT1.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorType.DXT3.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorType.DXT5.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorType.BPTC_FLOAT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorType.BPTC_UFLOAT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorType.BPTC_UNORM.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

