/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BatchBuilder;
import org.openrndr.draw.BatchesKt;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.CircleBatch;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferKt;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.shape.Circle;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000eJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0013J\u0014\u0010\u0014\u001a\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015J\u001c\u0010\u0014\u001a\u00020\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u00152\u0006\u0010\u0010\u001a\u00020\u000eJ\"\u0010\u0014\u001a\u00020\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015J\u0012\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0019R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lorg/openrndr/draw/CircleBatchBuilder;", "Lorg/openrndr/draw/BatchBuilder;", "drawer", "Lorg/openrndr/draw/Drawer;", "<init>", "(Lorg/openrndr/draw/Drawer;)V", "entries", "", "Lorg/openrndr/draw/CircleBatchBuilder$Entry;", "getEntries", "()Ljava/util/List;", "circle", "", "x", "", "y", "radius", "position", "Lorg/openrndr/math/Vector2;", "Lorg/openrndr/shape/Circle;", "circles", "", "centers", "radii", "batch", "Lorg/openrndr/draw/CircleBatch;", "existingBatch", "Entry", "openrndr-draw"})
public final class CircleBatchBuilder
extends BatchBuilder {
    @NotNull
    private final List<Entry> entries;

    public CircleBatchBuilder(@NotNull Drawer drawer) {
        Intrinsics.checkNotNullParameter(drawer, "drawer");
        super(drawer);
        this.entries = new ArrayList();
    }

    @NotNull
    public final List<Entry> getEntries() {
        return this.entries;
    }

    public final void circle(double x, double y, double radius) {
        ColorRGBa colorRGBa = this.getFill();
        ColorRGBa colorRGBa2 = this.getStroke();
        this.entries.add(new Entry(colorRGBa != null ? colorRGBa.toLinear() : null, colorRGBa2 != null ? colorRGBa2.toLinear() : null, this.getStrokeWeight(), new Vector3(x, y, 0.0), new Vector2(radius, radius)));
    }

    public final void circle(@NotNull Vector2 position, double radius) {
        Intrinsics.checkNotNullParameter(position, "position");
        ColorRGBa colorRGBa = this.getFill();
        ColorRGBa colorRGBa2 = this.getStroke();
        this.entries.add(new Entry(colorRGBa != null ? colorRGBa.toLinear() : null, colorRGBa2 != null ? colorRGBa2.toLinear() : null, this.getStrokeWeight(), position.xy0(), new Vector2(radius, radius)));
    }

    public final void circle(@NotNull Circle circle) {
        Intrinsics.checkNotNullParameter(circle, "circle");
        ColorRGBa colorRGBa = this.getFill();
        ColorRGBa colorRGBa2 = this.getStroke();
        this.entries.add(new Entry(colorRGBa != null ? colorRGBa.toLinear() : null, colorRGBa2 != null ? colorRGBa2.toLinear() : null, this.getStrokeWeight(), circle.center().xy0(), new Vector2(circle.radius(), circle.radius())));
    }

    public final void circles(@NotNull List<Circle> circles) {
        Intrinsics.checkNotNullParameter(circles, "circles");
        for (Circle circle : circles) {
            this.circle(circle);
        }
    }

    public final void circles(@NotNull List<Vector2> centers, double radius) {
        Intrinsics.checkNotNullParameter(centers, "centers");
        ColorRGBa colorRGBa = this.getFill();
        ColorRGBa lfill = colorRGBa != null ? colorRGBa.toLinear() : null;
        ColorRGBa colorRGBa2 = this.getStroke();
        ColorRGBa lstroke = colorRGBa2 != null ? colorRGBa2.toLinear() : null;
        for (Vector2 center : centers) {
            this.entries.add(new Entry(lfill, lstroke, this.getStrokeWeight(), center.xy0(), new Vector2(radius, radius)));
        }
    }

    public final void circles(@NotNull List<Vector2> centers, @NotNull List<Double> radii) {
        Intrinsics.checkNotNullParameter(centers, "centers");
        Intrinsics.checkNotNullParameter(radii, "radii");
        if (!(centers.size() == radii.size())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ColorRGBa colorRGBa = this.getFill();
        ColorRGBa lfill = colorRGBa != null ? colorRGBa.toLinear() : null;
        ColorRGBa colorRGBa2 = this.getStroke();
        ColorRGBa lstroke = colorRGBa2 != null ? colorRGBa2.toLinear() : null;
        int n = ((Collection)centers).size();
        for (int i = 0; i < n; ++i) {
            this.entries.add(new Entry(lfill, lstroke, this.getStrokeWeight(), centers.get(i).xy0(), new Vector2(((Number)radii.get(i)).doubleValue(), ((Number)radii.get(i)).doubleValue())));
        }
    }

    @NotNull
    public final CircleBatch batch(@Nullable CircleBatch existingBatch) {
        AutoCloseable autoCloseable = existingBatch;
        if (autoCloseable == null || (autoCloseable = autoCloseable.getGeometry()) == null) {
            autoCloseable = VertexBufferKt.vertexBuffer$default(BatchesKt.getCircleFormat(), this.entries.size(), null, 4, null);
        }
        AutoCloseable geometry = autoCloseable;
        VertexBuffer.put$default((VertexBuffer)geometry, 0, arg_0 -> CircleBatchBuilder.batch$lambda$0(this, arg_0), 1, null);
        AutoCloseable autoCloseable2 = existingBatch;
        if (autoCloseable2 == null || (autoCloseable2 = autoCloseable2.getDrawStyle()) == null) {
            autoCloseable2 = VertexBufferKt.vertexBuffer$default(BatchesKt.getDrawStyleFormat(), this.entries.size(), null, 4, null);
        }
        AutoCloseable drawStyle = autoCloseable2;
        VertexBuffer.put$default((VertexBuffer)drawStyle, 0, arg_0 -> CircleBatchBuilder.batch$lambda$1(this, arg_0), 1, null);
        CircleBatch circleBatch = existingBatch;
        if (circleBatch == null) {
            circleBatch = new CircleBatch((VertexBuffer)geometry, (VertexBuffer)drawStyle);
        }
        return circleBatch;
    }

    public static /* synthetic */ CircleBatch batch$default(CircleBatchBuilder circleBatchBuilder, CircleBatch circleBatch, int n, Object object) {
        if ((n & 1) != 0) {
            circleBatch = null;
        }
        return circleBatchBuilder.batch(circleBatch);
    }

    private static final Unit batch$lambda$0(CircleBatchBuilder this$0, BufferWriter $this$put) {
        Intrinsics.checkNotNullParameter($this$put, "$this$put");
        for (Entry entry : this$0.entries) {
            $this$put.write(entry.getOffset());
            $this$put.write(entry.getRadius());
        }
        return Unit.INSTANCE;
    }

    private static final Unit batch$lambda$1(CircleBatchBuilder this$0, BufferWriter $this$put) {
        Intrinsics.checkNotNullParameter($this$put, "$this$put");
        for (Entry entry : this$0.entries) {
            ColorRGBa colorRGBa = entry.getFill();
            if (colorRGBa == null || (colorRGBa = colorRGBa.toLinear()) == null) {
                colorRGBa = ColorRGBa.Companion.getTRANSPARENT();
            }
            $this$put.write(colorRGBa);
            ColorRGBa colorRGBa2 = entry.getStroke();
            if (colorRGBa2 == null || (colorRGBa2 = colorRGBa2.toLinear()) == null) {
                colorRGBa2 = ColorRGBa.Companion.getTRANSPARENT();
            }
            $this$put.write(colorRGBa2);
            $this$put.write(entry.getStroke() == null || entry.getStroke().getAlpha() == 0.0 ? 0.0f : (float)entry.getStrokeWeight());
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B3\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/openrndr/draw/CircleBatchBuilder$Entry;", "", "fill", "Lorg/openrndr/color/ColorRGBa;", "stroke", "strokeWeight", "", "offset", "Lorg/openrndr/math/Vector3;", "radius", "Lorg/openrndr/math/Vector2;", "<init>", "(Lorg/openrndr/color/ColorRGBa;Lorg/openrndr/color/ColorRGBa;DLorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector2;)V", "getFill", "()Lorg/openrndr/color/ColorRGBa;", "getStroke", "getStrokeWeight", "()D", "getOffset", "()Lorg/openrndr/math/Vector3;", "getRadius", "()Lorg/openrndr/math/Vector2;", "openrndr-draw"})
    public static final class Entry {
        @Nullable
        private final ColorRGBa fill;
        @Nullable
        private final ColorRGBa stroke;
        private final double strokeWeight;
        @NotNull
        private final Vector3 offset;
        @NotNull
        private final Vector2 radius;

        public Entry(@Nullable ColorRGBa fill, @Nullable ColorRGBa stroke, double strokeWeight, @NotNull Vector3 offset, @NotNull Vector2 radius) {
            Intrinsics.checkNotNullParameter(offset, "offset");
            Intrinsics.checkNotNullParameter(radius, "radius");
            this.fill = fill;
            this.stroke = stroke;
            this.strokeWeight = strokeWeight;
            this.offset = offset;
            this.radius = radius;
        }

        @Nullable
        public final ColorRGBa getFill() {
            return this.fill;
        }

        @Nullable
        public final ColorRGBa getStroke() {
            return this.stroke;
        }

        public final double getStrokeWeight() {
            return this.strokeWeight;
        }

        @NotNull
        public final Vector3 getOffset() {
            return this.offset;
        }

        @NotNull
        public final Vector2 getRadius() {
            return this.radius;
        }
    }
}

