/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.BufferTexture;
import org.openrndr.draw.BufferTextureFileFormat;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.Session;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a.\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\u0013"}, d2={"loadBufferTexture", "Lorg/openrndr/draw/BufferTexture;", "fileOrUrl", "", "formatHint", "Lorg/openrndr/draw/BufferTextureFileFormat;", "session", "Lorg/openrndr/draw/Session;", "file", "Ljava/io/File;", "url", "Ljava/net/URL;", "bufferTexture", "elementCount", "", "format", "Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "openrndr-draw"})
public final class BufferTextureKt {
    @NotNull
    public static final BufferTexture loadBufferTexture(@NotNull String fileOrUrl, @Nullable BufferTextureFileFormat formatHint, @Nullable Session session) {
        Intrinsics.checkNotNullParameter(fileOrUrl, "fileOrUrl");
        try {
            if (!StringsKt.startsWith$default(fileOrUrl, "data:", false, 2, null)) {
                URL url = new URL(fileOrUrl);
                return BufferTextureKt.loadBufferTexture(url, formatHint, session);
            }
            throw new IllegalStateException("data scheme not supported".toString());
        }
        catch (MalformedURLException e) {
            return BufferTextureKt.loadBufferTexture$default(new File(fileOrUrl), null, session, 2, null);
        }
    }

    public static /* synthetic */ BufferTexture loadBufferTexture$default(String string, BufferTextureFileFormat bufferTextureFileFormat, Session session, int n, Object object) {
        if ((n & 2) != 0) {
            bufferTextureFileFormat = BufferTextureFileFormat.ORB;
        }
        if ((n & 4) != 0) {
            session = Session.Companion.getActive();
        }
        return BufferTextureKt.loadBufferTexture(string, bufferTextureFileFormat, session);
    }

    @NotNull
    public static final BufferTexture loadBufferTexture(@NotNull File file, @Nullable BufferTextureFileFormat formatHint, @Nullable Session session) {
        Intrinsics.checkNotNullParameter(file, "file");
        if (!file.exists()) {
            boolean $i$a$-require-BufferTextureKt$loadBufferTexture$22 = false;
            String $i$a$-require-BufferTextureKt$loadBufferTexture$22 = "file " + file.getAbsolutePath() + " does not exist";
            throw new IllegalArgumentException($i$a$-require-BufferTextureKt$loadBufferTexture$22.toString());
        }
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        ByteBuffer header = ByteBuffer.allocateDirect(12);
        header.order(ByteOrder.nativeOrder());
        FileChannel chan = raf.getChannel();
        chan.read(header);
        header.rewind();
        int size = header.getInt();
        ColorFormat format = ColorFormat.values()[header.getInt()];
        ColorType type = ColorType.values()[header.getInt()];
        ByteBuffer buffer = ByteBuffer.allocateDirect(size);
        buffer.order(ByteOrder.nativeOrder());
        chan.read(buffer);
        chan.close();
        int elementCount = size / (format.getComponentCount() * type.getComponentSize());
        BufferTexture bufferTexture = BufferTextureKt.bufferTexture(elementCount, format, type, session);
        buffer.rewind();
        Intrinsics.checkNotNull(buffer);
        BufferTexture.write$default(bufferTexture, buffer, 0, 0, 6, null);
        return bufferTexture;
    }

    public static /* synthetic */ BufferTexture loadBufferTexture$default(File file, BufferTextureFileFormat bufferTextureFileFormat, Session session, int n, Object object) {
        if ((n & 2) != 0) {
            bufferTextureFileFormat = BufferTextureFileFormat.ORB;
        }
        if ((n & 4) != 0) {
            session = Session.Companion.getActive();
        }
        return BufferTextureKt.loadBufferTexture(file, bufferTextureFileFormat, session);
    }

    @NotNull
    public static final BufferTexture loadBufferTexture(@NotNull URL url, @Nullable BufferTextureFileFormat formatHint, @Nullable Session session) {
        Intrinsics.checkNotNullParameter(url, "url");
        InputStream stream = url.openStream();
        byte[] headerData = new byte[12];
        stream.read(headerData);
        ByteBuffer header = ByteBuffer.wrap(headerData);
        header.order(ByteOrder.nativeOrder());
        header.rewind();
        int size = header.getInt();
        ColorFormat format = ColorFormat.values()[header.getInt()];
        ColorType type = ColorType.values()[header.getInt()];
        ByteBuffer buffer = ByteBuffer.allocateDirect(size);
        buffer.order(ByteOrder.nativeOrder());
        byte[] bodyData = new byte[size];
        ByteBuffer body = ByteBuffer.wrap(bodyData);
        stream.read(bodyData);
        body.rewind();
        buffer.rewind();
        buffer.put(body);
        buffer.rewind();
        int elementCount = size / (format.getComponentCount() * type.getComponentSize());
        BufferTexture bufferTexture = BufferTextureKt.bufferTexture(elementCount, format, type, session);
        Intrinsics.checkNotNull(buffer);
        BufferTexture.write$default(bufferTexture, buffer, 0, 0, 6, null);
        return bufferTexture;
    }

    public static /* synthetic */ BufferTexture loadBufferTexture$default(URL uRL, BufferTextureFileFormat bufferTextureFileFormat, Session session, int n, Object object) {
        if ((n & 2) != 0) {
            bufferTextureFileFormat = BufferTextureFileFormat.ORB;
        }
        if ((n & 4) != 0) {
            session = Session.Companion.getActive();
        }
        return BufferTextureKt.loadBufferTexture(uRL, bufferTextureFileFormat, session);
    }

    @NotNull
    public static final BufferTexture bufferTexture(int elementCount, @NotNull ColorFormat format, @NotNull ColorType type, @Nullable Session session) {
        Intrinsics.checkNotNullParameter((Object)format, "format");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        return BufferTexture.Companion.create(elementCount, format, type, session);
    }

    public static /* synthetic */ BufferTexture bufferTexture$default(int n, ColorFormat colorFormat, ColorType colorType, Session session, int n2, Object object) {
        if ((n2 & 2) != 0) {
            colorFormat = ColorFormat.RGBa;
        }
        if ((n2 & 4) != 0) {
            colorType = ColorType.FLOAT32;
        }
        if ((n2 & 8) != 0) {
            session = Session.Companion.getActive();
        }
        return BufferTextureKt.bufferTexture(n, colorFormat, colorType, session);
    }
}

