/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.dds;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.dds.DDSData;
import org.openrndr.dds.DDSHeader;
import org.openrndr.dds.DDSHeaderDXT10;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.utils.buffer.MPPBuffer;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000%\n\u0000\n\u0002\u0010\b\n\u0003\b\u0086\u0001\n\u0002\u0010\t\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u001e\u0010\u009d\u0001\u001a\u00030\u009e\u00012\b\u0010\u009f\u0001\u001a\u00030\u00a0\u00012\n\b\u0002\u0010\u00a1\u0001\u001a\u00030\u00a2\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0014\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0015\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0016\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0017\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0018\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0019\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001a\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001c\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001d\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001e\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010 \u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010!\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\"\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010#\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010$\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010%\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010&\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010'\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010(\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010)\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010*\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010+\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010,\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010-\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010.\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010/\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u00100\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u00101\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u00102\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u00103\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u00104\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u00105\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u00106\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u00107\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u00108\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u00109\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010:\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010;\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010<\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010=\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010>\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010?\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010@\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010A\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010B\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010C\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010D\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010E\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010F\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010G\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010H\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010I\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010J\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010K\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010L\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010M\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010N\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010O\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010P\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010Q\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010R\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010S\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010T\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010U\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010V\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010W\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010X\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010Y\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010Z\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010[\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\\\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010]\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010^\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010_\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010`\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010a\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010c\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010d\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010e\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010g\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010h\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010i\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010j\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010k\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010l\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010m\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010o\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010p\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010q\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010r\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010s\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010u\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010v\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010w\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010x\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010y\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010z\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010{\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010|\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010}\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010~\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u007f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u0080\u0001\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u0081\u0001\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u0082\u0001\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u0083\u0001\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u0084\u0001\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u0085\u0001\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u0086\u0001\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0087\u0001\u001a\u00030\u0088\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u0089\u0001\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u008a\u0001\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u008b\u0001\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u008c\u0001\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u008d\u0001\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u008e\u0001\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u008f\u0001\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u0090\u0001\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u0091\u0001\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u0092\u0001\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u0093\u0001\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u0094\u0001\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u0095\u0001\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u0096\u0001\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u0097\u0001\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u0098\u0001\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u0099\u0001\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u009a\u0001\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u009b\u0001\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u009c\u0001\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a3\u0001"}, d2={"DDPF_ALPHAPIXELS", "", "DDPF_ALPHA", "DDPF_FOURCC", "DDPF_RGB", "DDPF_YUV", "DDPF_LUMINANCE", "DDS_RESOURCE_MISC_TEXTURECUBE", "DDS_DIMENSION_TEXTURE1D", "DDS_DIMENSION_TEXTURE2D", "DDS_DIMENSION_TEXTURE3D", "DDS_ALPHA_MODE_UNKNOWN", "DDS_ALPHA_MODE_STRAIGHT", "DDS_ALPHA_MODE_PREMULTIPLIED", "DDS_ALPHA_MODE_OPAQUE", "DDS_ALPHA_MODE_CUSTOM", "DXGI_FORMAT_UNKNOWN", "DXGI_FORMAT_R32G32B32A32_TYPELESS", "DXGI_FORMAT_R32G32B32A32_FLOAT", "DXGI_FORMAT_R32G32B32A32_UINT", "DXGI_FORMAT_R32G32B32A32_SINT", "DXGI_FORMAT_R32G32B32_TYPELESS", "DXGI_FORMAT_R32G32B32_FLOAT", "DXGI_FORMAT_R32G32B32_UINT", "DXGI_FORMAT_R32G32B32_SINT", "DXGI_FORMAT_R16G16B16A16_TYPELESS", "DXGI_FORMAT_R16G16B16A16_FLOAT", "DXGI_FORMAT_R16G16B16A16_UNORM", "DXGI_FORMAT_R16G16B16A16_UINT", "DXGI_FORMAT_R16G16B16A16_SNORM", "DXGI_FORMAT_R16G16B16A16_SINT", "DXGI_FORMAT_R32G32_TYPELESS", "DXGI_FORMAT_R32G32_FLOAT", "DXGI_FORMAT_R32G32_UINT", "DXGI_FORMAT_R32G32_SINT", "DXGI_FORMAT_R32G8X24_TYPELESS", "DXGI_FORMAT_D32_FLOAT_S8X24_UINT", "DXGI_FORMAT_R32_FLOAT_X8X24_TYPELESS", "DXGI_FORMAT_X32_TYPELESS_G8X24_UINT", "DXGI_FORMAT_R10G10B10A2_TYPELESS", "DXGI_FORMAT_R10G10B10A2_UNORM", "DXGI_FORMAT_R10G10B10A2_UINT", "DXGI_FORMAT_R11G11B10_FLOAT", "DXGI_FORMAT_R8G8B8A8_TYPELESS", "DXGI_FORMAT_R8G8B8A8_UNORM", "DXGI_FORMAT_R8G8B8A8_UNORM_SRGB", "DXGI_FORMAT_R8G8B8A8_UINT", "DXGI_FORMAT_R8G8B8A8_SNORM", "DXGI_FORMAT_R8G8B8A8_SINT", "DXGI_FORMAT_R16G16_TYPELESS", "DXGI_FORMAT_R16G16_FLOAT", "DXGI_FORMAT_R16G16_UNORM", "DXGI_FORMAT_R16G16_UINT", "DXGI_FORMAT_R16G16_SNORM", "DXGI_FORMAT_R16G16_SINT", "DXGI_FORMAT_R32_TYPELESS", "DXGI_FORMAT_D32_FLOAT", "DXGI_FORMAT_R32_FLOAT", "DXGI_FORMAT_R32_UINT", "DXGI_FORMAT_R32_SINT", "DXGI_FORMAT_R24G8_TYPELESS", "DXGI_FORMAT_D24_UNORM_S8_UINT", "DXGI_FORMAT_R24_UNORM_X8_TYPELESS", "DXGI_FORMAT_X24_TYPELESS_G8_UINT", "DXGI_FORMAT_R8G8_TYPELESS", "DXGI_FORMAT_R8G8_UNORM", "DXGI_FORMAT_R8G8_UINT", "DXGI_FORMAT_R8G8_SNORM", "DXGI_FORMAT_R8G8_SINT", "DXGI_FORMAT_R16_TYPELESS", "DXGI_FORMAT_R16_FLOAT", "DXGI_FORMAT_D16_UNORM", "DXGI_FORMAT_R16_UNORM", "DXGI_FORMAT_R16_UINT", "DXGI_FORMAT_R16_SNORM", "DXGI_FORMAT_R16_SINT", "DXGI_FORMAT_R8_TYPELESS", "DXGI_FORMAT_R8_UNORM", "DXGI_FORMAT_R8_UINT", "DXGI_FORMAT_R8_SNORM", "DXGI_FORMAT_R8_SINT", "DXGI_FORMAT_A8_UNORM", "DXGI_FORMAT_R1_UNORM", "DXGI_FORMAT_R9G9B9E5_SHAREDEXP", "DXGI_FORMAT_R8G8_B8G8_UNORM", "DXGI_FORMAT_G8R8_G8B8_UNORM", "DXGI_FORMAT_BC1_TYPELESS", "DXGI_FORMAT_BC1_UNORM", "DXGI_FORMAT_BC1_UNORM_SRGB", "DXGI_FORMAT_BC2_TYPELESS", "DXGI_FORMAT_BC2_UNORM", "DXGI_FORMAT_BC2_UNORM_SRGB", "DXGI_FORMAT_BC3_TYPELESS", "DXGI_FORMAT_BC3_UNORM", "DXGI_FORMAT_BC3_UNORM_SRGB", "DXGI_FORMAT_BC4_TYPELESS", "DXGI_FORMAT_BC4_UNORM", "DXGI_FORMAT_BC4_SNORM", "DXGI_FORMAT_BC5_TYPELESS", "DXGI_FORMAT_BC5_UNORM", "DXGI_FORMAT_BC5_SNORM", "DXGI_FORMAT_B5G6R5_UNORM", "DXGI_FORMAT_B5G5R5A1_UNORM", "DXGI_FORMAT_B8G8R8A8_UNORM", "DXGI_FORMAT_B8G8R8X8_UNORM", "DXGI_FORMAT_R10G10B10_XR_BIAS_A2_UNORM", "DXGI_FORMAT_B8G8R8A8_TYPELESS", "DXGI_FORMAT_B8G8R8A8_UNORM_SRGB", "DXGI_FORMAT_B8G8R8X8_TYPELESS", "DXGI_FORMAT_B8G8R8X8_UNORM_SRGB", "DXGI_FORMAT_BC6H_TYPELESS", "DXGI_FORMAT_BC6H_UF16", "DXGI_FORMAT_BC6H_SF16", "DXGI_FORMAT_BC7_TYPELESS", "DXGI_FORMAT_BC7_UNORM", "DXGI_FORMAT_BC7_UNORM_SRGB", "DXGI_FORMAT_AYUV", "DXGI_FORMAT_Y410", "DXGI_FORMAT_Y416", "DXGI_FORMAT_NV12", "DXGI_FORMAT_P010", "DXGI_FORMAT_P016", "DXGI_FORMAT_420_OPAQUE", "DXGI_FORMAT_YUY2", "DXGI_FORMAT_Y210", "DXGI_FORMAT_Y216", "DXGI_FORMAT_NV11", "DXGI_FORMAT_AI44", "DXGI_FORMAT_IA44", "DXGI_FORMAT_P8", "DXGI_FORMAT_A8P8", "DXGI_FORMAT_B4G4R4A4_UNORM", "DXGI_FORMAT_P208", "DXGI_FORMAT_V208", "DXGI_FORMAT_V408", "DXGI_FORMAT_FORCE_UINT", "", "DDSD_CAPS", "DDSD_HEIGHT", "DDSD_WIDTH", "DDSD_PITCH", "DDSD_PIXELFORMAT", "DDSD_MIPMAPCOUNT", "DDSD_LINEARSIZE", "DDSD_DEPTH", "DDSCAPS_COMPLEX", "DDSCAPS_MIPMAP", "DDSCAPS_TEXTURE", "DDSCAPS2_CUBEMAP", "DDSCAPS2_CUBEMAP_POSITIVEX", "DDSCAPS2_CUBEMAP_NEGATIVEX", "DDSCAPS2_CUBEMAP_POSITIVEY", "DDSCAPS2_CUBEMAP_NEGATIVEY", "DDSCAPS2_CUBEMAP_POSITIVEZ", "DDSCAPS2_CUBEMAP_NEGATIVEZ", "DDSCAPS2_VOLUME", "DDS_MAGIC", "loadDDS", "Lorg/openrndr/dds/DDSData;", "data", "Lorg/openrndr/utils/buffer/MPPBuffer;", "bgrIsRgb", "", "openrndr-dds"})
public final class DDSReaderKt {
    private static final int DDPF_ALPHAPIXELS = 1;
    private static final int DDPF_ALPHA = 2;
    private static final int DDPF_FOURCC = 4;
    private static final int DDPF_RGB = 64;
    private static final int DDPF_YUV = 512;
    private static final int DDPF_LUMINANCE = 131072;
    private static final int DDS_RESOURCE_MISC_TEXTURECUBE = 4;
    private static final int DDS_DIMENSION_TEXTURE1D = 2;
    private static final int DDS_DIMENSION_TEXTURE2D = 3;
    private static final int DDS_DIMENSION_TEXTURE3D = 4;
    private static final int DDS_ALPHA_MODE_UNKNOWN = 0;
    private static final int DDS_ALPHA_MODE_STRAIGHT = 1;
    private static final int DDS_ALPHA_MODE_PREMULTIPLIED = 2;
    private static final int DDS_ALPHA_MODE_OPAQUE = 3;
    private static final int DDS_ALPHA_MODE_CUSTOM = 4;
    private static final int DXGI_FORMAT_UNKNOWN = 0;
    private static final int DXGI_FORMAT_R32G32B32A32_TYPELESS = 1;
    private static final int DXGI_FORMAT_R32G32B32A32_FLOAT = 2;
    private static final int DXGI_FORMAT_R32G32B32A32_UINT = 3;
    private static final int DXGI_FORMAT_R32G32B32A32_SINT = 4;
    private static final int DXGI_FORMAT_R32G32B32_TYPELESS = 5;
    private static final int DXGI_FORMAT_R32G32B32_FLOAT = 6;
    private static final int DXGI_FORMAT_R32G32B32_UINT = 7;
    private static final int DXGI_FORMAT_R32G32B32_SINT = 8;
    private static final int DXGI_FORMAT_R16G16B16A16_TYPELESS = 9;
    private static final int DXGI_FORMAT_R16G16B16A16_FLOAT = 10;
    private static final int DXGI_FORMAT_R16G16B16A16_UNORM = 11;
    private static final int DXGI_FORMAT_R16G16B16A16_UINT = 12;
    private static final int DXGI_FORMAT_R16G16B16A16_SNORM = 13;
    private static final int DXGI_FORMAT_R16G16B16A16_SINT = 14;
    private static final int DXGI_FORMAT_R32G32_TYPELESS = 15;
    private static final int DXGI_FORMAT_R32G32_FLOAT = 16;
    private static final int DXGI_FORMAT_R32G32_UINT = 17;
    private static final int DXGI_FORMAT_R32G32_SINT = 18;
    private static final int DXGI_FORMAT_R32G8X24_TYPELESS = 19;
    private static final int DXGI_FORMAT_D32_FLOAT_S8X24_UINT = 20;
    private static final int DXGI_FORMAT_R32_FLOAT_X8X24_TYPELESS = 21;
    private static final int DXGI_FORMAT_X32_TYPELESS_G8X24_UINT = 22;
    private static final int DXGI_FORMAT_R10G10B10A2_TYPELESS = 23;
    private static final int DXGI_FORMAT_R10G10B10A2_UNORM = 24;
    private static final int DXGI_FORMAT_R10G10B10A2_UINT = 25;
    private static final int DXGI_FORMAT_R11G11B10_FLOAT = 26;
    private static final int DXGI_FORMAT_R8G8B8A8_TYPELESS = 27;
    private static final int DXGI_FORMAT_R8G8B8A8_UNORM = 28;
    private static final int DXGI_FORMAT_R8G8B8A8_UNORM_SRGB = 29;
    private static final int DXGI_FORMAT_R8G8B8A8_UINT = 30;
    private static final int DXGI_FORMAT_R8G8B8A8_SNORM = 31;
    private static final int DXGI_FORMAT_R8G8B8A8_SINT = 32;
    private static final int DXGI_FORMAT_R16G16_TYPELESS = 33;
    private static final int DXGI_FORMAT_R16G16_FLOAT = 34;
    private static final int DXGI_FORMAT_R16G16_UNORM = 35;
    private static final int DXGI_FORMAT_R16G16_UINT = 36;
    private static final int DXGI_FORMAT_R16G16_SNORM = 37;
    private static final int DXGI_FORMAT_R16G16_SINT = 38;
    private static final int DXGI_FORMAT_R32_TYPELESS = 39;
    private static final int DXGI_FORMAT_D32_FLOAT = 40;
    private static final int DXGI_FORMAT_R32_FLOAT = 41;
    private static final int DXGI_FORMAT_R32_UINT = 42;
    private static final int DXGI_FORMAT_R32_SINT = 43;
    private static final int DXGI_FORMAT_R24G8_TYPELESS = 44;
    private static final int DXGI_FORMAT_D24_UNORM_S8_UINT = 45;
    private static final int DXGI_FORMAT_R24_UNORM_X8_TYPELESS = 46;
    private static final int DXGI_FORMAT_X24_TYPELESS_G8_UINT = 47;
    private static final int DXGI_FORMAT_R8G8_TYPELESS = 48;
    private static final int DXGI_FORMAT_R8G8_UNORM = 49;
    private static final int DXGI_FORMAT_R8G8_UINT = 50;
    private static final int DXGI_FORMAT_R8G8_SNORM = 51;
    private static final int DXGI_FORMAT_R8G8_SINT = 52;
    private static final int DXGI_FORMAT_R16_TYPELESS = 53;
    private static final int DXGI_FORMAT_R16_FLOAT = 54;
    private static final int DXGI_FORMAT_D16_UNORM = 55;
    private static final int DXGI_FORMAT_R16_UNORM = 56;
    private static final int DXGI_FORMAT_R16_UINT = 57;
    private static final int DXGI_FORMAT_R16_SNORM = 58;
    private static final int DXGI_FORMAT_R16_SINT = 59;
    private static final int DXGI_FORMAT_R8_TYPELESS = 60;
    private static final int DXGI_FORMAT_R8_UNORM = 61;
    private static final int DXGI_FORMAT_R8_UINT = 62;
    private static final int DXGI_FORMAT_R8_SNORM = 63;
    private static final int DXGI_FORMAT_R8_SINT = 64;
    private static final int DXGI_FORMAT_A8_UNORM = 65;
    private static final int DXGI_FORMAT_R1_UNORM = 66;
    private static final int DXGI_FORMAT_R9G9B9E5_SHAREDEXP = 67;
    private static final int DXGI_FORMAT_R8G8_B8G8_UNORM = 68;
    private static final int DXGI_FORMAT_G8R8_G8B8_UNORM = 69;
    private static final int DXGI_FORMAT_BC1_TYPELESS = 70;
    private static final int DXGI_FORMAT_BC1_UNORM = 71;
    private static final int DXGI_FORMAT_BC1_UNORM_SRGB = 72;
    private static final int DXGI_FORMAT_BC2_TYPELESS = 73;
    private static final int DXGI_FORMAT_BC2_UNORM = 74;
    private static final int DXGI_FORMAT_BC2_UNORM_SRGB = 75;
    private static final int DXGI_FORMAT_BC3_TYPELESS = 76;
    private static final int DXGI_FORMAT_BC3_UNORM = 77;
    private static final int DXGI_FORMAT_BC3_UNORM_SRGB = 78;
    private static final int DXGI_FORMAT_BC4_TYPELESS = 79;
    private static final int DXGI_FORMAT_BC4_UNORM = 80;
    private static final int DXGI_FORMAT_BC4_SNORM = 81;
    private static final int DXGI_FORMAT_BC5_TYPELESS = 82;
    private static final int DXGI_FORMAT_BC5_UNORM = 83;
    private static final int DXGI_FORMAT_BC5_SNORM = 84;
    private static final int DXGI_FORMAT_B5G6R5_UNORM = 85;
    private static final int DXGI_FORMAT_B5G5R5A1_UNORM = 86;
    private static final int DXGI_FORMAT_B8G8R8A8_UNORM = 87;
    private static final int DXGI_FORMAT_B8G8R8X8_UNORM = 88;
    private static final int DXGI_FORMAT_R10G10B10_XR_BIAS_A2_UNORM = 89;
    private static final int DXGI_FORMAT_B8G8R8A8_TYPELESS = 90;
    private static final int DXGI_FORMAT_B8G8R8A8_UNORM_SRGB = 91;
    private static final int DXGI_FORMAT_B8G8R8X8_TYPELESS = 92;
    private static final int DXGI_FORMAT_B8G8R8X8_UNORM_SRGB = 93;
    private static final int DXGI_FORMAT_BC6H_TYPELESS = 94;
    private static final int DXGI_FORMAT_BC6H_UF16 = 95;
    private static final int DXGI_FORMAT_BC6H_SF16 = 96;
    private static final int DXGI_FORMAT_BC7_TYPELESS = 97;
    private static final int DXGI_FORMAT_BC7_UNORM = 98;
    private static final int DXGI_FORMAT_BC7_UNORM_SRGB = 99;
    private static final int DXGI_FORMAT_AYUV = 100;
    private static final int DXGI_FORMAT_Y410 = 101;
    private static final int DXGI_FORMAT_Y416 = 102;
    private static final int DXGI_FORMAT_NV12 = 103;
    private static final int DXGI_FORMAT_P010 = 104;
    private static final int DXGI_FORMAT_P016 = 105;
    private static final int DXGI_FORMAT_420_OPAQUE = 106;
    private static final int DXGI_FORMAT_YUY2 = 107;
    private static final int DXGI_FORMAT_Y210 = 108;
    private static final int DXGI_FORMAT_Y216 = 109;
    private static final int DXGI_FORMAT_NV11 = 110;
    private static final int DXGI_FORMAT_AI44 = 111;
    private static final int DXGI_FORMAT_IA44 = 112;
    private static final int DXGI_FORMAT_P8 = 113;
    private static final int DXGI_FORMAT_A8P8 = 114;
    private static final int DXGI_FORMAT_B4G4R4A4_UNORM = 115;
    private static final int DXGI_FORMAT_P208 = 130;
    private static final int DXGI_FORMAT_V208 = 131;
    private static final int DXGI_FORMAT_V408 = 132;
    private static final long DXGI_FORMAT_FORCE_UINT = 0xFFFFFFFFL;
    private static final int DDSD_CAPS = 1;
    private static final int DDSD_HEIGHT = 2;
    private static final int DDSD_WIDTH = 4;
    private static final int DDSD_PITCH = 8;
    private static final int DDSD_PIXELFORMAT = 4096;
    private static final int DDSD_MIPMAPCOUNT = 131072;
    private static final int DDSD_LINEARSIZE = 524288;
    private static final int DDSD_DEPTH = 0x800000;
    private static final int DDSCAPS_COMPLEX = 8;
    private static final int DDSCAPS_MIPMAP = 0x400000;
    private static final int DDSCAPS_TEXTURE = 4096;
    private static final int DDSCAPS2_CUBEMAP = 512;
    private static final int DDSCAPS2_CUBEMAP_POSITIVEX = 1024;
    private static final int DDSCAPS2_CUBEMAP_NEGATIVEX = 2048;
    private static final int DDSCAPS2_CUBEMAP_POSITIVEY = 4096;
    private static final int DDSCAPS2_CUBEMAP_NEGATIVEY = 8192;
    private static final int DDSCAPS2_CUBEMAP_POSITIVEZ = 16384;
    private static final int DDSCAPS2_CUBEMAP_NEGATIVEZ = 32768;
    private static final int DDSCAPS2_VOLUME = 0x200000;
    private static final int DDS_MAGIC = 542327876;

    @NotNull
    public static final DDSData loadDDS(@NotNull MPPBuffer data, boolean bgrIsRgb) {
        ColorType type;
        ColorFormat format;
        DDSHeader header;
        MPPBuffer inputData;
        List secondarySurfaces;
        List primarySurfaces;
        block14: {
            block17: {
                block16: {
                    block15: {
                        block13: {
                            Intrinsics.checkNotNullParameter(data, "data");
                            primarySurfaces = new ArrayList();
                            secondarySurfaces = new ArrayList();
                            boolean bl = false;
                            inputData = data;
                            int totalByteCount = inputData.capacity();
                            byte[] bMagic = new byte[4];
                            inputData.get(bMagic);
                            int magic = MPPBuffer.Companion.createFrom(bMagic).getInt();
                            if (magic != 542327876) {
                                throw new RuntimeException("mismatch in magic word, not a dds file");
                            }
                            byte[] bHeader = new byte[124];
                            inputData.get(bHeader);
                            header = new DDSHeader(MPPBuffer.Companion.createFrom(bHeader));
                            format = null;
                            type = null;
                            if (!StringsKt.equals(header.getPixelFormat().getSFourCC(), "DXT1", true)) break block13;
                            type = ColorType.DXT1;
                            format = header.getPixelFormat().getHasFlagAlpha() ? ColorFormat.RGBa : ColorFormat.RGB;
                            break block14;
                        }
                        if (!StringsKt.equals(header.getPixelFormat().getSFourCC(), "DXT3", true)) break block15;
                        type = ColorType.DXT3;
                        format = ColorFormat.RGBa;
                        break block14;
                    }
                    if (!StringsKt.equals(header.getPixelFormat().getSFourCC(), "DXT5", true)) break block16;
                    type = ColorType.DXT5;
                    format = ColorFormat.RGBa;
                    break block14;
                }
                if (!StringsKt.equals(header.getPixelFormat().getSFourCC(), "DX10", true)) break block17;
                byte[] dxt10HeaderArray = new byte[20];
                inputData.get(dxt10HeaderArray);
                DDSHeaderDXT10 dxt10Header = new DDSHeaderDXT10(MPPBuffer.Companion.createFrom(dxt10HeaderArray));
                switch (dxt10Header.getDxgiFormat()) {
                    case 10: {
                        format = ColorFormat.RGBa;
                        type = ColorType.FLOAT16;
                        break block14;
                    }
                    case 2: {
                        format = ColorFormat.RGBa;
                        type = ColorType.FLOAT32;
                        break block14;
                    }
                    default: {
                        throw new IllegalStateException(("unsupported dxgi format: " + dxt10Header.getDxgiFormat()).toString());
                    }
                }
            }
            if (header.getPixelFormat().getDwRGBBitCount() == 24 && header.getPixelFormat().getDwRBitMask() == 0xFF0000 && header.getPixelFormat().getDwGBitMask() == 65280 && header.getPixelFormat().getDwBBitMask() == 255) {
                format = bgrIsRgb ? ColorFormat.RGB : ColorFormat.BGR;
                type = ColorType.UINT8;
            } else {
                throw new RuntimeException("unknown and/or unsupported format " + header.getPixelFormat().getSFourCC());
            }
        }
        int surfaceCount = 0;
        totalByteCount -= 128;
        boolean isCubeMap = false;
        if (header.getHasCaps2CubeMap()) {
            surfaceCount = 6;
            isCubeMap = true;
        } else {
            surfaceCount = 1;
            isCubeMap = false;
        }
        int primarySize = DDSReaderKt.loadDDS$lambda$2$size(header, type, 0);
        if (!(primarySize > 0)) {
            boolean $i$a$-require-DDSReaderKt$loadDDS$1$32 = false;
            String $i$a$-require-DDSReaderKt$loadDDS$1$32 = "size of surface is 0 bytes " + header;
            throw new IllegalArgumentException($i$a$-require-DDSReaderKt$loadDDS$1$32.toString());
        }
        for (int i = 0; i < surfaceCount; ++i) {
            if (!(inputData.remaining() >= primarySize)) {
                boolean $i$a$-require-DDSReaderKt$loadDDS$1$42 = false;
                String $i$a$-require-DDSReaderKt$loadDDS$1$42 = "source byte buffer only has " + inputData.remaining() + " bytes left, need " + primarySize + ", " + format + "/" + type;
                throw new IllegalArgumentException($i$a$-require-DDSReaderKt$loadDDS$1$42.toString());
            }
            byte[] bytes = new byte[primarySize];
            inputData.get(bytes);
            totalByteCount -= bytes.length;
            primarySurfaces.add(MPPBuffer.Companion.createFrom(bytes));
            if (!header.getHasFlagMipMapCount()) continue;
            int n = header.getMipmapCount();
            for (int level = 1; level < n; ++level) {
                int secondarySize = DDSReaderKt.loadDDS$lambda$2$size(header, type, level);
                byte[] bytes2 = new byte[secondarySize];
                inputData.get(bytes2);
                totalByteCount -= bytes2.length;
                secondarySurfaces.add(MPPBuffer.Companion.createFrom(bytes2));
            }
        }
        return new DDSData(format, type, header.getWidth(), header.getHeight(), header.getMipmapCount(), isCubeMap, primarySurfaces, secondarySurfaces, true);
    }

    public static /* synthetic */ DDSData loadDDS$default(MPPBuffer mPPBuffer, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return DDSReaderKt.loadDDS(mPPBuffer, bl);
    }

    private static final int loadDDS$lambda$2$size(DDSHeader header, ColorType type, int level) {
        int div = 1 << level;
        int width = header.getWidth() / div;
        int height = header.getHeight() / div;
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> width * height / 2;
            case 2, 3 -> width * height;
            default -> header.getPitchOrLinearSize() * header.getHeight() << level;
        };
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ColorType.values().length];
            try {
                nArray[ColorType.DXT1.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorType.DXT3.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorType.DXT5.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

