/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.color;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.AlgebraicColor;
import org.openrndr.color.ColorHSLa;
import org.openrndr.color.ColorHSVa;
import org.openrndr.color.ColorLABa$;
import org.openrndr.color.ColorLABaKt;
import org.openrndr.color.ColorLCHABa;
import org.openrndr.color.ColorLSHABa;
import org.openrndr.color.ColorLUVa;
import org.openrndr.color.ColorModel;
import org.openrndr.color.ColorRGBa;
import org.openrndr.color.ColorXYZa;
import org.openrndr.color.ColorXYZa$;
import org.openrndr.color.LuminosityColor;
import org.openrndr.color.ReferenceWhitePoint;
import org.openrndr.color.ShadableColor;
import org.openrndr.math.Vector4;

@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 E2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00000\u00032\b\u0012\u0004\u0012\u00020\u00000\u00042\b\u0012\u0004\u0012\u00020\u00000\u00052\u00020\u0006:\u0002EFB3\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fBE\b\u0010\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b\u000e\u0010\u0014J\u0006\u0010\u0017\u001a\u00020\rJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\bH\u0016J\u0010\u0010&\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\bH\u0016J\u0011\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010)\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\bH\u0096\u0002J\b\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\bH\u0016J\t\u00100\u001a\u00020\bH\u00c6\u0003J\t\u00101\u001a\u00020\bH\u00c6\u0003J\t\u00102\u001a\u00020\bH\u00c6\u0003J\t\u00103\u001a\u00020\bH\u00c6\u0003J\t\u00104\u001a\u00020\rH\u00c6\u0003J;\u00105\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u000109H\u00d6\u0003J\t\u0010:\u001a\u00020\u0011H\u00d6\u0001J\t\u0010;\u001a\u00020<H\u00d6\u0001J%\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0001\u00a2\u0006\u0002\bDR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0015R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0015R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0015R\u0014\u0010\u000b\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0015R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0016R\u0014\u0010/\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0015\u00a8\u0006G"}, d2={"Lorg/openrndr/color/ColorLABa;", "Lorg/openrndr/color/ColorModel;", "Lorg/openrndr/color/ReferenceWhitePoint;", "Lorg/openrndr/color/ShadableColor;", "Lorg/openrndr/color/LuminosityColor;", "Lorg/openrndr/color/AlgebraicColor;", "Ljava/lang/Record;", "l", "", "a", "b", "alpha", "ref", "Lorg/openrndr/color/ColorXYZa;", "<init>", "(DDDDLorg/openrndr/color/ColorXYZa;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IDDDDLorg/openrndr/color/ColorXYZa;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "()D", "()Lorg/openrndr/color/ColorXYZa;", "toXYZa", "toLCHABa", "Lorg/openrndr/color/ColorLCHABa;", "toLSHABa", "Lorg/openrndr/color/ColorLSHABa;", "toLUVa", "Lorg/openrndr/color/ColorLUVa;", "toRGBa", "Lorg/openrndr/color/ColorRGBa;", "toHSVa", "Lorg/openrndr/color/ColorHSVa;", "toHSLa", "Lorg/openrndr/color/ColorHSLa;", "opacify", "factor", "shade", "plus", "right", "minus", "times", "scale", "toVector4", "Lorg/openrndr/math/Vector4;", "withLuminosity", "luminosity", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_color", "Companion", "$serializer", "openrndr-color"})
public final class ColorLABa
extends Record
implements ColorModel<ColorLABa>,
ReferenceWhitePoint,
ShadableColor<ColorLABa>,
LuminosityColor<ColorLABa>,
AlgebraicColor<ColorLABa> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double l;
    private final double a;
    private final double b;
    private final double alpha;
    @NotNull
    private final ColorXYZa ref;

    public ColorLABa(double l, double a, double b, double alpha, @NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        this.l = l;
        this.a = a;
        this.b = b;
        this.alpha = alpha;
        this.ref = ref;
    }

    public /* synthetic */ ColorLABa(double d, double d2, double d3, double d4, ColorXYZa colorXYZa, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        if ((n & 0x10) != 0) {
            colorXYZa = ColorXYZa.Companion.getNEUTRAL();
        }
        this(d, d2, d3, d4, colorXYZa);
    }

    public final double l() {
        return this.l;
    }

    public final double a() {
        return this.a;
    }

    public final double b() {
        return this.b;
    }

    public double alpha() {
        return this.alpha;
    }

    @NotNull
    public ColorXYZa ref() {
        return this.ref;
    }

    @NotNull
    public final ColorXYZa toXYZa() {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        ColorLABa lab = this;
        double fy = (lab.l + 16.0) / 116.0;
        double fx = lab.a / 500.0 + fy;
        double fz = fy - lab.b / 200.0;
        x = fx * fx * fx > 0.008856 ? fx * fx * fx : ((double)116 * fx - (double)16) / 903.3;
        y = lab.l > 7.9996247999999985 ? Math.pow((lab.l + (double)16) / 116.0, 3.0) : lab.l / 903.3;
        z = fz * fz * fz > 0.008856 ? fz * fz * fz : (116.0 * fz - 16.0) / 903.3;
        return new ColorXYZa(x *= this.ref().getX(), y *= this.ref().getY(), z *= this.ref().getZ(), this.alpha());
    }

    @NotNull
    public final ColorLCHABa toLCHABa() {
        return ColorLCHABa.Companion.fromLABa(this);
    }

    @NotNull
    public final ColorLSHABa toLSHABa() {
        return this.toLCHABa().toLSHABa();
    }

    @NotNull
    public final ColorLUVa toLUVa() {
        return this.toXYZa().toLUVa(this.ref());
    }

    @Override
    @NotNull
    public ColorRGBa toRGBa() {
        return this.toXYZa().toRGBa();
    }

    @NotNull
    public final ColorHSVa toHSVa() {
        return this.toXYZa().toRGBa().toHSVa();
    }

    @NotNull
    public final ColorHSLa toHSLa() {
        return this.toXYZa().toRGBa().toHSLa();
    }

    @Override
    @NotNull
    public ColorLABa opacify(double factor) {
        return ColorLABa.copy$default(this, 0.0, 0.0, 0.0, this.alpha() * factor, null, 23, null);
    }

    @Override
    @NotNull
    public ColorLABa shade(double factor) {
        return ColorLABa.copy$default(this, this.l * factor, 0.0, 0.0, 0.0, null, 30, null);
    }

    @Override
    @NotNull
    public ColorLABa plus(@NotNull ColorLABa right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return ColorLABa.copy$default(this, this.l + right.l, this.a + right.a, this.b + right.b, this.alpha() + right.alpha(), null, 16, null);
    }

    @Override
    @NotNull
    public ColorLABa minus(@NotNull ColorLABa right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return ColorLABa.copy$default(this, this.l - right.l, this.a - right.a, this.b - right.b, this.alpha() - right.alpha(), null, 16, null);
    }

    @Override
    @NotNull
    public ColorLABa times(double scale) {
        return ColorLABa.copy$default(this, this.l * scale, this.a * scale, this.b * scale, this.alpha() * scale, null, 16, null);
    }

    @Override
    @NotNull
    public Vector4 toVector4() {
        return new Vector4(this.l, this.a, this.b, this.alpha());
    }

    @Override
    @NotNull
    public ColorLABa withLuminosity(double luminosity) {
        return ColorLABa.copy$default(this, luminosity, 0.0, 0.0, 0.0, null, 30, null);
    }

    public double luminosity() {
        return this.l;
    }

    public final double component1() {
        return this.l;
    }

    public final double component2() {
        return this.a;
    }

    public final double component3() {
        return this.b;
    }

    public final double component4() {
        return this.alpha;
    }

    @NotNull
    public final ColorXYZa component5() {
        return this.ref;
    }

    @NotNull
    public final ColorLABa copy(double l, double a, double b, double alpha, @NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        return new ColorLABa(l, a, b, alpha, ref);
    }

    public static /* synthetic */ ColorLABa copy$default(ColorLABa colorLABa, double d, double d2, double d3, double d4, ColorXYZa colorXYZa, int n, Object object) {
        if ((n & 1) != 0) {
            d = colorLABa.l;
        }
        if ((n & 2) != 0) {
            d2 = colorLABa.a;
        }
        if ((n & 4) != 0) {
            d3 = colorLABa.b;
        }
        if ((n & 8) != 0) {
            d4 = colorLABa.alpha;
        }
        if ((n & 0x10) != 0) {
            colorXYZa = colorLABa.ref;
        }
        return colorLABa.copy(d, d2, d3, d4, colorXYZa);
    }

    @Override
    @NotNull
    public String toString() {
        return "ColorLABa(l=" + this.l + ", a=" + this.a + ", b=" + this.b + ", alpha=" + this.alpha + ", ref=" + this.ref + ")";
    }

    @Override
    public int hashCode() {
        int result = Double.hashCode(this.l);
        result = result * 31 + Double.hashCode(this.a);
        result = result * 31 + Double.hashCode(this.b);
        result = result * 31 + Double.hashCode(this.alpha);
        result = result * 31 + this.ref.hashCode();
        return result;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ColorLABa)) {
            return false;
        }
        ColorLABa colorLABa = (ColorLABa)other;
        if (Double.compare(this.l, colorLABa.l) != 0) {
            return false;
        }
        if (Double.compare(this.a, colorLABa.a) != 0) {
            return false;
        }
        if (Double.compare(this.b, colorLABa.b) != 0) {
            return false;
        }
        if (Double.compare(this.alpha, colorLABa.alpha) != 0) {
            return false;
        }
        return Intrinsics.areEqual(this.ref, colorLABa.ref);
    }

    @Override
    @NotNull
    public ColorLABa shadeLuminosity(double factor) {
        return LuminosityColor.DefaultImpls.shadeLuminosity(this, factor);
    }

    @Override
    @NotNull
    public ColorLABa mixLuminosity(double luminosity, double factor) {
        return LuminosityColor.DefaultImpls.mixLuminosity(this, luminosity, factor);
    }

    @Override
    @NotNull
    public ColorLABa div(double scale) {
        return AlgebraicColor.DefaultImpls.div(this, scale);
    }

    @Override
    @NotNull
    public ColorLABa mix(@NotNull ColorLABa other, double factor) {
        return (ColorLABa)AlgebraicColor.DefaultImpls.mix(this, (AlgebraicColor)other, factor);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_color(ColorLABa self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeDoubleElement(serialDesc, 0, self.l);
        output.encodeDoubleElement(serialDesc, 1, self.a);
        output.encodeDoubleElement(serialDesc, 2, self.b);
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : Double.compare(self.alpha(), 1.0) != 0) {
            output.encodeDoubleElement(serialDesc, 3, self.alpha());
        }
        if (output.shouldEncodeElementDefault(serialDesc, 4) ? true : !Intrinsics.areEqual(self.ref(), ColorXYZa.Companion.getNEUTRAL())) {
            output.encodeSerializableElement(serialDesc, 4, ColorXYZa$.serializer.INSTANCE, self.ref());
        }
    }

    public /* synthetic */ ColorLABa(int seen0, double l, double a, double b, double alpha, ColorXYZa ref, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 7, $serializer.INSTANCE.getDescriptor());
        }
        this.l = l;
        this.a = a;
        this.b = b;
        this.alpha = (seen0 & 8) == 0 ? 1.0 : alpha;
        this.ref = (seen0 & 0x10) == 0 ? ColorXYZa.Companion.getNEUTRAL() : ref;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\b\u001a\u00020\u0007J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r\u00a8\u0006\u000e"}, d2={"Lorg/openrndr/color/ColorLABa$Companion;", "", "<init>", "()V", "fromXYZa", "Lorg/openrndr/color/ColorLABa;", "xyz", "Lorg/openrndr/color/ColorXYZa;", "ref", "fromRGBa", "rgba", "Lorg/openrndr/color/ColorRGBa;", "serializer", "Lkotlinx/serialization/KSerializer;", "openrndr-color"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ColorLABa fromXYZa(@NotNull ColorXYZa xyz, @NotNull ColorXYZa ref) {
            Intrinsics.checkNotNullParameter(xyz, "xyz");
            Intrinsics.checkNotNullParameter(ref, "ref");
            double x = xyz.getX() / ref.getX();
            double y = xyz.getY() / ref.getY();
            double z = xyz.getZ() / ref.getZ();
            double l = (double)116 * ColorLABaKt.access$f(y) - 16.0;
            double a = (double)500 * (ColorLABaKt.access$f(x) - ColorLABaKt.access$f(y));
            double b = (double)200 * (ColorLABaKt.access$f(y) - ColorLABaKt.access$f(z));
            return new ColorLABa(l, a, b, xyz.getAlpha(), ref);
        }

        @NotNull
        public final ColorLABa fromRGBa(@NotNull ColorRGBa rgba, @NotNull ColorXYZa ref) {
            Intrinsics.checkNotNullParameter(rgba, "rgba");
            Intrinsics.checkNotNullParameter(ref, "ref");
            return this.fromXYZa(ColorXYZa.Companion.fromRGBa(rgba), ref);
        }

        public static /* synthetic */ ColorLABa fromRGBa$default(Companion companion, ColorRGBa colorRGBa, ColorXYZa colorXYZa, int n, Object object) {
            if ((n & 2) != 0) {
                colorXYZa = ColorXYZa.Companion.getNEUTRAL();
            }
            return companion.fromRGBa(colorRGBa, colorXYZa);
        }

        @NotNull
        public final KSerializer<ColorLABa> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

