/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.collections;

import java.util.Comparator;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010(\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001*B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\t\b\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0007B%\b\u0016\u0012\u001a\u0010\b\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0018\u00010\tj\n\u0012\u0004\u0012\u00028\u0000\u0018\u0001`\n\u00a2\u0006\u0004\b\u0005\u0010\u000bB-\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u001a\u0010\b\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0018\u00010\tj\n\u0012\u0004\u0012\u00028\u0000\u0018\u0001`\n\u00a2\u0006\u0004\b\u0005\u0010\fB\u0017\b\u0016\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e\u00a2\u0006\u0004\b\u0005\u0010\u000fJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0004J\u000b\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017J\u0019\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0019\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001aJ\u0019\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0019\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001aJ\r\u0010\u001c\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0017J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eH\u0096\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0004H\u0002J\u0010\u0010\"\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0004H\u0002J\u0018\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004H\u0002J\u0018\u0010&\u001a\u00020 2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004H\u0002J\b\u0010'\u001a\u00020\u0014H\u0002J\u0010\u0010'\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0004H\u0002J\u0010\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020\u0004H\u0002R\u0018\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0018\u00010\tj\n\u0012\u0004\u0012\u00028\u0000\u0018\u0001`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/openrndr/collections/PriorityQueue;", "Key", "", "initCapacity", "", "<init>", "(I)V", "()V", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "(Ljava/util/Comparator;)V", "(ILjava/util/Comparator;)V", "keys", "", "([Ljava/lang/Object;)V", "pq", "[Ljava/lang/Object;", "n", "isEmpty", "", "size", "peek", "()Ljava/lang/Object;", "add", "x", "(Ljava/lang/Object;)Lorg/openrndr/collections/PriorityQueue;", "insert", "poll", "iterator", "", "swim", "", "k", "sink", "greater", "i", "j", "exch", "isMinHeap", "resize", "capacity", "HeapIterator", "openrndr-utils"})
@SourceDebugExtension(value={"SMAP\nPriorityQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PriorityQueue.kt\norg/openrndr/collections/PriorityQueue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n1#2:146\n*E\n"})
public final class PriorityQueue<Key>
implements Iterable<Key>,
KMappedMarker {
    @NotNull
    private Key[] pq;
    private int n;
    @Nullable
    private final Comparator<Key> comparator;

    public PriorityQueue(int initCapacity) {
        this(initCapacity, null);
    }

    public PriorityQueue() {
        this(1);
    }

    public PriorityQueue(@Nullable Comparator<Key> comparator) {
        this(1, comparator);
    }

    public PriorityQueue(int initCapacity, @Nullable Comparator<Key> comparator) {
        this.comparator = comparator;
        this.pq = new Object[initCapacity + 1];
    }

    public PriorityQueue(@NotNull Key[] keys2) {
        Intrinsics.checkNotNullParameter(keys2, "keys");
        this(keys2.length);
        this.pq = new Object[keys2.length + 1];
        this.n = keys2.length;
        int n = this.n;
        for (int i = 0; i < n; ++i) {
            this.pq[i + 1] = keys2[i];
        }
        for (int k = this.n / 2; 0 < k; --k) {
            super.sink(k);
        }
    }

    public final boolean isEmpty() {
        return this.n == 0;
    }

    public final int size() {
        return this.n;
    }

    public final Key peek() {
        if (!this.isEmpty()) {
            Key Key2 = this.pq[1];
            Intrinsics.checkNotNull(Key2);
            return Key2;
        }
        throw new IllegalStateException("pq empty".toString());
    }

    @NotNull
    public final PriorityQueue<Key> add(Key x) {
        return this.insert(x);
    }

    @NotNull
    public final PriorityQueue<Key> insert(Key x) {
        if (this.n == this.pq.length - 1) {
            this.resize(2 * this.pq.length);
        }
        ++this.n;
        this.pq[this.n] = x;
        this.swim(this.n);
        return this;
    }

    @Nullable
    public final Key poll() {
        if (this.isEmpty()) {
            return null;
        }
        Key min = this.pq[1];
        int n = this.n;
        this.n = n + -1;
        this.exch(1, n);
        this.sink(1);
        this.pq[this.n + 1] = null;
        Key Key2 = min;
        if (Key2 == null) {
            throw new NullPointerException("'min' must not be null");
        }
        return Key2;
    }

    @Override
    @NotNull
    public Iterator<Key> iterator() {
        return new HeapIterator<Key>(this.comparator, this.size(), this.n, this.pq);
    }

    private final void swim(int k) {
        for (int myK = k; myK > 1 && this.greater(myK / 2, myK); myK /= 2) {
            this.exch(myK, myK / 2);
        }
    }

    private final void sink(int k) {
        int myK = k;
        while (2 * myK <= this.n) {
            int j = 2 * myK;
            if (j < this.n && this.greater(j, j + 1)) {
                ++j;
            }
            if (!this.greater(myK, j)) {
                return;
            }
            this.exch(myK, j);
            myK = j;
        }
    }

    private final boolean greater(int i, int j) {
        boolean bl;
        if (this.comparator == null) {
            Key Key2 = this.pq[i];
            Intrinsics.checkNotNull(Key2, "null cannot be cast to non-null type kotlin.Comparable<Key of org.openrndr.collections.PriorityQueue>");
            Comparable comparable = (Comparable)Key2;
            Key Key3 = this.pq[j];
            Intrinsics.checkNotNull(Key3);
            bl = comparable.compareTo(Key3) > 0;
        } else {
            Key Key4 = this.pq[i];
            Intrinsics.checkNotNull(Key4);
            Key Key5 = this.pq[j];
            Intrinsics.checkNotNull(Key5);
            bl = this.comparator.compare(Key4, Key5) > 0;
        }
        return bl;
    }

    private final void exch(int i, int j) {
        Key Key2;
        Key Key3 = Key2 = this.pq[j];
        int n = i;
        Key[] KeyArray = this.pq;
        boolean bl = false;
        this.pq[j] = this.pq[i];
        Unit unit = Unit.INSTANCE;
        KeyArray[n] = Key2;
    }

    private final boolean isMinHeap() {
        return this.isMinHeap(1);
    }

    private final boolean isMinHeap(int k) {
        if (k > this.n) {
            return true;
        }
        int left = 2 * k;
        int right = 2 * k + 1;
        return left <= this.n && this.greater(k, left) ? false : (right <= this.n && this.greater(k, right) ? false : this.isMinHeap(left) && this.isMinHeap(right));
    }

    private final void resize(int capacity) {
        Object[] temp = new Object[capacity];
        int i = 1;
        int n = this.n;
        if (i <= n) {
            while (true) {
                temp[i] = this.pq[i];
                if (i == n) break;
                ++i;
            }
        }
        this.pq = temp;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002BC\u0012\u001a\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0004j\n\u0012\u0004\u0012\u00028\u0001\u0018\u0001`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J\u000e\u0010\u0011\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u0012R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/openrndr/collections/PriorityQueue$HeapIterator;", "Key", "", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "size", "", "n", "pq", "", "<init>", "(Ljava/util/Comparator;II[Ljava/lang/Object;)V", "copy", "Lorg/openrndr/collections/PriorityQueue;", "hasNext", "", "next", "()Ljava/lang/Object;", "openrndr-utils"})
    @SourceDebugExtension(value={"SMAP\nPriorityQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PriorityQueue.kt\norg/openrndr/collections/PriorityQueue$HeapIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n1#2:146\n*E\n"})
    public static final class HeapIterator<Key>
    implements Iterator<Key>,
    KMappedMarker {
        @NotNull
        private final PriorityQueue<Key> copy;

        public HeapIterator(@Nullable Comparator<Key> comparator, int size, int n, @NotNull Key[] pq) {
            Intrinsics.checkNotNullParameter(pq, "pq");
            this.copy = comparator == null ? new PriorityQueue(size) : new PriorityQueue<Key>(size, comparator);
            int i = 1;
            if (i <= n) {
                while (true) {
                    Key Key2 = pq[i];
                    Intrinsics.checkNotNull(Key2);
                    this.copy.insert(Key2);
                    if (i == n) break;
                    ++i;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return !this.copy.isEmpty();
        }

        @Override
        public Key next() {
            if (!this.hasNext()) {
                boolean bl = false;
                String string = "Queue is empty";
                throw new IllegalArgumentException(string.toString());
            }
            Key Key2 = this.copy.poll();
            if (Key2 == null) {
                throw new IllegalStateException("Queue is empty".toString());
            }
            return Key2;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

