/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.nfd;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.nfd.NFDFilterItem;
import org.lwjgl.util.nfd.NFDWindowHandle;

@NativeType(value="struct nfdsavedialogu8args_t")
public class NFDSaveDialogArgs
extends Struct<NFDSaveDialogArgs>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FILTERLIST;
    public static final int FILTERCOUNT;
    public static final int DEFAULTPATH;
    public static final int DEFAULTNAME;
    public static final int PARENTWINDOW;

    protected NFDSaveDialogArgs(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected NFDSaveDialogArgs create(long address, @Nullable ByteBuffer container) {
        return new NFDSaveDialogArgs(address, container);
    }

    public NFDSaveDialogArgs(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NFDSaveDialogArgs.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="nfdfilteritem_t const *")
    public @Nullable NFDFilterItem.Buffer filterList() {
        return NFDSaveDialogArgs.nfilterList(this.address());
    }

    @NativeType(value="nfdfiltersize_t")
    public int filterCount() {
        return NFDSaveDialogArgs.nfilterCount(this.address());
    }

    @NativeType(value="nfdchar_t const *")
    public @Nullable ByteBuffer defaultPath() {
        return NFDSaveDialogArgs.ndefaultPath(this.address());
    }

    @NativeType(value="nfdchar_t const *")
    public @Nullable String defaultPathString() {
        return NFDSaveDialogArgs.ndefaultPathString(this.address());
    }

    @NativeType(value="nfdchar_t const *")
    public @Nullable ByteBuffer defaultName() {
        return NFDSaveDialogArgs.ndefaultName(this.address());
    }

    @NativeType(value="nfdchar_t const *")
    public @Nullable String defaultNameString() {
        return NFDSaveDialogArgs.ndefaultNameString(this.address());
    }

    @NativeType(value="nfdwindowhandle_t")
    public NFDWindowHandle parentWindow() {
        return NFDSaveDialogArgs.nparentWindow(this.address());
    }

    public NFDSaveDialogArgs filterList(@NativeType(value="nfdfilteritem_t const *") @Nullable NFDFilterItem.Buffer value) {
        NFDSaveDialogArgs.nfilterList(this.address(), value);
        return this;
    }

    public NFDSaveDialogArgs defaultPath(@NativeType(value="nfdchar_t const *") @Nullable ByteBuffer value) {
        NFDSaveDialogArgs.ndefaultPath(this.address(), value);
        return this;
    }

    public NFDSaveDialogArgs defaultName(@NativeType(value="nfdchar_t const *") @Nullable ByteBuffer value) {
        NFDSaveDialogArgs.ndefaultName(this.address(), value);
        return this;
    }

    public NFDSaveDialogArgs parentWindow(@NativeType(value="nfdwindowhandle_t") NFDWindowHandle value) {
        NFDSaveDialogArgs.nparentWindow(this.address(), value);
        return this;
    }

    public NFDSaveDialogArgs parentWindow(Consumer<NFDWindowHandle> consumer) {
        consumer.accept(this.parentWindow());
        return this;
    }

    public NFDSaveDialogArgs set(@Nullable NFDFilterItem.Buffer filterList, @Nullable ByteBuffer defaultPath, @Nullable ByteBuffer defaultName, NFDWindowHandle parentWindow) {
        this.filterList(filterList);
        this.defaultPath(defaultPath);
        this.defaultName(defaultName);
        this.parentWindow(parentWindow);
        return this;
    }

    public NFDSaveDialogArgs set(NFDSaveDialogArgs src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NFDSaveDialogArgs malloc() {
        return new NFDSaveDialogArgs(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static NFDSaveDialogArgs calloc() {
        return new NFDSaveDialogArgs(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static NFDSaveDialogArgs create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new NFDSaveDialogArgs(MemoryUtil.memAddress(container), container);
    }

    public static NFDSaveDialogArgs create(long address) {
        return new NFDSaveDialogArgs(address, null);
    }

    public static @Nullable NFDSaveDialogArgs createSafe(long address) {
        return address == 0L ? null : new NFDSaveDialogArgs(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(NFDSaveDialogArgs.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NFDSaveDialogArgs.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static NFDSaveDialogArgs malloc(MemoryStack stack) {
        return new NFDSaveDialogArgs(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NFDSaveDialogArgs calloc(MemoryStack stack) {
        return new NFDSaveDialogArgs(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static @Nullable NFDFilterItem.Buffer nfilterList(long struct) {
        return NFDFilterItem.createSafe(MemoryUtil.memGetAddress(struct + (long)FILTERLIST), NFDSaveDialogArgs.nfilterCount(struct));
    }

    public static int nfilterCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FILTERCOUNT);
    }

    public static @Nullable ByteBuffer ndefaultPath(long struct) {
        return MemoryUtil.memByteBufferNT1Safe(MemoryUtil.memGetAddress(struct + (long)DEFAULTPATH));
    }

    public static @Nullable String ndefaultPathString(long struct) {
        return MemoryUtil.memUTF8Safe(MemoryUtil.memGetAddress(struct + (long)DEFAULTPATH));
    }

    public static @Nullable ByteBuffer ndefaultName(long struct) {
        return MemoryUtil.memByteBufferNT1Safe(MemoryUtil.memGetAddress(struct + (long)DEFAULTNAME));
    }

    public static @Nullable String ndefaultNameString(long struct) {
        return MemoryUtil.memUTF8Safe(MemoryUtil.memGetAddress(struct + (long)DEFAULTNAME));
    }

    public static NFDWindowHandle nparentWindow(long struct) {
        return NFDWindowHandle.create(struct + (long)PARENTWINDOW);
    }

    public static void nfilterList(long struct, @Nullable NFDFilterItem.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)FILTERLIST, MemoryUtil.memAddressSafe(value));
        NFDSaveDialogArgs.nfilterCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nfilterCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FILTERCOUNT, value);
    }

    public static void ndefaultPath(long struct, @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(value);
        }
        MemoryUtil.memPutAddress(struct + (long)DEFAULTPATH, MemoryUtil.memAddressSafe(value));
    }

    public static void ndefaultName(long struct, @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(value);
        }
        MemoryUtil.memPutAddress(struct + (long)DEFAULTNAME, MemoryUtil.memAddressSafe(value));
    }

    public static void nparentWindow(long struct, NFDWindowHandle value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PARENTWINDOW, NFDWindowHandle.SIZEOF);
    }

    public static void validate(long struct) {
        int filterCount = NFDSaveDialogArgs.nfilterCount(struct);
        if (filterCount != 0) {
            long filterList = MemoryUtil.memGetAddress(struct + (long)FILTERLIST);
            Checks.check(filterList);
            NFDSaveDialogArgs.validate(filterList, filterCount, NFDFilterItem.SIZEOF, NFDFilterItem::validate);
        }
    }

    static {
        Struct.Layout layout = NFDSaveDialogArgs.__struct(NFDSaveDialogArgs.__member(POINTER_SIZE), NFDSaveDialogArgs.__member(4), NFDSaveDialogArgs.__member(POINTER_SIZE), NFDSaveDialogArgs.__member(POINTER_SIZE), NFDSaveDialogArgs.__member(NFDWindowHandle.SIZEOF, NFDWindowHandle.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FILTERLIST = layout.offsetof(0);
        FILTERCOUNT = layout.offsetof(1);
        DEFAULTPATH = layout.offsetof(2);
        DEFAULTNAME = layout.offsetof(3);
        PARENTWINDOW = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<NFDSaveDialogArgs, Buffer>
    implements NativeResource {
        private static final NFDSaveDialogArgs ELEMENT_FACTORY = NFDSaveDialogArgs.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected NFDSaveDialogArgs getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="nfdfilteritem_t const *")
        public @Nullable NFDFilterItem.Buffer filterList() {
            return NFDSaveDialogArgs.nfilterList(this.address());
        }

        @NativeType(value="nfdfiltersize_t")
        public int filterCount() {
            return NFDSaveDialogArgs.nfilterCount(this.address());
        }

        @NativeType(value="nfdchar_t const *")
        public @Nullable ByteBuffer defaultPath() {
            return NFDSaveDialogArgs.ndefaultPath(this.address());
        }

        @NativeType(value="nfdchar_t const *")
        public @Nullable String defaultPathString() {
            return NFDSaveDialogArgs.ndefaultPathString(this.address());
        }

        @NativeType(value="nfdchar_t const *")
        public @Nullable ByteBuffer defaultName() {
            return NFDSaveDialogArgs.ndefaultName(this.address());
        }

        @NativeType(value="nfdchar_t const *")
        public @Nullable String defaultNameString() {
            return NFDSaveDialogArgs.ndefaultNameString(this.address());
        }

        @NativeType(value="nfdwindowhandle_t")
        public NFDWindowHandle parentWindow() {
            return NFDSaveDialogArgs.nparentWindow(this.address());
        }

        public Buffer filterList(@NativeType(value="nfdfilteritem_t const *") @Nullable NFDFilterItem.Buffer value) {
            NFDSaveDialogArgs.nfilterList(this.address(), value);
            return this;
        }

        public Buffer defaultPath(@NativeType(value="nfdchar_t const *") @Nullable ByteBuffer value) {
            NFDSaveDialogArgs.ndefaultPath(this.address(), value);
            return this;
        }

        public Buffer defaultName(@NativeType(value="nfdchar_t const *") @Nullable ByteBuffer value) {
            NFDSaveDialogArgs.ndefaultName(this.address(), value);
            return this;
        }

        public Buffer parentWindow(@NativeType(value="nfdwindowhandle_t") NFDWindowHandle value) {
            NFDSaveDialogArgs.nparentWindow(this.address(), value);
            return this;
        }

        public Buffer parentWindow(Consumer<NFDWindowHandle> consumer) {
            consumer.accept(this.parentWindow());
            return this;
        }
    }
}

