/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.function.IntFunction;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.ThreadLocalUtil;

public final class GLES {
    private static final @Nullable APIUtil.APIVersion MAX_VERSION;
    private static @Nullable FunctionProvider functionProvider;
    private static final ThreadLocal<@Nullable GLESCapabilities> capabilitiesTLS;
    private static ICD icd;

    private GLES() {
    }

    static void initialize() {
    }

    public static void create() {
        GLES.create(Library.loadNative(GLES.class, "org.lwjgl.opengles", Configuration.OPENGLES_LIBRARY_NAME, Configuration.OPENGLES_LIBRARY_NAME_DEFAULTS()));
    }

    public static void create(String libName) {
        GLES.create(Library.loadNative(GLES.class, "org.lwjgl.opengles", libName));
    }

    private static @Nullable SharedLibrary getContextProvider() {
        SharedLibrary GL2 = null;
        String contextAPI = Configuration.OPENGLES_CONTEXT_API.get();
        if ("native".equals(contextAPI)) {
            GL2 = GLES.loadNative();
        } else if ("OSMesa".equals(contextAPI)) {
            GL2 = GLES.loadOSMesa();
        }
        if (GL2 == null && (GL2 = GLES.loadEGL()) == null && !"EGL".equals(contextAPI)) {
            if (!"native".equals(contextAPI)) {
                GL2 = GLES.loadNative();
            }
            if (GL2 == null && !"OSMesa".equals(contextAPI)) {
                GL2 = GLES.loadOSMesa();
            }
        }
        return GL2 == null ? null : new SharedLibrary.Delegate(GL2){
            private final long GetProcAddress;
            {
                long GetProcAddress = 0L;
                switch (Platform.get()) {
                    case FREEBSD: 
                    case LINUX: {
                        GetProcAddress = this.library.getFunctionAddress("glXGetProcAddress");
                        if (GetProcAddress != 0L) break;
                        GetProcAddress = this.library.getFunctionAddress("glXGetProcAddressARB");
                        break;
                    }
                    case WINDOWS: {
                        GetProcAddress = this.library.getFunctionAddress("wglGetProcAddress");
                    }
                }
                if (GetProcAddress == 0L) {
                    GetProcAddress = this.library.getFunctionAddress("eglGetProcAddress");
                }
                if (GetProcAddress == 0L) {
                    GetProcAddress = this.library.getFunctionAddress("OSMesaGetProcAddress");
                }
                this.GetProcAddress = GetProcAddress;
            }

            @Override
            public long getFunctionAddress(ByteBuffer functionName) {
                long address;
                long l = address = this.GetProcAddress == 0L ? 0L : JNI.callPP(MemoryUtil.memAddress(functionName), this.GetProcAddress);
                if (address == 0L) {
                    address = this.library.getFunctionAddress(functionName);
                }
                return address;
            }
        };
    }

    private static @Nullable SharedLibrary loadEGL() {
        try {
            return Library.loadNative(GLES.class, "org.lwjgl.opengles", Configuration.EGL_LIBRARY_NAME, Configuration.EGL_LIBRARY_NAME_DEFAULTS());
        }
        catch (Throwable ignored) {
            APIUtil.apiLog("[GLES] Failed to initialize context management based on EGL");
            return null;
        }
    }

    private static @Nullable SharedLibrary loadNative() {
        try {
            return Library.loadNative(GLES.class, "org.lwjgl.opengles", Configuration.OPENGL_LIBRARY_NAME, Configuration.OPENGL_LIBRARY_NAME_DEFAULTS());
        }
        catch (Throwable ignored) {
            APIUtil.apiLog("[GLES] Failed to initialize context management based on native OpenGL platform API");
            return null;
        }
    }

    private static @Nullable SharedLibrary loadOSMesa() {
        try {
            return Library.loadNative(GLES.class, "org.lwjgl.opengles", Configuration.OPENGL_OSMESA_LIBRARY_NAME, Configuration.OPENGL_OSMESA_LIBRARY_NAME_DEFAULTS());
        }
        catch (Throwable ignored) {
            APIUtil.apiLog("[GLES] Failed to initialize context management based on OSMesa");
            return null;
        }
    }

    private static void create(SharedLibrary GLES2) {
        final SharedLibrary contextProvider = GLES.getContextProvider();
        if (contextProvider == null) {
            GLES2.free();
            throw new IllegalStateException("There is no OpenGL ES context management API available.");
        }
        SharedLibrary.Delegate provider = new SharedLibrary.Delegate(GLES2){

            @Override
            public long getFunctionAddress(ByteBuffer functionName) {
                long address = contextProvider.getFunctionAddress(functionName);
                if (address == 0L && (address = this.library.getFunctionAddress(functionName)) == 0L && Checks.DEBUG_FUNCTIONS) {
                    APIUtil.apiLogMissing("GLES", functionName);
                }
                return address;
            }

            @Override
            public void free() {
                super.free();
                contextProvider.free();
            }
        };
        try {
            GLES.create((FunctionProvider)provider);
        }
        catch (RuntimeException e) {
            provider.free();
            throw e;
        }
    }

    public static void create(FunctionProvider functionProvider) {
        if (GLES.functionProvider != null) {
            throw new IllegalStateException("OpenGL ES has already been created.");
        }
        GLES.functionProvider = functionProvider;
        ThreadLocalUtil.setFunctionMissingAddresses(874);
    }

    public static void destroy() {
        if (functionProvider == null) {
            return;
        }
        ThreadLocalUtil.setFunctionMissingAddresses(0);
        if (functionProvider instanceof NativeResource) {
            ((NativeResource)((Object)functionProvider)).free();
        }
        functionProvider = null;
    }

    public static @Nullable FunctionProvider getFunctionProvider() {
        return functionProvider;
    }

    public static void setCapabilities(@Nullable GLESCapabilities caps) {
        capabilitiesTLS.set(caps);
        ThreadLocalUtil.setCapabilities(caps == null ? 0L : MemoryUtil.memAddress(caps.addresses));
        icd.set(caps);
    }

    public static GLESCapabilities getCapabilities() {
        return GLES.checkCapabilities(capabilitiesTLS.get());
    }

    private static GLESCapabilities checkCapabilities(@Nullable GLESCapabilities caps) {
        if (caps == null) {
            throw new IllegalStateException("No GLESCapabilities instance set for the current thread. Possible solutions:\n\ta) Call GLES.createCapabilities() after making a context current in the current thread.\n\tb) Call GLES.setCapabilities() if a GLESCapabilities instance already exists for the current context.");
        }
        return caps;
    }

    public static GLESCapabilities createCapabilities() {
        return GLES.createCapabilities(null);
    }

    public static GLESCapabilities createCapabilities(@Nullable IntFunction<PointerBuffer> bufferFactory) {
        int minorVersion;
        int majorVersion;
        FunctionProvider functionProvider = GLES.functionProvider;
        if (functionProvider == null) {
            throw new IllegalStateException("OpenGL ES library not been loaded.");
        }
        long GetError = functionProvider.getFunctionAddress("glGetError");
        long GetString = functionProvider.getFunctionAddress("glGetString");
        long GetIntegerv = functionProvider.getFunctionAddress("glGetIntegerv");
        if (GetError == 0L || GetString == 0L || GetIntegerv == 0L) {
            throw new IllegalStateException("Core OpenGL ES functions could not be found. Make sure that the OpenGL ES library has been loaded correctly.");
        }
        int errorCode = JNI.callI(GetError);
        if (errorCode != 0) {
            APIUtil.apiLog(String.format("An OpenGL ES context was in an error state before the creation of its capabilities instance. Error: [0x%X]", errorCode));
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer pi = stack.ints(0);
            JNI.callPV(33307, MemoryUtil.memAddress(pi), GetIntegerv);
            if (JNI.callI(GetError) == 0 && 3 <= (majorVersion = pi.get(0))) {
                JNI.callPV(33308, MemoryUtil.memAddress(pi), GetIntegerv);
                minorVersion = pi.get(0);
            } else {
                String versionString = MemoryUtil.memUTF8Safe(JNI.callP(7938, GetString));
                if (versionString == null || JNI.callI(GetError) != 0) {
                    throw new IllegalStateException("There is no OpenGL ES context current in the current thread.");
                }
                APIUtil.APIVersion version = APIUtil.apiParseVersion(versionString);
                majorVersion = version.major;
                minorVersion = version.minor;
            }
        }
        if (majorVersion < 2) {
            throw new IllegalStateException("OpenGL ES 2.0 is required.");
        }
        int[] GL_VERSIONS = new int[]{-1, 0, 2};
        HashSet<String> supportedExtensions = new HashSet<String>(128);
        int maxMajor = Math.min(majorVersion, GL_VERSIONS.length);
        if (MAX_VERSION != null) {
            maxMajor = Math.min(GLES.MAX_VERSION.major, maxMajor);
        }
        for (int M = 2; M <= maxMajor; ++M) {
            int maxMinor = GL_VERSIONS[M - 1];
            if (M == majorVersion) {
                maxMinor = Math.min(minorVersion, maxMinor);
            }
            if (MAX_VERSION != null && M == GLES.MAX_VERSION.major) {
                maxMinor = Math.min(GLES.MAX_VERSION.minor, maxMinor);
            }
            for (int m = 0; m <= maxMinor; ++m) {
                supportedExtensions.add("GLES" + M + m);
            }
        }
        if (majorVersion < 3) {
            String extensionsString = MemoryUtil.memASCIISafe(JNI.callP(7939, GetString));
            if (extensionsString != null) {
                StringTokenizer tokenizer = new StringTokenizer(extensionsString);
                while (tokenizer.hasMoreTokens()) {
                    supportedExtensions.add(tokenizer.nextToken());
                }
            }
        } else {
            int extensionCount;
            try (MemoryStack stack = MemoryStack.stackPush();){
                IntBuffer pi = stack.ints(0);
                JNI.callPV(33309, MemoryUtil.memAddress(pi), GetIntegerv);
                extensionCount = pi.get(0);
            }
            long GetStringi = APIUtil.apiGetFunctionAddress(functionProvider, "glGetStringi");
            for (int i = 0; i < extensionCount; ++i) {
                supportedExtensions.add(MemoryUtil.memASCII(JNI.callP(7939, i, GetStringi)));
            }
        }
        APIUtil.apiFilterExtensions(supportedExtensions, Configuration.OPENGLES_EXTENSION_FILTER);
        GLESCapabilities caps = new GLESCapabilities(functionProvider, supportedExtensions, bufferFactory == null ? BufferUtils::createPointerBuffer : bufferFactory);
        GLES.setCapabilities(caps);
        return caps;
    }

    static GLESCapabilities getICD() {
        return GLES.checkCapabilities(icd.get());
    }

    static {
        capabilitiesTLS = new ThreadLocal();
        icd = new ICDStatic();
        Library.loadSystem(System::load, System::loadLibrary, GLES.class, "org.lwjgl.opengles", Platform.mapLibraryNameBundled("lwjgl_opengles"));
        MAX_VERSION = APIUtil.apiParseVersion(Configuration.OPENGLES_MAXVERSION);
        if (!Configuration.OPENGLES_EXPLICIT_INIT.get(false).booleanValue()) {
            GLES.create();
        }
    }

    private static class ICDStatic
    implements ICD {
        private static @Nullable GLESCapabilities tempCaps;

        private ICDStatic() {
        }

        @Override
        public void set(@Nullable GLESCapabilities caps) {
            if (tempCaps == null) {
                tempCaps = caps;
            } else if (caps != null && caps != tempCaps && ThreadLocalUtil.areCapabilitiesDifferent(ICDStatic.tempCaps.addresses, caps.addresses)) {
                APIUtil.apiLog("[WARNING] Incompatible context detected. Falling back to thread-local lookup for GLES contexts.");
                icd = GLES::getCapabilities;
            }
        }

        @Override
        public GLESCapabilities get() {
            return WriteOnce.caps;
        }

        private static final class WriteOnce {
            static final GLESCapabilities caps;

            private WriteOnce() {
            }

            static {
                GLESCapabilities tempCaps = tempCaps;
                if (tempCaps == null) {
                    throw new IllegalStateException("No GLESCapabilities instance has been set");
                }
                caps = tempCaps;
            }
        }
    }

    private static interface ICD {
        default public void set(@Nullable GLESCapabilities caps) {
        }

        public @Nullable GLESCapabilities get();
    }
}

