/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class KHRLockSurface3 {
    public static final int EGL_READ_SURFACE_BIT_KHR = 1;
    public static final int EGL_WRITE_SURFACE_BIT_KHR = 2;
    public static final int EGL_LOCK_SURFACE_BIT_KHR = 128;
    public static final int EGL_OPTIMAL_FORMAT_BIT_KHR = 256;
    public static final int EGL_MATCH_FORMAT_KHR = 12355;
    public static final int EGL_FORMAT_RGB_565_EXACT_KHR = 12480;
    public static final int EGL_FORMAT_RGB_565_KHR = 12481;
    public static final int EGL_FORMAT_RGBA_8888_EXACT_KHR = 12482;
    public static final int EGL_FORMAT_RGBA_8888_KHR = 12483;
    public static final int EGL_MAP_PRESERVE_PIXELS_KHR = 12484;
    public static final int EGL_LOCK_USAGE_HINT_KHR = 12485;
    public static final int EGL_BITMAP_PITCH_KHR = 12487;
    public static final int EGL_BITMAP_ORIGIN_KHR = 12488;
    public static final int EGL_BITMAP_PIXEL_RED_OFFSET_KHR = 12489;
    public static final int EGL_BITMAP_PIXEL_GREEN_OFFSET_KHR = 12490;
    public static final int EGL_BITMAP_PIXEL_BLUE_OFFSET_KHR = 12491;
    public static final int EGL_BITMAP_PIXEL_ALPHA_OFFSET_KHR = 12492;
    public static final int EGL_BITMAP_PIXEL_LUMINANCE_OFFSET_KHR = 12493;
    public static final int EGL_BITMAP_PIXEL_SIZE_KHR = 12560;
    public static final int EGL_BITMAP_POINTER_KHR = 12486;
    public static final int EGL_LOWER_LEFT_KHR = 12494;
    public static final int EGL_UPPER_LEFT_KHR = 12495;

    protected KHRLockSurface3() {
        throw new UnsupportedOperationException();
    }

    public static int neglLockSurfaceKHR(long dpy, long surface, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglLockSurfaceKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(surface);
        }
        return JNI.callPPPI(dpy, surface, attrib_list, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglLockSurfaceKHR(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLSurface") long surface, @NativeType(value="EGLint const *") @Nullable IntBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list, 12344);
        }
        return KHRLockSurface3.neglLockSurfaceKHR(dpy, surface, MemoryUtil.memAddressSafe(attrib_list)) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglUnlockSurfaceKHR(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLSurface") long surface) {
        long __functionAddress = EGL.getCapabilities().eglUnlockSurfaceKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(surface);
        }
        return JNI.callPPI(dpy, surface, __functionAddress) != 0;
    }

    public static int neglQuerySurface64KHR(long dpy, long surface, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglQuerySurface64KHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(surface);
        }
        return JNI.callPPPI(dpy, surface, attribute, value, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQuerySurface64KHR(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLSurface") long surface, @NativeType(value="EGLint") int attribute, @NativeType(value="EGLAttribKHR *") PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.check(value, 1);
        }
        return KHRLockSurface3.neglQuerySurface64KHR(dpy, surface, attribute, MemoryUtil.memAddress(value)) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglLockSurfaceKHR(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLSurface") long surface, @NativeType(value="EGLint const *") int @Nullable [] attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglLockSurfaceKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(surface);
            Checks.checkNTSafe(attrib_list, 12344);
        }
        return JNI.callPPPI(dpy, surface, attrib_list, __functionAddress) != 0;
    }
}

