/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class EXTDeviceQuery {
    public static final int EGL_BAD_DEVICE_EXT = 12843;
    public static final int EGL_DEVICE_EXT = 12844;
    public static final long EGL_NO_DEVICE_EXT = 0L;

    protected EXTDeviceQuery() {
        throw new UnsupportedOperationException();
    }

    public static int neglQueryDeviceAttribEXT(long device, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglQueryDeviceAttribEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
        }
        return JNI.callPPI(device, attribute, value, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQueryDeviceAttribEXT(@NativeType(value="EGLDeviceEXT") long device, @NativeType(value="EGLint") int attribute, @NativeType(value="EGLAttrib *") PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.check(value, 1);
        }
        return EXTDeviceQuery.neglQueryDeviceAttribEXT(device, attribute, MemoryUtil.memAddress(value)) != 0;
    }

    public static long neglQueryDeviceStringEXT(long device, int name) {
        long __functionAddress = EGL.getCapabilities().eglQueryDeviceStringEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
        }
        return JNI.callPP(device, name, __functionAddress);
    }

    @NativeType(value="char *")
    public static @Nullable String eglQueryDeviceStringEXT(@NativeType(value="EGLDeviceEXT") long device, @NativeType(value="EGLint") int name) {
        long __result = EXTDeviceQuery.neglQueryDeviceStringEXT(device, name);
        return MemoryUtil.memASCIISafe(__result);
    }

    public static int neglQueryDisplayAttribEXT(long dpy, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglQueryDisplayAttribEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
        }
        return JNI.callPPI(dpy, attribute, value, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQueryDisplayAttribEXT(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLint") int attribute, @NativeType(value="EGLAttrib *") PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.check(value, 1);
        }
        return EXTDeviceQuery.neglQueryDisplayAttribEXT(dpy, attribute, MemoryUtil.memAddress(value)) != 0;
    }
}

