/*
 * Decompiled with CFR 0.152.
 */
package lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.fft.FFT;
import org.openrndr.extra.shapes.rectify.RectifiedContour;
import org.openrndr.extra.shapes.splines.CatmullRomKt;
import org.openrndr.math.FunctionsKt;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector4;
import org.openrndr.shape.Path;
import org.openrndr.shape.Segment2D;
import org.openrndr.shape.ShapeContour;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\n\u0010\u0006\u001a\u00020\u0003*\u00020\u0003\u001a\u001e\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001a\u0010\b\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0005\u001a \u0010\u000b\u001a\u00020\f*\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010\u001a\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010\u001a:\u0010\u0013\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00172\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001a\u00a8\u0006\u001b"}, d2={"poseParts", "Lkotlin/Pair;", "Lorg/openrndr/math/Matrix44;", "Lorg/openrndr/shape/ShapeContour;", "t", "", "subdivide", "Lorg/openrndr/extra/shapes/rectify/RectifiedContour;", "mix", "other", "factor", "toFloatArrays", "", "", "Lorg/openrndr/math/Vector2;", "x", "", "y", "vectorsFromFloatArrays", "spectralFilter", "points", "", "normalize", "", "smoothing", "filter", "Lkotlin/Function1;", "deminityy"})
@SourceDebugExtension(value={"SMAP\nShapeContour.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShapeContour.kt\nlib/ShapeContourKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n1368#2:145\n1454#2,5:146\n1557#2:151\n1628#2,3:152\n*S KotlinDebug\n*F\n+ 1 ShapeContour.kt\nlib/ShapeContourKt\n*L\n35#1:145\n35#1:146,5\n61#1:151\n61#1:152,3\n*E\n"})
public final class ShapeContourKt {
    @NotNull
    public static final Pair<Matrix44, Matrix44> poseParts(@NotNull ShapeContour $this$poseParts, double t) {
        Intrinsics.checkNotNullParameter($this$poseParts, "<this>");
        Vector2 n = $this$poseParts.normal(t);
        Vector4 dx = n.perpendicular($this$poseParts.getPolarity()).xy0().xyz0();
        Vector4 dy = n.xy0().xyz0();
        Vector4 dt = ((Vector2)$this$poseParts.position(t)).xy01();
        if (!Intrinsics.areEqual(n, n)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!Intrinsics.areEqual(dx, dx)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!Intrinsics.areEqual(dy, dy)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!Intrinsics.areEqual(dt, dt)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return new Pair<Matrix44, Matrix44>(Matrix44.Companion.fromColumnVectors(dx, dy, Vector4.Companion.getUNIT_Z(), Vector4.Companion.getUNIT_W()), Matrix44.Companion.fromColumnVectors(Vector4.Companion.getUNIT_X(), Vector4.Companion.getUNIT_Y(), Vector4.Companion.getUNIT_Z(), dt));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ShapeContour subdivide(@NotNull ShapeContour $this$subdivide) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$subdivide, "<this>");
        Iterable $this$flatMap$iv = $this$subdivide.getSegments();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Segment2D it = (Segment2D)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ArraysKt.toList(it.split(0.5));
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List segments = (List)destination$iv$iv;
        return ShapeContour.Companion.fromSegments$default(ShapeContour.Companion, segments, $this$subdivide.getClosed(), null, 0.0, 12, null);
    }

    @NotNull
    public static final Pair<Matrix44, Matrix44> poseParts(@NotNull RectifiedContour $this$poseParts, double t) {
        Intrinsics.checkNotNullParameter($this$poseParts, "<this>");
        return $this$poseParts.getContour().getEmpty() ? new Pair<Matrix44, Matrix44>(Matrix44.Companion.getIDENTITY(), Matrix44.Companion.getIDENTITY()) : ShapeContourKt.poseParts($this$poseParts.getContour(), $this$poseParts.rectify(ShapeContourKt.poseParts$safe($this$poseParts, t)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ShapeContour mix(@NotNull ShapeContour $this$mix, @NotNull ShapeContour other, double factor) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$mix, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        if (!($this$mix.getSegments().size() == other.getSegments().size())) {
            boolean $i$a$-require-ShapeContourKt$mix$22 = false;
            String $i$a$-require-ShapeContourKt$mix$22 = "number of segments differ: " + $this$mix.getSegments().size() + " vs " + other.getSegments().size();
            throw new IllegalArgumentException($i$a$-require-ShapeContourKt$mix$22.toString());
        }
        Iterable $this$map$iv = CollectionsKt.zip((Iterable)$this$mix.getSegments(), (Iterable)other.getSegments());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Segment2D)it.getFirst()).times(1.0 - factor).plus(((Segment2D)it.getSecond()).times(factor)));
        }
        List segs = (List)destination$iv$iv;
        return ShapeContour.Companion.fromSegments$default(ShapeContour.Companion, segs, false, null, 0.0, 12, null);
    }

    public static final void toFloatArrays(@NotNull List<Vector2> $this$toFloatArrays, @NotNull float[] x, @NotNull float[] y) {
        Intrinsics.checkNotNullParameter($this$toFloatArrays, "<this>");
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(y, "y");
        Iterator iterator2 = ((Iterable)$this$toFloatArrays).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            Vector2 segment = (Vector2)iterator2.next();
            x[index] = (float)segment.x();
            y[index] = (float)segment.y();
        }
    }

    @NotNull
    public static final List<Vector2> vectorsFromFloatArrays(@NotNull float[] x, @NotNull float[] y) {
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(y, "y");
        int n = x.length;
        List result = new ArrayList();
        for (int i = 0; i < n; ++i) {
            result.add(new Vector2(x[i], y[i]));
        }
        return result;
    }

    @NotNull
    public static final ShapeContour spectralFilter(@NotNull ShapeContour $this$spectralFilter, int points2, boolean normalize, boolean smoothing, @NotNull Function1<? super Double, Double> filter2) {
        Intrinsics.checkNotNullParameter($this$spectralFilter, "<this>");
        Intrinsics.checkNotNullParameter(filter2, "filter");
        FFT fft = new FFT(points2, null, 2, null);
        float[] x = new float[points2];
        float[] xr = new float[points2];
        float[] y = new float[points2];
        float[] yr = new float[points2];
        ShapeContourKt.toFloatArrays(CollectionsKt.take(Path.DefaultImpls.equidistantPositions$default($this$spectralFilter, points2, 0.0, 2, null), points2), x, y);
        ShapeContourKt.spectralFilter$filterAxis(fft, points2, filter2, normalize, x, xr);
        ShapeContourKt.spectralFilter$filterAxis(fft, points2, filter2, normalize, y, yr);
        List<Vector2> reconstructedPoints = ShapeContourKt.vectorsFromFloatArrays(xr, yr);
        return smoothing ? CatmullRomKt.toContour(CatmullRomKt.catmullRom$default(reconstructedPoints, 0.0, $this$spectralFilter.getClosed(), 1, null)) : ShapeContour.Companion.fromPoints$default(ShapeContour.Companion, reconstructedPoints, $this$spectralFilter.getClosed(), null, 4, null);
    }

    public static /* synthetic */ ShapeContour spectralFilter$default(ShapeContour shapeContour, int n, boolean bl, boolean bl2, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        if ((n2 & 4) != 0) {
            bl2 = true;
        }
        return ShapeContourKt.spectralFilter(shapeContour, n, bl, bl2, function1);
    }

    private static final double poseParts$safe(RectifiedContour $this_poseParts, double t) {
        double d;
        double d2;
        double d3;
        return $this_poseParts.getContour().getClosed() ? (!((d3 = (d2 = t) % (d = 1.0)) == 0.0) && !(Math.signum(d3) == Math.signum(d)) ? d3 + d : d3) : FunctionsKt.doubleClamp(t, 0.0, 1.0);
    }

    private static final void spectralFilter$filterAxis(FFT fft, int $points, Function1<? super Double, Double> $filter, boolean $normalize, float[] input, float[] output) {
        fft.forward(input);
        double power = FFT.magnitudeSum$default(fft, false, 1, null);
        int i = 1;
        int n = $points / 2;
        if (i <= n) {
            while (true) {
                double t = (double)i / (double)($points / 2 - 1);
                double f = ((Number)$filter.invoke((Double)t)).doubleValue();
                fft.scaleBand(i, (float)f);
                if (i == n) break;
                ++i;
            }
        }
        double postPower = RangesKt.coerceAtLeast(FFT.magnitudeSum$default(fft, false, 1, null), 1.0);
        if ($normalize) {
            FFT.scaleAll$default(fft, (float)(power / postPower), false, 2, null);
        }
        fft.inverse(output);
    }
}

