/*
 * Decompiled with CFR 0.152.
 */
package lib;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import lib.ParametricPoseProvider;
import lib.PosePath3D;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.MappingKt;
import org.openrndr.math.Matrix44;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0006H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Llib/NonUniformPosePath3D;", "Llib/ParametricPoseProvider;", "posePath3D", "Llib/PosePath3D;", "walk", "", "", "<init>", "(Llib/PosePath3D;Ljava/util/List;)V", "getPosePath3D", "()Llib/PosePath3D;", "getWalk", "()Ljava/util/List;", "warp", "t", "pose", "Lorg/openrndr/math/Matrix44;", "deminityy"})
public final class NonUniformPosePath3D
implements ParametricPoseProvider {
    @NotNull
    private final PosePath3D posePath3D;
    @NotNull
    private final List<Double> walk;

    public NonUniformPosePath3D(@NotNull PosePath3D posePath3D, @NotNull List<Double> walk) {
        Intrinsics.checkNotNullParameter(posePath3D, "posePath3D");
        Intrinsics.checkNotNullParameter(walk, "walk");
        this.posePath3D = posePath3D;
        this.walk = walk;
    }

    @NotNull
    public final PosePath3D getPosePath3D() {
        return this.posePath3D;
    }

    @NotNull
    public final List<Double> getWalk() {
        return this.walk;
    }

    public final double warp(double t) {
        double d;
        if (t < 0.0) {
            d = ((Number)CollectionsKt.first(this.walk)).doubleValue();
        } else if (t >= 1.0) {
            d = ((Number)CollectionsKt.last(this.walk)).doubleValue();
        } else {
            double t0 = (double)this.walk.size() * t;
            int i0 = RangesKt.coerceIn((int)t0, CollectionsKt.getIndices((Collection)this.walk));
            int i1 = RangesKt.coerceIn(i0 + 1, CollectionsKt.getIndices((Collection)this.walk));
            double f = t0 - (double)i0;
            d = MappingKt.mix(((Number)this.walk.get(i0)).doubleValue(), ((Number)this.walk.get(i1)).doubleValue(), f);
        }
        double rt = d;
        return rt;
    }

    @Override
    @NotNull
    public Matrix44 pose(double t) {
        double rt = this.warp(t);
        return this.posePath3D.pose(rt);
    }
}

