/*
 * Decompiled with CFR 0.152.
 */
package lib;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0012\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B5\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00028\u00000\bj\b\u0012\u0004\u0012\u00028\u0000`\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u000b\u0010\u001f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010 J\u0006\u0010!\u001a\u00020\u0019J\u000e\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0019J\u000e\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u0019J\u000e\u0010&\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u0019J\u000e\u0010'\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0019J\u000e\u0010(\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0019J\u0016\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u0019J\u0018\u0010,\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u0019H\u0002J\u0016\u0010-\u001a\u00028\u00002\u0006\u0010#\u001a\u00020\u0019H\u0086\u0002\u00a2\u0006\u0002\u0010.J\u0011\u0010/\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u0019H\u0086\u0002J\u000e\u0010\u0016\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u0019R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00028\u00000\bj\b\u0012\u0004\u0012\u00028\u0000`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u001e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00060"}, d2={"Llib/Heap;", "T", "", "data", "", "maxHeap", "", "cmp", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "<init>", "(Ljava/util/List;ZLjava/util/Comparator;)V", "getData", "()Ljava/util/List;", "getMaxHeap", "()Z", "getCmp", "()Ljava/util/Comparator;", "heap", "", "getHeap", "()[I", "heapPos", "getHeapPos", "value", "", "heapItemCount", "getHeapItemCount", "()I", "build", "", "peek", "()Ljava/lang/Object;", "pop", "heapOrder", "ix", "itemMoveUp", "id", "itemMoveDown", "heapMoveUp", "heapMoveDown", "notInOrder", "ix1", "ix2", "swapItems", "get", "(I)Ljava/lang/Object;", "contains", "deminityy"})
@SourceDebugExtension(value={"SMAP\nHeap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Heap.kt\nlib/Heap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1#2:121\n*E\n"})
public final class Heap<T> {
    @NotNull
    private final List<T> data;
    private final boolean maxHeap;
    @NotNull
    private final Comparator<T> cmp;
    @NotNull
    private final int[] heap;
    @NotNull
    private final int[] heapPos;
    private int heapItemCount;

    public Heap(@NotNull List<? extends T> data, boolean maxHeap, @NotNull Comparator<T> cmp) {
        Intrinsics.checkNotNullParameter(data, "data");
        Intrinsics.checkNotNullParameter(cmp, "cmp");
        this.data = data;
        this.maxHeap = maxHeap;
        this.cmp = cmp;
        this.heap = new int[this.data.size() + 1];
        this.heapPos = new int[this.data.size()];
        this.heapItemCount = this.data.size();
    }

    @NotNull
    public final List<T> getData() {
        return this.data;
    }

    public final boolean getMaxHeap() {
        return this.maxHeap;
    }

    @NotNull
    public final Comparator<T> getCmp() {
        return this.cmp;
    }

    @NotNull
    public final int[] getHeap() {
        return this.heap;
    }

    @NotNull
    public final int[] getHeapPos() {
        return this.heapPos;
    }

    public final int getHeapItemCount() {
        return this.heapItemCount;
    }

    public final void build() {
        int i;
        int n = ((Collection)this.data).size();
        for (i = 0; i < n; ++i) {
            this.heapPos[i] = i + 1;
        }
        i = 1;
        n = this.data.size();
        if (i <= n) {
            while (true) {
                this.heap[i] = i - 1;
                if (i == n) break;
                ++i;
            }
        }
        for (int ix = this.heapItemCount / 2; 0 < ix; --ix) {
            this.heapMoveDown(ix);
        }
    }

    public final T peek() {
        if (!(this.heapItemCount >= 1)) {
            boolean bl = false;
            String string = "heap is empty";
            throw new IllegalArgumentException(string.toString());
        }
        return this.data.get(this.heap[1]);
    }

    public final int pop() {
        if (!(this.heapItemCount >= 1)) {
            boolean bl = false;
            String string = "heap is empty";
            throw new IllegalArgumentException(string.toString());
        }
        int top = this.heap[1];
        this.swapItems(1, this.heapItemCount);
        int n = this.heapItemCount;
        this.heapItemCount = n + -1;
        this.heapMoveDown(1);
        return top;
    }

    public final boolean heapOrder(int ix) {
        if (ix > this.heapItemCount) {
            return false;
        }
        if (this.heapMoveUp(ix)) {
            return true;
        }
        return this.heapMoveDown(ix);
    }

    public final boolean itemMoveUp(int id) {
        int ix = this.heapPos[id];
        return this.heapMoveUp(ix);
    }

    public final boolean itemMoveDown(int id) {
        int ix = this.heapPos[id];
        return this.heapMoveDown(ix);
    }

    public final boolean heapMoveUp(int ix) {
        int parent;
        int ix2;
        int org = ix2 = ix;
        while (ix2 >= 2 && this.notInOrder(parent = ix2 / 2, ix2)) {
            this.swapItems(parent, ix2);
            ix2 = parent;
        }
        return ix2 != org;
    }

    public final boolean heapMoveDown(int ix) {
        int ix2;
        int org = ix2 = ix;
        int child = ix2 * 2;
        while (child + 1 <= this.heapItemCount) {
            if (this.notInOrder(child, child + 1)) {
                ++child;
            }
            if (!this.notInOrder(ix2, child)) {
                return ix2 != org;
            }
            this.swapItems(ix2, child);
            ix2 = child;
            child = ix2 * 2;
        }
        if (child <= this.heapItemCount && this.notInOrder(ix2, child)) {
            this.swapItems(ix2, child);
            return true;
        }
        return ix2 != org;
    }

    public final boolean notInOrder(int ix1, int ix2) {
        int c2 = this.cmp.compare(this.data.get(this.heap[ix1]), this.data.get(this.heap[ix2]));
        return this.maxHeap ? c2 < 0 : c2 > 0;
    }

    private final void swapItems(int ix1, int ix2) {
        int t = this.heap[ix1];
        this.heap[ix1] = this.heap[ix2];
        this.heap[ix2] = t;
        this.heapPos[this.heap[ix1]] = ix1;
        this.heapPos[this.heap[ix2]] = ix2;
    }

    public final T get(int ix) {
        if (!(ix >= 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(ix <= this.heapItemCount)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.data.get(this.heap[ix]);
    }

    public final boolean contains(int id) {
        if (!(id >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.heapPos[id] <= this.heapItemCount;
    }

    public final int heapPos(int id) {
        int position = this.heapPos[id];
        if (!(position <= this.heapItemCount)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return position;
    }
}

