/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.AbstractJsonLexerKt;
import kotlinx.serialization.json.internal.StringJsonLexer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0006\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0007H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lkotlinx/serialization/json/internal/StringJsonLexerWithComments;", "Lkotlinx/serialization/json/internal/StringJsonLexer;", "source", "", "<init>", "(Ljava/lang/String;)V", "consumeNextToken", "", "canConsumeValue", "", "", "expected", "", "peekNextToken", "skipWhitespaces", "", "kotlinx-serialization-json"})
@SourceDebugExtension(value={"SMAP\nCommentLexers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommentLexers.kt\nkotlinx/serialization/json/internal/StringJsonLexerWithComments\n+ 2 AbstractJsonLexer.kt\nkotlinx/serialization/json/internal/AbstractJsonLexer\n*L\n1#1,219:1\n158#2:220\n*S KotlinDebug\n*F\n+ 1 CommentLexers.kt\nkotlinx/serialization/json/internal/StringJsonLexerWithComments\n*L\n66#1:220\n*E\n"})
public final class StringJsonLexerWithComments
extends StringJsonLexer {
    public StringJsonLexerWithComments(@NotNull String source) {
        Intrinsics.checkNotNullParameter(source, "source");
        super(source);
    }

    @Override
    public byte consumeNextToken() {
        String source = this.getSource();
        int cpos = this.skipWhitespaces();
        if (cpos >= source.length() || cpos == -1) {
            return 10;
        }
        this.currentPosition = cpos + 1;
        return AbstractJsonLexerKt.charToTokenClass(source.charAt(cpos));
    }

    @Override
    public boolean canConsumeValue() {
        int current = this.skipWhitespaces();
        if (current >= this.getSource().length() || current == -1) {
            return false;
        }
        return this.isValidValueStart(this.getSource().charAt(current));
    }

    @Override
    public void consumeNextToken(char expected) {
        String source = this.getSource();
        int current = this.skipWhitespaces();
        if (current >= source.length() || current == -1) {
            this.currentPosition = -1;
            this.unexpectedToken(expected);
        }
        char c2 = source.charAt(current);
        this.currentPosition = current + 1;
        if (c2 == expected) {
            return;
        }
        this.unexpectedToken(expected);
    }

    @Override
    public byte peekNextToken() {
        String source = this.getSource();
        int cpos = this.skipWhitespaces();
        if (cpos >= source.length() || cpos == -1) {
            return 10;
        }
        this.currentPosition = cpos;
        return AbstractJsonLexerKt.charToTokenClass(source.charAt(cpos));
    }

    @Override
    public int skipWhitespaces() {
        int current = this.currentPosition;
        if (current == -1) {
            return current;
        }
        String source = this.getSource();
        block4: while (current < source.length()) {
            char c2 = source.charAt(current);
            AbstractJsonLexer abstractJsonLexer = this;
            char $this$isWs$iv = c2;
            boolean $i$f$isWs = false;
            if ($this$isWs$iv == ' ' || $this$isWs$iv == '\n' || $this$isWs$iv == '\r' || $this$isWs$iv == '\t') {
                ++current;
                continue;
            }
            if (c2 != '/' || current + 1 >= source.length()) break;
            switch (source.charAt(current + 1)) {
                case '/': {
                    current = StringsKt.indexOf$default((CharSequence)source, '\n', current + 2, false, 4, null);
                    if (current == -1) {
                        current = source.length();
                        continue block4;
                    }
                    ++current;
                    continue block4;
                }
                case '*': {
                    current = StringsKt.indexOf$default((CharSequence)source, "*/", current + 2, false, 4, null);
                    if (current == -1) {
                        this.currentPosition = source.length();
                        AbstractJsonLexer.fail$default(this, "Expected end of the block comment: \"*/\", but had EOF instead", 0, null, 6, null);
                        throw new KotlinNothingValueException();
                    }
                    current += 2;
                    continue block4;
                }
            }
            break;
        }
        this.currentPosition = current;
        return current;
    }
}

