/*
 * Decompiled with CFR 0.152.
 */
package demo.view.renderers;

import demo.model.Layer;
import demo.view.AssetLoader;
import demo.view.IObjectView;
import demo.view.LayerRenderer;
import demo.view.ObjectView;
import demo.view.renderers.ShapeRendererBase;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferKt;
import org.openrndr.draw.VertexFormat;
import org.openrndr.draw.VertexFormatKt;
import org.openrndr.extra.composition.Composition;
import org.openrndr.extra.composition.ShapeNode;
import org.openrndr.extra.shapes.path3d.Path3DExtensionsKt;
import org.openrndr.extra.shapes.rectify.RectifiedPath3D;
import org.openrndr.extra.svg.SVGLoaderKt;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.transforms.TransformBuilder;
import org.openrndr.math.transforms.TransformBuilderKt;
import org.openrndr.shape.Path3D;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeContour;
import org.openrndr.shape.ShapeTopology;
import org.openrndr.shape.Triangle;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bR\u00020\fH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldemo/view/renderers/Svg3dRenderer;", "Ldemo/view/renderers/ShapeRendererBase;", "<init>", "()V", "compositionDraws3D", "Ldemo/view/AssetLoader;", "", "Ldemo/view/renderers/Svg3dRenderer$ObjectDraw3D;", "draw", "", "objectContext", "Ldemo/view/LayerRenderer$ObjectContext;", "Ldemo/view/LayerRenderer;", "ObjectDraw3D", "ObjectPath3D", "deminityy"})
@SourceDebugExtension(value={"SMAP\nSvg3dRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Svg3dRenderer.kt\ndemo/view/renderers/Svg3dRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n1567#2:137\n1598#2,3:138\n1557#2:141\n1628#2,3:142\n1601#2:145\n*S KotlinDebug\n*F\n+ 1 Svg3dRenderer.kt\ndemo/view/renderers/Svg3dRenderer\n*L\n34#1:137\n34#1:138,3\n36#1:141\n36#1:142,3\n34#1:145\n*E\n"})
public final class Svg3dRenderer
extends ShapeRendererBase {
    @NotNull
    private final AssetLoader<List<ObjectDraw3D>> compositionDraws3D = new AssetLoader(this.getProgram(), this.getDemo().getAssetPath(), CollectionsKt.emptyList(), null, Svg3dRenderer::compositionDraws3D$lambda$4, 8, null);

    @Override
    public void draw(@NotNull LayerRenderer.ObjectContext objectContext) {
        List<ObjectDraw3D> list;
        Intrinsics.checkNotNullParameter(objectContext, "objectContext");
        Layer layer = objectContext.getLayerView().getLayer();
        Layer.Object obj = objectContext.getObj();
        double ot = objectContext.getObjectTime();
        IObjectView iObjectView = objectContext.getObjectView();
        Intrinsics.checkNotNull(iObjectView, "null cannot be cast to non-null type demo.view.ObjectView");
        ObjectView.Animation animation = ((ObjectView)iObjectView).getAnimation();
        double strokeGain = switch (WhenMappings.$EnumSwitchMapping$0[layer.getCamera().type().ordinal()]) {
            case 1 -> 1.0;
            case 2 -> 256.0;
            default -> throw new NoWhenBranchMatchedException();
        };
        String string = obj.getType();
        if (Intrinsics.areEqual(string, "svg-3d")) {
            String string2 = objectContext.getAssetName();
            Intrinsics.checkNotNull(string2);
            list = this.compositionDraws3D.get(string2);
        } else if (Intrinsics.areEqual(string, "svg-path-3d")) {
            list = CollectionsKt.emptyList();
        } else {
            throw new IllegalStateException("not implemented".toString());
        }
        List<ObjectDraw3D> objectDraws = list;
        for (ObjectDraw3D objectDraw : objectDraws) {
            DrawerKt.isolated(this.getDrawer(), arg_0 -> Svg3dRenderer.draw$lambda$6(animation, ot, obj, this, objectDraw, objectContext, strokeGain, arg_0));
        }
    }

    private static final Unit compositionDraws3D$lambda$4$lambda$3$lambda$1(VertexFormat $this$vertexFormat) {
        Intrinsics.checkNotNullParameter($this$vertexFormat, "$this$vertexFormat");
        $this$vertexFormat.position(3);
        VertexFormat.textureCoordinate$default($this$vertexFormat, 2, 0, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit compositionDraws3D$lambda$4$lambda$3$lambda$2(List $triangles, BufferWriter $this$put) {
        Intrinsics.checkNotNullParameter($this$put, "$this$put");
        for (Triangle triangle : $triangles) {
            $this$put.write(triangle.getX1().xy0());
            $this$put.write(triangle.getX1().div(new Vector2(1280.0, 720.0)));
            $this$put.write(triangle.getX2().xy0());
            $this$put.write(triangle.getX2().div(new Vector2(1280.0, 720.0)));
            $this$put.write(triangle.getX3().xy0());
            $this$put.write(triangle.getX3().div(new Vector2(1280.0, 720.0)));
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final List compositionDraws3D$lambda$4(File file, String string) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(string, "<unused var>");
        Composition composition = SVGLoaderKt.loadSVG(file);
        int contourIndex = 0;
        Iterable $this$mapIndexed$iv = composition.findShapes();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void shapeIndex;
            VertexBuffer vertexBuffer;
            void $this$mapTo$iv$iv;
            void shape;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ShapeNode shapeNode = (ShapeNode)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ShapeNode flattened = ShapeNode.flatten$default((ShapeNode)shape, null, 1, null);
            Iterable $this$map$iv = flattened.getShape().getContours();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void contour;
                ShapeContour shapeContour = (ShapeContour)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                Path3D path = Path3DExtensionsKt.toPath3D((ShapeContour)contour);
                ++contourIndex;
                collection2.add(new ObjectPath3D(shape.getEffectiveStroke(), shape.getEffectiveStrokeWeight(), org.openrndr.extra.shapes.rectify.Path3DExtensionsKt.rectified$default(path, 0.0, 0.0, 3, null)));
            }
            List paths = (List)destination$iv$iv2;
            if (shape.getShape().getTopology() != ShapeTopology.OPEN) {
                Shape fixedShape = flattened.getShape();
                List<Triangle> triangles = fixedShape.getTriangulation();
                VertexBuffer vb = VertexBufferKt.vertexBuffer$default(VertexFormatKt.vertexFormat$default(null, Svg3dRenderer::compositionDraws3D$lambda$4$lambda$3$lambda$1, 1, null), triangles.size() * 3, null, 4, null);
                VertexBuffer.put$default(vb, 0, arg_0 -> Svg3dRenderer.compositionDraws3D$lambda$4$lambda$3$lambda$2(triangles, arg_0), 1, null);
                vertexBuffer = vb;
            } else {
                vertexBuffer = null;
            }
            VertexBuffer triangulation = vertexBuffer;
            collection.add(new ObjectDraw3D((int)shapeIndex, shape.getEffectiveFill(), triangulation, paths));
        }
        return (List)destination$iv$iv;
    }

    private static final Unit draw$lambda$6$lambda$5(TransformBuilder $this$buildTransform) {
        Intrinsics.checkNotNullParameter($this$buildTransform, "$this$buildTransform");
        $this$buildTransform.scale(1.0, -1.0, 1.0);
        TransformBuilder.translate$default($this$buildTransform, -640.0, -360.0, 0.0, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit draw$lambda$6(ObjectView.Animation $animation, double $ot, Layer.Object $obj, Svg3dRenderer this$0, ObjectDraw3D $objectDraw, LayerRenderer.ObjectContext $objectContext, double $strokeGain, Drawer $this$isolated) {
        Intrinsics.checkNotNullParameter($this$isolated, "$this$isolated");
        Matrix44 modelTransform = Matrix44.Companion.getIDENTITY();
        modelTransform = modelTransform.times($animation.transform($ot));
        if (!Intrinsics.areEqual($obj.getType(), "svg-path-3d")) {
            modelTransform = modelTransform.times(TransformBuilderKt.buildTransform$default(null, Svg3dRenderer::draw$lambda$6$lambda$5, 1, null));
        }
        Drawer drawer = this$0.getDrawer();
        drawer.setModel(drawer.getModel().times(modelTransform));
        if ($objectDraw.getTriangulation() != null) {
            this$0.getDrawer().setStroke(null);
            this$0.getDrawer().setFill(this$0.fill($obj, $objectDraw.getFill(), $animation, $ot));
            if (this$0.getDrawer().getFill() != null) {
                ColorRGBa colorRGBa = this$0.getDrawer().getFill();
                double d = colorRGBa != null ? colorRGBa.getAlpha() : 0.0;
                if (d > 0.0) {
                    Drawer.vertexBuffer$default(this$0.getDrawer(), $objectDraw.getTriangulation(), DrawPrimitive.TRIANGLES, 0, 0, 12, null);
                }
            }
        }
        for (ObjectPath3D objectPath : $objectDraw.getPaths()) {
            Path3D drawPath = ((Number)$objectContext.getFunctions().getC0().invoke($ot)).doubleValue() == 0.0 && ((Number)$objectContext.getFunctions().getC1().invoke($ot)).doubleValue() == 1.0 ? objectPath.getPath3D().getPath() : objectPath.getPath3D().sub(((Number)$objectContext.getFunctions().getC0().invoke($ot)).doubleValue(), ((Number)$objectContext.getFunctions().getC1().invoke($ot)).doubleValue());
            this$0.getDrawer().setStroke(this$0.stroke($obj, objectPath.getStroke(), $animation, $ot));
            this$0.getDrawer().setStrokeWeight(this$0.strokeWeight($obj, objectPath.getStrokeWeight(), $objectContext, $ot) * $strokeGain);
            this$0.getDrawer().setFill(null);
            this$0.getDrawer().path(drawPath);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Ldemo/view/renderers/Svg3dRenderer$ObjectDraw3D;", "", "shapeIndex", "", "fill", "Lorg/openrndr/color/ColorRGBa;", "triangulation", "Lorg/openrndr/draw/VertexBuffer;", "paths", "", "Ldemo/view/renderers/Svg3dRenderer$ObjectPath3D;", "<init>", "(ILorg/openrndr/color/ColorRGBa;Lorg/openrndr/draw/VertexBuffer;Ljava/util/List;)V", "getShapeIndex", "()I", "getFill", "()Lorg/openrndr/color/ColorRGBa;", "getTriangulation", "()Lorg/openrndr/draw/VertexBuffer;", "getPaths", "()Ljava/util/List;", "deminityy"})
    private static final class ObjectDraw3D {
        private final int shapeIndex;
        @Nullable
        private final ColorRGBa fill;
        @Nullable
        private final VertexBuffer triangulation;
        @NotNull
        private final List<ObjectPath3D> paths;

        public ObjectDraw3D(int shapeIndex, @Nullable ColorRGBa fill, @Nullable VertexBuffer triangulation, @NotNull List<ObjectPath3D> paths) {
            Intrinsics.checkNotNullParameter(paths, "paths");
            this.shapeIndex = shapeIndex;
            this.fill = fill;
            this.triangulation = triangulation;
            this.paths = paths;
        }

        public final int getShapeIndex() {
            return this.shapeIndex;
        }

        @Nullable
        public final ColorRGBa getFill() {
            return this.fill;
        }

        @Nullable
        public final VertexBuffer getTriangulation() {
            return this.triangulation;
        }

        @NotNull
        public final List<ObjectPath3D> getPaths() {
            return this.paths;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Ldemo/view/renderers/Svg3dRenderer$ObjectPath3D;", "", "stroke", "Lorg/openrndr/color/ColorRGBa;", "strokeWeight", "", "path3D", "Lorg/openrndr/extra/shapes/rectify/RectifiedPath3D;", "<init>", "(Lorg/openrndr/color/ColorRGBa;Ljava/lang/Double;Lorg/openrndr/extra/shapes/rectify/RectifiedPath3D;)V", "getStroke", "()Lorg/openrndr/color/ColorRGBa;", "getStrokeWeight", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getPath3D", "()Lorg/openrndr/extra/shapes/rectify/RectifiedPath3D;", "deminityy"})
    private static final class ObjectPath3D {
        @Nullable
        private final ColorRGBa stroke;
        @Nullable
        private final Double strokeWeight;
        @NotNull
        private final RectifiedPath3D path3D;

        public ObjectPath3D(@Nullable ColorRGBa stroke, @Nullable Double strokeWeight, @NotNull RectifiedPath3D path3D) {
            Intrinsics.checkNotNullParameter(path3D, "path3D");
            this.stroke = stroke;
            this.strokeWeight = strokeWeight;
            this.path3D = path3D;
        }

        @Nullable
        public final ColorRGBa getStroke() {
            return this.stroke;
        }

        @Nullable
        public final Double getStrokeWeight() {
            return this.strokeWeight;
        }

        @NotNull
        public final RectifiedPath3D getPath3D() {
            return this.path3D;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Layer.Camera.CameraType.values().length];
            try {
                nArray[Layer.Camera.CameraType.ORTHO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Layer.Camera.CameraType.PERSPECTIVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

