/*
 * Decompiled with CFR 0.152.
 */
package demo.view.objects;

import demo.model.Layer;
import demo.view.IObjectView;
import demo.view.LayerView;
import demo.view.objects.ObjectFunction;
import demo.view.objects.ObjectInputType;
import demo.view.objects.ObjectOutputType;
import demo.view.objects.ObjectTypeName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.koin.core.component.KoinComponent;
import org.openrndr.extra.shapes.rectify.Path3DExtensionsKt;
import org.openrndr.extra.shapes.rectify.RectifiedPath;
import org.openrndr.shape.Path3D;

@ObjectTypeName(name="paths-3d-dash")
@ObjectInputType(type=Path3D.class)
@ObjectOutputType(type=Path3D.class)
@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J&\u0010\u001e\u001a \u0012\u0004\u0012\u00020\u001b\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120 0\u001fH\u0016J\b\u0010!\u001a\u00020\"H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u001a\u001a\u00020\u001bX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006#"}, d2={"Ldemo/view/objects/Paths3dDashObjectView;", "Ldemo/view/IObjectView;", "Lorg/koin/core/component/KoinComponent;", "obj", "Ldemo/model/Layer$Object;", "layerView", "Ldemo/view/LayerView;", "<init>", "(Ldemo/model/Layer$Object;Ldemo/view/LayerView;)V", "getObj", "()Ldemo/model/Layer$Object;", "getLayerView", "()Ldemo/view/LayerView;", "renderable", "", "getRenderable", "()Z", "input", "", "Lorg/openrndr/shape/Path3D;", "x", "", "dashOffset", "dashWidth", "dashSpace", "splitPoints", "outputFunction", "", "getOutputFunction", "()Ljava/lang/String;", "builtInFunctions", "", "Lkotlin/Function1;", "close", "", "deminityy"})
@SourceDebugExtension(value={"SMAP\nPaths3dDashObjectView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Paths3dDashObjectView.kt\ndemo/view/objects/Paths3dDashObjectView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1368#2:111\n1454#2,5:112\n785#2:117\n796#2:118\n1872#2,2:119\n797#2,2:121\n1874#2:123\n799#2:124\n*S KotlinDebug\n*F\n+ 1 Paths3dDashObjectView.kt\ndemo/view/objects/Paths3dDashObjectView\n*L\n102#1:111\n102#1:112,5\n102#1:117\n102#1:118\n102#1:119,2\n102#1:121,2\n102#1:123\n102#1:124\n*E\n"})
public final class Paths3dDashObjectView
extends IObjectView
implements KoinComponent {
    @NotNull
    private final Layer.Object obj;
    @NotNull
    private final LayerView layerView;
    private final boolean renderable;
    @NotNull
    private final String outputFunction;

    public Paths3dDashObjectView(@NotNull Layer.Object obj, @NotNull LayerView layerView) {
        Intrinsics.checkNotNullParameter(obj, "obj");
        Intrinsics.checkNotNullParameter(layerView, "layerView");
        this.obj = obj;
        this.layerView = layerView;
        this.renderable = true;
        this.outputFunction = "dashRectified";
    }

    @Override
    @NotNull
    public Layer.Object getObj() {
        return this.obj;
    }

    @Override
    @NotNull
    public LayerView getLayerView() {
        return this.layerView;
    }

    @Override
    public boolean getRenderable() {
        return this.renderable;
    }

    @ObjectFunction(name="input")
    @NotNull
    public final List<Path3D> input(double x) {
        Function1<Double, Object> function1 = this.getFunctions1().get("input");
        Function1<Double, Object> input = TypeIntrinsics.isFunctionOfArity(function1, 1) ? function1 : null;
        return input == null ? CollectionsKt.emptyList() : (List)input.invoke(x);
    }

    @ObjectFunction(name="dash-offset")
    public final double dashOffset(double x) {
        Function1<Double, Double> function1 = this.getSamplers().get("dash-offset");
        return function1 != null ? ((Number)function1.invoke(x)).doubleValue() : 0.0;
    }

    @ObjectFunction(name="dash-width")
    public final double dashWidth(double x) {
        Function1<Double, Double> function1 = this.getSamplers().get("dash-width");
        return function1 != null ? ((Number)function1.invoke(x)).doubleValue() : 0.02;
    }

    @ObjectFunction(name="dash-space")
    public final double dashSpace(double x) {
        Function1<Double, Double> function1 = this.getSamplers().get("dash-space");
        return function1 != null ? ((Number)function1.invoke(x)).doubleValue() : 0.02;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Double> splitPoints(double x) {
        double d;
        double dw = this.dashWidth(x);
        double totalWidth = this.dashWidth(x) + this.dashSpace(x);
        double d2 = this.dashOffset(x);
        double d3 = d2 % (d = 1.0);
        double o = (!(d3 == 0.0) && !(Math.signum(d3) == Math.signum(d)) ? d3 + d : d3) * totalWidth;
        double count2 = 1.0 / totalWidth;
        int ic = (int)Math.ceil(count2);
        int n = ic * 2;
        ArrayList<Double> arrayList = new ArrayList<Double>(n);
        int n2 = 0;
        while (n2 < n) {
            void it;
            int n3;
            int n4 = n3 = n2++;
            ArrayList<Double> arrayList2 = arrayList;
            boolean bl = false;
            int n5 = ic;
            int n6 = 2;
            int n7 = n5 % n6;
            arrayList2.add(o + (double)(it / 2) * totalWidth + (double)(n7 + (n6 & ((n7 ^ n6) & (n7 | -n7)) >> 31)) * dw);
        }
        List result = arrayList;
        return result;
    }

    @Override
    @NotNull
    protected String getOutputFunction() {
        return this.outputFunction;
    }

    @NotNull
    public Map<String, Function1<Double, List<Path3D>>> builtInFunctions() {
        return MapsKt.mapOf(TuplesKt.to("dashRectified", arg_0 -> Paths3dDashObjectView.builtInFunctions$lambda$3(this, arg_0)));
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - void declaration
     */
    private static final List builtInFunctions$lambda$3(Paths3dDashObjectView this$0, double it) {
        void $this$filterIndexedTo$iv$iv;
        void $this$filterIndexed$iv;
        void $this$flatMapTo$iv$iv;
        List<Double> sp = this$0.splitPoints(it);
        Iterable $this$flatMap$iv = this$0.input(it);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Path3D it2 = (Path3D)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = RectifiedPath.splitAt$default(Path3DExtensionsKt.rectified$default(it2, 1.0E-5, 0.0, 2, null), sp, 0.0, 2, null);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$filterIndexed = false;
        $this$flatMapTo$iv$iv = $this$filterIndexed$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            Path3D path3D = (Path3D)element$iv$iv;
            int index = index$iv$iv;
            boolean bl2 = false;
            int n2 = index;
            int n3 = 2;
            int n4 = n2 % n3;
            if (!(n4 + (n3 & ((n4 ^ n3) & (n4 | -n4)) >> 31) == 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

