/*
 * Decompiled with CFR 0.152.
 */
package demo.view.objects;

import demo.model.Layer;
import demo.view.IObjectView;
import demo.view.LayerView;
import demo.view.objects.ObjectFunction;
import demo.view.objects.ObjectInputType;
import demo.view.objects.ObjectOutputType;
import demo.view.objects.ObjectTypeName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.math.MathKt;
import kotlin.random.RandomKt;
import org.jetbrains.annotations.NotNull;
import org.koin.core.component.KoinComponent;
import org.openrndr.extra.mesh.MeshData;
import org.openrndr.extra.mesh.noise.IMeshDataExtensionsKt;
import org.openrndr.math.Vector3;

@ObjectTypeName(name="meshes-point-sampler")
@ObjectInputType(type=MeshData.class)
@ObjectOutputType(type=Vector3.class)
@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J \u0010\u001d\u001a\u001a\u0012\u0004\u0012\u00020\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020 0\u001f0\u001eH\u0016J\b\u0010!\u001a\u00020\"H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0019\u001a\u00020\u001aX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006#"}, d2={"Ldemo/view/objects/MeshesPointSamplerObjectView;", "Ldemo/view/IObjectView;", "Lorg/koin/core/component/KoinComponent;", "obj", "Ldemo/model/Layer$Object;", "layerView", "Ldemo/view/LayerView;", "<init>", "(Ldemo/model/Layer$Object;Ldemo/view/LayerView;)V", "getObj", "()Ldemo/model/Layer$Object;", "getLayerView", "()Ldemo/view/LayerView;", "renderable", "", "getRenderable", "()Z", "input", "", "Lorg/openrndr/extra/mesh/MeshData;", "x", "", "pointCount", "", "seed", "outputFunction", "", "getOutputFunction", "()Ljava/lang/String;", "builtInFunctions", "", "Lkotlin/Function1;", "", "close", "", "deminityy"})
@SourceDebugExtension(value={"SMAP\nMeshesPointSamplerObjectView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MeshesPointSamplerObjectView.kt\ndemo/view/objects/MeshesPointSamplerObjectView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1368#2:82\n1454#2,5:83\n1368#2:88\n1454#2,5:89\n*S KotlinDebug\n*F\n+ 1 MeshesPointSamplerObjectView.kt\ndemo/view/objects/MeshesPointSamplerObjectView\n*L\n73#1:82\n73#1:83,5\n74#1:88\n74#1:89,5\n*E\n"})
public final class MeshesPointSamplerObjectView
extends IObjectView
implements KoinComponent {
    @NotNull
    private final Layer.Object obj;
    @NotNull
    private final LayerView layerView;
    private final boolean renderable;
    @NotNull
    private final String outputFunction;

    public MeshesPointSamplerObjectView(@NotNull Layer.Object obj, @NotNull LayerView layerView) {
        Intrinsics.checkNotNullParameter(obj, "obj");
        Intrinsics.checkNotNullParameter(layerView, "layerView");
        this.obj = obj;
        this.layerView = layerView;
        this.renderable = true;
        this.outputFunction = "uniform";
    }

    @Override
    @NotNull
    public Layer.Object getObj() {
        return this.obj;
    }

    @Override
    @NotNull
    public LayerView getLayerView() {
        return this.layerView;
    }

    @Override
    public boolean getRenderable() {
        return this.renderable;
    }

    private final List<MeshData> input(double x) {
        Function1<Double, Object> function1 = this.getFunctions1().get("input");
        Function1<Double, Object> input = TypeIntrinsics.isFunctionOfArity(function1, 1) ? function1 : null;
        return input == null ? CollectionsKt.emptyList() : (List)input.invoke(x);
    }

    @ObjectFunction(name="point-count")
    public final int pointCount(double x) {
        Function1<Double, Double> function1 = this.getSamplers().get("point-count");
        return MathKt.roundToInt(function1 != null ? ((Number)function1.invoke(x)).doubleValue() : 100.0);
    }

    @ObjectFunction(name="seed")
    public final int seed(double x) {
        Function1<Double, Double> function1 = this.getSamplers().get("seed");
        return MathKt.roundToInt(function1 != null ? ((Number)function1.invoke(x)).doubleValue() : 0.0);
    }

    @Override
    @NotNull
    protected String getOutputFunction() {
        return this.outputFunction;
    }

    @Override
    @NotNull
    public Map<String, Function1<Double, Object>> builtInFunctions() {
        Pair[] pairArray = new Pair[]{TuplesKt.to("positions", arg_0 -> MeshesPointSamplerObjectView.builtInFunctions$lambda$1(this, arg_0)), TuplesKt.to("uniform", arg_0 -> MeshesPointSamplerObjectView.builtInFunctions$lambda$3(this, arg_0))};
        return MapsKt.mapOf(pairArray);
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - void declaration
     */
    private static final List builtInFunctions$lambda$1(MeshesPointSamplerObjectView this$0, double x) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this$0.input(x);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            MeshData it = (MeshData)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.vertexData().getPositions();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List builtInFunctions$lambda$3(MeshesPointSamplerObjectView this$0, double x) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this$0.input(x);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            MeshData it = (MeshData)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = IMeshDataExtensionsKt.uniform(it, this$0.pointCount(x), RandomKt.Random(this$0.seed(x)));
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

