/*
 * Decompiled with CFR 0.152.
 */
package demo.view.loaders;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.databind.CBORMapper;
import demo.model.Demo;
import demo.view.loaders.DatasetLoaderKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\f*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\rH\u0002J\f\u0010\u000b\u001a\u00020\u0001*\u00020\u000eH\u0002J\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\fj\u0002`\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Ldemo/view/loaders/DatasetLoader;", "", "demo", "Ldemo/model/Demo;", "<init>", "(Ldemo/model/Demo;)V", "getDemo", "()Ldemo/model/Demo;", "datasets", "", "", "function", "Lkotlin/Function1;", "", "Lkotlinx/serialization/json/JsonElement;", "environment", "Ldemo/view/EnvironmentFunction;", "getEnvironment", "()Lkotlin/jvm/functions/Function1;", "environment$delegate", "Lkotlin/Lazy;", "loadDatasets", "", "deminityy"})
@SourceDebugExtension(value={"SMAP\nDatasetLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatasetLoader.kt\ndemo/view/loaders/DatasetLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,83:1\n1557#2:84\n1628#2,3:85\n1863#2,2:91\n1863#2,2:96\n1557#2:98\n1628#2,3:99\n3829#3:88\n4344#3,2:89\n3829#3:93\n4344#3,2:94\n*S KotlinDebug\n*F\n+ 1 DatasetLoader.kt\ndemo/view/loaders/DatasetLoader\n*L\n42#1:84\n42#1:85,3\n69#1:91,2\n74#1:96,2\n21#1:98\n21#1:99,3\n69#1:88\n69#1:89,2\n74#1:93\n74#1:94,2\n*E\n"})
public final class DatasetLoader {
    @NotNull
    private final Demo demo;
    @NotNull
    private final Map<String, Object> datasets;
    @NotNull
    private final Lazy environment$delegate;

    public DatasetLoader(@NotNull Demo demo) {
        Intrinsics.checkNotNullParameter(demo, "demo");
        this.demo = demo;
        this.datasets = new LinkedHashMap();
        this.environment$delegate = LazyKt.lazy(() -> DatasetLoader.environment_delegate$lambda$5(this));
    }

    @NotNull
    public final Demo getDemo() {
        return this.demo;
    }

    private final Function1<String, Object> function(Map<?, ?> $this$function) {
        return arg_0 -> DatasetLoader.function$lambda$1($this$function, this, arg_0);
    }

    /*
     * WARNING - void declaration
     */
    private final Object function(JsonElement $this$function) {
        Object object;
        JsonElement obj = $this$function;
        JsonElement jsonElement = $this$function;
        if (jsonElement instanceof JsonPrimitive) {
            object = ((JsonPrimitive)$this$function).isString() ? ((JsonPrimitive)$this$function).getContent() : Double.valueOf(JsonElementKt.getDouble((JsonPrimitive)$this$function));
        } else if (jsonElement instanceof JsonArray) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)((Object)$this$function);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JsonElement jsonElement2 = (JsonElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.function((JsonElement)it));
            }
            object = (List)destination$iv$iv;
        } else if (jsonElement instanceof JsonObject) {
            object = arg_0 -> DatasetLoader.function$lambda$3(obj, this, arg_0);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @NotNull
    public final Function1<String, Object> getEnvironment() {
        Lazy lazy = this.environment$delegate;
        return (Function1)lazy.getValue();
    }

    public final void loadDatasets() {
        block6: {
            int n;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            File it;
            File element$iv$iv;
            File[] $this$filterTo$iv$iv;
            boolean $i$f$filterTo;
            Collection destination$iv$iv;
            boolean $i$f$filter;
            File[] $this$filter$iv;
            File datasetsDir = new File(this.demo.getDataBase(), "datasets");
            if (!datasetsDir.exists()) {
                return;
            }
            File[] fileArray = datasetsDir.listFiles();
            if (fileArray != null) {
                $this$filter$iv = fileArray;
                $i$f$filter = false;
                File[] fileArray2 = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                int n2 = $this$filterTo$iv$iv.length;
                for (int i = 0; i < n2; ++i) {
                    it = element$iv$iv = $this$filterTo$iv$iv[i];
                    boolean bl = false;
                    Intrinsics.checkNotNull(it);
                    if (!Intrinsics.areEqual(FilesKt.getExtension(it), "json")) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$forEach$iv = (List)destination$iv$iv;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File it2 = (File)element$iv;
                    n = 0;
                    DatasetLoaderKt.access$getLogger$p().info(() -> DatasetLoader.loadDatasets$lambda$8$lambda$7(it2));
                    Intrinsics.checkNotNull(it2);
                    JsonElement jsonObject = Json.Default.parseToJsonElement(FilesKt.readText$default(it2, null, 1, null));
                    this.datasets.put(FilesKt.getNameWithoutExtension(it2), jsonObject);
                }
            }
            File[] fileArray3 = datasetsDir.listFiles();
            if (fileArray3 == null) break block6;
            $this$filter$iv = fileArray3;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            int jsonObject = $this$filterTo$iv$iv.length;
            for (n = 0; n < jsonObject; ++n) {
                it = element$iv$iv = $this$filterTo$iv$iv[n];
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                if (!Intrinsics.areEqual(FilesKt.getExtension(it), "cbor")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$forEach$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object cborObject;
                File it3 = (File)element$iv;
                boolean bl = false;
                DatasetLoaderKt.access$getLogger$p().info(() -> DatasetLoader.loadDatasets$lambda$11$lambda$10(it3));
                ObjectMapper mapper = new CBORMapper();
                Intrinsics.checkNotNull(it3);
                Intrinsics.checkNotNullExpressionValue(mapper.readValue(FilesKt.readBytes(it3), Object.class), "readValue(...)");
                this.datasets.put(FilesKt.getNameWithoutExtension(it3), cborObject);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Object function$lambda$1(Map<?, ?> $this_function, DatasetLoader this$0, String n) {
        Object object;
        Object o = $this_function.get(n);
        Object obj = o;
        if (obj instanceof Map) {
            object = this$0.function((Map)o);
        } else if (obj instanceof List) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)o;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it instanceof Map ? this$0.function((Map)it) : it);
            }
            object = (List)destination$iv$iv;
        } else {
            object = o;
        }
        return object;
    }

    private static final Object function$lambda$3(JsonElement $obj, DatasetLoader this$0, String n) {
        Intrinsics.checkNotNullParameter(n, "n");
        JsonElement jsonElement = $obj;
        Intrinsics.checkNotNull(jsonElement, "null cannot be cast to non-null type kotlinx.serialization.json.JsonObject");
        JsonElement jsonElement2 = (JsonElement)((JsonObject)jsonElement).get((Object)n);
        return jsonElement2 != null ? this$0.function(jsonElement2) : null;
    }

    private static final Object environment_delegate$lambda$5$lambda$4(DatasetLoader this$0, String property) {
        Object set = this$0.datasets.get(property);
        Object object = set;
        return object instanceof Map ? this$0.function((Map)set) : (object instanceof JsonElement ? this$0.function((JsonElement)set) : set);
    }

    private static final Function1 environment_delegate$lambda$5(DatasetLoader this$0) {
        return arg_0 -> DatasetLoader.environment_delegate$lambda$5$lambda$4(this$0, arg_0);
    }

    private static final Object loadDatasets$lambda$8$lambda$7(File $it) {
        return "loading data set " + $it.getPath();
    }

    private static final Object loadDatasets$lambda$11$lambda$10(File $it) {
        return "loading data set " + $it.getPath();
    }
}

