/*
 * Decompiled with CFR 0.152.
 */
package demo.view;

import demo.model.Demo;
import demo.model.Layer;
import demo.services.LayerWatcherService;
import demo.view.DemoController;
import demo.view.IObjectView;
import demo.view.LayerRenderer;
import demo.view.LayerView;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import lib.EfcurveKt;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;
import org.openrndr.Program;
import org.openrndr.color.AlgebraicColor;
import org.openrndr.color.ColorHSLa;
import org.openrndr.color.ColorHSVa;
import org.openrndr.color.ColorLABa;
import org.openrndr.color.ColorLCHABa;
import org.openrndr.color.ColorLCHUVa;
import org.openrndr.color.ColorLUVa;
import org.openrndr.color.ColorModel;
import org.openrndr.color.ColorRGBa;
import org.openrndr.color.ColorXSLa;
import org.openrndr.color.ColorXSVa;
import org.openrndr.color.ColorXYZa;
import org.openrndr.color.ConvertibleToColorRGBa;
import org.openrndr.color.HueShiftableColor;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.RectangleBatchBuilder;
import org.openrndr.draw.RenderTarget;
import org.openrndr.extra.color.presets.ColorsKt;
import org.openrndr.extra.color.spaces.ColorHPLUVa;
import org.openrndr.extra.color.spaces.ColorHPLUVaKt;
import org.openrndr.extra.color.spaces.ColorHSLUVa;
import org.openrndr.extra.color.spaces.ColorHSLUVaKt;
import org.openrndr.extra.color.spaces.ColorOKHSLa;
import org.openrndr.extra.color.spaces.ColorOKHSLaKt;
import org.openrndr.extra.color.spaces.ColorOKHSVa;
import org.openrndr.extra.color.spaces.ColorOKHSVaKt;
import org.openrndr.extra.color.spaces.ColorOKLABa;
import org.openrndr.extra.color.spaces.ColorOKLABaKt;
import org.openrndr.extra.color.spaces.ColorOKLCHa;
import org.openrndr.extra.color.spaces.ColorOKLCHaKt;
import org.openrndr.extra.color.spaces.ColorXSLUVa;
import org.openrndr.extra.color.spaces.ColorXSLUVaKt;
import org.openrndr.extra.color.tools.ColorRGBaExtensionsKt;
import org.openrndr.extra.fcurve.FCurve;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;
import org.openrndr.math.transforms.TransformsKt;
import org.openrndr.shape.Rectangle;
import org.openrndr.shape.RectangleKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010(\u001a\u00020)J\u0016\u0010-\u001a\u00020%2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020%J\u000e\u00101\u001a\u0002022\u0006\u00103\u001a\u00020)R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\t\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\t\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\t\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010*\u001a\u00020)X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u00064"}, d2={"Ldemo/view/UIRenderer;", "Lorg/koin/core/component/KoinComponent;", "<init>", "()V", "program", "Lorg/openrndr/Program;", "getProgram", "()Lorg/openrndr/Program;", "program$delegate", "Lkotlin/Lazy;", "demo", "Ldemo/model/Demo;", "getDemo", "()Ldemo/model/Demo;", "demo$delegate", "demoController", "Ldemo/view/DemoController;", "getDemoController", "()Ldemo/view/DemoController;", "demoController$delegate", "layerWatcherService", "Ldemo/services/LayerWatcherService;", "getLayerWatcherService", "()Ldemo/services/LayerWatcherService;", "layerWatcherService$delegate", "layerRenderer", "Ldemo/view/LayerRenderer;", "getLayerRenderer", "()Ldemo/view/LayerRenderer;", "layerRenderer$delegate", "showFCurves", "", "getShowFCurves", "()Z", "setShowFCurves", "(Z)V", "viewBounds", "Lorg/openrndr/shape/Rectangle;", "getViewBounds", "()Lorg/openrndr/shape/Rectangle;", "timeScale", "", "layerLabelWidth", "getLayerLabelWidth", "()D", "project", "view", "Lorg/openrndr/math/Matrix44;", "rectangle", "renderUI", "", "time", "deminityy"})
@SourceDebugExtension(value={"SMAP\nUIRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UIRenderer.kt\ndemo/view/UIRenderer\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n+ 3 ColorRGBaExtensions.kt\norg/openrndr/extra/color/tools/ColorRGBaExtensionsKt\n*L\n1#1,273:1\n58#2,6:274\n58#2,6:280\n58#2,6:286\n58#2,6:292\n58#2,6:298\n187#3:304\n66#3,22:305\n*S KotlinDebug\n*F\n+ 1 UIRenderer.kt\ndemo/view/UIRenderer\n*L\n24#1:274,6\n25#1:280,6\n26#1:286,6\n27#1:292,6\n28#1:298,6\n151#1:304\n151#1:305,22\n*E\n"})
public final class UIRenderer
implements KoinComponent {
    @NotNull
    private final Lazy program$delegate;
    @NotNull
    private final Lazy demo$delegate;
    @NotNull
    private final Lazy demoController$delegate;
    @NotNull
    private final Lazy layerWatcherService$delegate;
    @NotNull
    private final Lazy layerRenderer$delegate;
    private boolean showFCurves;
    private final double layerLabelWidth;

    public UIRenderer() {
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.program$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<Program>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final Program invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(Program.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(Program.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.demo$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<Demo>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final Demo invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(Demo.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(Demo.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.demoController$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<DemoController>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final DemoController invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(DemoController.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(DemoController.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.layerWatcherService$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<LayerWatcherService>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final LayerWatcherService invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(LayerWatcherService.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(LayerWatcherService.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.layerRenderer$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<LayerRenderer>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final LayerRenderer invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(LayerRenderer.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(LayerRenderer.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        this.layerLabelWidth = 200.0;
    }

    private final Program getProgram() {
        Lazy lazy = this.program$delegate;
        return (Program)lazy.getValue();
    }

    private final Demo getDemo() {
        Lazy lazy = this.demo$delegate;
        return (Demo)lazy.getValue();
    }

    private final DemoController getDemoController() {
        Lazy lazy = this.demoController$delegate;
        return (DemoController)lazy.getValue();
    }

    private final LayerWatcherService getLayerWatcherService() {
        Lazy lazy = this.layerWatcherService$delegate;
        return (LayerWatcherService)lazy.getValue();
    }

    private final LayerRenderer getLayerRenderer() {
        Lazy lazy = this.layerRenderer$delegate;
        return (LayerRenderer)lazy.getValue();
    }

    public final boolean getShowFCurves() {
        return this.showFCurves;
    }

    public final void setShowFCurves(boolean bl) {
        this.showFCurves = bl;
    }

    private final Rectangle getViewBounds() {
        Matrix44 vi = this.getProgram().getDrawer().getView().times(this.getProgram().getDrawer().getModel()).inversed();
        Vector4 tl = vi.times(new Vector4(0.0, 0.0, 0.0, 1.0));
        Vector4 br = vi.times(new Vector4((double)RenderTarget.Companion.getActive().getWidth() - 0.0, (double)RenderTarget.Companion.getActive().getHeight() - 0.0, 0.0, 1.0));
        return new Rectangle(tl.xy(), br.x() - tl.x(), br.y() - tl.y());
    }

    public final double timeScale() {
        return ((double)RenderTarget.Companion.getActive().getWidth() - 210.0) / this.getDemo().getDuration() / this.getDemo().getTimeScale();
    }

    public final double getLayerLabelWidth() {
        return this.layerLabelWidth;
    }

    @NotNull
    public final Rectangle project(@NotNull Matrix44 view, @NotNull Rectangle rectangle) {
        Intrinsics.checkNotNullParameter(view, "view");
        Intrinsics.checkNotNullParameter(rectangle, "rectangle");
        Vector2 tl = view.times(rectangle.corner().xy01()).xy();
        Vector2 br = view.times(rectangle.position(1.0, 1.0).xy01()).xy();
        return RectangleKt.Rectangle(tl.x(), tl.y(), br.x() - tl.x(), br.y() - tl.y());
    }

    public final void renderUI(double time) {
        Drawer drawer = this.getProgram().getDrawer();
        Matrix44 oldView = drawer.getView();
        Matrix44 oldProjection = drawer.getProjection();
        double timescale = this.timeScale();
        int width = RenderTarget.Companion.getActive().getWidth();
        int height = RenderTarget.Companion.getActive().getHeight();
        double timeX = TransformsKt.project(new Vector3(time * timescale + this.layerLabelWidth), oldProjection, oldView, width, height).x();
        Function1[] function1Array = new Function1[]{UIRenderer::renderUI$lambda$0, UIRenderer::renderUI$lambda$1};
        List sortedLayers = CollectionsKt.sortedWith((Iterable)this.getLayerWatcherService().getLayers(), ComparisonsKt.compareBy(function1Array));
        drawer.clear(ColorRGBa.Companion.getGRAY().shade(0.25));
        Drawer.translate$default(drawer, this.layerLabelWidth, 0.0, null, 4, null);
        Rectangle vb = this.getViewBounds();
        Vector2 scaleXY = drawer.getView().times(new Vector4(1.0, 1.0, 0.0, 0.0)).xy();
        Vector2 offsetXY = drawer.getView().times(new Vector4(0.0, 0.0, 0.0, 1.0)).xy();
        DrawerKt.isolated(drawer, arg_0 -> UIRenderer.renderUI$lambda$3(drawer, sortedLayers, this, time, timescale, scaleXY, offsetXY, arg_0));
        if (this.showFCurves) {
            DrawerKt.isolated(drawer, arg_0 -> UIRenderer.renderUI$lambda$5(drawer, sortedLayers, this, time, timescale, vb, oldView, scaleXY, timeX, offsetXY, arg_0));
        }
        DrawerKt.isolated(drawer, arg_0 -> UIRenderer.renderUI$lambda$6(drawer, sortedLayers, oldProjection, oldView, width, height, arg_0));
        double cuePointX = TransformsKt.project(new Vector3(this.getDemoController().getCuePoint() * timescale + this.layerLabelWidth), oldProjection, oldView, width, height).x();
        DrawerKt.isolated(drawer, arg_0 -> UIRenderer.renderUI$lambda$11(drawer, timeX, height, time, this, cuePointX, arg_0));
    }

    @Override
    @NotNull
    public Koin getKoin() {
        return KoinComponent.DefaultImpls.getKoin(this);
    }

    private static final Comparable renderUI$lambda$0(Layer it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Integer.valueOf(it.getZIndex());
    }

    private static final Comparable renderUI$lambda$1(Layer it) {
        Intrinsics.checkNotNullParameter(it, "it");
        File file = it.getSourceFile();
        return (Comparable)((Object)(file != null ? file.getName() : null));
    }

    private static final Unit renderUI$lambda$3$lambda$2(List $sortedLayers, UIRenderer this$0, double $time, double $timescale, Vector2 $scaleXY, Vector2 $offsetXY, RectangleBatchBuilder $this$rectangles) {
        Intrinsics.checkNotNullParameter($this$rectangles, "$this$rectangles");
        $this$rectangles.setStroke(ColorRGBa.Companion.getBLACK());
        $this$rectangles.setStrokeWeight(0.1);
        Iterator iterator2 = ((Iterable)$sortedLayers).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int layerIndex = n++;
            Layer layer = (Layer)iterator2.next();
            LayerView lv = this$0.getLayerRenderer().getLayerViews().get(layer);
            Iterator iterator3 = ((Iterable)layer.getObjects()).iterator();
            int n2 = 0;
            while (iterator3.hasNext()) {
                int index = n2++;
                Layer.Object obj = (Layer.Object)iterator3.next();
                if (obj.getTime() == null || obj.getDuration() == null) continue;
                Intrinsics.checkNotNull(obj.getTime());
                $this$rectangles.setFill(layerIndex % 2 == 0 ? ColorRGBa.Companion.getGRAY() : ColorRGBa.Companion.getGRAY().shade(0.5));
                IObjectView ov = lv.getObjectViews().get(obj);
                Double d = obj.getDuration();
                Intrinsics.checkNotNull(d);
                double duration = d;
                if (obj.getTime() <= $time && obj.getTime() + duration > $time) {
                    $this$rectangles.setFill(ColorRGBa.Companion.getWHITE());
                }
                RectangleBatchBuilder.rectangle$default($this$rectangles, (this$0.layerLabelWidth + obj.getTime() * $timescale) * $scaleXY.x() + $offsetXY.x(), (double)(layerIndex + 1) * 24.0 * $scaleXY.y() + $offsetXY.y(), duration * $timescale * $scaleXY.x(), 16.0 * $scaleXY.y(), 0.0, 16, null);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit renderUI$lambda$3(Drawer $drawer, List $sortedLayers, UIRenderer this$0, double $time, double $timescale, Vector2 $scaleXY, Vector2 $offsetXY, Drawer $this$isolated) {
        Intrinsics.checkNotNullParameter($this$isolated, "$this$isolated");
        $drawer.defaults();
        $drawer.rectangles(arg_0 -> UIRenderer.renderUI$lambda$3$lambda$2($sortedLayers, this$0, $time, $timescale, $scaleXY, $offsetXY, arg_0));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit renderUI$lambda$5(Drawer $drawer, List $sortedLayers, UIRenderer this$0, double $time, double $timescale, Rectangle $vb, Matrix44 $oldView, Vector2 $scaleXY, double $timeX, Vector2 $offsetXY, Drawer $this$isolated) {
        Intrinsics.checkNotNullParameter($this$isolated, "$this$isolated");
        $drawer.defaults();
        $drawer.setStrokeWeight(0.1);
        Iterator iterator2 = ((Iterable)$sortedLayers).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int layerIndex = n++;
            Layer layer = (Layer)iterator2.next();
            LayerView lv = this$0.getLayerRenderer().getLayerViews().get(layer);
            Drawer $this$renderUI_u24lambda_u245_u24lambda_u244 = $this$isolated;
            boolean bl = false;
            double x = layer.getTime() * $timescale * $scaleXY.x() + this$0.layerLabelWidth * $scaleXY.x() + $offsetXY.x();
            double y0 = ((double)(layerIndex + 1) * 24.0 - 4.0) * $scaleXY.y() + $offsetXY.y();
            double y1 = ((double)(layerIndex + 2) * 24.0 - 4.0) * $scaleXY.y() + $offsetXY.y();
            $drawer.setStroke(ColorsKt.getDARK_ORANGE(ColorRGBa.Companion));
            $drawer.setStrokeWeight(1.0);
            $drawer.lineSegment(x, y0, x, y1);
            $drawer.setStrokeWeight(0.1);
            for (Layer.Object obj : layer.getObjects()) {
                Intrinsics.checkNotNull(obj.getTime());
                IObjectView ov = lv.getObjectViews().get(obj);
                Double d = obj.getDuration();
                Intrinsics.checkNotNull(d);
                double duration = d;
                boolean active = obj.getTime() <= $time && obj.getTime() + duration > $time;
                Rectangle r = RectangleKt.Rectangle(obj.getTime() * $timescale, (double)(layerIndex + 1) * 24.0, duration * $timescale, 16.0);
                if (!active || !r.intersects($vb)) continue;
                Rectangle pr = this$0.project($oldView, r);
                for (Map.Entry<String, FCurve> entry : ov.getFcurves().entrySet()) {
                    ColorHSLa converted$iv$iv;
                    AlgebraicColor<ColorHSLa> algebraicColor;
                    void $this$shiftHue$iv;
                    String key = entry.getKey();
                    FCurve fc = entry.getValue();
                    FCurve tfc = EfcurveKt.subX(fc, 0.0, duration);
                    Rectangle tfcBounds = tfc.getBounds();
                    double hs = tfcBounds.height() == 0.0 ? -1.0 : -16.0 / tfcBounds.height();
                    double ho = tfcBounds.height() == 0.0 ? 0.5 : 0.0;
                    ColorRGBa colorRGBa = ColorRGBa.Companion.getRED();
                    double degrees$iv = key.hashCode();
                    boolean $i$f$shiftHue = false;
                    void $this$convertTo$iv$iv = $this$shiftHue$iv;
                    boolean $i$f$convertTo = false;
                    KClass kClass = Reflection.getOrCreateKotlinClass(ColorHSVa.class);
                    if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorHSLa.class))) {
                        algebraicColor = $this$convertTo$iv$iv.toHSLa();
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorHSVa.class))) {
                        algebraicColor = $this$convertTo$iv$iv.toHSVa();
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorRGBa.class))) {
                        algebraicColor = $this$convertTo$iv$iv;
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorHPLUVa.class))) {
                        algebraicColor = ColorHPLUVaKt.toHPLUVa((ColorRGBa)$this$convertTo$iv$iv);
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorHSLUVa.class))) {
                        algebraicColor = ColorHSLUVaKt.toHSLUVa((ColorRGBa)$this$convertTo$iv$iv);
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorOKLABa.class))) {
                        algebraicColor = ColorOKLABaKt.toOKLABa((ColorRGBa)$this$convertTo$iv$iv);
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorOKLCHa.class))) {
                        algebraicColor = ColorOKLCHaKt.toOKLCHa((ColorRGBa)$this$convertTo$iv$iv);
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorOKHSLa.class))) {
                        algebraicColor = ColorOKHSLaKt.toOKHSLa((ColorRGBa)$this$convertTo$iv$iv);
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorOKHSVa.class))) {
                        algebraicColor = ColorOKHSVaKt.toOKHSVa((ColorRGBa)$this$convertTo$iv$iv);
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorLABa.class))) {
                        algebraicColor = ColorRGBa.toLABa$default((ColorRGBa)$this$convertTo$iv$iv, null, 1, null);
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorLUVa.class))) {
                        algebraicColor = ColorRGBa.toLUVa$default((ColorRGBa)$this$convertTo$iv$iv, null, 1, null);
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorLCHABa.class))) {
                        algebraicColor = ColorRGBa.toLCHABa$default((ColorRGBa)$this$convertTo$iv$iv, null, 1, null);
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorLCHUVa.class))) {
                        algebraicColor = ColorRGBa.toLCHUVa$default((ColorRGBa)$this$convertTo$iv$iv, null, 1, null);
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorOKHSLa.class))) {
                        algebraicColor = ColorOKHSLaKt.toOKHSLa((ColorRGBa)$this$convertTo$iv$iv);
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorXYZa.class))) {
                        algebraicColor = $this$convertTo$iv$iv.toXYZa();
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorXSLUVa.class))) {
                        algebraicColor = ColorXSLUVaKt.toXSLUVa((ColorRGBa)$this$convertTo$iv$iv);
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorXSVa.class))) {
                        algebraicColor = $this$convertTo$iv$iv.toXSVa();
                    } else if (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(ColorXSLa.class))) {
                        algebraicColor = $this$convertTo$iv$iv.toXSLa();
                    } else {
                        throw new IllegalStateException(("color model " + Reflection.getOrCreateKotlinClass(ColorHSVa.class) + " not supported").toString());
                    }
                    ColorHSLa colorHSLa = converted$iv$iv = algebraicColor;
                    if (colorHSLa == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.openrndr.color.ColorHSVa");
                    }
                    $drawer.setStroke(ColorRGBaExtensionsKt.matchLinearity(((ConvertibleToColorRGBa)((HueShiftableColor)((Object)((ColorModel)((ColorHSVa)((Object)colorHSLa))))).shiftHue(degrees$iv)).toRGBa(), (ColorRGBa)$this$shiftHue$iv));
                    $drawer.contours(tfc.contours(new Vector2($timescale * $scaleXY.x(), hs * $scaleXY.y()), new Vector2(this$0.layerLabelWidth, 0.0).times($scaleXY).plus(pr.position(0.0, ho)).minus(tfcBounds.position(0.0, 1.0).times($scaleXY).times(hs))));
                }
                $drawer.setFill(ColorRGBa.Companion.getBLACK());
                String string = "%.3f";
                Object[] objectArray = new Object[]{obj.getTime() * this$0.getDemo().getTimeScale()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                $drawer.text(string2, new Vector2(this$0.layerLabelWidth, 0.0).times($scaleXY).plus(pr.position(0.0, 0.0)).plus(new Vector2(5.0, 10.0)));
                String object2 = "%.3f";
                objectArray = new Object[]{(this$0.getDemoController().position() - obj.getTime()) * this$0.getDemo().getTimeScale()};
                String string3 = String.format(object2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
                $drawer.text(string3, new Vector2($timeX, pr.position(0.0, 0.0).y()).plus(new Vector2(5.0, 26.0)));
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit renderUI$lambda$6(Drawer $drawer, List $sortedLayers, Matrix44 $oldProjection, Matrix44 $oldView, int $width, int $height, Drawer $this$isolated) {
        Intrinsics.checkNotNullParameter($this$isolated, "$this$isolated");
        $drawer.defaults();
        Iterator iterator2 = ((Iterable)$sortedLayers).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int layerIndex = n++;
            Layer layer = (Layer)iterator2.next();
            $drawer.setFill(ColorRGBa.Companion.getBLACK());
            double y = TransformsKt.project(new Vector3(0.0, (double)(layerIndex + 2) * 24.0 - 4.0, 0.0), $oldProjection, $oldView, $width, $height).y();
            double ty = TransformsKt.project(new Vector3(0.0, (double)(layerIndex + 2) * 24.0 - 16.0, 0.0), $oldProjection, $oldView, $width, $height).y();
            Object object = layer.getSourceFile();
            if (object == null || (object = FilesKt.getNameWithoutExtension((File)object)) == null) {
                object = "";
            }
            $drawer.text((String)object, 11.0, ty + 4.0);
            $drawer.setFill(layer.getEnabled() ? (layerIndex % 2 == 0 ? ColorRGBa.Companion.getWHITE() : ColorRGBa.Companion.getWHITE().shade(0.85)) : ColorRGBa.Companion.getWHITE().shade(0.2));
            Object object2 = layer.getSourceFile();
            if (object2 == null || (object2 = FilesKt.getNameWithoutExtension((File)object2)) == null) {
                object2 = "";
            }
            $drawer.text((String)object2, 10.0, ty - 1.0 + 4.0);
            $drawer.setStroke(ColorRGBa.Companion.getBLACK().opacify(0.5));
            $drawer.lineSegment(0.0, y, (double)$width * 1.0, y);
        }
        return Unit.INSTANCE;
    }

    private static final Unit renderUI$lambda$11$lambda$10$lambda$9(Drawer $drawer, double $time, UIRenderer this$0, double $lx, int $height, Drawer $this$isolated) {
        Intrinsics.checkNotNullParameter($this$isolated, "$this$isolated");
        $drawer.defaults();
        String string = "%.3f";
        Object[] objectArray = new Object[]{$time - this$0.getDemoController().getCuePoint()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        $drawer.text(string2, $lx, (double)$height - 24.0);
        $drawer.setFill(ColorRGBa.Companion.getPINK().shade(0.5));
        string = "%.3fs";
        objectArray = new Object[]{($time - this$0.getDemoController().getCuePoint()) / this$0.getDemo().getTimeScale()};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
        $drawer.text(string3, $lx + 64.0, (double)$height - 24.0);
        return Unit.INSTANCE;
    }

    private static final Unit renderUI$lambda$11(Drawer $drawer, double $timeX, int $height, double $time, UIRenderer this$0, double $cuePointX, Drawer $this$isolated) {
        Intrinsics.checkNotNullParameter($this$isolated, "$this$isolated");
        $drawer.defaults();
        Drawer $this$renderUI_u24lambda_u2411_u24lambda_u247 = $this$isolated;
        boolean bl = false;
        $drawer.setStroke(ColorRGBa.Companion.getGREEN());
        double x = $timeX;
        $drawer.lineSegment(x, 0.0, x, $height);
        $drawer.setFill(ColorRGBa.Companion.getGREEN());
        double lx = RangesKt.coerceAtMost(x + 12.0, (double)RenderTarget.Companion.getActive().getWidth() - 140.0);
        String string = "%.3f";
        Object[] objectArray = new Object[]{$time};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        string = "%.3fs";
        objectArray = new Object[]{$time / this$0.getDemo().getTimeScale()};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
        $drawer.text(string2 + " / " + string3, lx, 12.0);
        Drawer $this$renderUI_u24lambda_u2411_u24lambda_u248 = $this$isolated;
        boolean bl2 = false;
        $drawer.setStroke(ColorRGBa.Companion.getBLUE());
        x = $cuePointX;
        $drawer.lineSegment(x, 0.0, x, $height);
        $drawer.setFill(ColorRGBa.Companion.getBLUE());
        lx = RangesKt.coerceAtMost(x + 12.0, (double)RenderTarget.Companion.getActive().getWidth() - 140.0);
        string = "%.3f";
        objectArray = new Object[]{this$0.getDemoController().getCuePoint()};
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
        string = "%.3fs";
        objectArray = new Object[]{this$0.getDemoController().getCuePoint() / this$0.getDemo().getTimeScale()};
        String string5 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string5, "format(...)");
        $drawer.text(string4 + " / " + string5, lx, (double)$height - 12.0);
        Drawer $this$renderUI_u24lambda_u2411_u24lambda_u2410 = $this$isolated;
        boolean bl3 = false;
        double x0 = $timeX;
        double x1 = $cuePointX;
        $drawer.setFill(ColorRGBa.Companion.getPINK());
        $drawer.setStroke(ColorRGBa.Companion.getPINK());
        double y = (double)$height - 24.0;
        $drawer.lineSegment(x0, y, x1, y);
        double lx2 = ($timeX + $cuePointX) / 2.0 - 50.0;
        DrawerKt.isolated($drawer, arg_0 -> UIRenderer.renderUI$lambda$11$lambda$10$lambda$9($drawer, $time, this$0, lx2, $height, arg_0));
        return Unit.INSTANCE;
    }
}

