lmpr:          EQU  &FA
hmpr:          EQU  &FB
vmpr:          EQU  &FC
rom0_off:      EQU  %00100000
;mode_4:        EQU  %01100000

AMP: 			EQU 14
SINEDATA:		EQU &9000

autoexec
ORG	&8000
DUMP &8000

pageIndex:
di
ld sp,0

ld hl,pageIndex
ld de,points
ld bc,256
ldir

mainloop:

	waitVsync:
		in a,(249)
		and 8		; 249 read, 8 = FRAME
	jr nz,waitVsync

	; Lazy CLS
	;xor a
	ld h,a
	ld l,a
	ld d,h
	ld e,h
	inc e
	ld (hl),a
	ld bc,24576
ldir

	; Move points
	ld ix,points
	ld a,32
	allPointsLoop:
	ex af,af'
		ld a,2
		movePointLoop:
			ld e,(ix)
			ld d,(ix+1)
			ld c,(ix+4)
			ld b,(ix+5)
			ld l,4
			skatoloop:
				sra b
				rr c
				dec l
			jr nz,skatoloop

			ex de,hl
			sbc hl,bc
			ld (ix),l
			ld (ix+1),h
			inc ix
			inc ix

			dec a
		jr nz,movePointLoop
		ld bc,4
	add ix,bc
	ex af,af'
	dec a
	jr nz,allPointsLoop

	ld ix,points
	ld a,31
	mainLineFxLoop:
		ld c,(ix+1)
		ld h,(ix+3)
		srl c
		srl h
		ld e,(ix+9)
		ld d,(ix+11)
		srl e
		srl d
		ex af,af'
		push ix
		call drawLine
		pop ix

		ex af,af'
		ld bc,8
		add ix,bc
	dec a
	jr nz,mainLineFxLoop


	;call swapPage
	ld a,(pageIndex)
	inc a
	and 1
	ld (pageIndex),a
	or a
	ld a,%11111110
	ld b,%00111100
	jr nz,show_page0
		ld a,%11111100
		ld b,%00111110
	show_page0:
	out (vmpr),a
	ld a,b
out (lmpr),a	

jp mainloop

; Bad line routine just to fit for size
;c,h,e,d (x0,y0,x1,y1)
drawLine:
	ld a,e
	sub c
	ld e,a	; e = x1 - x0
	ld a,d
	sub h
	ld d,a	; d = y1 - y0

	or e
	ret z	; if dx==dy==0 return

	ld a,e
	add d
	cp 128
	ret nc

	ld l,0
	ld b,l
	ld ixh,0	; somewhere to keep remained and set to zero at first
	srl h
	rr l
	;ld ixl,c		; keep the physical x position
	;srl c
	;sla c
	add hl,bc		; hl is the starting address now

	ld ixl,1
	; not proper, should be 128 but just to expand and fit. But if you expand -128 it will crash
	ld bc,256

	bit 7,e
	jr z,noNegDx
		ld a,e
	neg
	ld e,a
		ld ixl,-1
	noNegDx:

	bit 7,d
	jr z,noNegDy
		ld a,d
	neg
	ld d,a
		ld bc,-128
	noNegDy:

	ld a,d
	cp e
	jr c,dyNotOverDx
		ld ixh,d	; remainder = dy
	dyNotOverDx:

	ld iyl,e		; ix
	ld iyh,d		; iy

	lineLoopDy:

		lineLoopDx:
			ld a,ixh
			cp e
			jr nc,afterLineLoopDx

			add d
			ld ixh,a				; remainder += dy
			ld (hl),l
			inc h
			ld (hl),l
			dec h
			ld a,l
			add ixl
			ld l,a 		; vram += vx

			dec iyl
			ret z
		jr lineLoopDx
		afterLineLoopDx:

		add hl,bc	; vram += vy
		ld (hl),l
		inc l
		ld (hl),l
		dec l

		ld a,ixh
		sub e
		ld ixh,a			; remainder -= dx

	dec iyh
	jr nz,lineLoopDy
ret


points:
