#version 450

layout(location = 0) in vec2 texCoord;

layout(location = 0) out vec4 outColor;

layout(set = 1, binding = 0) uniform sampler2D hudTexture;

#include "ubo_perframe.glsl"
#include "noise.glsl"

void main() {
    //outColor = u_fade * texture(hudTexture, texCoord);

    float n = fbm(vec3(texCoord.xy * 8.0, 0.0));

    if (abs(u_fade - n) < 0.01) {
        outColor = vec4(0.5,0.75,0.25,1);
    } else if (n <= u_fade) {
        outColor = texture(hudTexture, texCoord);
    } else { 
        outColor = vec4(0,0,0,1);
    }
}



