#version 450

layout(location = 0) in vec3 inPosition;
layout(location = 1) in vec3 inNormal;
layout(location = 2) in vec3 inColor;

layout(location = 0) out vec4 outColor;

#include "ubo_perframe.glsl"

void main() {

    vec3 N = normalize(inNormal);
    vec3 V = normalize(cameraPosition.xyz-inPosition);
    
    float NdotV = max(dot(N, V), 0.0f);
#if 0
    // distance-based illumination from center
    float dist = abs(length(inPosition.xz));
    const float coreGlowRange = 6.5f; //40.0f;
    float coreGlowFactor = 1.0f - clamp(dist/coreGlowRange, 0.0f, 1.0f);
    const vec3 coreGlowColor = vec3(1.0f, 0.5f, 0.0f);

    vec3 coreGlowResult = coreGlowFactor*2.0f*coreGlowColor;
#endif
    //outColor = vec4(inColor + coreGlowResult, 1.0f);
    //outColor = vec4(lambert*intensity*vec3(0.5,0.25,0.05)*1.0f + coreGlowResult, 1.0f);


    //float headLight = pow(NdotV, 8.0f);

    float rimFactor = 1.0f - pow(NdotV, 0.5f);
    vec3 rim = vec3(1.0f,0.25f,0) * max(rimFactor, 0.0f);

    vec3 result = rim; // + coreGlowResult;

    outColor = vec4(result, 1.0f);

    
#if 0
    // luminance / desaturate / tint
//    float lum = result.r * 0.33 + result.g * 0.33 + result.b * 0.33;
    float lum = result.r * 0.25 + result.g * 0.5 + result.b * 0.25;
    //lum = sqrt(lum+0.001);
    lum = pow(lum, 1.5);
    result = vec3(lum, lum, lum);
//    result = mix(result, vec3(lum, lum, lum), 0.5);
    //result = mix(result, vec3(0.05, 0.5, 0.0)*lum, 0.15);

    result *= 8.0;
#endif

    result *= 8.0;

    // apply gamma correction
    result = pow(result, vec3(1.0/u_gamma));

    // output tonemapped result
    outColor = vec4(tanh(result), 1.0f);
}



