;                                           _____
;                                          / ___ \
; another_invitation.asm v0.1 by nikhotmsk  /_o_\
;
; use this command to compile this thing:
; wine ../../sjasmplus-1.18.3.win/sjasmplus.exe another_invitation.asm --lst=another_invitation.lst --sym=another_invitation.sym && ../bas2tap/bas2tap -a10 loader.bas ; cat loader.tap another_invitation_code.tap > another_invitation.tap
;
; run in emulator:
; wine ../../../unreal_speccy/us0.38.1/unreal.exe another_invitation.tap
; or
; fbzx another_invitation.tap
;

;
; message for humans. If you want to learn Z80 assembly language, try
; this tutorial: https://www.chibiakumas.com/z80 (or any other)
;

	DEVICE ZXSPECTRUM128
	org $a000
	;
	; This is a fischinger engine, it is used to draw multiple objects
	; at many places using precompiled drawing code. Ask nikhotmsk if you
	; want to understand how it works. Kind a mess.
	;
code_start:
	di
	ld (saved_iy), iy ; save IY register, because it is needed for rst #10
	
	; find the page that was active at boot and place it to player_page
	ld a, (stored_paging_byte_address) ; which is $5b5c (23388)
	and 0b00000111
	ld (player_page), a
	
code_again:
	di
	ld hl, machine_stack_end
	ld sp, hl
	
	ld a, (flip_mask)
	ld l, a
	ld a, (player_page)
	and 0b00000111
	or l
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	out  (c),a ; page into player page (probably it is a page 0)
	
	; TODO make sure keyboard keys are released
	
	; init variables
	ld hl, 0
	ld (frame_counter), hl
	ld hl, draw_text_empty_byte
	ld (draw_text_pointer), hl
	ld hl, draw_polyline_empty
	ld (polyline_pointer), hl
	ld (polyline_erase_pointer), hl
	ld hl, $4000
	ld (draw_text_screen_address), hl
	ld a, 0
	ld (nested_waiting), a
	ld (tv_flag_contect_1), a
	ld (tv_flag_contect_2), a
	ld (tv_flag_contect_3), a
	ld (draw_bitstream_enable), a
	; turbo sound setting should survive
	; TODO cancel pause
	
	ld a, 0
	out (#FE),A      ; border black
	ld HL, #5800
	ld BC, 768       ; set background to black
	ld D, 0b01000111 ; set ink to white
	call fill_mem
	
	ld hl, vars
	ld bc, machine_stack - vars
	ld d, 0
	call fill_mem ; clear variables and shedule
	
	ld hl, assembled_sequence_1_12
	ld bc, assembled_sequence_end - assembled_sequence_1_12
	ld d, 0
	call fill_mem ; clear this area too
	
	;ld ix, vars     ; put four dots
	;ld de, 0x0202	;
	;ld (ix+0), de	;    A-------B
	;ld de, 0x0214	;    |       |
	;ld (ix+2), de	;    |       |
	;ld de, 0x1414	;    |       |
	;ld (ix+4), de	;    D-------C
	;ld de, 0x1402	;
	;ld (ix+6), de
	
	ld a,2
	call $1601 ; select S channel for text
	
	di
	ld hl, im2_interrupt_block ; prepare interrupt mode 2
	ld a, h
	ld i, a
	;ld bc, 257 ; size of interrupt block
;interrupt_setup_loop:
	;ld (hl), $80
	;inc hl
	;dec bc
	;ld a, b
	;or c
	;jr nz, interrupt_setup_loop
	im 2
	
stored_paging_byte_address: EQU $5b5c ; this is standard ROM variable
	
	; initSong
	ld a, (flip_mask)
	ld l, a
	ld a, (player_page)
	or l
	or 16 ; always select basic48 ROM
	ld bc, #7ffd
	ld (stored_paging_byte_address), a
	; always store this byte, so interrupt can restore it back
	; interrupts are not enabled yet, but still lets save it
	out (c),a
	
	ld a, (no_music)
	or a
	call z, initSong
	
	
	jp code_main
saved_iy:	WORD 0
	
	; ORG ahead, do not put extra code here, because not much space

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; interrupt routine
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	org #a0a0 ; interrupt routine here
	push af ; make sure player is not running with interrupts enabled
	ld a, (nested_waiting)
	or a
	jr z, interrupt_not_nested_this_time
	ld a, 1
	ld (nested_arrived_flag), a
	pop af
	reti ; do not set interrupt flag
interrupt_not_nested_this_time:
	push bc
	push de
	push hl
	push ix
	push iy
	
	; frame counter here
	ld hl, (frame_counter)
	inc hl ; normal flow
	ld (frame_counter), hl ; TODO pause
	
	jp interrupt_routine_continue

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; interrupt table
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	ALIGN 2 ; hardcoded interrupt table here
im2_interrupt_block:
	.257 BYTE #a0 ; this is an interrupt table (size 257 bytes)
	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; interrupt_routine_continue
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
no_music: BYTE 0
flip_mask: BYTE 0
flip_override: BYTE 0
flip_override_storage: BYTE 0
paging_available: BYTE 0
player_page: BYTE 0
interrupt_choosen_file: WORD 0
interrupt_chosen_erase_bank: WORD 0
interrupt_chosen_queue: WORD 0
draw_polyline_empty: BYTE 0,0,0,0
draw_bitstream_enable: BYTE 0
draw_bitstream_pointer: WORD bitstream_empty
bitstream_empty: BYTE 255
interrupt_routine_continue:
	; do flip
	ld a, (flip_override)
	or a
	jp z, interrupt_no_override
	ld a, (flip_mask)
	and 0b11110111 ; if flip override, then always display screen 0
	ld (flip_override_storage), a ; save flip_mask for later recovery
interrupt_no_override:
	
	ld a, (no_music)
	or a
	jr nz, interrupt_routine_no_music
	; page in a player
	ld a, (flip_mask)
	ld l, a
	ld a, (player_page)
	and 0b00000111
	or l
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	out  (c),a ; page into player page (probably it is a page 0)
	; do not save the byte
	call player+5 ; run music ; TODO implement pause
	
interrupt_routine_no_music:
	
	ld hl, (frame_counter)
	ld a, l
	and 0b00000010
	jr z, interrupt_frame_is_0
	; set active file to IY
	ld iy, asm_file_for_screen_1
	ld a, 0
	ld (flip_mask), a ; and show screen 0
	jr interrupt_frame_is_not_0_skip
interrupt_frame_is_0:
	; set active file IY
	ld iy, asm_file_for_screen_0 ; writing to screen 0, displayng 1
	ld a, 8
	ld (flip_mask), a ; frame 1 is displayed
interrupt_frame_is_not_0_skip:
	ld a, (flip_override)
	or a
	jp z, interrupt_no_override_2
	ld a, (flip_override_storage) ; recover
	ld (flip_mask), a
interrupt_no_override_2:
	ld a, (flip_mask)
	ld l, a
	ld a, (iy+7) ; [memory page]
	or l
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	; do not save a byte, because it is for interrupt only
	out  (c),a	; flip shadow screen
	ld (interrupt_choosen_file), iy

	

	; page in a screen file & shedule & erase shedule
	ld iy, (interrupt_choosen_file)
	ld hl, (iy+12) ; [*bank to be erased]
	ld (interrupt_chosen_erase_bank), hl
	ld hl, (iy+10) ; [*shedule]
	ld (interrupt_chosen_queue), hl
	
	ld a, (flip_mask)
	ld l, a
	ld a, (iy+7) ; [memory page]
	or l
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	; interrupt, do not save the byte
	out  (c),a
	
	ld a, (nested_double_time_mode)
	or a
	jr z, interrupt_double_time_disabled
	ld a, 1
	ld (nested_waiting), a
	ld a, 0
	ld (nested_arrived_flag), a
	ei
interrupt_double_time_disabled:
	
	ld a, (iy+6) ; [asm enable]
	or a ; if asm is disabled, it means that this page does not exist, no paging available
	jp z, do_not_draw_this_time_wait_for_next_interrupt ; skip the whole thing
	
	
	; the engine makes flip and then erases shapes, on next frame it draws shapes
	ld hl, (frame_counter)
	ld a, l
	and 1
	jr z, interrupt_routine_go_erase
	ld a, (paging_available)
	or a
	jp z, do_not_draw_this_time_wait_for_next_interrupt ; avoid draw two times in compatibility mode
	jp interrupt_routine_no_erase_this_time
	
	
interrupt_routine_go_erase:
	ld b, shedule_bank_size ; erase thing on even frames
	ld ix, (interrupt_chosen_erase_bank)
	ld a, ixl
	or ixh
	jp z, interrupt_routine_no_erase_this_time
	
interrupt_c0:
	ld a, (ix+4) ; [hl register] [drawing code] [enable]
	or a
	jr z, interrupt_skip0
	ld d, (iy+14) ; [frame number mask]
	cp d
	jr nz, interrupt_skip0
	
	ld de, (ix+2) ; drawing code pointer
	ld hl, (ix+0) ; screen pointer
	push bc
	ld b, 0 ; draw black
	call call_de
	pop bc
	ld a, 0
	ld (ix+4), a ; [enable] mark this entry as empty
	
interrupt_skip0:
	ld de, shedule_entry_size
	add ix, de
	ld a, b
	and 0b00000111
	call z, interrupt_check_nested_arrived ; and play music
	dec b
	jr nz, interrupt_c0
	
	; if no shadow screen is supported, draw instantly after erase
	ld a, (paging_available)
	or a
	jp nz, do_not_draw_this_time_wait_for_next_interrupt ; draw on next frame
	
	

interrupt_routine_no_erase_this_time:

	; draw some figurines
	
	ld de, (frame_counter) ; prepare frame number mask byte
	rr d
	rr e
	rr d
	rr e
	ld a, e
	and 0b11111100
	or 1
	ld (iy+14), a ; store [frame number mask]
	
	; select shedule bank here
	ld a, (frame_counter)
	ld de, shedule_bank_size * shedule_entry_size ; 20 * 5 = 100
	ld hl, 0
	; test bits in a
	bit 2, a
	jr z, interrupt_draw_multiply_0001_skip
	add hl, de ; addition here
interrupt_draw_multiply_0001_skip:
	or a ; drop carry bit
	rl e
	rl d
	bit 3, a
	jr z, interrupt_draw_multiply_0010_skip
	add hl, de
interrupt_draw_multiply_0010_skip:
	or a ; drop carry bit
	rl e
	rl d
	bit 4, a
	jr z, interrupt_draw_multiply_0100_skip
	add hl, de
interrupt_draw_multiply_0100_skip:
	or a ; drop carry bit
	rl e
	rl d
	bit 5, a
	jr z, interrupt_draw_multiply_1000_skip
	add hl, de
interrupt_draw_multiply_1000_skip: ; end of multiply
	ex hl, de ; now DE contains proper displacement
	
	ld hl, (interrupt_chosen_queue) ; [*shedule]
	add hl, de
	ld iy, (interrupt_choosen_file)
	ld (iy+12), hl ; [*bank to be erased]
	ld ix, hl
	ld b, shedule_bank_size
interrupt_c1:
	ld a, (ix+4) ; [hl register] [drawing code] [enable]
	or a
	jr z, interrupt_skip1 ; enable byte is reset
	ld d, (iy+14) ; [frame number mask]
	cp d
	jr nz, interrupt_skip1
	ld hl, (ix+0) ; load screen pointer
	ld de, (ix+2) ; load drawing code
	push bc
	ld b, #ff
	call call_de ; run drawing code
	pop bc
	
	
	; do not drop enable byte, it will be used to erase figurine
	
interrupt_skip1:
	; TODO check frame number
	ld de, shedule_entry_size
	add ix, de
	ld a, b
	and 0b00000111
	call z, interrupt_check_nested_arrived ; and play music
	dec b
	jp nz, interrupt_c1
	
do_not_draw_this_time_wait_for_next_interrupt:
	call fischinger_draw_polyline
	call fischinger_erase_polyline
	
	; read keyboard
	ld bc, #7ffe ; keys b,n,m,sym,space
	in a, (c)
	and 0b00000001 ; the 'break' key
	jr nz, interrupt_routine_no_break_key
interrupt_routine_goto_code_again:
	; reset program back to the beginning
	ld de, code_again
	push de
	di
	reti ; start the program from the beginning
interrupt_routine_no_break_key:
	ld bc, #fdfe ; keys g,f,d,s,a
	in a, (c)
	ld b, a
	and 0b00000010 ; the 's' key
	jr nz, interrupt_routine_no_s_key
	ld a, (turbosound_setting_byte)
	and 0b11101111 ; disable turbosound, thus making normal AY
	ld (turbosound_setting_byte), a
	ld a, 0
	ld (turbosound_flip_modules), a
	jr interrupt_routine_goto_code_again
interrupt_routine_no_s_key:
	ld a, b
	and 0b00000001 ; the 'a' key
	jr nz, interrupt_routine_no_a_key
	ld a, (turbosound_setting_byte)
	and 0b11101111 ; disable turbosound, thus making normal AY
	ld (turbosound_setting_byte), a
	ld a, 1
	ld (turbosound_flip_modules), a
	jr interrupt_routine_goto_code_again
interrupt_routine_no_a_key:

	; draw text here
	ld a, (flip_mask)
	or 7  ; select page 7 for text drawing
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	out  (c),a
	
	ld hl, (draw_text_pointer)
	ld a, (hl)
	cp '$'
	jr z, interrupt_no_draw_text
	ld b, 15 ; speed of text drawing here
interrupt_draw_text_cycle:
	ld a, (hl)
	cp '$'
	jr z, interrupt_draw_text_end
	; catch a ctl_at byte here
	cp ctl_at
	jr nz, interrupt_draw_text_to_ctl_at
	
	inc hl
	ld c, (hl)
	inc hl
	ld b, (hl)
	inc hl
	or a ; drop carry
	rl c
	rl c
	rl c
	call get_video_pos ; returns de
	ld (draw_text_screen_address), de
	jr interrupt_draw_text_cycle
	
interrupt_draw_text_to_ctl_at:
	
	push bc
	push hl
	
	ld bc, (draw_text_erase)
	bit 0, c
	jr z, interrupt_draw_text_no_erase
	ld a, ' ' ; erase text with spaces
interrupt_draw_text_no_erase:
	
	ld hl, 0
	
	sub 32 ; substract non-printable chars
	ld l, a
	or a ; drop carry bit
	rl l
	rl h
	rl l
	rl h
	rl l
	rl h ; multiply by eight
	ld de, $3d00 ; Character set
	add hl, de
	ld b, 8
	ld de, (draw_text_screen_address)
	push de
interrupt_draw_text_cycle_cycle:
	ld a, (hl)
	ld (de), a ; write to screen
	ld ixl, a
	ld a, (paging_available)
	or a
	jr z, interrupt_draw_text_no_shadow_screen
	push de
	set 7, d ; extended instruction, set bit 7 in register d
	ld a, ixl
	ld (de), a ; write the same thing to shadow screen
	pop de
	
interrupt_draw_text_no_shadow_screen:
	inc d      ; step down
	inc hl
	dec b
	jr nz, interrupt_draw_text_cycle_cycle
	pop de
	inc e ; step right
	ld (draw_text_screen_address), de
	
	pop hl
	pop bc
	inc hl
	dec b
	jr nz, interrupt_draw_text_cycle
interrupt_draw_text_end:
	ld (draw_text_pointer), hl
interrupt_no_draw_text:

	; draw starfield
	;ld hl, (frame_counter)
	;bit 0, l
	;jr z, interrupt_starfield_draw_no_loop ; skip odd frames
	; erase
	;ld ix, starfield_array
	;call interrupt_page_set_player_page
;interrupt_starfield_erase_loop:
	;ld a, (ix+0) ; [speed] enable
	;or a
	;jr z, interrupt_starfield_erase_no_loop
	;ld a, (ix+3) ; [prev contents]
	;or a
	;jr nz, interrupt_starfield_erase_skip_dot
	
	;ld bc, (ix+1)
	;push bc
	;call interrupt_page_set_7
	;pop bc
	;call Unplot ; remove point ; this bastard requires the correct page
	;call interrupt_page_set_player_page
	
;interrupt_starfield_erase_skip_dot:
;	ld de, 4 ; [speed] [x] [y] [prev contents]
;	add ix, de
;	jr interrupt_starfield_erase_loop
	
;interrupt_starfield_erase_no_loop:
;	; draw
;	ld a, (starfield_enable)
;	or a
;	jr z, interrupt_starfield_draw_no_loop
;	call interrupt_page_set_player_page
;	ld ix, starfield_array
;interrupt_starfield_draw_loop:
;	ld a, (ix+0) ; [speed] enable
;	or a
;	jr z, interrupt_starfield_draw_no_loop
;	ld a, (ix+0)
;	add (ix+1)
;	ld (ix+1), a ; move star right
;	ld bc, (ix+1)
;	push bc
;	call interrupt_page_set_7
;	pop bc
;	call Plot ; draw point
;	call interrupt_page_set_player_page
;	ld de, 4 ; [speed] [x] [y] [prev contents]
;	add ix, de
;	jr interrupt_starfield_draw_loop
	
;interrupt_starfield_draw_no_loop:

	call draw_bitstream
	call draw_bitstream
	call draw_bitstream
	call draw_bitstream
	
interrupt_nested_busy_loop_at_the_end:
	ld a, (nested_waiting)
	or a
	jr z, interrupt_nested_do_not_wait_quit
	call interrupt_check_nested_arrived ; catch flag and play music frame
	jr interrupt_nested_busy_loop_at_the_end
	
interrupt_nested_do_not_wait_quit:
	ld a, (flip_mask)
	ld l, a
	ld a, (stored_paging_byte_address)
	and 0b11110111
	or l
	or 16 ; basic48
	ld bc, #7ffd
	out (c),a ; restore page as it was before interrupt
	
	
	;ld a, 0b00000000 ; border black again
	;out (#fe), a
	; .6 call busy_wait
	
	
	
	pop iy
	pop ix
	pop hl
	pop de
	pop bc
	pop af
	ei
	reti


;;;;;;;;;;;;;;;;;;;;;;;;;
; interrupt_check_nested_arrived
;;;;;;;;;;;;;;;;;;;;;;;;;
nested_waiting: BYTE 0
nested_arrived_flag: BYTE 0
nested_double_time_mode: BYTE 1
interrupt_check_nested_arrived:
	ld a, (nested_waiting)
	or a
	ret z
	ld a, (nested_arrived_flag)
	or a
	jr nz, interrupt_check_nested_arrived_has_arrived
	ret
	
interrupt_check_nested_arrived_has_arrived:
	ld a, (no_music)
	or a
	jr nz, interrupt_routine_no_music_nested
	push bc
	push hl
	push de
	push ix
	push iy
	; page in a player
	ld a, (flip_mask)
	ld l, a
	ld a, (player_page)
	and 0b00000111
	or l
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	out  (c),a ; page into player page (probably it is a page 0)
	call player+5 ; run music ; TODO implement pause
	pop iy
	pop ix
	ld a, (flip_mask)
	ld l, a
	ld a, (iy+7) ; [memory page]
	or l
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	; interrupt, do not save the byte
	out  (c),a
	pop de
	pop hl
	pop bc
interrupt_routine_no_music_nested:
	ld a, 0
	ld (nested_waiting), a
	
	ret

;;;;;;;;;;;;;;;;;
; rewind_music
;;;;;;;;;;;;;;;;;
rewind_frame: EQU 950
rewind_music:
	ld a, (no_music)
	or a
	ret nz
	ld bc, rewind_frame
	ld hl, (frame_counter)
	ld de, rewind_frame
	add hl, de
	ld (frame_counter), hl
rewind_music_loop:
	push bc
	call player+5
	pop bc
	dec bc
	ld a, b
	or c
	jr nz, rewind_music_loop
	ret
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; draw_bitstream
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
draw_bitstream_screen_y: BYTE 0
draw_bitstream:
	ld a, (draw_bitstream_enable)
	or a
	ret z
	call interrupt_page_set_player_page
draw_bitstream_loop:
	ld hl, (draw_bitstream_pointer)
	ld a, (hl)
	inc a
	jr z, draw_bitstream_end_marker_found
	dec a
	jr nz, draw_bitstream_no_next_line
	ld a, (draw_bitstream_screen_y)
	inc a
	ld (draw_bitstream_screen_y), a
	cp 192
	jr nc, draw_bitstream_end_marker_found
	inc hl
	ld (draw_bitstream_pointer), hl
	jr draw_bitstream_loop
	
draw_bitstream_no_next_line:
	ld a, (hl) ; load it one more time
	inc hl
	inc a ; check for 255 marker
	jr z, draw_bitstream_end_marker_found
	dec a
	ld c, a
	ld a, (hl) ; load it one more time
	inc hl
	inc a
	jr z, draw_bitstream_end_marker_found
	dec a
	dec a ; fix fatty image
	ld e, a ; X points are ready
	ld a, (draw_bitstream_screen_y)
	ld d, a
	ld b, a ; Y points are ready
	push hl
	call interrupt_page_set_7
	call Draw_Line ; draw on both shadow screens
	pop hl
	ld (draw_bitstream_pointer), hl
	ret ; draw one line at a time
	
draw_bitstream_end_marker_found:
	ld a, 0
	ld (draw_bitstream_enable), a
	ret
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; main code
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;test_figurine_asm:	WORD 0
code_main:
	
	; WANTFIX the loader of music is probably to be located here, make user
	; able to cancel music loading on device that does not
	; support AY sound, by pressing a key
	
	; check if paging available
	ld a, 1
	ld (paging_available), a
	
	ld a, (flip_mask)
	ld h, a
	ld a, 4
	or h
	or 16 ; select basic rom
	ld (stored_paging_byte_address), a
	ld bc, #7ffd
	out (c),a ; set page 4
	ld a, 16
	ld ($ffff), a
	
	ld a, 7
	or h
	or 16 ; select basic rom
	ld (stored_paging_byte_address), a
	ld bc, #7ffd
	out (c),a ; set page 7
	ld a, 17
	ld ($ffff), a
	
	ld a, 4
	or h
	or 16 ; select basic rom
	ld (stored_paging_byte_address), a
	ld bc, #7ffd
	out (c),a ; set page 4
	ld a, ($ffff)
	cp 17
	jr nz, code_main_paging_ok
	ld a, 0
	ld (paging_available), a
	
	ld a, 2
	out (#FE),A ; border red means that paging is failed (48k compatibility mode)
	
	; change asm_file so it assembles into $6000 and drop even frames
	ld ix, asm_file_for_screen_0
	ld (ix+6), 0 ; [enable asm] screen 0 does not compile
	ld hl, shedule_6000
	ld (ix+10), hl
	;ld hl, erase_queue_6000
	;ld (ix+12), hl
	
	ld ix, asm_file_for_screen_1
	ld hl, 0
	ld (ix+8), hl ; [screen file offset]
	
	
	jr code_main_paging_not_available_skip_music_check
code_main_paging_ok:
	; player page should not be 4 or 7, if so, disable music
	; it would probably always be 0 at load, but I put a check to be sure
	ld a, (player_page)
	and 0b00000111
	cp 7
	jr z, code_main_disable_music
	cp 4
	jr z, code_main_disable_music
	jr code_main_music_ok
code_main_disable_music:
	ld a, 1
	ld (no_music), a
	
code_main_music_ok:
	
	ld hl, vault_c000
	ld bc, shedule_c000_end - vault_c000 ; page 4
	ld d, 0
	call fill_mem ; clear shedule at c000
	
	ld a, (flip_mask)
	or 7  ; page 7
	or 16 ; select basic rom
	ld (stored_paging_byte_address), a
	ld bc, #7ffd
	out (c),a ; set page 7
	ld HL, #d800
	ld BC, 768       ; set background to black
	ld D, 0b01000111 ; set ink to white
	call fill_mem
	
code_main_paging_not_available_skip_music_check:
	
	ei
	call clear_slow
	
	; set player page, so the code has access to shapes
	ld a, (player_page)
	ld l, a
	di
	ld a, (flip_mask)
	or l
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a ; set player page (where shapes are stored)
	ei
	
	jp frame_0_program_start

;;;;;;;;;;;;;;;;;;;;;;;;;;;
; on screen display text
;;;;;;;;;;;;;;;;;;;;;;;;;;;
ctl_paper:	EQU $11
ctl_ink:	EQU $10
ctl_at:		EQU $16
ctl_bright:	EQU $13
text_nikhotmsk_presents: ; BYTE ctl_paper,0,ctl_ink,7,ctl_bright,1
	;BYTE ctl_at,8, 6,'       _____'
	;BYTE ctl_at,9, 6,'      / ___ \'
	;BYTE ctl_at,10,6,'       /   \'
	;BYTE ctl_at,11,6,'      /__O__\'
	BYTE ctl_at,22,4,'  nik-hot-msk  presents', '$'
text_cc24_invitation:
	BYTE ctl_at,22,4,' an intro that invites you'
	BYTE ctl_at,23,4,'  to the CC"24 demoparty', '$'


text_precomputing:
	BYTE ctl_at,11,10,'Precomputing...', '$'
text_hello_hackerz:
	BYTE ctl_at,11,11,'Hi coderz!!', '$'
text_watch_this:
	BYTE ctl_at,11,11,'WATCH THIS!', '$'
text_hello_invitation_2:
	BYTE ctl_at,11,6,'  to the DEMOPARTY', '$'

text_filler_1:
	BYTE ctl_at,20,0,'  Demoparty on old CRT displays ', '$'
text_filler_2:
	BYTE ctl_at,20,0,'        A lot of DIY stuff      ', '$'
text_filler_3:
	BYTE ctl_at,20,0,'    https://undefined.c-c.ru    ', '$'
text_filler_4:
	BYTE ctl_at,20,0,'      http://107.189.31.31      ', '$'



;place_single:
;	BYTE 1, 0, 0, 0, 0 ; [enable] [dY dX] [dFrame]
;	BYTE 0 ; terminator



;;;;;;;;;;;;;;;
; call_de
;;;;;;;;;;;;;;;
call_de:
	push de
	ret
	
;;;;;;;;;;;;;;;;;;;;;;;
; callback_set_border_white
;;;;;;;;;;;;;;;;;;;;;;;
callback_set_border_white:
	ld a, 7
	out (#FE),A      ; border white
	ret
;;;;;;;;;;;;;;;;;;;;;;;
; callback_set_border_black
;;;;;;;;;;;;;;;;;;;;;;;
callback_set_border_black:
	ld a, 0
	out (#FE),A      ; border black
	ret


	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; set_right_page_and_chosen_shedule
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
set_right_page_and_chosen_shedule:
	ld hl, (asm_file_for_screen_0 + 10) ; [schedule]
	ld (asm_chosen_shedule), hl
	
	 ; do not forget to set right page for shedule_add_figurine
	ld iy, asm_file_for_screen_0
	ld a, (iy+7) ; [memory page]
	or 16 ; always select basic48 ROM
	ld l, a
	;di
	ld a, (flip_mask)
	or l
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a
	ei
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; a structure for shadow screen pointers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
asm_file_for_screen_0: WORD vault_c000	; [*assembler_running_w]
	WORD vault_c000						; [*vault]
	WORD vault_c000_wraparound			; [*wraparound]
	BYTE 1								; [enable asm]
	BYTE 4								; [memory page]
	WORD $0000							; [*screen file offset]
	WORD shedule_c000					; [*shedule]
	WORD 0								; [*bank to be erased]
	BYTE 0								; [frame number mask]
	
asm_file_for_screen_1: WORD drawing_code_vault	; [*assembler_running_w]
	WORD drawing_code_vault						; [*vault]
	WORD wraparound_area				; [*wraparound]
	BYTE 1								; [enable asm]
	BYTE 7								; [memory page]
	WORD $8000							; [*screen file offset]
	WORD shedule_6000					; [*shedule]
	WORD 0								; [*bank to be erased]
	BYTE 0								; [frame number mask to be erased]
; [*assembler_running_w] [*vault] [*wraparound] [enable asm] [memory page] [*screen file offset] [*screen file offset] [*shedule] [*bank to be erased] [frame number mask]


vault_c000: EQU $c000 ; on page 4
	; size 13384
vault_c000_wraparound: EQU vault_c000 + 13384
vault_c000_end: EQU vault_c000_wraparound + 16
shedule_c000: EQU vault_c000_end
shedule_c000_end: EQU shedule_c000 + (shedule_entry_size * shedule_size)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; silkscreen_mirror_leftright_run
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
silkscreen_mirror_leftright_run:
	ld ix, vars
	; load X coordinate and mirror it
	ld a, (ix+0)
	xor 0b11111111 ; make negative number (and wrap around modulo 256)
	inc a
	ld (ix+0), a
	ld a, (ix+2)
	xor 0b11111111
	inc a
	ld (ix+2), a
	ld a, (ix+4)
	xor 0b11111111
	inc a
	ld (ix+4), a
	ld a, (ix+6)
	xor 0b11111111
	inc a
	ld (ix+6), a
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; silkscreen_mirror_updown_run
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
silkscreen_mirror_updown_run:
	ld ix, vars
	; load Y coordinate and mirror it around the center of the screen
	ld a, (ix+1)
	xor 0b11111111  ; make negative number, same as neg a
	inc a
	add 192
	ld (ix+1), a
	
	ld a, (ix+3)
	xor 0b11111111
	inc a
	add 192
	ld (ix+3), a
	
	ld a, (ix+5)
	xor 0b11111111
	inc a
	add 192
	ld (ix+5), a
	
	ld a, (ix+7)
	xor 0b11111111
	inc a
	add 192
	ld (ix+7), a
	ret



assembled_sequence_tv_color_zone_16:
	BYTE 96, 106 ; [upper lower pixels]
	WORD callback_color_around_tv ; [*drawing code]
	BYTE 128 ; [upper_point_x]
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	BYTE 96, 106
	WORD callback_color_around_tv
	BYTE 128
	
	BYTE 0, 0, 0, 0, 0


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; callback_color_around_tv
; hl - screen pointer
; b - drawing/erase mode
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
callback_color_around_tv:
	ld a, l
	ld e, a
	
	ld a, h
	rra
	rra
	rra
	and 0b00000011 ; get attribute pointer from screen pointer
	ld d, a
	ld a, h
	and 0b10000000 ; also take shadow screen offset
	or  0b01011000  ; set address to $5800
	or d
	ld d, a ; de contains attribute pointer
	
	ld a, 0b01000111 ; black background & white ink
	bit 0, b
	jr z, callback_color_around_tv_erase_mode
	ld a, 0b01000011 ; black background & pink ink
callback_color_around_tv_erase_mode:
	
	ex hl, de
	ld de, -160 ; move up five steps
	add hl, de
	ld (hl), a
	inc hl
	ld (hl), a
	inc hl
	ld (hl), a
	inc hl
	ld (hl), a
	ld de, 32
	add hl, de ; move down one step
	ld (hl), a
	add hl, de ; move down one step
	ld (hl), a
	add hl, de ; move down one step
	ld (hl), a
	add hl, de ; move down one step
	ld (hl), a
	add hl, de ; move down one step
	ld (hl), a
	add hl, de ; move down one step
	ld (hl), a
	add hl, de ; move down one step
	ld (hl), a
	dec hl
	ld (hl), a
	dec hl
	ld (hl), a
	dec hl
	ld (hl), a
	dec hl
	ld (hl), a
	dec hl
	ld (hl), a
	dec hl
	ld (hl), a
	dec hl
	ld (hl), a
	ld de, -32
	add hl, de ; move up one step
	ld (hl), a
	add hl, de
	ld (hl), a
	add hl, de
	ld (hl), a
	add hl, de
	ld (hl), a
	add hl, de
	ld (hl), a
	add hl, de
	ld (hl), a
	add hl, de
	ld (hl), a
	inc hl
	ld (hl), a
	inc hl
	ld (hl), a
	inc hl
	ld (hl), a ; color area ready
	ret

;;;;;;;;;;;;;;;;;;;;;
; shedule_compile_shape (sequence)
; hl - shape sequence
; de - base frame number
; add_shape_places_table - places sequence
;;;;;;;;;;;;;;;;;;;;;
shedule_prev_line_a: WORD 0 ; X Y (like in memory)
shedule_prev_line_b: WORD 0
shedule_base_frame_number: WORD 0
add_shape_places_table: WORD 0 ; place_single
asm_chosen_shedule: WORD 0
asm_chosen_screen_offset: BYTE 0
asm_sequence_buffer: WORD 0
silkscreen_mirror_updown: BYTE 0
silkscreen_mirror_leftright: BYTE 0
upper_point_lower_point_orig: WORD 0
upper_point_x_orig: BYTE 0
shedule_compile_shape_mirror_override_only_right: BYTE 0
shedule_compile_shape:
	ld (shedule_base_frame_number), de
	ld ix, hl
	ld hl, 0
	ld (shedule_prev_line_a), hl ; reset prev_line
	ld (shedule_prev_line_b), hl
shedule_add_shape_cycle1:
	; decide where to put the drawing code, which shadow screen to use
	push hl
	ld iy, asm_file_for_screen_0
	ld hl, (shedule_base_frame_number)
	ld a, l ; choice the memory page here
	and 0b00000010
	jr z, shedule_add_shape_screen_0
	ld iy, asm_file_for_screen_1
shedule_add_shape_screen_0:
	ld hl, (iy+8) ; [screen offset]
	ld a, h
	ld (asm_chosen_screen_offset), a
	ld hl, (iy+10) ; [*shedule]
	ld (asm_chosen_shedule), hl
	
	; select page with shapes, so IX will work
	ld a, (player_page)
	or 16 ; always select basic48 ROM
	ld l, a
	;di
	ld a, (flip_mask)
	or l
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a ; set page
	;ei
	
	pop hl
	
	ld bc, (ix+0)
	ld a, b
	or c
	ret z ; sequence ready
	
	ld bc, (shedule_prev_line_a)
	ld de, (shedule_prev_line_b)
	ld a, b
	or c
	or d
	or e ; check if prev line empty
	jr nz, shedule_add_shape_draw ; do not draw, just remember prev line
	ld bc, (ix+0) ; c = X, b = Y ??
	inc ix
	inc ix
	ld de, (ix+0)
	inc ix
	inc ix
	ld (shedule_prev_line_a), bc
	ld (shedule_prev_line_b), de
	
	jr shedule_add_shape_cycle1
shedule_add_shape_draw:
	
	; silkscreen (do not forget to push ix)
	ld hl, vars
	ld bc, (ix+0) ; c = Y, b = X
	ld (hl), c
	inc hl
	ld (hl), b
	inc hl
	ld bc, (ix+2)
	ld (hl), c
	inc hl
	ld (hl), b ; fill vars with figurine parameters
	inc hl
	ld bc, (shedule_prev_line_b) ; c = Y, b = X
	ld (hl), c
	inc hl
	ld (hl), b
	inc hl
	ld bc, (shedule_prev_line_a)
	ld (hl), c
	inc hl
	ld (hl), b
	inc hl
	
	push ix
	
	;ld a, (silkscreen_mirror_updown) ; moved down to the assembler
	;or a
	;call nz, silkscreen_mirror_updown_run
	
	;ld a, (silkscreen_mirror_leftright)
	;or a
	;call nz, silkscreen_mirror_leftright_run
	
	; select page with drawing code vault
	ld a, (iy+7) ; [memory page]
	or 16 ; always select basic48 ROM
	ld l, a
	;di
	ld a, (flip_mask)
	or l
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a
	;ei
	
	pop ix
	
	ld hl, 0 ; if asm is disabled, write 0 at drawing code pointer
	ld a, 1
	ld (upper_point_lower_point), a ; put default value to make entry active
	
	ld a, (iy+6) ; [enable asm]
	or a
	jp z, shedule_add_shape_asm_disabled
	
	push ix
	
	call silkscreen_figurine ; this function sets upper_point_lower_point
	; call debug_lines
	; .8 call busy_wait
	
	; do not forget to set asm_file IY
	call silkscreen.silkscreen_assembler ; (returns HL)
	push hl
	ld hl, (upper_point_lower_point)
	ld (upper_point_lower_point_orig), hl
	ld a, (upper_point_x)
	ld (upper_point_x_orig), a
	
	ld hl, (iy+0) ; running_w
	dec hl ; remove ret
	ld (iy+0), hl ; running_w
	call silkscreen_mirror_leftright_run
	call silkscreen_figurine ; upper_point_lower_point is set
	call silkscreen.insert_assembler_decode_reencode_position_y_call
	call silkscreen.silkscreen_assembler ; adhoc mode
	ld a, (shedule_compile_shape_mirror_override_only_right)
	or a
	jr nz, shedule_compile_shape_mirror_skip1
	ld hl, (iy+0) ; running_w
	dec hl ; remove ret
	ld (iy+0), hl ; running_w
	call silkscreen_mirror_updown_run
	call silkscreen_figurine ; upper_point_lower_point is set
	call silkscreen.insert_assembler_decode_reencode_position_y_call
	call silkscreen.silkscreen_assembler ; adhoc mode
	ld hl, (iy+0) ; running_w
	dec hl ; remove ret
	ld (iy+0), hl ; running_w
	call silkscreen_mirror_leftright_run
	call silkscreen_figurine ; upper_point_lower_point is set
	call silkscreen.insert_assembler_decode_reencode_position_y_call
	call silkscreen.silkscreen_assembler ; adhoc mode
shedule_compile_shape_mirror_skip1:
	pop hl ; (hl is a drawing code starting point)
	
	pop ix
shedule_add_shape_asm_disabled:
	; remember prev line
	push hl ; select page with shapes
	ld a, (player_page)
	ld l, a
	; di
	ld a, (flip_mask)
	or l
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a ; set page
	;ei
	pop hl
	ld bc, (ix+0)
	inc ix
	inc ix
	ld de, (ix+0)
	inc ix
	inc ix
	ld (shedule_prev_line_a), bc
	ld (shedule_prev_line_b), de ; also move ix forvard
	
	; put it in draw queue
	push ix
	
	;push hl ; select page with shedule
	;ld a, (iy+7) ; [memory page]
	;or 16 ; always select basic48 ROM
	;ld l, a
	;; di
	;ld a, (flip_mask)
	;or l
	;ld   bc, #7ffd
	;ld (stored_paging_byte_address), a
	;out  (c),a
	;ei
	;pop hl
	
	;ld a, (iy+6) ; [enable asm]
	; or a
	; call nz, shedule_add_figurine_many_places (deprecated)
	
	ld ix, (asm_sequence_buffer) ; this allows for compilation and later posting
	; there was no such thing before, compiler was doing posting immediately
	ld (ix+2), hl
	ld hl, (upper_point_lower_point_orig)
	ld (ix+0), hl ; [upper lower pixels] [*drawing code] [upper_point_x]
	ld a, (upper_point_x_orig)
	ld (ix+4), a
	inc ix
	inc ix
	inc ix
	inc ix
	inc ix
	ld (asm_sequence_buffer), ix
	ld hl, 0
	ld (ix+0), hl ; mark the end of sequence
	
	
	pop ix
	ld de, (shedule_base_frame_number)
	inc de
	inc de
	ld (shedule_base_frame_number), de
	
	jp shedule_add_shape_cycle1

;;;;;;;;;;;;;;;;;;;;;;;;;;
; shedule_post_sequence
; ix - sequence buffer
; de - base frame number
; bc - position shift
;;;;;;;;;;;;;;;;;;;;;;;;;;
shedule_post_sequence_track_enabled: BYTE 1
shedule_post_sequence_running_track: WORD 0
shedule_post_sequence_track_return: WORD 0
shedule_post_sequence_running_running_track: WORD 0
shedule_post_sequence:
	ld hl, (shedule_post_sequence_running_track)
	ld (shedule_post_sequence_running_running_track), hl
	ld a, 0
	ld (shedule_add_figurine_cached), a
shedule_post_sequence_loop:
	ld hl, (ix+0) ; [upper lower pixels] [*drawing code] [upper_point_x]
	ld a, h
	or l
	ret z
	ld (upper_point_lower_point), hl
	ld a, (ix+4)
	ld (upper_point_x), a
	ld hl, (ix+2) ; [upper lower pixels] [*drawing code] [upper_point_x]
	; bc is ready
	; de is ready
	ld a, (shedule_post_sequence_track_enabled)
	or a
	jr z, shedule_post_sequence_no_track
	push ix
	ld ix, (shedule_post_sequence_running_running_track)
	; [frame number] [track running] [track returning point]
	; [x] [y] [visible] [enabled]
	ld bc, (ix+0) ; [x] [y]
	push de
	ld de, 4
	add ix, de ; move to next entry in track
	pop de:
	ld a, (ix+3) ; enabled
	or a
	jr nz, shedule_post_sequence_track_no_wraparound
	; wraparound here
	push de
	ld de, (shedule_post_sequence_track_return)
	ld ix, de
	ld (shedule_post_sequence_running_running_track), de
	pop de
shedule_post_sequence_track_no_wraparound:
	ld (shedule_post_sequence_running_running_track), ix
	pop ix
	
	
shedule_post_sequence_no_track:
	
	ld a, h
	or l
	jr z, shedule_post_sequence_no_write ; drawing code pointer is 0
	
	push bc
	push de
	push ix
	call shedule_add_figurine
	pop ix
	pop de
	pop bc
shedule_post_sequence_no_write:
	
	inc de
	inc de
	
	inc ix
	inc ix
	inc ix
	inc ix
	inc ix
	jr shedule_post_sequence_loop
	ret



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; wait_for_frame
; de - frame number (function will halt if frame_counter is less then de)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
tv_flag_contect_1: BYTE 0
tv_flag_contect_2: BYTE 0
tv_flag_contect_3: BYTE 0
wait_for_frame:
	push de
	
	ld a, (tv_flag_contect_1)
	or a
	jr z, wait_for_frame_skip_context_1
	ld ix, tv_context_1
	;call interrupt_page_set_player_page
	call shedule_post_tv ; invoke in interrupt mode
	ld a, 0
	ld (tv_flag_contect_1), a
wait_for_frame_skip_context_1:
	ld a, (tv_flag_contect_2)
	or a
	jr z, wait_for_frame_skip_context_2
	ld ix, tv_context_2
	;call interrupt_page_set_player_page
	call shedule_post_tv ; invoke in interrupt mode
	ld a, 0
	ld (tv_flag_contect_2), a
wait_for_frame_skip_context_2:
	ld a, (tv_flag_contect_3)
	or a
	jr z, wait_for_frame_skip_context_3
	ld ix, tv_context_3
	;call interrupt_page_set_player_page
	call shedule_post_tv ; invoke in interrupt mode
	ld a, 0
	ld (tv_flag_contect_3), a
wait_for_frame_skip_context_3:

	pop de
	ld hl, (frame_counter)
	or a ; clear carry flag
	sbc hl, de
	add hl, de	; compare words
	ret nc		; carry is set if (hl < de)
	halt
	jr wait_for_frame

;;;;;;;;;;;;;;;;;;;;;
; shedule_add_figurine
; hl - drawing code
; de - frame number (must not be even (because erase runs at 25 fps))
; bc - position shift
;;;;;;;;;;;;;;;;;;;;;
shedule_add_figurine_frame_number_mask: BYTE 0
shedule_add_figurine_cached: BYTE 0
shedule_add_figurine_cached_offset: WORD 0
shedule_add_figurine:
	ld a, 2 ; red
	out (#FE),A ; debug border
	
	push hl
	
	ld a, (shedule_add_figurine_cached)
	or a
	jr z, shedule_add_figurine_do_compute_cache
	; here we do shedule pointer increment and page file flip
	; WONTFIX cache is not implemented, do entry appending instead
	
	
	jp shedule_add_figurine_skip_computing
	
shedule_add_figurine_do_compute_cache:
	
	; select page based on drawing code pointer
	
	ld iy, asm_file_for_screen_0
	ld a, e ; choice the memory page based on frame number
	and 0b00000010
	jr z, shedule_add_figurine_select_screen_ready
	ld iy, asm_file_for_screen_1
	
shedule_add_figurine_select_screen_ready:
	; now iy holds screen file struct
	pop hl
	
	push hl
	push de
	; select shedule bank here
	ld a, e
	ld de, shedule_bank_size * shedule_entry_size ; 20 * 5 = 100
	; shedule itself is 16 banks, second shedule for shadow screen
	ld hl, 0
	; test bits in a
	bit 2, a
	jr z, asm_multiply_0001_skip
	add hl, de ; addition here
asm_multiply_0001_skip:
	or a ; drop carry bit
	rl e ; rotate left
	rl d
	bit 3, a
	jr z, asm_multiply_0010_skip
	add hl, de
asm_multiply_0010_skip:
	or a ; drop carry bit
	rl e
	rl d
	bit 4, a
	jr z, asm_multiply_0100_skip
	add hl, de
asm_multiply_0100_skip:
	or a ; drop carry bit
	rl e
	rl d
	bit 5, a
	jr z, asm_multiply_1000_skip
	add hl, de
asm_multiply_1000_skip: ; end of multiply

	ld (shedule_add_figurine_cached_offset), hl ; offset found
	pop de
	
	;ld a, 0 ; WONTFIX cache disabled and not implemented
	;ld (shedule_add_figurine_cached), a ; mark as cached
	; next time bank offset and file flip will be taken from cache
	
shedule_add_figurine_skip_computing:
	
	ld hl, (iy+10) ; [schedule]
	ld (asm_chosen_shedule), hl
	ld hl, (iy+8) ; [screen offset]
	ld a, h
	ld (asm_chosen_screen_offset), a

	ld a, (iy+7) ; [memory page]
	or 16 ; always select basic48 ROM
	ld l, a
	; di
	ld a, (flip_mask)
	or l
	push bc
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a ; switching pages
	out  (c),a
	pop bc
	; ei
	
	push de ; prepare frame number mask (enable byte)
	;or a ; drop carry
	rr d
	rr e
	rr d
	rr e
	ld a, e
	and 0b11111100
	or 1 ; LSB is always one
	ld (shedule_add_figurine_frame_number_mask), a
	pop de
	
	ld hl, (shedule_add_figurine_cached_offset)
	ex hl, de
	ld ix, (asm_chosen_shedule)
	add ix, de ; now  IX is a shedule bank
	; [hl register] [drawing code] [enable]
	
	; if asm is not enabled, do not write
	ld a, (iy+6) ; [enable asm]
	or a
	jp z, shedule_add_figurine_abort
	
	push bc
	push de
	ld b, shedule_bank_size
shedule_add_figurine_c1:
	; move ix to empty slot here
	
	ld a, (ix+4) ; [enable]
	or a
	jr z, shedule_add_figurine_found_slot1
	ld de, shedule_entry_size
	add ix, de
	dec b
	jr nz, shedule_add_figurine_c1
	; no space left, clobber the first entry
	ld hl, (shedule_add_figurine_cached_offset)
	ex hl, de
	ld ix, (asm_chosen_shedule)
	add ix, de ; ix is back to the beginning of the bank
shedule_add_figurine_found_slot1:
	pop de
	pop bc
	
	push bc
	sla b
	sla b
	sla b ; multiply by 8
	ld a, b
	ld hl, (upper_point_lower_point)
	add h
	ld b, a ; add vertical shift ; TODO add return path crop
	ld a, (upper_point_x)
	ld c, a
	call Get_Pixel_Address ; returns hl
debug_point_4:
	ld a, (asm_chosen_screen_offset)
	or h
	ld h, a
	pop bc
	ld a, l      ; add horizontal shift value
	add c
	ld l, a
	di
	ld (ix+0), l ; screen address ready
	ld (ix+1), h
	pop hl
	ld (ix+2), l
	ld (ix+3), h ; drawing code address ready
	ld a, (shedule_add_figurine_frame_number_mask)
	ld (ix+4), a ; enable byte ; it is atomic write here
	; FIXME this routine now can run both inside interrupt and as normal code
	; FIXME need to disable interrupts for table write
	ei

shedule_add_figurine_abort:
	; change page back to player page
	ld a, (player_page)
	or 16 ; always select basic48 ROM
	ld l, a
	; di
	ld a, (flip_mask)
	or l
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a
	;ei

	ld a, 0 ; black
	out (#FE),A ; debug border
	ret


;;;;;;;;;;;;;;;;;;
; empty_routine
;;;;;;;;;;;;;;;;;;
empty_routine:
	
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;
; clear screen data
;;;;;;;;;;;;;;;;;;;;;;;;;
clear_slow:
	; di
	ld a, (flip_mask)
	or 7
	or 16 ; always select basic48 ROM
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a ; set page 7 (no op if it is spectrum48)
	ei
debug_point_6:
	ld a, (paging_available)
	or a
	jr nz, clear_slow_paging_ok
	ld a, $00 ; nop
	ld (clear_slow_mod1), a ; self modify code so it does not write to c000
clear_slow_paging_ok:

	ld HL, #4000
	ld de, #c000 ; on page 7
	ld BC, 6144      ; clear image data (slow and nice)
clear_slow_c1:
	xor a
	ld (hl), a ; draw on screen
clear_slow_mod1:
	ld (de), a ; draw on shadow screen
	inc hl
	inc de
	dec bc
	ld a, c
	or a
	jr nz, clear_slow_skip1
	halt
clear_slow_skip1:
	or b
	jr nz, clear_slow_c1
	
	ld a, (player_page)
	or 16 ; always select basic48 ROM
	ld l, a
	; di
	ld a, (flip_mask)
	or l
	ld   bc, #7ffd
	ld (stored_paging_byte_address), a
	out  (c),a ; set player page, because program is there
	ei
	ret
	
;
; fill memory with constant byte
;
; D  - byte
; HL - start address
; BC - size
;
fill_mem:
  ld A, D
  ld (HL), A
  inc HL
  dec BC
  ld A,B
  or C
  jr nz, fill_mem
  ret


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; silkscreen_figurine
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
silkscreen_figurine:
	; TODO clear the header
	ld h, 255
	ld l, 0
	ld (upper_point_lower_point), hl ; reset upper point
	
	; clear the buffer
	ld c, 192
	ld hl, silk_data
	ld b, 255 ; these are the shape coordinates
	ld a, 0   ; they are invalid, so drawing code will fix them
silkscreen_figurine_c1:
	ld (hl), b
	inc hl
	ld (hl), a ; set second point to zero to mark it as disabled
	inc hl
	dec c
	jr nz, silkscreen_figurine_c1
	
	; do silkscreen drawing
	ld ix, vars
	ld bc, (ix+0) ; AB
	ld de, (ix+2)
	call silkscreen.Draw_Line
	
	ld ix, vars
	ld bc, (ix+2) ; BC
	ld de, (ix+4)
	
	call silkscreen.Draw_Line
	
	ld ix, vars
	ld bc, (ix+4) ; CD
	ld de, (ix+6)
	
	call silkscreen.Draw_Line
	
	ld ix, vars
	ld bc, (ix+6) ; DA
	ld de, (ix+0)
	call silkscreen.Draw_Line
	
	
	ret
	

;;;;;;;;;;;;;;;;;;;;;;;;
; debug_draw_silkscreen
;;;;;;;;;;;;;;;;;;;;;;;;
;debug_draw_silkscreen:
;	ld hl, silk_data
;	ld c, 192 ; counter
;	ld b, 0   ; Y coordinate
;debug_draw_silkscreen_c1:
;	push bc
;	ld d, b ; make horisontal line
;	ld c, (hl) ; load X left
;	inc hl
;	ld e, (hl) ; load X right
;	inc hl
;	push hl
;	ld a, e ; check if the line is active
;	or a
;	jr z, debug_draw_silkscreen_s
;	ld a, e ; check if line is valid
;	cp c
;	jr c, debug_draw_silkscreen_s
;	jr z, debug_draw_silkscreen_s
;	dec e ; last point is not included
;	;call nz, Plot
;	;ld b, d
;	;ld c, e
;	;call nz, Plot
;	call Draw_Line
;debug_draw_silkscreen_s:
;	pop hl
;	pop bc
;	inc b
;	dec c
;	jr nz, debug_draw_silkscreen_c1
;	ret

;;;;;;;;;;;;;;;;;;;;;;;;
; debug_lines
;;;;;;;;;;;;;;;;;;;;;;;;
;debug_lines:
;	ld ix, vars
;	ld bc, (ix+0) ; AB
;	ld de, (ix+2)
;	call Draw_Line
;	
;	ld ix, vars
;	ld bc, (ix+2) ; BC
;	ld de, (ix+4)
;	call Draw_Line
;	
;	ld ix, vars
;	ld bc, (ix+4) ; CD
;	ld de, (ix+6)
;	call Draw_Line
;	
;	ld ix, vars
;	ld bc, (ix+6) ; DA
;	ld de, (ix+0)
;	call Draw_Line
;	ret
	
	
;
; this code comes from ChibiAkumas. Compute spectrum video address
;
; B  - X in bytes
; C  - Y
; return DE - mem pos in video memory
;;;;;;;;;;;;;;;;;;;;;;;;;
; get_video_pos
;;;;;;;;;;;;;;;;;;;;;;;;;
get_video_pos:
  ld a, c
  and %00111000
  rlca
  rlca
  or b
  ld e, a ; first byte is ready
  ld a, c
  and %00000111
  ld d, a
  ld a, c
  and %11000000
  rrca
  rrca
  rrca
  or d
  or #40
  ld d, a ; second byte is ready
  ret


;
; this code comes from ChibiAkumas too.
;
; DE - address in video mem
; returns DE - new address
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; get_next_line
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
get_next_line:
  inc d
  ld a, d
  and    %00000111 ; check bits Y5 Y4 Y3 overflow
  ret nz
  ld a, e
  add a, %00100000
  ld e, a
  ret c            ; check bits Y2 Y1 Y0 overflow
  ld a, d
  sub    %00001000 ; fix overflow bit Y6
  ld d, a
  ret


;;;;;;;;;;;;;;;;;;;;;;
; busy_wait
;;;;;;;;;;;;;;;;;;;;;;
busy_wait:
	push bc
	ld bc, 5000
busy_wait_loop:
	dec bc
	ld a, b
	or c
	jr nz, busy_wait_loop
	pop bc
	ret




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; shapes
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

shape_flyby_1:
	BYTE 10,115,14,119
	BYTE 40,82,44,87
	BYTE 118,51,119,59
	BYTE 189,66,185,70
	BYTE 198,114,192,112
	BYTE 160,132,162,125
	BYTE 126,113,134,110
	BYTE 130,83,135,88
	BYTE 199,71,201,63
	BYTE 224,105,234,107
	BYTE 186,149,187,154
	BYTE 120,137,112,143
	BYTE 114,100,108,96
	BYTE 143,64,141,54
	BYTE 211,71,219,66
	BYTE 212,128,220,132
	BYTE 164,148,160,156
	BYTE 151,111,142,114
	BYTE 177,55,172,50
	BYTE 225,23,218,17
	BYTE 0,0,0,0




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; scanline fill by John Metcalf
; call with d=x-coord, e=y-coord
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; set end marker

fill:
  ld l,255
  push hl

; calculate bit position of pixel

nextrun:
  ld a,d
  and 7
  inc a
  ld b,a
  ld a,1
bitpos:
  rrca
  djnz bitpos
  ld c,b
  ld b,a

; move left until hitting a set pixel or the screen edge

seekleft:
  ld a,d
  or a
  jr z,goright
  dec d
  rlc b
  call scrpos
  jr nz,seekleft

; move right until hitting a set pixel or the screen edge,
; setting pixels as we go. Check rows above and below and
; save their coordinates to fill later if necessary

seekright:  
  rrc b
  inc d
  jr z,rightedge
goright:
  call scrpos
  jr z,rightedge
  ld (hl),a
  inc e
  call checkadj
  dec e
  dec e
  call checkadj
  inc e
  jr seekright

; check to see if there's another row waiting to be filled

rightedge:
  pop de
  ld a,e
  inc a
  jr nz,nextrun
  ret  

; calculate the pixel address and whether or not it's set

scrpos:
  ld a,e
  and 248
  rra
  scf
  rra
  rra
  ld l,a
  xor e
  and 248
  xor e
  ld h,a
  ld a,l
  xor d
  and 7
  xor d
  rrca
  rrca
  rrca
  ld l,a
  ld a,b
  or (hl)
  cp (hl)
  ret

; check and save the coordinates of an adjacent row

checkadj:
  sla c
  ld a,e
  cp 192
  ret nc
  call scrpos+1
  ret z
  inc c
  bit 2,c
  ret nz
  pop hl
  push de
  jp (hl)

polyline_pointer: WORD draw_polyline_empty
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; fischinger_draw_polyline
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
fischinger_draw_polyline:
polyline_speed:
	ld b, 2 ; speed of drawing
draw_polyline_cycle: ; draw logo
	call interrupt_page_set_player_page
	
	ld hl, (polyline_pointer)
	ld ix, hl
	ld a, (ix+0)
	or a ; check zero
	jr z, no_draw_polyline
	ld a, (ix+1)

	or a ; check zero
	jr z, no_draw_polyline
	ld a, (ix+2)
	ld e, a
	or a
	jr z, no_draw_polyline
	ld a, (ix+3)
	ld d, a
	or a
	jr z, no_draw_polyline
	
	push bc
	ld c, (ix+0)
	ld b, (ix+1)
	;
	; bc = Ya Xa
	; de = Yb Xb
	;
	; b = Ya c = Xa
	; d = Yb e = Xb
	;
	call interrupt_page_set_7
	call Draw_Line
	call interrupt_page_set_player_page
	pop bc
	
	ld hl, (polyline_pointer)
	inc hl
	inc hl
	inc hl
	inc hl
	ld (polyline_pointer), hl
	
	dec b
	jr nz, draw_polyline_cycle
no_draw_polyline:
	ret

polyline_erase_pointer: WORD draw_polyline_empty
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; fischinger_erase_polyline
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
fischinger_erase_polyline:
polyline_erase_speed:
	ld b, 2 ; speed of eraseing
erase_polyline_cycle: ; erase logo
	call interrupt_page_set_player_page
	
	ld hl, (polyline_erase_pointer)
	ld ix, hl
	ld a, (ix+0)
	or a ; check zero
	jr z, no_erase_polyline
	ld a, (ix+1)

	or a ; check zero
	jr z, no_erase_polyline
	ld a, (ix+2)
	ld e, a
	or a
	jr z, no_erase_polyline
	ld a, (ix+3)
	ld d, a
	or a
	jr z, no_erase_polyline
	
	push bc
	ld c, (ix+0)
	ld b, (ix+1)
	;
	; bc = Ya Xa
	; de = Yb Xb
	;
	; b = Ya c = Xa
	; d = Yb e = Xb
	;
	call interrupt_page_set_7
	call Erase_Line
	call interrupt_page_set_player_page
	pop bc
	
	ld hl, (polyline_erase_pointer)
	inc hl
	inc hl
	inc hl
	inc hl
	ld (polyline_erase_pointer), hl
	
	dec b
	jr nz, erase_polyline_cycle
no_erase_polyline:
	ret

;;;;;;;;;;;;;;;;;;;;;;;;
; callback_self_post_tv_again_context_1
;;;;;;;;;;;;;;;;;;;;;;;;
callback_self_post_tv_again_context_1:
	bit 0, b
	ret z
	ld a, 1
	ld (tv_flag_contect_1), a
	ret


;;;;;;;;;;;;;;;;;;;;;;;;
; callback_self_post_tv_again_context_2
;;;;;;;;;;;;;;;;;;;;;;;;
callback_self_post_tv_again_context_2:
	bit 0, b
	ret z
	
	ld a, 1
	ld (tv_flag_contect_2), a
	ret
	
;;;;;;;;;;;;;;;;;;;;;;;;
; callback_self_post_tv_again_context_3
;;;;;;;;;;;;;;;;;;;;;;;;
callback_self_post_tv_again_context_3:
	bit 0, b
	ret z
	
	ld a, 1
	ld (tv_flag_contect_3), a
	ret


;;;;;;;;;;;;;;;;;;;;;;;;
; interrupt_page_set_7
;;;;;;;;;;;;;;;;;;;;;;;;
interrupt_page_set_7:
	push bc
	; di
	ld a, (flip_mask)
	or 7  ; page 7
	or 16 ; select basic rom
	; ld (stored_paging_byte_address), a ; its interrupt
	ld bc, #7ffd
	out (c),a ; set page 7
	; ei
	pop bc
	ret
	
;;;;;;;;;;;;;;;;;;;;;;;;
; interrupt_page_set_player_page
;;;;;;;;;;;;;;;;;;;;;;;;
interrupt_page_set_player_page:
	push de
	push bc
	ld a, (player_page)
	or 16 ; select basic rom
	ld d, a
	;di
	ld a, (flip_mask)
	or d
	; ld (stored_paging_byte_address), a
	ld bc, #7ffd
	out (c),a ; set the page
	;ei
	pop bc
	pop de
	ret

;;;;;;;;;;;;;;;;;
; initSong
; hl,de - address of raw pt3 file
;;;;;;;;;;;;;;;;;
initSong:
	ld hl,music
	ld de,music
	ld a, (turbosound_flip_modules)
	or a
	jr z, initSong_noflip
	ex de, hl
initSong_noflip:
	ld a, (turbosound_setting_byte)
	ld (player+10),a
	     ;set bit0, if you want to play without looping
	     ;(optional);
	     ;set bit1 for PT2 and reset for PT3 before
	     ;calling INIT;
	     ;bits2-3: %00-ABC, %01-ACB, %10-BAC (optional);
	     ;bits4-5: %00-no TS, %01-2 modules TS, %10-
	     ;autodetect PT3 TS-format by AlCo (PT 3.7+);
	     ;Remark: old PT3 TS-format by AlCo (PT 3.6) is not
	     ;documented and must be converted to new standard.
	     ;bit6 is set each time, when loop point of 2nd TS
	     ;module is passed (optional).
	     ;bit7 is set each time, when loop point of 1st TS
	     ;or of single module is passed (optional).
	call player+3
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; vector.asm -- drawing routines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	INCLUDE "vector.asm"

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; vector_silkscreen.asm -- drawing routines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	MODULE silkscreen
	INCLUDE "vector_silkscreen.asm"
	ENDMODULE


;;;;;;;;;;;;;;;;;;;;;;;;;
; prerecorded variables here
;;;;;;;;;;;;;;;;;;;;;;;;;

frame_counter: WORD 0
draw_text_pointer: WORD draw_text_empty_byte
draw_text_screen_address: WORD $4000
draw_text_empty_byte: BYTE '$'
draw_text_erase: BYTE 0
;turbosound_setting_byte: BYTE 00010001b ; turbosound enabled
turbosound_setting_byte: BYTE 00000001b
turbosound_flip_modules: BYTE 0


;
; end of code
;
code_end:

; variables here (moved to 5ccb)
vars: EQU $5ccb
	; 8 bytes
upper_point_lower_point: EQU vars + 8
	; 2 bytes
upper_point_x: EQU upper_point_lower_point + 2
	; 1 byte
silk_header: EQU upper_point_x + 1
	; 2 bytes
silk_data: EQU silk_header + 2
	; 192*2 bytes
silk_end: EQU silk_data + 192*2
drawing_code_vault: EQU silk_end
	; 13384 bytes
wraparound_area: EQU drawing_code_vault + 13384
	; 16 bytes
drawing_code_vault_end: EQU wraparound_area + 16

shedule_6000: EQU drawing_code_vault_end
shedule_bank_size: EQU 31
shedule_size: EQU 16 * shedule_bank_size
shedule_entry_size: EQU 5
	; 16 * 20 * 5 bytes ; [hl register] [drawing code] [enable]
machine_stack: EQU shedule_6000 + (shedule_size * shedule_entry_size)
	; stack size 256
machine_stack_end: EQU machine_stack + 256
assembled_sequence_1_12: EQU machine_stack_end
	; [upper lower pixels] [*drawing code] [upper_point_x]
	; 5 * 12
assembled_sequence_2_12: EQU assembled_sequence_1_12 + (5 * 12)
	; 5 * 12
assembled_sequence_3_12: EQU assembled_sequence_2_12 + (5 * 12)
	; 5 * 12
assembled_sequence_4_12: EQU assembled_sequence_3_12 + (5 * 12)
	; 5 * 12
assembled_sequence_5_17: EQU assembled_sequence_4_12 + (5 * 12)
	; 5 * 17
assembled_sequence_6_17: EQU assembled_sequence_5_17 + (5 * 17)
	; 5 * 17
assembled_sequence_7_17: EQU assembled_sequence_6_17 + (5 * 17)
	; 5 * 17
assembled_sequence_8_17: EQU assembled_sequence_7_17 + (5 * 17)
	; 5 * 17
assembled_sequence_end: EQU assembled_sequence_8_17 + (5 * 17)

;;;;;;;;;;;;;;;;;;;;;;;;
; music code here
;;;;;;;;;;;;;;;;;;;;;;;;
	ORG $c000
player:
	MODULE ptsplay
	include "PTSPlay.asm"
	ENDMODULE
music:
	incbin "m.pt3"


;;;;;;;;;;;;;;;;;;;;;;;
; fischinger_make_static_shape_16
; ix - assembled_sequence_pointer
;;;;;;;;;;;;;;;;;;;;;;;
fischinger_make_static_shape_16:
	ld hl, ix
	ld de, 5 * 2
	add hl, de
	ex hl, de
	ld hl, ix
	ld bc, 5 * 2 ; 10
	ldir ; copy bytes multiple times
	ld hl, ix
	ld bc, 5 * 2 ; 10
	ldir
	ld hl, ix
	ld bc, 5 * 2 ; 10
	ldir
	ld hl, ix
	ld bc, 5 * 8 ; 40 bytes
	ldir
	ld a, 0
	ld (de), a ; null terminator
	inc de
	ld (de), a
	inc de
	ld (de), a
	inc de
	ld (de), a
	ret
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; FRAME 0 PROGRAM START
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
prepare_drawing_bitstream_running_x_byte: BYTE 0
frame_0_program_start:

	ld a, 0
	ld (flip_override), a ; enable flip

	;;;;;;;;;;;;;;;;;;;;
	; walking tv precalculating
	;;;;;;;;;;;;;;;;;;;;
	ld de, 24 / 2
	call wait_for_frame
	ld a, 0
	ld (draw_text_erase), a
	ld hl, text_precomputing
	ld (draw_text_pointer), hl
	
	;ld a, 1
	;out (#FE),A ; border blue (make it visible just for debugging)
	
	ld a, 0
	ld (silkscreen_mirror_updown), a
	ld (silkscreen_mirror_leftright), a ; disable mirror
	
	ld hl, assembled_sequence_1_12
	ld (asm_sequence_buffer), hl
	ld hl, shape_romb_24_down_right ; compile
	ld de, 100 ; frame number (just for shadow screen selection)
	call shedule_compile_shape
	
	;ld a, 1
	;ld (silkscreen_mirror_updown), a ; enable mirror
	
	;ld hl, assembled_sequence_2_12
	;ld (asm_sequence_buffer), hl
	;ld hl, shape_romb_24_down_right ; compile
	;ld de, 100
	;call shedule_compile_shape
	
	;ld a, 1
	;ld (silkscreen_mirror_leftright), a ; enable another mirror
	
	;ld hl, assembled_sequence_3_12
	;ld (asm_sequence_buffer), hl
	;ld hl, shape_romb_24_down_right ; compile
	;ld de, 100
	;call shedule_compile_shape
	
	;ld a, 0
	;ld (silkscreen_mirror_updown), a ; disable first mirror
	
	;ld hl, assembled_sequence_4_12
	;ld (asm_sequence_buffer), hl
	;ld hl, shape_romb_24_down_right ; compile
	;ld de, 100
	;call shedule_compile_shape
	
	;ld a, 0
	;ld (silkscreen_mirror_leftright), a ; disable second mirror just for sure
	
	
	ld hl, assembled_sequence_5_17
	ld (asm_sequence_buffer), hl
	ld hl, shape_tv_1 ; compile tv box
	ld de, 100
	call shedule_compile_shape
	
	;ld hl, assembled_sequence_6_17
	;ld (asm_sequence_buffer), hl
	;ld hl, shape_tv_2 ; compile tv box
	;ld de, 100
	;call shedule_compile_shape
	
	ld hl, assembled_sequence_7_17
	ld (asm_sequence_buffer), hl
	ld a, 1
	ld (shedule_compile_shape_mirror_override_only_right), a
	ld hl, shape_tv_3_antenna_left ; compile tv antenna left
	ld de, 100
	call shedule_compile_shape
	ld a, 0
	ld (shedule_compile_shape_mirror_override_only_right), a
	
	;ld a, 1
	;ld (silkscreen_mirror_leftright), a
	;ld hl, assembled_sequence_8_17
	;ld (asm_sequence_buffer), hl
	;ld hl, shape_tv_3_antenna_left ; compile tv antenna right
	;ld de, 100
	;call shedule_compile_shape
	
	;ld a, 0
	;ld (silkscreen_mirror_leftright), a ; cancel mirror
	
	
	ld ix, assembled_sequence_5_17
	call fischinger_make_static_shape_16 ; populate the shape
	
	;ld ix, assembled_sequence_6_17
	;call fischinger_make_static_shape_16
	
	ld ix, assembled_sequence_7_17
	call fischinger_make_static_shape_16
	
	;ld ix, assembled_sequence_8_17
	;call fischinger_make_static_shape_16

	;;;;;;;;;;;;;;;;;;;;
	; FRAME 112 hello, hackerz
	;;;;;;;;;;;;;;;;;;;;
	
	
	ld de, (128 - 12) / 2
	call wait_for_frame
	
	ld a, 1
	ld (draw_text_erase), a
	ld hl, text_precomputing
	ld (draw_text_pointer), hl
	
	ld a, 1
	ld (shedule_post_sequence_track_enabled), a
	
	ld ix, tv_context_1
	ld de, 128 / 2
	ld (ix+0), de ; frame number
	ld de, tv_track_testing_rotate_large
	ld (ix+2), de ; track running
	ld de, tv_track_testing_rotate_large
	ld (ix+4), de ; track returning point
	ld de, callback_self_post_tv_again_context_1
	ld (ix+6), de ; callback
	call shedule_post_tv
	
	ld ix, tv_context_2
	ld de, (128 + 40) / 2
	ld (ix+0), de ; frame number
	ld de, tv_track_testing_rotate_large
	ld (ix+2), de ; track running
	ld de, tv_track_testing_rotate_large
	ld (ix+4), de ; track returning point
	ld de, callback_self_post_tv_again_context_2
	ld (ix+6), de ; callback
	call shedule_post_tv
	
	ld ix, tv_context_3
	ld de, (128 + 80) / 2
	ld (ix+0), de ; frame number
	ld de, tv_track_testing_rotate_large
	ld (ix+2), de ; track running
	ld de, tv_track_testing_rotate_large
	ld (ix+4), de ; track returning point
	ld de, callback_self_post_tv_again_context_3
	ld (ix+6), de ; callback
	call shedule_post_tv
	
	; we can afford three tvs because of double time mode (fps 12.5)
	; which is broken so we go back to 1 tv at 25 fps
	; i think i have found this bastard, but the mode is still broken
	; now I find another one. god knows how many bugs are there
	
	ld de, 128 / 2
	call wait_for_frame
	ld a, 1
	ld (draw_text_erase), a
	ld hl, text_precomputing
	ld (draw_text_pointer), hl
	
	ld de, 224 / 2
	call wait_for_frame
	ld a, 0
	ld (draw_text_erase), a
	ld hl, text_hello_hackerz
	ld (draw_text_pointer), hl
	
	ld de, 336 / 2
	call wait_for_frame
	ld a, 1
	ld (draw_text_erase), a
	ld hl, text_hello_hackerz
	ld (draw_text_pointer), hl
	
	ld de, 392 / 2
	call wait_for_frame
	ld a, 0
	ld (draw_text_erase), a
	ld hl, text_watch_this
	ld (draw_text_pointer), hl
	
	ld de, 560 / 2
	call wait_for_frame
	ld a, 1
	ld (draw_text_erase), a
	ld hl, text_watch_this
	ld (draw_text_pointer), hl
	
	; do not forget to kill tv, or it will pop up again
	ld de, (560 - 8) / 2
	call wait_for_frame
	call kill_tv
	
	;;;;;;;;;;;;;;;;;;;;;;
	; FRAME 616 
	;;;;;;;;;;;;;;;;;;;;;;
	
	
	
	;ld a, 1
	;out (#FE),A ; border blue (make it visible just for debugging)
	
	;ld de, 600 / 2
	;call wait_for_frame
	;ld a, 1
	;ld (flip_override), a
	
	;ld a, 10 / 2
	;ld (polyline_speed + 1), a
	;ld hl, the_logo_svg
	;ld (polyline_pointer), hl ; interrupt now will draw the logo
	
	jp skip_creating_bitstream
	
	; fill logotype
	ld de, 1000 / 2
	call wait_for_frame
	ld d, 10
	ld e, 192 - 174
	call fill
	ld d, 52
	ld e, 192 - 174
	call fill
	ld d, 129
	ld e, 192 - 173
	call fill
	ld d, 179
	ld e, 192 - 171
	call fill
	ld d, 232
	ld e, 192 - 164
	call fill
	
	; prepare the drawing bitstream
	ld hl, $4000
	ld de, bitstream_logo
	ld c, 192
	ld ixl, 0 ; state
	ld a, 0
	ld (de), a ; put 0 to the bitstream
prepare_drawing_bitstream_c0:
	push bc
	ld b, 32
prepare_drawing_bitstream_c1:
	ld a, b
	or a ; clear carry flag
	rlca ; multiply by 8
	rlca
	rlca
	ld (prepare_drawing_bitstream_running_x_byte), a
	ld a, (hl)
	push bc
	ld b, 8
	ld c, a
prepare_drawing_bitstream_c2:
	; read bit
	ld a, c
	xor ixl
	and 0b10000000
	jr z, prepare_drawing_bitstream_no_difference
	ld a, c
	ld ixl, a ; swap a new state
	ld a, 8 ; 256 + 8
	sub b
	push hl
	ld hl, prepare_drawing_bitstream_running_x_byte
	sub (hl)
	pop hl
	ld (de), a ; put value into bitstream
	inc de
	ld a, 0
	ld (de), a ; put new 0 to the bitstream	
	
	jr prepare_drawing_bitstream_no_skip1
prepare_drawing_bitstream_no_difference:
	; do nothing
	
prepare_drawing_bitstream_no_skip1:
	ld a, c
	rlca
	ld c, a
	dec b
	jr nz, prepare_drawing_bitstream_c2
	pop bc
	inc l
	dec b
	jr nz, prepare_drawing_bitstream_c1
	dec l
	call Pixel_Address_Down
	inc de ; leave 0 behind - a marker for a new line
	ld a, 0
	ld (de), a
	ld a, l
	and 0b11100000 ; move hl to the left of the screen
	ld l, a
	pop bc
	dec c
	jr nz, prepare_drawing_bitstream_c0
	inc de
	ld a, 255 ; a code for bitstream end
	ld (de), a
	di
	ld a, 7
	out (#FE),A      ; border white
	di
	halt
	; image ready, dump it into the file using debugger
skip_creating_bitstream:

	; compile splash
	ld hl, assembled_sequence_1_12
	ld (asm_sequence_buffer), hl
	ld a, 0
	ld (shedule_compile_shape_mirror_override_only_right), a
	ld hl, shape_splash_1_small
	ld de, 256 / 2
	call shedule_compile_shape
	
	ld de, 704 / 2
	ld b, 14
	ld c, 32
	ld hl, assembled_sequence_1_12
	call splash_period
	
	ld de, 742 / 2
	call wait_for_frame
	ld a, 0
	ld (draw_text_erase), a
	ld hl, text_nikhotmsk_presents
	ld (draw_text_pointer), hl

	ld hl, assembled_sequence_2_12 ; compile another one
	ld (asm_sequence_buffer), hl
	ld a, 0
	ld (shedule_compile_shape_mirror_override_only_right), a
	ld hl, shape_splash_1_big
	ld de, 256 / 2
	call shedule_compile_shape
	
	ld hl, assembled_sequence_3_12 ; compile another one
	ld (asm_sequence_buffer), hl
	ld a, 0
	ld (shedule_compile_shape_mirror_override_only_right), a
	ld hl, shape_splash_1_medium_long ; this one takes more steps
	ld de, 256 / 2
	call shedule_compile_shape
	
	ld hl, assembled_sequence_5_17 ; compile another one
	ld (asm_sequence_buffer), hl
	ld a, 0
	ld (shedule_compile_shape_mirror_override_only_right), a
	ld hl, shape_jumper_left_to_right
	ld de, 256 / 2
	; call shedule_compile_shape ; not enough space in vault
	
	ld de, 1000 / 2
	call wait_for_frame
	ld a, 1
	ld (draw_text_erase), a
	ld hl, text_nikhotmsk_presents
	ld (draw_text_pointer), hl
	
	
	ld de, 1160 / 2
	call wait_for_frame
	ld a, 0
	ld (draw_text_erase), a
	ld hl, text_cc24_invitation
	ld (draw_text_pointer), hl
	
	ld de, 1511 / 2
	call wait_for_frame
	ld a, 1
	ld (draw_text_erase), a
	ld hl, text_cc24_invitation
	ld (draw_text_pointer), hl
	
	ld de, 1458 / 2 - 8
	call wait_for_frame
	ld de, 1458 / 2
	ld b, 10
	ld c, 8
	ld hl, assembled_sequence_1_12
	call splash_period
	
	ld de, 1714 / 2 - 8
	call wait_for_frame
	ld de, 1714 / 2
	ld b, 4
	ld c, 32
	ld hl, assembled_sequence_3_12
	call splash_period
	
	ld de, 1842 / 2 - 8
	call wait_for_frame
	ld de, 1842 / 2
	ld b, 6
	ld c, 32
	ld hl, assembled_sequence_2_12
	call splash_period
	
	
	
	;;;;;;;;;;;;;;;;;;;;;;
	; FRAME 2107 LOGO TIME
	;;;;;;;;;;;;;;;;;;;;;;
	
	; draw bitstream
	ld de, 2107 / 2
	call wait_for_frame
	ld hl, the_logo_svg_bitstream
	ld (draw_bitstream_pointer), hl
	ld a, 0
	ld (draw_bitstream_screen_y), a
	ld a, 1
	ld (draw_bitstream_enable), a
	
	
	;;;;;;;;;;;;;;;;;;;;;;
	; FRAME 3492 press this button again
	;;;;;;;;;;;;;;;;;;;;;;
	ld de, 3492 / 2
	call wait_for_frame
	call clear_slow
	
	ld de, 3552 / 2
	call wait_for_frame
	ld a, 5
	ld (polyline_speed + 1), a
	ld hl, courage_svg
	ld (polyline_pointer), hl ; interrupt now will draw the thing
	
	ld de, 3632 / 2
	call wait_for_frame
	ld a, 5
	ld (polyline_speed + 1), a
	ld hl, courage_svg_part_2
	ld (polyline_pointer), hl ; interrupt now will draw the thing
	
	ld de, 4900 / 2
	call wait_for_frame
	jp interrupt_routine_goto_code_again ; automatic rewind

; main program ends here


;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; splash_period
; b - quantity
; c - period
; hl - preassembled sequence
; de - frame number
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
splash_period:
	push de
	ld de, tv_track_testing_stay_still
	ld (shedule_post_sequence_running_track), de
	ld de, tv_track_testing_stay_still
	ld (shedule_post_sequence_track_return), de
	ld a, 0
	ld (shedule_post_sequence_track_enabled), a
	pop de
	ld ix, hl ; post preassembled sequence
	
splash_period_loop:
	push bc
	push de
	push ix
	ld bc, 0 ; location shift
	call shedule_post_sequence
	pop ix
	pop de
	pop bc
	dec b
	ret z
	ld h, 0
	ld l, c
	add hl, de
	ld de, hl ; period added
	
	jr splash_period_loop


;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; kill_tv
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
kill_tv:
	; scan shedule and find all callbacks that post new tvs
	; and remove them
	ld ix, shedule_6000
	ld bc, shedule_size ; all banks
kill_tv_cycle_1:
	ld de, callback_self_post_tv_again_context_1
	ld hl, (ix+2) ; [hl register] [drawing code] [enable]
	or a ; clear carry flag
	sbc hl, de
	add hl, de	; compare words
	jr z, kill_tv_found
	ld de, callback_self_post_tv_again_context_2
	or a ; clear carry flag
	sbc hl, de
	add hl, de	; compare words
	jr z, kill_tv_found
	ld de, callback_self_post_tv_again_context_3
	or a ; clear carry flag
	sbc hl, de
	add hl, de	; compare words
	jr z, kill_tv_found
	
	jr kill_tv_not_found
	
kill_tv_found:
	ld a, 0
	ld (ix+4), a ; [enable] mark entry as empty
kill_tv_not_found:
	
	ld de, shedule_entry_size
	add ix, de
	dec bc
	ld a, b
	or c
	jr nz, kill_tv_cycle_1
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; shedule_post_tv
; ix - context
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
shedule_post_tv:
	; [frame number] [track running] [track returning point] [callback]
	ld de, (ix+2)
	ld (shedule_post_sequence_running_track), de
	ld de, (ix+4)
	ld (shedule_post_sequence_track_return), de
	
	
	ld de, (ix+0) ; frame number
	ld b, 0 ; position shift
	ld c, 0
	push ix
	ld ix, assembled_sequence_1_12 ; post
	call shedule_post_sequence
	pop ix
	;ld de, (ix+0)
	;ld b, 0
	;ld c, 0
	;push ix
	;ld ix, assembled_sequence_2_12 ; post
	;call shedule_post_sequence
	;pop ix
	;ld de, (ix+0)
	;ld b, 0
	;ld c, 0
	;push ix
	;ld ix, assembled_sequence_3_12 ; post
	;;call shedule_post_sequence
	;pop ix
	;ld de, (ix+0)
	;ld b, 0
	;ld c, 0
	;push ix
	;ld ix, assembled_sequence_4_12 ; post
	;call shedule_post_sequence
	;pop ix
	ld de, (ix+0)
	ld b, 0
	ld c, 0
	push ix
	ld ix, assembled_sequence_5_17 ; post tv frame
	call shedule_post_sequence
	pop ix
	;ld de, (ix+0)
	;ld b, 0
	;ld c, 0
	;push ix
	;ld ix, assembled_sequence_6_17 ; post tv frame 2
	;call shedule_post_sequence
	;pop ix
	ld de, (ix+0)
	ld b, 0
	ld c, 0
	push ix
	ld ix, assembled_sequence_7_17 ; post tv antenna
	call shedule_post_sequence
	pop ix
	;ld de, (ix+0)
	;ld b, 0
	;ld c, 0
	;push ix
	;ld ix, assembled_sequence_8_17 ; post tv antenna
	;call shedule_post_sequence
	;pop ix
	ld de, (ix+0)
	ld b, 0
	ld c, 0
	push ix
	ld ix, assembled_sequence_tv_color_zone_16 ; post
	call shedule_post_sequence
	pop ix
	
	
	ld hl, (ix+0)
	ld de, 8
	add hl, de
	ld (ix+0), hl ; increment frame number
	
	call advance_running_track_8 ; increment track
	
	ld de, (ix+0) ; new frame number
	ld b, 0 ; position shift
	ld c, 0
	push ix
	ld ix, assembled_sequence_1_12 ; post
	call shedule_post_sequence
	pop ix
	;ld de, (ix+0)
	;ld b, 0
	;ld c, 0
	;push ix
	;ld ix, assembled_sequence_2_12 ; post
	;call shedule_post_sequence
	;pop ix
	;ld de, (ix+0)
	;ld b, 0
	;ld c, 0
	;push ix
	;;ld ix, assembled_sequence_3_12 ; post
	;;call shedule_post_sequence
	;pop ix
	;ld de, (ix+0)
	;ld b, 0
	;ld c, 0
	;push ix
	;ld ix, assembled_sequence_4_12 ; post
	;call shedule_post_sequence
	;pop ix
	
	ld hl, (ix+0)
	ld de, 8
	add hl, de
	ld (ix+0), hl
	
	call advance_running_track_8 ; increment track
	
	ld de, (ix+0) ; frame number
	ld b, 0 ; position shift
	ld c, 0
	push ix
	ld ix, assembled_sequence_1_12 ; post
	call shedule_post_sequence
	pop ix
	;ld de, (ix+0)
	;ld b, 0
	;ld c, 0
	;push ix
	;ld ix, assembled_sequence_2_12 ; post
	;call shedule_post_sequence
	;pop ix
	;ld de, (ix+0)
	;ld b, 0
	;ld c, 0
	;push ix
	;ld ix, assembled_sequence_3_12 ; post
	;;call shedule_post_sequence
	;pop ix
	;ld de, (ix+0)
	;ld b, 0
	;ld c, 0
	;push ix
	;ld ix, assembled_sequence_4_12 ; post
	;call shedule_post_sequence
	;pop ix
	
	ld hl, (ix+0)
	ld de, 8
	add hl, de
	ld (ix+0), hl
	
	call advance_running_track_8 ; increment track
	
	ld de, (ix+0) ; new frame number
	ld b, 0 ; position shift
	ld c, 0
	push ix
	ld ix, assembled_sequence_1_12 ; post
	call shedule_post_sequence
	pop ix
	;ld de, (ix+0)
	;ld b, 0
	;ld c, 0
	;push ix
	;ld ix, assembled_sequence_2_12 ; post
	;call shedule_post_sequence
	;pop ix
	;ld de, (ix+0)
	;ld b, 0
	;ld c, 0
	;push ix
	;ld ix, assembled_sequence_3_12 ; post
	;;call shedule_post_sequence
	;pop ix
	;ld de, (ix+0)
	;ld b, 0
	;ld c, 0
	;push ix
	;ld ix, assembled_sequence_4_12 ; post
	;call shedule_post_sequence
	;pop ix
	
	call advance_running_track_8 ; increment track
	
	ld hl, (ix+0)
	ld de, 8
	add hl, de
	ld (ix+0), hl ; new frame number stored in context
	
	; put a callback so tv can post itself again and again
	ld hl, (ix+0) ; [frame number]
	ld de, 4
	sbc hl, de ; step back
	set 1, l ; make so that callback ends up only for screen 1
	ex hl, de ; frame number ready
	ld bc, 0
	ld hl, (ix+6) ; [callback]
	ld a, 0
	ld (shedule_add_figurine_cached), a
	push ix
	call shedule_add_figurine
	pop ix
	
	; [frame number] [track running] [track returning point] [callback]
	ld de, (shedule_post_sequence_running_track)
	ld (ix+2), de
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;
; advance_running_track_8
;;;;;;;;;;;;;;;;;;;;;;;;;;;
advance_running_track_8:
	push ix
	ld ix, (shedule_post_sequence_running_track)
	ld b, 4
advance_running_track_8_loop:
	
	
	ld de, 4 ; [x] [y] [visible] [enabled]
	add ix, de ; move to next entry in track
	
	ld a, (ix+3) ; enabled
	or a
	jr nz, advance_running_track_8_no_wraparound
	
	ld ix, (shedule_post_sequence_track_return); wraparound
	
	
advance_running_track_8_no_wraparound:
	dec b
	jr nz, advance_running_track_8_loop
	ld (shedule_post_sequence_running_track), ix
	pop ix
	ret


tv_context_1:
	WORD 0, 0, 0, 0
tv_context_2:
	WORD 0, 0, 0, 0
tv_context_3:
	WORD 0, 0, 0, 0
; [frame number] [track running] [track returning point] [callback]



;;;;;;;;;;;;;;;;;;;;;;
; shapes
;;;;;;;;;;;;;;;;;;;;;;

shape_romb_24_down_right:
	BYTE 128,96,128,96 ; this is previous line
	BYTE 128+ 0,96+ 4,128+ 4,96+ 0 ; draw figurine based on prev line
	BYTE 128+ 0,96+ 8,128+ 8,96+ 0
	BYTE 128+ 0,96+12,128+12,96+ 0
	BYTE 128+ 0,96+16,128+16,96+ 0
	BYTE 128+ 0,96+20,128+20,96+ 0
	BYTE 128+ 4,96+20,128+20,96+ 4
	BYTE 128+ 8,96+20,128+20,96+ 8
	BYTE 128+12,96+20,128+20,96+12 ; this is where next figurine would fire
	BYTE 128+16,96+20,128+20,96+16
	BYTE 128+20,96+20,128+20,96+20
	; assembled_sequence_1_12 has only 11 places (and zero terminator is 12)
	BYTE 0,0,0,0
	
shape_tv_1:
	BYTE 103,96,103,121
	BYTE 103,121,128,121
	BYTE 103,96,103,121 ; broken shape just to draw two lines
	BYTE 0,0,0,0 ; this thing compile to two identical frames for each shadowscreen
	
;shape_tv_2:
;	BYTE 103,71,152,71
;	BYTE 152,71,152,120
;	BYTE 103,71,152,71 ; another broken shape to complete the tv box
;	BYTE 0,0,0,0

shape_tv_3_antenna_left:
	BYTE 126,70,126,70
	BYTE 121,65,121,65
	BYTE 126,70,126,70 ; tv antenna left
	BYTE 0,0,0,0

shape_splash_1_small:
	BYTE 125,95,127,95
	BYTE 124,94,127,94
	BYTE 123,93,127,93
	BYTE 122,92,127,92
	BYTE 121,91,127,91
	BYTE 120,90,127,90
	BYTE 119,89,127,89
	BYTE 118,88,127,88
	BYTE 117,87,127,87
	BYTE 116,86,127,86
	BYTE 115,85,127,85
	BYTE 114,84,127,84
	BYTE 0,0,0,0
	
shape_splash_1_big:
	BYTE 125,91,127,91
	BYTE 121,87,127,87
	BYTE 117,83,127,83
	BYTE 113,79,127,79
	BYTE 109,75,127,75
	BYTE 105,71,127,71
	BYTE 101,67,127,67
	BYTE  97,63,127,63
	BYTE  93,59,127,59
	BYTE  89,55,127,55
	BYTE  85,51,127,51
	BYTE  81,47,127,47
	BYTE 0,0,0,0
	
shape_splash_1_medium_long:
	BYTE 125,95,127,95
	BYTE 123,93,127,93
	BYTE 121,91,127,91
	BYTE 119,89,127,89
	BYTE 117,87,127,87
	BYTE 115,85,127,85
	BYTE 113,83,127,83
	BYTE 111,81,127,81
	BYTE 109,79,127,79
	BYTE 107,77,127,77
	BYTE 105,75,127,75
	BYTE 103,73,127,73
	BYTE 101,71,127,71
	BYTE  99,69,127,69
	BYTE  97,67,127,67
	BYTE  95,65,127,65
	BYTE  93,63,127,63
	BYTE  91,61,127,61
	BYTE  89,59,127,59
	BYTE  87,57,127,57
	BYTE  85,55,127,55
	BYTE  83,53,127,53
	BYTE  81,51,127,51
	BYTE  79,49,127,49
	BYTE 0,0,0,0
	
shape_jumper_left_to_right:
	BYTE  1,90,1,110 ; 5
	BYTE  5,90,5,110 ; 10
	BYTE  15,90,15,110 ; 30
	BYTE  45,90,45,110 ; 75
	BYTE  120,90,120,110 ; 75
	BYTE  195,90,195,110 ; 30
	BYTE  225,90,225,110 ; 10
	BYTE  235,90,235,110 ; 5
	BYTE  240,90,240,110 ; 1
	BYTE  239,90,239,110 ; 5
	BYTE  235,90,235,110
	BYTE  225,90,225,110
	BYTE  195,90,195,110
	BYTE  120,90,120,110
	BYTE  45,90,45,110
	BYTE  15,90,15,110
	BYTE  5,90,5,110
	BYTE  1,90,1,110
	BYTE  0,0,0,0
	
tv_track_testing_stay_still:
	; [x] [y] [visible] [enabled]
	BYTE 0, 0,1,1
	BYTE 0,0,0,0

tv_track_testing_rotate_small:
	; [x] [y] [visible] [enabled]
	BYTE -1,-1,1,1
	BYTE -1,-1,1,1
	BYTE -1,-1,1,1
	BYTE  1,-1,1,1
	BYTE  1,-1,1,1
	BYTE  1,-1,1,1
	BYTE  1, 1,1,1
	BYTE  1, 1,1,1
	BYTE  1, 1,1,1
	BYTE -1, 1,1,1
	BYTE -1, 1,1,1
	BYTE -1, 1,1,1
	BYTE 0,0,0,0

; left -12 right 12 up -8 down 8
tv_track_testing_rotate_large:
	; [x] [y] [visible] [enabled]
	.1 BYTE - 8, 8,1,1
	.1 BYTE - 9, 7,1,1
	.1 BYTE -10, 6,1,1
	.1 BYTE -11, 5,1,1
	.1 BYTE -12, 4,1,1
	.1 BYTE -12, 3,1,1
	.1 BYTE -12, 2,1,1
	.1 BYTE -12, 1,1,1
	.1 BYTE -12, 0,1,1
	.1 BYTE -12,-1,1,1
	.1 BYTE -12,-2,1,1
	.1 BYTE -12,-3,1,1
	.1 BYTE -12,-4,1,1
	.1 BYTE -11,-5,1,1
	.1 BYTE -10,-6,1,1
	.1 BYTE - 9,-7,1,1
	.1 BYTE - 8,-8,1,1
	.1 BYTE - 6,-8,1,1
	.1 BYTE - 5,-8,1,1
	.1 BYTE - 4,-8,1,1
	.1 BYTE - 3,-8,1,1
	.1 BYTE - 2,-8,1,1
	.1 BYTE - 1,-8,1,1
	.1 BYTE   0,-8,1,1
	.1 BYTE   1,-8,1,1
	.1 BYTE   2,-8,1,1
	.1 BYTE   3,-8,1,1
	.1 BYTE   4,-8,1,1
	.1 BYTE   5,-8,1,1
	.1 BYTE   6,-8,1,1
	.1 BYTE   7,-8,1,1
	.1 BYTE   8,-8,1,1
	.1 BYTE   9,-7,1,1
	.1 BYTE  10,-6,1,1
	.1 BYTE  11,-5,1,1
	.1 BYTE  11,-4,1,1
	.1 BYTE  11,-3,1,1
	.1 BYTE  11,-2,1,1
	.1 BYTE  11,-1,1,1
	.1 BYTE  11, 0,1,1
	.1 BYTE  11, 1,1,1
	.1 BYTE  11, 2,1,1
	.1 BYTE  11, 3,1,1
	.1 BYTE  11, 4,1,1
	.1 BYTE  11, 5,1,1
	.1 BYTE  10, 6,1,1
	.1 BYTE   9, 7,1,1
	.1 BYTE   8, 8,1,1
	.1 BYTE   7, 8,1,1
	.1 BYTE   6, 8,1,1
	.1 BYTE   5, 8,1,1
	.1 BYTE   4, 8,1,1
	.1 BYTE   3, 8,1,1
	.1 BYTE   2, 8,1,1
	.1 BYTE   1, 8,1,1
	.1 BYTE   0, 8,1,1
	.1 BYTE  -1, 8,1,1
	.1 BYTE  -2, 8,1,1
	.1 BYTE  -3, 8,1,1
	.1 BYTE  -4, 8,1,1
	.1 BYTE  -5, 8,1,1
	.1 BYTE  -6, 8,1,1
	.1 BYTE  -7, 8,1,1
	BYTE 0,0,0,0

the_logo_svg:
	;.INCLUDE "svg_logo.asm"
	.BYTE 0
courage_svg:
	.INCLUDE "courage.asm"
	.BYTE 0

the_logo_svg_bitstream:
	.INCBIN "logotype_bitstream"

starfield_array:
	BYTE 5,20,70,0
	BYTE 4,20,74,0
	BYTE 6,20,77,0
	BYTE 5,20,84,0
	BYTE 0,0,0,0 ; [speed] [x] [y] [prev contents]

bitstream_logo: BYTE 0 ; a long array here
silkscreen_shape_diagonal_buffer: BYTE 0 ; another big runtime array

player_n_shapes_end:



  EMPTYTAP "another_invitation_code.tap"
  SAVETAP "another_invitation_code.tap",CODE,"usr40960",code_start,code_end - code_start,code_start
  SAVETAP "another_invitation_code.tap",CODE,"ptsplay",player,player_n_shapes_end - player, player
  
  ; basic loader will be concatenated later by make.sh script

	; debug messages to the console of compiler
	DISPLAY "variables free space before $a000: ", /A, $a000 - assembled_sequence_end
	DISPLAY "variables free space on page 4: ", /A, $ffff - shedule_c000_end
	DISPLAY "free space before $c000: ", /A, $c000 - code_end
	DISPLAY "free space before $ffff: ", /A, $ffff - player_n_shapes_end
	IF code_end < $c000
	; DISPLAY "boundary test succeed"
	ELSE
	DISPLAY "*** WARNING the boundary test failed, too much code ***"
	ENDIF

