require("lualibs.common")
require("skilanderkit")

eyeTalk = true
mouthTalk = false
talkState = false

eyeTiles   = { 80, 81, 82, 83, 84 }
mouthTiles = { 86, 87, 88, 89, 90 }

eyeSpeed = 8
mouthSpeed = 7

talkEyes  = { 1, 1, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 3, 3, 4, 4, 3, 3, 3, 3 }
talkMouth = { 1, 3, 1, 3, 2, 4, 3, 5, 3, 1, 2, 1, 3, 4, 5, 2, 3 }

function seppoTalk(state)
	--eyeTalk = true
	talkState = state
end

function seppoDraw(x, y, z, f) 

	eyeTile = 80
	mouthTile = 86

	if ((f % mouthSpeed) == 0) then
		mouthTalk = talkState
	end

	rotatesprite(x, y, z, 0,   47,   2,0, 2,    0,0,1,1);

	if eyeTalk then
		index = ((f // eyeSpeed) % 32) + 1
		eyeTile = eyeTiles[talkEyes[index]]
	end

	if mouthTalk then
		index = ((f // mouthSpeed) % 16) + 1
		mouthTile = mouthTiles[talkMouth[index]]
	end

	rotatesprite(x, y, z, 0,   eyeTile,   2,0, 2,    0,0,1,1);
	rotatesprite(x, y, z, 0,   mouthTile, 2,0, 2,    0,0,1,1);

end

emotionDuration = 100
emotionCounter = 0

eyeEmotions = { 82, 81, 80, 83, 84 }
mouthEmotions = { 90, 89, 88, 86, 87 }

eyeEmotion = 1
mouthEmotion = 1

-- eyes, mouth: larger number is happier face
function setEmotion(ee, me)
	eyeEmotion = ee
	mouthEmotion = me

	if (eyeEmotion < 1) then
		eyeEmotion = 1
	elseif (eyeEmotion > 5) then
		eyeEmotion = 5
	end

	if (mouthEmotion < 1) then
		mouthEmotion = 1
	elseif (mouthEmotion > 5) then
		mouthEmotion = 5
	end
end

function seppoEmotion(x, y, z, f)

	zoom = math.pow(math.sin(1.0 * math.pi * emotionCounter / emotionDuration), 0.05)
	zz = z * zoom

	if zz > z then
		zz = z
	end

	if emotionCounter == 0 then
		emotionCounter = emotionDuration
	else

		ei = eyeEmotion
		mi = 1 + (((mouthEmotion + (f // 10) % 2)) % 5)

		eyeTile = eyeEmotions[ei]
		mouthTile = mouthEmotions[mi]

		bx = x + 8
		by = y + 5
		bz = zz - 0.01
		tx = x
		ty = y
		tz = zz

		rotatesprite(bx, by, bz, 0, 092,   	  	2,0, 2,    0,0,1,1);
		rotatesprite(tx, ty, tz, 0, 047,   	  	2,0, 2,    0,0,1,1);
		rotatesprite(bx, by, bz, 0, 093,   	  	2,0, 2,    0,0,1,1);
		rotatesprite(tx, ty, tz, 0, eyeTile, 	2,0, 2,    0,0,1,1);
		rotatesprite(tx, ty, tz, 0, mouthTile,	2,0, 2,    0,0,1,1);

		emotionCounter = emotionCounter - 1
	end

	return emotionCounter
end