require("lualibs.common")
require("skilanderkit")
require("seppo")

boardname="menu.map"


function init(newinitpos, hotload)
	initpos = table_shallow_copy(newinitpos)

	allvis = 241

	for i = 0,numwalls()-1
	do
		sector_visibility(i, allvis)
		--print(i, sector_visibility(i))
	end

	loadsong("music/intro.kdm")

	setmusic(true)

	introresetstate()
	print("intro? gomode", gomode)
end

function getlightingposx(pos)
	return 160-(640-(pos+32))//4
end

function getlightingposy(pos)
	return 100-(160-(pos+32))//4
end

-- 00.00 RAMIREZ1
-- Greetings!
-- I am Juan Seppo Blade-Slalom Ramirez...

-- 04.66 RAMIREZ2
-- Chief skishop maintainer to Mayor of Himos...

-- 08.23 RAMIREZ3
-- and I'm at your service.

-- 10.50 RAMIREZ4
-- You are Connor MacGleisberg, wounded att offpiste.. (lausutaan ofpiist)

-- 13.98 RAMIREZ5
-- and driven from your village five years ago.

-- 17.04 RAMIREZ6
-- The sensation you're feeling is The Snowquenching.

-- 20.29 RAMIREZ7
-- We are the same, MacGleisberg!

-- 22.52 RAMIREZ8
-- We are brothers!

-- xx.xx RAMIREZ09
-- You have no knowledge of your powers but I'm here to guide you
function introresetstate()
	ramirezCount = 8
	ramirezWave = { "RAMIREZ1", "RAMIREZ2", "RAMIREZ3", "RAMIREZ4", "RAMIREZ5", "RAMIREZ6", "RAMIREZ7", "RAMIREZ8" }
	ramirezTime = {  0.00,  4.66,  8.23, 10.50, 13.98, 17.04, 20.29, 22.52, 24.00  }
	ramirezTrig = { false, false, false, false, false, false, false, false, false  }
	ramirezStart = 0.0
	ramirezState = 1
	
	lightningCount = 18
	lightningStartTime = 0
	
	lTileX = {  129,  228,  316,  434,  464,  336,  551,  680,  756,  748,  768,  807,  902,  987,  926,  1115, 1017, 1015 }
	lTileY = {  147,  161,  138,  122,   44,  242,  100,  117,  245,  -10,  372,   90,  175,  292,   62,  288,   172,   94 }
	lTileI = {  401,  402,  403,  404,  414,  405,  406,  407,  408,  415,  409,  410,  411,  412,  413,  414,   415,  416 }
	
	function getLightningVis(t, i)
		lightningDuration = 20
		lightningInterval = 1 + (t % 2)
		--t = t % 100
		if ((t > (lightningStartTime + i * lightningInterval)) and (t < (lightningStartTime + i * lightningInterval + lightningDuration))) then
			return true
		else
			return false
		end
	end
	
	sepy = 210
	a = 150000.0
	horiz = 50
	curtime = 0
	newhoriz = horiz
	newhorizv = 0
	ablend = 1.0

end



function frame()

	curtime = curtime + 1

	local dither = ((curtime & 3) * (1.0/3.0) - 0.5) * 2.0

	if (a > 0.0) then
		a = a - 50.5
	end

	if getkeystatus(0xd0) then
		a = a - 300.5
		horiz = horiz + 1.0
		curtime = curtime + 10

		print("kaasuu")
	end

	local horizt = math.max( -0.1, 130.0 - horiz ) * 0.001
	horiz = horiz + horizt
	local mypos = table_shallow_copy(initpos)


	b_visibility(a * ablend)
	b_parallaxvisibility(512000)

	local horizq = math.floor(horiz*1.0)/1.0

	--local newhoriz = horizq+dither*0.1
	newhorizv = newhorizv + (horizq - newhoriz) * 0.01
	newhoriz = newhoriz + newhorizv


	--drawrooms(mypos.x, mypos.y, mypos.z, mypos.ang, horiz, mypos.sect)
	drawrooms(mypos.x, mypos.y, (mypos.z ) + horiz*25, mypos.ang, 100, mypos.sect)
	drawmasks()

	--drawtimer(string.format("haeh %f", horiz), 10, 10, 1.0, 0)

	--clearview(0)

	if ( curtime < 200 ) then
		rotatesprite(160, 60, 0.2, 0,   302,   5,0, 2,    0,0,1,1)
		rotatesprite(160, 150, 0.2, 0,   303,   0,0, 2,    0,0,1,1)
		drawtext("PRESENTS", 110, 115, 0.65, 0, 20.0)
		--print("curtime0",curtime)
	elseif ( curtime < 597 ) then
		--print("curtime1",curtime)

		if (lightningStartTime == 0) then
			lightningStartTime = curtime + 100
		end

		for i=1, lightningCount do
			if getLightningVis(curtime, i) then
				rotatesprite(getlightingposx(lTileX[i]), getlightingposy(lTileY[i]), 0.25, 0, lTileI[i], 0,0, 2, 0,0,1,1)
			end

		end

		if ( curtime > lightningStartTime and not light1trig) then
			light1trig = true
			ablend = 0.0
			wsay("THUNDER",3072, 0.7, 0.7)
		else
			ablend = math.min(1.0, ablend + 0.03)
		end

		rotatesprite(160, 100, 0.25, 0,   300,   0,0, 2,    0,0,1,1)

	elseif ( curtime < 1592 ) then

		rotatesprite(160, 100, 0.1+(curtime-997)*0.001, 0,   48,   29,0, 2,    0,0,1,1);

		creditsStart = 12*60-40
		creditsInterval = 190

		upperPos = 90
		lowerPos = 50

		if ( curtime < creditsStart ) then
			--print("curtime2",curtime)
		elseif ( curtime < creditsStart + 1 * creditsInterval ) then
			drawtimer("     PROGRAM     ",	upperPos,  90, 0.5, 0)
			drawtimer("   ASH CHECKSUM  ",	lowerPos, 105, 0.8, 0)
			--print("curtime2",curtime)
		elseif ( curtime < creditsStart + 2 * creditsInterval ) then
			drawtimer("    MUSIC, CODE  ", 	upperPos,  90, 0.5, 0)
			drawtimer("     VAN DAMME   ", 	lowerPos, 105, 0.8, 0)
			--print("curtime2",curtime)
		elseif ( curtime < creditsStart + 3 * creditsInterval ) then
			drawtimer("BUILD  SPECIALIST", 	upperPos,  80, 0.5, 0)
			drawtimer("  GAME DESIGNER  ", 	upperPos,  90, 0.5, 0)
			drawtimer("     HI STACK    ", 	lowerPos, 105, 0.8, 0)
			--print("curtime2",curtime)
		elseif ( curtime < creditsStart + 4 * creditsInterval ) then
			drawtimer("   CONCEPT GFX   ", 	upperPos,  90, 0.5, 0)
			drawtimer("NETSCAPE AGITATOR", 	lowerPos, 105, 0.8, 0)
			--print("curtime2",curtime)
		elseif ( curtime < creditsStart + 5 * creditsInterval ) then
			drawtimer("   VOICE ACTOR   ", 	upperPos,  90, 0.5, 0)
			drawtimer("       KARL      ", 	lowerPos, 105, 0.8, 0)
			--print("curtime2",curtime)
		end
	end

	if (getkeystatus(0x1c)) then
	end

	if (curtime > 1592) then
		sepy = math.max(110, sepy - 10)

		seppoDraw(220, sepy, 0.7, curtime)

		if ramirezStart == 0.0 then
			ramirezStart = curtime / 60.0 - ramirezTime[ramirezState]
		end

		time = curtime / 60.0

		if ramirezStart > 0.0 and ramirezState <= ramirezCount then
			if time >= (ramirezStart + ramirezTime[ramirezState]) and not ramirezTrig[ramirezState] then
				seppoTalk(true)
				wsay(ramirezWave[ramirezState],2900, 0.8, 0.8)
				ramirezTrig[ramirezState] = true
				ramirezState = ramirezState + 1
			end
		end

		if time >= (ramirezStart + ramirezTime[ramirezState] - 0.65) and not ramirezTrig[ramirezState] then
			seppoTalk(false)
		end
	end


	if (curtime > 1550) then

		--local bpal = 0;
		--if ( curtime & 15 ) > 8 then 
		drawtimer("ENTER: SKIP STORY", 45, 170, 0.8, 25)
		--end

	end

	if (curtime == 3100) then
		gotomode = 0
	end

	if (curtime > 10 and (getkeystatus(1) or getkeystatus(0x1c))) and not gotomode then
		gotomode = 0
	end


end
