vec2meta = { }

function vec2meta.__add(_a, _b)
	--print(type(_t), type(_v))
	if (type(_a) == "number") then
		return vec2(_a + _b.x,   _a + _b.y)
	elseif (type(_b) == "number") then
		return vec2(_a.x + _b,   _a.y + _b)
	else
		return vec2(_a.x + _b.x, _a.y + _b.y)
	end
end

function vec2meta.__sub(_a, _b)
	--print(type(_t), type(_v))
	if (type(_a) == "number") then
		return vec2(_a - _b.x,   _a - _b.y)
	elseif (type(_b) == "number") then
		return vec2(_a.x - _b,   _a.y - _b)
	else
		return vec2(_a.x - _b.x, _a.y - _b.y)
	end
end

function vec2meta.__unm(_a)
	return vec2(-_a.x, -_a.y)
end

function vec2meta.__mul(_a, _b)
	--print(type(_t), type(_v))
	if (type(_a) == "number") then
		return vec2(_a * _b.x,   _a * _b.y)
	elseif (type(_b) == "number") then
		return vec2(_a.x * _b,   _a.y * _b)
	else
		return vec2(_a.x * _b.x, _a.y * _b.y)
	end
end

function vec2meta.__div(_a, _b)
	--print(type(_t), type(_v))
	if (type(_a) == "number") then
		return vec2(_a / _b.x,   _a / _b.y)
	elseif (type(_b) == "number") then
		return vec2(_a.x / _b,   _a.y / _b)
	else
		return vec2(_a.x / _b.x, _a.y / _b.y)
	end
end


function vec2(x,y)
	local stuf = {}
	stuf.x = x
	stuf.y = y
	setmetatable(stuf, vec2meta)
	return stuf
end


function length2(v)
	return math.sqrt(v.x*v.x + v.y*v.y)
end

function dot2(a,b)
	return a.x*b.x + a.y*b.y
end

function normalize2(v)
	local x,y,invlen
	invlen = 1.0 / length2(v)
	x = v.x * invlen
	y = v.y * invlen
	return vec2(x,y)
end

function abs2(v)
	return vec2(math.abs(v.x), math.abs(v.y))
end

function vecstr2(v)
	return string.format("vec2(%.2f,%.2f)", v.x, v.y )
end