var Kaleidos = function(){
    var size = TDEMO.MAIN.getRendererSize();
    PartBase.call(this,
        {camera : new THREE.OrthographicCamera( -size[0]/2, size[0]/2, size[1]/2, -size[1]/2, 0.1, 2000 )});
    this.camera.position.z = 1;

    this.mainScene = new THREE.Scene();
    var aspect = this.width/this.height;
    this.mainCamera = new THREE.PerspectiveCamera(50, aspect, this.near, this.far);
    this.mainScene.add(this.mainCamera);


    this.rtt = new THREE.WebGLRenderTarget(size[0], size[1]);
    this.rtt.texture.format = THREE.RGBFormat;
    this.rtt.texture.minFilter = THREE.NearestFilter;
    this.rtt.texture.magFilter = THREE.NearestFilter;
    this.rtt.texture.generateMipmaps = false;
    this.rtt.stencilBuffer = false;

    this.uniforms = THREE.Kaleido2.uniforms;
    this.uniforms.uNear.value = this.near;
    this.uniforms.uFar.value = this.far;
    this.uniforms.uResolution.value = size;
    
    var pg = new THREE.PlaneBufferGeometry(this.width, this.height);
    var pm = new THREE.ShaderMaterial({
        uniforms : this.uniforms,
        vertexShader : THREE.Kaleido2.vertexShader,
        fragmentShader : THREE.Kaleido2.fragmentShader
    })

    this.plane = new THREE.Mesh(pg, pm);
    this.scene.add(this.plane);

    //POSTPROCESSING
    this.setEdgeDetection();
    this.setBloom(0.5);

};

Kaleidos.prototype = PartBase.prototype.inheritance();

Kaleidos.prototype.animateCamera = function(){
    this.near = TDEMO.SYNC.getNear();
    this.far = TDEMO.SYNC.getFar();

    this.mainCamera.near = this.near;
    this.mainCamera.far = this.far;
    this.lens = TDEMO.SYNC.getLens();
    this.mainCamera.filmGauge = this.lens.fg;
    this.mainCamera.setFocalLength(this.lens.fl);
    this.mainCamera.updateProjectionMatrix();
    
    const camp = TDEMO.SYNC.getCameraPosition();
    this.mainCamera.position.x = 0;
    this.mainCamera.position.y = camp.y;
    this.mainCamera.position.z = camp.x;

    const camr = TDEMO.SYNC.getCameraRotation();
    this.mainCamera.lookAt(camr);

    this.uniforms.uNear.value = this.near;
    this.uniforms.uFar.value = this.far;
    this.uniforms.uRo.value = this.mainCamera.position;
    this.uniforms.uRd.value = camr;
    this.uniforms.uFOV.value = this.mainCamera.getEffectiveFOV();
}

Kaleidos.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, false);
    this.animateCamera();

    var pos = TDEMO.SYNC.getObjPosition();

    var rot = TDEMO.SYNC.getObjRotation();

    var hb = TDEMO.SYNC.getHeartBeat();
    this.uniforms.uHb.value = hb;
    this.uniforms.uTime.value = elapsedTime;

    var edges = TDEMO.SYNC.getEdges();
    this.edge.enabled = edges;
};
