const Confusion = function () {
    PartBase.call(this);

    //POSTPROCESSING
    this.setEdgeDetection();
    this.setBloom(1.0);

    this.scene.fog = new THREE.Fog(0xFF478B, 100, 500);
    const light = new THREE.HemisphereLight(0xffccaa, 0xF80800, 1);
    this.scene.add(light);
    const sky = this.createSky();
    this.scene.add(sky);

    this.viivat = this.createLines();
    this.scene.add(this.viivat);
};

Confusion.prototype = PartBase.prototype.inheritance();

const rotateObject = (obj, rot) => {
    obj.rotation.x = rot.x;
    obj.rotation.y = rot.y;
    obj.rotation.z = rot.z;
};

const translateObject = (obj, pos) => {
    obj.position.x = pos.x;
    obj.position.y = pos.y;
    obj.position.z = pos.z;
}

Confusion.prototype.animate = function (elapsedTime, delta) {
    PartBase.prototype.animate.call(this, elapsedTime, delta, true);
    const camp = TDEMO.SYNC.getCameraPosition();
    this.camera.position.x = 0;
    this.camera.position.y = camp.y;
    this.camera.position.z = camp.z;

    const rot = TDEMO.SYNC.getObjRotation();

    this.viivat.children.forEach((viiva, index) => {
        rotateObject(viiva, rot);
        viiva.rotation.x = (index%2 === 0) ? rot.x : -rot.x;
        viiva.rotation.z = (index%3 === 0) ? rot.z : -rot.z;
    });

    const edges = TDEMO.SYNC.getEdges();
    this.edge.enabled = edges;
};

Confusion.prototype.createSky = function () {
    const material = new THREE.MeshBasicMaterial({ color: 0xFF0000, side: THREE.DoubleSide });
    const skySphere = new THREE.Mesh(new THREE.SphereGeometry(300, 64, 64), material);
    skySphere.rotation.x = -Math.PI / 2;
    return skySphere;
};

Confusion.prototype.createLines = function(){
    const lines = new THREE.Object3D();
    const lineMaterial = new THREE.LineBasicMaterial({
        color: 0xAA00FF,
        linewidth: 3
    });
    const lineMaterial2 = new THREE.LineBasicMaterial({
        color: 0xFF0000,
        linewidth: 3
    });

    const lsystem = new LSYSTEM();
    lsystem.interpret(9, 160, 
        "FrFrFruFuFuFulFlFl","FuFrFFtFrFlF", 3);
    lsystem.moveToCenter();

    const line = lsystem.createLine(lineMaterial);
    line.material.opacity = 0.25;
    line.material.transparent = true;
    line.position.z = -20;
    line.position.x = 70;
    lines.add(line);

    const line2 = lsystem.createLine(lineMaterial2);
    line2.material.opacity = 0.5;
    line2.material.transparent = true;
    line2.position.z = 20;
    line2.position.x = -70;
    lines.add(line2);

    lsystem.interpret(9, 60,
        "FrFrFruFuFuFulFlFl","FuFrFFtFrFlF", 3);
    lsystem.moveToCenter();
    const line3 = lsystem.createLine(lineMaterial);
    line.material.opacity = 0.25;
    line.material.transparent = true;
    line.position.z = -20;
    line.position.x = 70;
    lines.add(line3);

    const line4 = lsystem.createLine(lineMaterial2);
    line.material.opacity = 0.25;
    line.material.transparent = true;
    line.position.z = 20;
    line.position.x = -70;
    lines.add(line4);

    return lines;
};