//sync tracks for rocket
//dependent on config.js, JSRocket and THREE

//Only one Sync per demo!
const Sync =  function(){

    const config = Config();
    const syncDevice = new JSRocket.SyncDevice();

    let part = 0;
    let symbol = 0;
    let brightness = 0;
    let negate = 0;
    let glitch = 0;
    let grayscale = 0;
    let snow = 0;
    let additive = 0;
    let edges = 0;
    let fade = {
        color : {r: 0, g: 0, b: 0},
        value : 0.0,
        all: 0.0
        //the value range is from 0...1 (0 no fade, 1 completely faded)
        //fade all is done on top of glitch pass
    };

    let near = 0.1;
    let far = 1000;
    let focalLength = 10;
    let filmGauge = 24;

    let heart = 0;
    let text = 0;

    let camera = {
        pos : {x: 0, y: 0, z: 0},
        rot : {x: 0, y: 0, z: 0}
    };

    let obj = {
        pos : {x: 0, y: 0, z: 0},
        rot : {x: 0, y: 0, z: 0}
    };

    const syncInterface = {

        getPart : function(){
            return part.getValue(config.getRow());
        },

        getSymbol : function(){
            return symbol.getValue(config.getRow());
        },

        getBrightness : function(){
            return (brightness.getValue(config.getRow()) || 0);
        },

        getNegate : function(){
            return (negate.getValue(config.getRow()) || 0);
        },

        getGlitch : function(){
            return (glitch.getValue(config.getRow()) || 0);
        },

        getSnow : function(){
            return (snow.getValue(config.getRow()) || 0);
        },

        getGrayscale : function(){
            return (grayscale.getValue(config.getRow()) || 0);
        },

        getAdditive : function(){
            return (additive.getValue(config.getRow()) || 0);
        },

        getEdges : function(){
            const e = edges.getValue(config.getRow()) || 0;
            if(e === 0){
                return false;
            }
            else{
                return true;
            }
        },

        getFadeColor : function(){
            const r = fade.color.r.getValue(config.getRow());
            const g = fade.color.g.getValue(config.getRow());
            const b = fade.color.b.getValue(config.getRow());

            return new THREE.Vector3(r, g, b);
        },

        getFadeValue : function(){
            const value = fade.value.getValue(config.getRow());
            return value;
        },

        getFadeAll : function(){
            const all = fade.all.getValue(config.getRow());
            return all;
        },

        getNear : function(){
            return near.getValue(config.getRow());
        },

        getFar : function(){
            return far.getValue(config.getRow());
        },

        getLens : function(){
            const fl = focalLength.getValue(config.getRow());
            const fg = filmGauge.getValue(config.getRow());
            return{
                fl : fl,
                fg : fg
            };
        },

        getHeartBeat : function(){
            return heart.getValue(config.getRow());
        },

        getShowText : function(){
            return text.getValue(config.getRow());
        },

        getCameraPosition : function(){
            const x = camera.pos.x.getValue(config.getRow());
            const y = camera.pos.y.getValue(config.getRow());
            const z = camera.pos.z.getValue(config.getRow());

            return new THREE.Vector3(x,y,z);
        },

        getCameraRotation : function(){
            const x = camera.rot.x.getValue(config.getRow());
            const y = camera.rot.y.getValue(config.getRow());
            const z = camera.rot.z.getValue(config.getRow());

            return new THREE.Vector3(x,y,z);
        },

        getObjPosition : function(){
            const x = obj.pos.x.getValue(config.getRow());
            const y = obj.pos.y.getValue(config.getRow());
            const z = obj.pos.z.getValue(config.getRow());

            return new THREE.Vector3(x,y,z);
        },

        getObjRotation : function(){
            const x = obj.rot.x.getValue(config.getRow());
            const y = obj.rot.y.getValue(config.getRow());
            const z = obj.rot.z.getValue(config.getRow());

            return new THREE.Vector3(x,y,z);
        },

        //Binding tracks
        bindTracks : function(){

            part = syncDevice.getTrack('part');
            symbol = syncDevice.getTrack('symbol');
            brightness = syncDevice.getTrack('brightness');
            negate = syncDevice.getTrack('negate');
            glitch = syncDevice.getTrack('glitch');
            grayscale = syncDevice.getTrack('grayscale');
            snow = syncDevice.getTrack('snow');
            additive = syncDevice.getTrack('additive');
            edges = syncDevice.getTrack('edges');

            //fade
            fade.color.r = syncDevice.getTrack('fade_col_r');
            fade.color.g = syncDevice.getTrack('fade_col_g');
            fade.color.b = syncDevice.getTrack('fade_col_b');

            fade.value = syncDevice.getTrack('fade');
            fade.all = syncDevice.getTrack('fade_all');

            near = syncDevice.getTrack('near');
            far = syncDevice.getTrack('far');
            focalLength = syncDevice.getTrack('focal_length');
            filmGauge = syncDevice.getTrack('film_gauge');

            //Heart Beat
            heart = syncDevice.getTrack('heart_beat');

            //Text
            text = syncDevice.getTrack('text');

            //CAMERA
            camera.pos.x = syncDevice.getTrack('cam_x');
            camera.pos.y = syncDevice.getTrack('cam_y');
            camera.pos.z = syncDevice.getTrack('cam_z');

            camera.rot.x = syncDevice.getTrack('cam_rot_x');
            camera.rot.y = syncDevice.getTrack('cam_rot_y');
            camera.rot.z = syncDevice.getTrack('cam_rot_z');

            //OBJECT
            obj.pos.x = syncDevice.getTrack('obj_x');
            obj.pos.y = syncDevice.getTrack('obj_y');
            obj.pos.z = syncDevice.getTrack('obj_z');

            obj.rot.x = syncDevice.getTrack('obj_rot_x');
            obj.rot.y = syncDevice.getTrack('obj_rot_y');
            obj.rot.z = syncDevice.getTrack('obj_rot_z');
        },

        //Initializes the sync device and returns it
        initSyncDevice : function(){
            if(config.isDemoMode()){
                syncDevice.setConfig({'rocketXML': config.getXML()});
                syncDevice.init("demo");
            } else {
                //config.syncDevice.setConfig({'socketURL':'ws://192.168.0.100:1338'});
                syncDevice.init();
            }
            return syncDevice;
        },

        //returns the sync device
        getSyncDevice : function(){
            return syncDevice;
        },

        getConfig : function(){
            return config;
        }


    };

    return syncInterface;
};

TDEMO.SYNC = Sync();
